/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.JarClassLoader;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.ProxyClassLoader;
import org.netbeans.core.modules.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public final class Module
extends ModuleInfo {
    public static final String PROP_RELOADABLE = "reloadable";
    public static final String PROP_CLASS_LOADER = "classLoader";
    public static final String PROP_MANIFEST = "manifest";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PROBLEMS = "problems";
    private final ModuleManager mgr;
    private final Events ev;
    private final Object history;
    private final File jar;
    private File physicalJar = null;
    private boolean enabled;
    private boolean reloadable;
    private final boolean autoload;
    private final boolean eager;
    private Manifest manifest;
    private String codeNameBase;
    private int codeNameRelease;
    private String codeName;
    private String[] provides;
    private Set dependencies;
    private Dependency[] dependenciesA;
    private SpecificationVersion specVers;
    private ClassLoader classloader = null;
    private final Set oldClassLoaders = new WeakSet(5);
    private Properties localizedProps;
    private PackageExport[] publicPackages;
    private static final Map extensionOwners = new HashMap();
    private final Set localeVariants = new HashSet();
    private final Set plainExtensions = new HashSet();
    private final Set localeExtensions = new HashSet();
    private transient boolean released;
    private transient int releaseCount = 0;
    private static PermissionCollection modulePermissions;

    Module(ModuleManager moduleManager, Events events, File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (bl2 && bl3) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = moduleManager;
        this.ev = events;
        this.jar = file;
        this.history = object;
        this.reloadable = bl;
        this.autoload = bl2;
        this.eager = bl3;
        this.enabled = false;
        this.loadManifest();
        this.parseManifest();
    }

    Module(ModuleManager moduleManager, Events events, Manifest manifest, Object object, ClassLoader classLoader) throws InvalidException {
        this.mgr = moduleManager;
        this.ev = events;
        this.manifest = manifest;
        this.history = object;
        this.classloader = classLoader;
        this.jar = null;
        this.reloadable = false;
        this.autoload = false;
        this.eager = false;
        this.enabled = false;
        this.parseManifest();
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isValid() {
        return this.mgr.get(this.getCodeNameBase()) == this;
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public Object getAttribute(String string) {
        return this.getManifest().getMainAttributes().getValue(string);
    }

    public Object getLocalizedAttribute(String string) {
        int n;
        Object object;
        String string2 = this.manifest.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean bl = false;
        if (string2 != null) {
            Object object2;
            if (this.classloader != null) {
                if (string2.endsWith(".properties")) {
                    bl = true;
                    object2 = string2.substring(0, string2.length() - 11).replace('/', '.');
                    try {
                        object = NbBundle.getBundle((String)object2, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return ((ResourceBundle)object).getString(string);
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        Util.err.notify((Throwable)missingResourceException);
                    }
                } else {
                    Util.err.log(16, "WARNING - cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + string2);
                }
            }
            if (!bl) {
                block19: {
                    if (this.localizedProps == null) {
                        Util.err.log("Trying to get localized attr " + string + " from disabled module " + this.getCodeNameBase());
                        try {
                            if (this.jar != null) {
                                object2 = new JarFile(this.jar);
                                try {
                                    this.loadLocalizedProps((JarFile)object2, this.manifest);
                                    Object var8_11 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var8_12 = null;
                                    ((ZipFile)object2).close();
                                    throw throwable;
                                }
                                ((ZipFile)object2).close();
                                {
                                    break block19;
                                }
                            }
                            if (this.classloader != null) {
                                this.loadLocalizedPropsClasspath();
                                break block19;
                            }
                            throw new IllegalStateException();
                        }
                        catch (IOException iOException) {
                            Util.err.annotate((Throwable)iOException, 1, this.jar.getAbsolutePath(), null, null, null);
                            Util.err.notify(1, (Throwable)iOException);
                            if (this.localizedProps != null) break block19;
                            this.localizedProps = new Properties();
                        }
                    }
                }
                if ((object2 = this.localizedProps.getProperty(string)) != null) {
                    return object2;
                }
            }
        }
        if ((n = string.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(string));
        }
        object = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Attributes attributes = this.getManifest().getAttributes((String)object);
        if (attributes != null) {
            return NbBundle.getLocalizedValue((Attributes)attributes, (Attributes.Name)new Attributes.Name(string3));
        }
        return null;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    public String[] getProvides() {
        return this.provides;
    }

    final boolean provides(String string) {
        int n = 0;
        while (n < this.provides.length) {
            if (this.provides[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Set getDependencies() {
        return this.dependencies;
    }

    final Dependency[] getDependenciesArray() {
        return this.dependenciesA;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.specVers;
    }

    public boolean owns(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)classLoader)).getModule() == this;
        }
        return false;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    private void parseManifest() throws InvalidException {
        Attributes attributes = this.manifest.getMainAttributes();
        this.codeName = attributes.getValue("OpenIDE-Module");
        if (this.codeName == null) {
            throw new InvalidException("Not a module: no OpenIDE-Module tag in manifest of " + this.jar);
        }
        try {
            Object object;
            Object object2;
            if (this.codeName.indexOf(44) != -1) {
                throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module: " + this.codeName);
            }
            Dependency.create((int)1, (String)this.codeName);
            int n = this.codeName.lastIndexOf(47);
            if (n == -1) {
                this.codeNameBase = this.codeName;
                this.codeNameRelease = -1;
            } else {
                this.codeNameBase = this.codeName.substring(0, n);
                this.codeNameRelease = Integer.parseInt(this.codeName.substring(n + 1));
            }
            String string = attributes.getValue("OpenIDE-Module-Specification-Version");
            if (string != null) {
                try {
                    this.specVers = new SpecificationVersion(string);
                }
                catch (NumberFormatException numberFormatException) {
                    InvalidException invalidException = new InvalidException("While parsing OpenIDE-Module-Specification-Version: " + numberFormatException.toString());
                    Util.err.annotate((Throwable)invalidException, (Throwable)numberFormatException);
                    throw invalidException;
                }
            } else {
                this.specVers = null;
            }
            String string2 = attributes.getValue("OpenIDE-Module-Provides");
            if (string2 == null) {
                this.provides = new String[0];
            } else {
                object2 = new StringTokenizer(string2, ", ");
                this.provides = new String[((StringTokenizer)object2).countTokens()];
                int n2 = 0;
                while (n2 < this.provides.length) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (((String)object).indexOf(44) != -1) {
                        throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module-Provides: " + (String)object);
                    }
                    Dependency.create((int)1, (String)object);
                    if (((String)object).lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Provides: " + (String)object);
                    }
                    this.provides[n2] = object;
                    ++n2;
                }
                if (new HashSet<String>(Arrays.asList(this.provides)).size() < this.provides.length) {
                    throw new IllegalArgumentException("Duplicate entries in OpenIDE-Module-Provides: " + string2);
                }
            }
            object2 = attributes.getValue("OpenIDE-Module-Public-Packages");
            if (object2 != null) {
                if (((String)object2).trim().equals("-")) {
                    this.publicPackages = new PackageExport[0];
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ", ");
                    object = new ArrayList(Math.max(stringTokenizer.countTokens(), 1));
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3;
                        String string4 = stringTokenizer.nextToken();
                        if (string4.endsWith(".*")) {
                            string3 = string4.substring(0, string4.length() - 2);
                            Dependency.create((int)1, (String)string3);
                            if (string3.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + (String)object2);
                            }
                            object.add(new PackageExport(string3.replace('.', '/') + '/', false));
                            continue;
                        }
                        if (string4.endsWith(".**")) {
                            string3 = string4.substring(0, string4.length() - 3);
                            Dependency.create((int)1, (String)string3);
                            if (string3.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + (String)object2);
                            }
                            object.add(new PackageExport(string3.replace('.', '/') + '/', true));
                            continue;
                        }
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + (String)object2);
                    }
                    if (object.isEmpty()) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + (String)object2);
                    }
                    this.publicPackages = object.toArray(new PackageExport[object.size()]);
                }
            } else {
                this.publicPackages = null;
            }
            HashSet hashSet = new HashSet(20);
            hashSet.addAll(Dependency.create((int)4, (String)attributes.getValue("OpenIDE-Module-IDE-Dependencies")));
            hashSet.addAll(Dependency.create((int)3, (String)attributes.getValue("OpenIDE-Module-Java-Dependencies")));
            hashSet.addAll(Dependency.create((int)1, (String)attributes.getValue("OpenIDE-Module-Module-Dependencies")));
            hashSet.addAll(Dependency.create((int)2, (String)attributes.getValue("OpenIDE-Module-Package-Dependencies")));
            hashSet.addAll(Dependency.create((int)5, (String)attributes.getValue("OpenIDE-Module-Requires")));
            this.mgr.refineDependencies(this, hashSet);
            this.dependencies = Collections.unmodifiableSet(hashSet);
            this.dependenciesA = hashSet.toArray(new Dependency[hashSet.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidException invalidException = new InvalidException("While parsing a dependency attribute: " + illegalArgumentException.toString());
            Util.err.annotate((Throwable)invalidException, (Throwable)illegalArgumentException);
            throw invalidException;
        }
    }

    public File getJarFile() {
        return this.jar;
    }

    public boolean isFixed() {
        return this.jar == null;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.log(16, "Warning: temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.log("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.log("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    private void loadManifest() throws IOException {
        JarFile jarFile;
        Util.err.log("loading manifest of " + this.jar);
        if (this.reloadable) {
            this.ensurePhysicalJar();
            jarFile = new JarFile(this.physicalJar);
        } else {
            jarFile = new JarFile(this.jar);
        }
        try {
            Manifest manifest = jarFile.getManifest();
            this.findExtensionsAndVariants(manifest);
            this.manifest = manifest;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    private void findExtensionsAndVariants(Manifest manifest) {
        this.localeVariants.clear();
        this.localeVariants.addAll(Util.findLocaleVariantsOf(this.jar, false));
        this.plainExtensions.clear();
        this.localeExtensions.clear();
        String string = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                File file;
                String string2 = stringTokenizer.nextToken();
                if ((new File(string2).isAbsolute() || string2.indexOf("../") != -1) && !string2.equals("../lib/updater.jar")) {
                    Util.err.log(16, "WARNING: Class-Path value " + string2 + " from " + this.jar + " is illegal according to the Java Extension Mechanism: must be relative and not move up directories");
                }
                if (!(file = new File(this.jar.getParentFile(), string2.replace('/', File.separatorChar))).exists()) continue;
                Map map = extensionOwners;
                synchronized (map) {
                    HashSet<File> hashSet = (HashSet<File>)extensionOwners.get(file);
                    if (hashSet == null) {
                        hashSet = new HashSet<File>(2);
                        hashSet.add(this.jar);
                        extensionOwners.put(file, hashSet);
                    } else if (!hashSet.contains(this.jar)) {
                        hashSet.add(this.jar);
                        this.ev.log("extensionMultiplyLoaded", file, hashSet);
                    }
                }
                this.plainExtensions.add(file);
                this.localeExtensions.addAll(Util.findLocaleVariantsOf(file, false));
            }
        }
        Util.err.log("localeVariants of " + this.jar + ": " + this.localeVariants);
        Util.err.log("plainExtensions of " + this.jar + ": " + this.plainExtensions);
        Util.err.log("localeExtensions of " + this.jar + ": " + this.localeExtensions);
    }

    private void loadLocalizedProps(JarFile jarFile, Manifest manifest) throws IOException {
        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (string != null) {
            String string2;
            int n;
            List list;
            Object object;
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                this.localizedProps = new Properties();
                object = jarFile.getInputStream(zipEntry);
                try {
                    this.localizedProps.load((InputStream)object);
                    list = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ((InputStream)object).close();
                    throw throwable;
                }
                ((InputStream)object).close();
                {
                }
            }
            if ((n = string.lastIndexOf(46)) == -1) {
                object = string;
                string2 = "";
            } else {
                object = string.substring(0, n);
                string2 = string.substring(n);
            }
            list = Util.findLocaleVariantsOf(this.jar, true);
            Collections.reverse(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object var19_20;
                Object[] objectArray = (Object[])iterator.next();
                File file = (File)objectArray[0];
                String string3 = (String)objectArray[1];
                String string4 = (String)object + string3 + string2;
                JarFile jarFile2 = new JarFile(file);
                try {
                    ZipEntry zipEntry2 = jarFile2.getEntry(string4);
                    if (zipEntry2 != null) {
                        Object var17_19;
                        if (this.localizedProps == null) {
                            this.localizedProps = new Properties();
                        }
                        InputStream inputStream = jarFile2.getInputStream(zipEntry2);
                        try {
                            this.localizedProps.load(inputStream);
                            var17_19 = null;
                        }
                        catch (Throwable throwable) {
                            var17_19 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        {
                        }
                    }
                    var19_20 = null;
                }
                catch (Throwable throwable) {
                    var19_20 = null;
                    jarFile2.close();
                    throw throwable;
                }
                jarFile2.close();
                {
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + string);
            }
        }
    }

    private void loadLocalizedPropsClasspath() throws InvalidException {
        Attributes attributes = this.manifest.getMainAttributes();
        String string = attributes.getValue("OpenIDE-Module-Localizing-Bundle");
        if (string != null) {
            Util.err.log("Localized props in " + string + " for " + attributes.getValue("OpenIDE-Module"));
            try {
                String string2;
                String string3;
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    string3 = string;
                    string2 = "";
                } else {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n);
                }
                ArrayList arrayList = new ArrayList(10);
                Iterator iterator = NbBundle.getLocalizingSuffixes();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                Collections.reverse(arrayList);
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    String string5 = string3 + string4 + string2;
                    InputStream inputStream = this.classloader.getResourceAsStream(string5);
                    if (inputStream == null) continue;
                    Util.err.log("Found " + string5);
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    this.localizedProps.load(inputStream);
                }
                if (this.localizedProps == null) {
                    throw new IOException("Could not find localizing bundle: " + string);
                }
            }
            catch (IOException iOException) {
                InvalidException invalidException = new InvalidException(iOException.toString());
                Util.err.annotate((Throwable)invalidException, (Throwable)iOException);
                throw invalidException;
            }
        }
    }

    public List getAllJars() {
        if (this.jar == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.reloadable ? this.physicalJar : this.jar);
        arrayList.addAll(this.plainExtensions);
        arrayList.addAll(this.localeVariants);
        arrayList.addAll(this.localeExtensions);
        return arrayList;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean bl) {
        if (this.isFixed()) {
            throw new IllegalStateException();
        }
        if (this.reloadable != bl) {
            this.reloadable = bl;
            this.mgr.fireReloadable(this);
        }
    }

    void reload() throws IOException {
        if (this.isFixed()) {
            throw new IllegalStateException();
        }
        this.destroyPhysicalJar();
        String string = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        String string2 = this.getCodeNameBase();
        if (!string.equals(string2)) {
            throw new InvalidException("Code name base changed during reload: " + string + " -> " + string2);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    void classLoaderUp(Set set) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (this.isFixed()) {
            return;
        }
        Util.err.log("classLoaderUp on " + (Object)((Object)this) + " with parents " + set);
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(Math.max(set.size(), 1));
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            object3 = (Module)((Object)iterator.next());
            object2 = ((Module)((Object)object3)).getClassLoader();
            if (((Module)((Object)object3)).isFixed() && arrayList.contains(object2)) {
                Util.err.log("#24996: skipping duplicate classloader from " + object3);
                continue;
            }
            arrayList.add((ClassLoader)object2);
        }
        object3 = new ArrayList(3);
        object2 = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
        if (((File)object2).isDirectory()) {
            object = ((File)object2).listFiles(Util.jarFilter());
            if (object != null) {
                int n = 0;
                while (n < ((File[])object).length) {
                    this.ev.log("patch", object[n]);
                    object3.add(new JarFile(object[n]));
                    ++n;
                }
            } else {
                Util.err.log(16, "Could not search for patches in " + object2);
            }
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            object3.add(new JarFile(this.physicalJar));
        } else {
            object3.add(new JarFile(this.jar));
        }
        iterator = this.localeVariants.iterator();
        while (iterator.hasNext()) {
            object3.add(new JarFile((File)iterator.next()));
        }
        iterator = this.localeExtensions.iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            object3.add(((File)object).isDirectory() ? object : new JarFile((File)object));
        }
        iterator = this.plainExtensions.iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            object3.add(((File)object).isDirectory() ? object : new JarFile((File)object));
        }
        try {
            this.classloader = new OneModuleClassLoader((List)object3, arrayList.toArray(new ClassLoader[arrayList.size()]));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException(illegalArgumentException.toString());
            Util.err.annotate((Throwable)iOException, (Throwable)illegalArgumentException);
            throw iOException;
        }
        this.oldClassLoaders.add(this.classloader);
    }

    void classLoaderDown() {
        if (this.isFixed()) {
            return;
        }
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
        Util.err.log("classLoaderDown on " + (Object)((Object)this) + ": releaseCount=" + this.releaseCount + " released=" + this.released);
        this.released = false;
    }

    void cleanup() {
        if (this.isFixed()) {
            return;
        }
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + (Object)((Object)this));
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + (Object)((Object)this));
        }
        if (!this.released) {
            Util.err.log("Warning: not all resources associated with module " + this.jar + " were successfully released.");
            this.released = true;
        } else {
            Util.err.log("All resources associated with module " + this.jar + " were successfully released.");
        }
        this.destroyPhysicalJar();
    }

    void destroy() {
        Iterator iterator = this.oldClassLoaders.iterator();
        while (iterator.hasNext()) {
            OneModuleClassLoader oneModuleClassLoader = (OneModuleClassLoader)iterator.next();
            oneModuleClassLoader.releaseLocks();
        }
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Set getProblems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Not valid: " + (Object)((Object)this));
        }
        if (this.isEnabled()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.mgr.missingDependencies(this));
    }

    final void firePropertyChange0(String string, Object object, Object object2) {
        if (Util.err.isLoggable(0)) {
            Util.err.log("Module.propertyChange: " + (Object)((Object)this) + " " + string + ": " + object + " -> " + object2);
        }
        this.firePropertyChange(string, object, object2);
    }

    public final Object getHistory() {
        return this.history;
    }

    public String toString() {
        String string = "Module[" + this.getCodeNameBase() + "]";
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    public static final class PackageExport {
        public final String pkg;
        public final boolean recursive;

        public PackageExport(String string, boolean bl) {
            this.pkg = string;
            this.recursive = bl;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "**/" : "") + "]";
        }
    }

    private class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider,
    Util.PackageAccessibleClassLoader {
        private int rc;

        public OneModuleClassLoader(List list, ClassLoader[] classLoaderArray) throws IllegalArgumentException {
            super(list, classLoaderArray);
            this.rc = Module.this.releaseCount++;
        }

        public Module getModule() {
            return Module.this;
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return Module.getAllPermission();
        }

        protected String findLibrary(String string) {
            String string2 = System.mapLibraryName(string);
            File file = new File(new File(Module.this.jar.getParentFile(), "bin"), string2);
            if (file.isFile()) {
                return file.getAbsolutePath();
            }
            return null;
        }

        protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
            if (!super.shouldDelegateResource(string, classLoader)) {
                return false;
            }
            Module module = classLoader instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)classLoader)).getModule() : null;
            return Module.this.mgr.shouldDelegateResource(Module.this, module, string);
        }

        public String toString() {
            return super.toString() + "[" + Module.this.getCodeNameBase() + "]";
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Finalize for " + this + ": rc=" + this.rc + " releaseCount=" + Module.this.releaseCount + " released=" + Module.this.released);
            if (this.rc == Module.this.releaseCount) {
                Module.this.released = true;
            } else {
                Util.err.log("Now resources for " + Module.this.getCodeNameBase() + " have been released.");
            }
        }
    }
}

