/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import org.openide.modules.SpecificationVersion;

public final class ModuleHistory {
    private final String origin;
    private final String relativeJar;
    private int oldMajorVers;
    private SpecificationVersion oldSpecVers;
    private boolean upgraded;
    private byte[] installerState;
    private String base;
    private boolean installerStateChanged = false;

    ModuleHistory(String string, String string2) {
        this.origin = string;
        this.relativeJar = string2;
        this.upgraded = false;
        this.oldMajorVers = -1;
        this.oldSpecVers = null;
        this.installerState = null;
    }

    public ModuleHistory() {
        this("adhoc", null);
    }

    String getOrigin() {
        return this.origin;
    }

    String getRelativeJar() {
        return this.relativeJar;
    }

    public boolean isAutoscan() {
        return !this.origin.equals("adhoc");
    }

    boolean isPreviouslyInstalled() {
        return this.upgraded;
    }

    int getOldMajorVersion() {
        return this.oldMajorVers;
    }

    SpecificationVersion getOldSpecificationVersion() {
        return this.oldSpecVers;
    }

    void upgrade(int n, SpecificationVersion specificationVersion) {
        this.upgraded = true;
        this.oldMajorVers = n;
        this.oldSpecVers = specificationVersion;
    }

    byte[] getInstallerState() {
        return this.installerState;
    }

    void setInstallerState(byte[] byArray) {
        if (this.installerState != null && byArray != null) {
            this.installerStateChanged = true;
        }
        this.installerState = byArray;
    }

    boolean getInstallerStateChanged() {
        return this.installerStateChanged;
    }

    void resetHistory() {
        this.upgraded = false;
        this.installerState = null;
        this.installerStateChanged = false;
    }
}

