/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.netbeans.core.modules.ChangeFirer;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleInstaller;
import org.netbeans.core.modules.ProxyClassLoader;
import org.netbeans.core.modules.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

public final class ModuleManager {
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    private final HashSet modules = new HashSet(100);
    private final Map modulesByName = new HashMap(100);
    private final Map moduleProblems = new HashMap(100);
    private final Map providersOf = new HashMap(25);
    private final ModuleInstaller installer;
    private SystemClassLoader classLoader = new SystemClassLoader(new ClassLoader[0]);
    private final Object classLoaderLock = "ModuleManager.classLoaderLock";
    private final Events ev;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private final Set listeners = new HashSet(10);
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private static final Object PROBING_IN_PROCESS = new Object();

    public ModuleManager(ModuleInstaller moduleInstaller, Events events) {
        this.installer = moduleInstaller;
        this.ev = events;
        ModuleManager.updateContextClassLoaders(this.classLoader, true);
    }

    final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(propertyChangeListener);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if (Util.err.isLoggable(0)) {
            Util.err.log("ModuleManager.propertyChange: " + string + ": " + object + " -> " + object2);
        }
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            propertyChangeListenerArray = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < propertyChangeListenerArray.length) {
            propertyChangeListenerArray[n].propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    final void fireReloadable(Module module) {
        this.firer.change(new ChangeFirer.Change((Object)module, "reloadable", null, null));
    }

    public Lookup getModuleLookup() {
        return this.lookup;
    }

    final void fireModulesCreatedDeleted(Set set, Set set2) {
        Util.err.log("lookup created: " + set + " deleted: " + set2);
        this.lookup.changed();
    }

    public Set getModules() {
        return (Set)this.modules.clone();
    }

    public final Set getEnabledModules() {
        HashSet hashSet = new HashSet(this.modules);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (module.isEnabled()) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public final Module get(String string) {
        return (Module)((Object)this.modulesByName.get(string));
    }

    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            SystemClassLoader systemClassLoader = this.classLoader;
            return systemClassLoader;
        }
    }

    private void invalidateClassLoader() {
        SystemClassLoader systemClassLoader;
        ClassLoader[] classLoaderArray;
        Object object = this.classLoaderLock;
        synchronized (object) {
            this.classLoader.destroy();
        }
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 1);
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            classLoaderArray = (ClassLoader[])iterator.next();
            if (!classLoaderArray.isEnabled()) continue;
            hashSet.add(classLoaderArray.getClassLoader());
        }
        classLoaderArray = hashSet.toArray(new ClassLoader[hashSet.size()]);
        try {
            systemClassLoader = new SystemClassLoader(classLoaderArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.err.notify((Throwable)illegalArgumentException);
            systemClassLoader = new SystemClassLoader(new ClassLoader[0]);
        }
        Object object2 = this.classLoaderLock;
        synchronized (object2) {
            this.classLoader = systemClassLoader;
            ModuleManager.updateContextClassLoaders(this.classLoader, false);
        }
        this.firer.change(new ChangeFirer.Change(this, PROP_CLASS_LOADER, null, null));
    }

    private static void updateContextClassLoaders(ClassLoader classLoader, boolean bl) {
        int n;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        while (true) {
            int n2;
            Thread[] threadArray;
            if ((n = threadGroup.enumerate(threadArray = new Thread[n2 = threadGroup.activeCount() + 1], true)) < n2) {
                int n3 = 0;
                while (n3 < n) {
                    if (bl || threadArray[n3].getContextClassLoader() instanceof SystemClassLoader) {
                        threadArray[n3].setContextClassLoader(classLoader);
                    } else {
                        Util.err.log("Not touching context class loader " + threadArray[n3].getContextClassLoader() + " on thread " + threadArray[n3].getName());
                    }
                    ++n3;
                }
                break;
            }
            Util.err.log("Race condition getting all threads, restarting...");
        }
        Util.err.log("Set context class loader on " + n + " threads");
    }

    public Module create(File file, Object object, boolean bl, boolean bl2) throws IOException, DuplicateException {
        return this.create(file, object, bl, bl2, false);
    }

    public Module create(File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException, DuplicateException {
        List list;
        this.ev.log("startCreateRegularModule", file);
        Module module = new Module(this, this.ev, file.getAbsoluteFile(), object, bl, bl2, bl3);
        this.ev.log("finishCreateRegularModule", file);
        this.subCreate(module);
        if (module.isEager() && !(list = this.simulateEnable(Collections.EMPTY_SET)).isEmpty()) {
            if (!list.contains((Object)module)) {
                throw new IllegalStateException("Can immediately enable modules " + list + ", but not including " + (Object)((Object)module));
            }
            boolean bl4 = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Module module2 = (Module)((Object)iterator.next());
                if (module2.isAutoload() || module2.isEager()) continue;
                bl4 = false;
                break;
            }
            if (bl4) {
                Util.err.log("Enabling " + (Object)((Object)module) + " immediately");
                this.enable(Collections.EMPTY_SET);
            }
        }
        return module;
    }

    public Module createFixed(Manifest manifest, Object object, ClassLoader classLoader) throws InvalidException, DuplicateException {
        if (manifest == null || classLoader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", object);
        Module module = new Module(this, this.ev, manifest, object, classLoader);
        this.ev.log("finishCreateBootModule", object);
        this.subCreate(module);
        return module;
    }

    void refineDependencies(Module module, Set set) {
        this.installer.refineDependencies(module, set);
    }

    boolean shouldDelegateResource(Module module, Module module2, String string) {
        boolean bl = this.installer.shouldDelegateResource(module, module2, string);
        if (!bl && Util.err.isLoggable(1)) {
            Util.err.log("Refusing to load " + string + " for " + (Object)((Object)module) + " from parent module " + (Object)((Object)module2));
        }
        return bl;
    }

    private void subCreate(Module module) throws DuplicateException {
        Util.err.log("created: " + (Object)((Object)module));
        Module module2 = this.get(module.getCodeNameBase());
        if (module2 != null) {
            throw new DuplicateException(module2, module);
        }
        this.modules.add(module);
        this.modulesByName.put(module.getCodeNameBase(), module);
        this.possibleProviderAdded(module);
        this.lookup.add(module);
        this.firer.created(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.clearProblemCache();
    }

    private void possibleProviderAdded(Module module) {
        String[] stringArray = module.getProvides();
        int n = 0;
        while (n < stringArray.length) {
            HashSet<Module> hashSet = (HashSet<Module>)this.providersOf.get(stringArray[n]);
            if (hashSet == null) {
                hashSet = new HashSet<Module>(10);
                this.providersOf.put(stringArray[n], hashSet);
            }
            hashSet.add(module);
            ++n;
        }
    }

    public void delete(Module module) throws IllegalArgumentException {
        if (module.isFixed()) {
            throw new IllegalArgumentException("fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("enabled module: " + (Object)((Object)module));
        }
        this.ev.log("deleteModule", (Object)module);
        this.modules.remove((Object)module);
        this.modulesByName.remove(module.getCodeNameBase());
        this.possibleProviderRemoved(module);
        this.lookup.remove(module);
        this.firer.deleted(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)module, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
        module.destroy();
    }

    private void possibleProviderRemoved(Module module) {
        String[] stringArray = module.getProvides();
        int n = 0;
        while (n < stringArray.length) {
            Set set = (Set)this.providersOf.get(stringArray[n]);
            if (set != null) {
                set.remove((Object)module);
                if (set.isEmpty()) {
                    this.providersOf.remove(stringArray[n]);
                }
            }
            ++n;
        }
    }

    public void reload(Module module) throws IllegalArgumentException, IOException {
        Util.err.log("reload: " + (Object)((Object)module));
        if (module.isFixed()) {
            throw new IllegalArgumentException("reload fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("reload enabled module: " + (Object)((Object)module));
        }
        this.possibleProviderRemoved(module);
        try {
            module.reload();
        }
        catch (IOException iOException) {
            this.delete(module);
            throw iOException;
        }
        this.possibleProviderAdded(module);
        this.firer.change(new ChangeFirer.Change((Object)module, "manifest", null, null));
        this.moduleProblems.remove((Object)module);
        this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        this.clearProblemCache();
    }

    public final void enable(Module module) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(module));
    }

    public final void disable(Module module) throws IllegalArgumentException {
        this.disable(Collections.singleton(module));
    }

    /*
     * Unable to fully structure code
     */
    public void enable(Set var1_1) throws IllegalArgumentException, InvalidException {
        block25: {
            Util.err.log("enable: " + var1_1);
            this.ev.log("perfStart", "ModuleManager.enable");
            var2_2 = this.simulateEnable(var1_1);
            this.ev.log("perfTick", "checked the required ordering and autoloads");
            Util.err.log("enable: toEnable=" + var2_2);
            var3_3 = new HashSet<E>(var2_2);
            if (!var3_3.containsAll(var1_1)) {
                var4_4 = new HashSet<E>(var1_1);
                var4_4.removeAll((Collection<?>)var3_3);
                throw new IllegalArgumentException("Not all requested modules can be enabled: " + var4_4);
            }
            var4_5 = var3_3.iterator();
            while (var4_5.hasNext()) {
                var5_8 = (Module)var4_5.next();
                if (var1_1.contains((Object)var5_8) || var5_8.isAutoload() || var5_8.isEager()) continue;
                throw new IllegalArgumentException("Would also need to enable " + (Object)var5_8);
            }
            Util.err.log("enable: verified dependencies");
            this.ev.log("perfTick", "verified dependencies");
            this.ev.log("startEnableModules", var2_2);
            var3_3 = new LinkedList<E>();
            var4_6 = false;
            var5_8 = null;
            try {
                var6_9 = var2_2.iterator();
                this.ev.log("perfStart", "module preparation");
                while (var6_9.hasNext()) {
                    var7_11 = (Module)var6_9.next();
                    var3_3.addFirst((Module)var7_11);
                    Util.err.log("enable: bringing up: " + var7_11);
                    this.ev.log("perfStart", "bringing up classloader on " + var7_11.getCodeName());
                    try {
                        var8_13 = var7_11.getDependenciesArray();
                        var9_17 = new HashSet<Module>(var8_13.length * 4 / 3 + 1);
                        var10_20 = 0;
                        while (var10_20 < var8_13.length) {
                            var11_23 = var8_13[var10_20];
                            if (var11_23.getType() == 1) {
                                var12_24 = var11_23.getName();
                                var13_25 = var12_24.lastIndexOf(47);
                                if (var13_25 != -1) {
                                    var12_24 = var12_24.substring(0, var13_25);
                                }
                                if ((var14_26 = this.get(var12_24)) == null) {
                                    throw new IOException("Parent " + var12_24 + " not found!");
                                }
                                var9_17.add(var14_26);
                            }
                            ++var10_20;
                        }
                        var7_11.classLoaderUp(var9_17);
                    }
                    catch (IOException var8_14) {
                        var4_6 = true;
                        var9_18 = new InvalidException(var8_14.toString());
                        Util.err.annotate((Throwable)var9_18, (Throwable)var8_14);
                        throw var9_18;
                    }
                    var7_11.setEnabled(true);
                    this.ev.log("perfEnd", "bringing up classloader on " + var7_11.getCodeName());
                    this.ev.log("perfStart", "package dependency check on " + var7_11.getCodeName());
                    Util.err.log("enable: checking package dependencies for " + var7_11);
                    var8_13 = var7_11.getDependenciesArray();
                    var9_16 = 0;
                    while (var9_16 < var8_13.length) {
                        var10_21 = var8_13[var9_16];
                        if (var10_21.getType() == 2) {
                            if (!Util.checkPackageDependency(var10_21, var7_11.getClassLoader())) {
                                var5_8 = var10_21;
                                throw new InvalidException((Module)var7_11, "Dependency failed on " + var10_21);
                            }
                            Util.err.log("Successful check for: " + var10_21);
                        }
                        ++var9_16;
                    }
                    this.ev.log("perfEnd", "package dependency check on " + var7_11.getCodeName());
                    this.ev.log("perfStart", "ModuleInstaller.prepare " + var7_11.getCodeName());
                    this.installer.prepare((Module)var7_11);
                    this.ev.log("perfEnd", "ModuleInstaller.prepare " + var7_11.getCodeName());
                }
                this.ev.log("perfEnd", "module preparation");
                break block25;
            }
            catch (InvalidException var6_10) {
                var7_12 = var6_10.getModule();
                if (var7_12 == null) {
                    throw new IllegalStateException("Problem with no associated module: " + var6_10);
                }
                var8_15 = (Set)this.moduleProblems.get((Object)var7_12);
                if (var8_15 == null) {
                    throw new IllegalStateException("Were trying to install a module that had never been checked: " + (Object)var7_12);
                }
                if (!var8_15.isEmpty()) {
                    throw new IllegalStateException("Were trying to install a module that was known to be bad: " + (Object)var7_12);
                }
                if (var5_8 != null) {
                    var8_15.add(var5_8);
                } else {
                    var8_15.add(var6_10);
                }
                this.clearProblemCache();
                this.firer.change(new ChangeFirer.Change((Object)var7_12, "problems", Collections.EMPTY_SET, Collections.singleton(var8_15.iterator().next())));
                Util.err.log("enable: will roll back from: " + var6_10);
                var9_19 = var3_3.iterator();
                ** while (var9_19.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                var10_22 = (Module)var9_19.next();
                var10_22.setEnabled(false);
                if (var4_6) {
                    var4_6 = false;
                    continue;
                }
                var10_22.classLoaderDown();
                System.gc();
                System.runFinalization();
                var10_22.cleanup();
                continue;
            }
lbl108:
            // 1 sources

            throw var6_10;
        }
        if (this.classLoader != null) {
            Util.err.log("enable: adding to system classloader");
            var6_9 = new ArrayList<E>(var2_2.size());
            var7_11 = var2_2.iterator();
            while (var7_11.hasNext()) {
                var6_9.add(((Module)var7_11.next()).getClassLoader());
            }
            this.classLoader.append(var6_9.toArray(new ClassLoader[var6_9.size()]));
        } else {
            Util.err.log("enable: no class loader yet, not appending");
        }
        Util.err.log("enable: continuing to installation");
        this.installer.load(var2_2);
        Util.err.log("enable: firing changes");
        this.firer.change(new ChangeFirer.Change(this, "enabledModules", null, null));
        var3_3 = var2_2.iterator();
        while (var3_3.hasNext()) {
            var4_7 = (Module)var3_3.next();
            this.firer.change(new ChangeFirer.Change((Object)var4_7, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (var4_7.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)var4_7, "classLoader", null, null));
        }
        this.ev.log("finishEnableModules", var2_2);
    }

    public void disable(Set set) throws IllegalArgumentException {
        Module module;
        Util.err.log("disable: " + set);
        if (set.isEmpty()) {
            return;
        }
        List list = this.simulateDisable(set);
        Util.err.log("disable: toDisable=" + list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            if (set.contains((Object)module) || module.isAutoload() || module.isEager()) continue;
            throw new IllegalArgumentException("Would also need to disable: " + (Object)((Object)module));
        }
        Util.err.log("disable: verified dependencies");
        this.ev.log("startDisableModules", list);
        this.installer.unload(list);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            this.installer.dispose(module);
            module.setEnabled(false);
            module.classLoaderDown();
        }
        System.gc();
        System.runFinalization();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            module.cleanup();
        }
        Util.err.log("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            this.firer.change(new ChangeFirer.Change((Object)module, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)module, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", list);
    }

    public List simulateEnable(Set set) throws IllegalArgumentException {
        Object object;
        HashSet hashSet = new HashSet(set.size() * 2 + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (object.isAutoload()) {
                throw new IllegalArgumentException("Cannot simulate enabling an autoload: " + (Object)object);
            }
            if (object.isEager()) {
                throw new IllegalArgumentException("Cannot simulate enabling an eager module: " + (Object)object);
            }
            if (object.isEnabled()) {
                throw new IllegalArgumentException("Already enabled: " + (Object)object);
            }
            if (!object.isValid()) {
                throw new IllegalArgumentException("Not managed by me: " + (Object)object + " in " + object.getJarFile());
            }
            this.maybeAddToEnableList(hashSet, set, (Module)((Object)object), true);
        }
        object = new HashSet(this.getModules());
        object.removeAll(this.getEnabledModules());
        object.removeAll(hashSet);
        while (this.searchForPossibleEager(hashSet, (Set)object, set)) {
        }
        try {
            return Utilities.partialSort(new ArrayList(hashSet), (Comparator)Util.dependencyComparator(false), (boolean)false);
        }
        catch (Utilities.UnorderableException unorderableException) {
            IllegalStateException illegalStateException = new IllegalStateException(unorderableException.toString());
            Util.err.annotate((Throwable)illegalStateException, (Throwable)unorderableException);
            throw illegalStateException;
        }
    }

    private void maybeAddToEnableList(Set set, Set set2, Module module, boolean bl) {
        if (!this.missingDependencies(module).isEmpty()) {
            if (!bl) {
                throw new IllegalStateException("Module was supposed to be OK: " + (Object)((Object)module));
            }
            return;
        }
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        Dependency[] dependencyArray = module.getDependenciesArray();
        int n = 0;
        while (n < dependencyArray.length) {
            Object object;
            String string;
            Dependency dependency = dependencyArray[n];
            if (dependency.getType() == 1) {
                string = dependency.getName();
                int n2 = string.lastIndexOf(47);
                object = n2 == -1 ? string : string.substring(0, n2);
                Module module2 = this.get((String)object);
                if (module2 == null) {
                    throw new IllegalStateException("Should have found module: " + (String)object);
                }
                if (!module2.isEnabled()) {
                    this.maybeAddToEnableList(set, set2, module2, false);
                }
            } else if (dependency.getType() == 5) {
                Module module3;
                string = dependency.getName();
                Set set3 = (Set)this.providersOf.get(string);
                if (set3 == null) {
                    throw new IllegalStateException("Should have found a provider of: " + string);
                }
                object = set3.iterator();
                boolean bl2 = false;
                while (object.hasNext()) {
                    module3 = (Module)((Object)object.next());
                    if (!module3.isEnabled() && (!module3.getProblems().isEmpty() || !set2.contains((Object)module3))) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    object = set3.iterator();
                    while (object.hasNext()) {
                        module3 = (Module)((Object)object.next());
                        this.maybeAddToEnableList(set, set2, module3, true);
                        if (bl2 || !set.contains((Object)module3)) continue;
                        bl2 = true;
                    }
                    if (!bl2) {
                        throw new IllegalStateException("Should have found a nonproblematic provider of: " + string);
                    }
                }
            }
            ++n;
        }
    }

    private boolean searchForPossibleEager(Set set, Set set2, Set set3) {
        boolean bl = false;
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (set.contains((Object)module)) {
                iterator.remove();
                continue;
            }
            if (!module.isEager() || !this.couldBeEnabledWithEagers(module, set, new HashSet())) continue;
            bl = true;
            iterator.remove();
            this.maybeAddToEnableList(set, set3, module, false);
        }
        return bl;
    }

    private boolean couldBeEnabledWithEagers(Module module, Set set, Set set2) {
        if (module.isEnabled() || set.contains((Object)module)) {
            return true;
        }
        if (!module.isAutoload() && !module.isEager()) {
            return false;
        }
        if (!module.getProblems().isEmpty()) {
            return false;
        }
        if (!set2.add(module)) {
            return true;
        }
        Dependency[] dependencyArray = module.getDependenciesArray();
        int n = 0;
        while (n < dependencyArray.length) {
            Module module2;
            Object object;
            Dependency dependency = dependencyArray[n];
            if (dependency.getType() == 1) {
                object = dependency.getName();
                int n2 = ((String)object).lastIndexOf(47);
                Object object2 = n2 == -1 ? object : ((String)object).substring(0, n2);
                module2 = this.get((String)object2);
                if (module2 == null) {
                    throw new IllegalStateException("Should have found module: " + (String)object2);
                }
                if (!this.couldBeEnabledWithEagers(module2, set, set2)) {
                    return false;
                }
            } else if (dependency.getType() == 5) {
                object = (Set)this.providersOf.get(dependency.getName());
                if (object == null) {
                    throw new IllegalStateException("Should have found a provider of: " + dependency.getName());
                }
                Iterator iterator = object.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    module2 = (Module)((Object)iterator.next());
                    if (!this.couldBeEnabledWithEagers(module2, set, set2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public List simulateDisable(Set set) throws IllegalArgumentException {
        Object object;
        if (set.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet hashSet = new HashSet(20);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (object.isAutoload()) {
                throw new IllegalArgumentException("Cannot disable autoload: " + (Object)object);
            }
            if (object.isEager()) {
                throw new IllegalArgumentException("Cannot disable eager module: " + (Object)object);
            }
            if (object.isFixed()) {
                throw new IllegalArgumentException("Cannot disable fixed module: " + (Object)object);
            }
            if (!object.isEnabled()) {
                throw new IllegalArgumentException("Already disabled: " + (Object)object);
            }
            this.addToDisableList(hashSet, (Module)((Object)object));
        }
        object = new HashSet(this.getEnabledModules());
        object.removeAll(hashSet);
        while (this.searchForUnusedAutoloads(hashSet, (Set)object)) {
        }
        try {
            return Utilities.partialSort(new ArrayList(hashSet), (Comparator)Util.dependencyComparator(true), (boolean)false);
        }
        catch (Utilities.UnorderableException unorderableException) {
            IllegalStateException illegalStateException = new IllegalStateException(unorderableException.toString());
            Util.err.annotate((Throwable)illegalStateException, (Throwable)unorderableException);
            throw illegalStateException;
        }
    }

    private void addToDisableList(Set set, Module module) {
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        Iterator iterator = this.modules.iterator();
        block0: while (iterator.hasNext()) {
            Module module2 = (Module)((Object)iterator.next());
            if (module2.isFixed() || !module2.isEnabled() || set.contains((Object)module2)) continue;
            Dependency[] dependencyArray = module2.getDependenciesArray();
            int n = 0;
            while (n < dependencyArray.length) {
                Dependency dependency = dependencyArray[n];
                if (dependency.getType() == 1) {
                    if (dependency.getName().equals(module.getCodeName())) {
                        this.addToDisableList(set, module2);
                        continue block0;
                    }
                } else if (dependency.getType() == 5 && module.provides(dependency.getName())) {
                    Iterator iterator2 = this.getEnabledModules().iterator();
                    boolean bl = false;
                    while (iterator2.hasNext()) {
                        Module module3 = (Module)((Object)iterator2.next());
                        if (!module3.isEnabled() || set.contains((Object)module3) || !module3.provides(dependency.getName())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.addToDisableList(set, module2);
                        continue block0;
                    }
                }
                ++n;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set set, Set set2) {
        boolean bl = false;
        Iterator iterator = set2.iterator();
        block0: while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (!module.isAutoload()) continue;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                Module module2 = (Module)((Object)iterator2.next());
                Dependency[] dependencyArray = module2.getDependenciesArray();
                int n = 0;
                while (n < dependencyArray.length) {
                    Dependency dependency = dependencyArray[n];
                    if (dependency.getType() == 1 ? dependency.getName().equals(module.getCodeName()) : dependency.getType() == 5 && module.provides(dependency.getName())) continue block0;
                    ++n;
                }
            }
            bl = true;
            iterator.remove();
            set.add(module);
        }
        return bl;
    }

    Set missingDependencies(Module module) {
        Map map = this.moduleProblems;
        synchronized (map) {
            Dependency[] dependencyArray;
            Dependency[] dependencyArray2;
            block18: {
                dependencyArray2 = (Dependency[])this.moduleProblems.get((Object)module);
                if (dependencyArray2 != null) break block18;
                dependencyArray2 = new HashSet();
                dependencyArray2.add(PROBING_IN_PROCESS);
                this.moduleProblems.put(module, dependencyArray2);
                dependencyArray = module.getDependenciesArray();
                int n = 0;
                while (n < dependencyArray.length) {
                    block19: {
                        int n2;
                        Object object;
                        String string;
                        Dependency dependency;
                        block20: {
                            Object object2;
                            block25: {
                                block26: {
                                    int n3;
                                    block27: {
                                        int n4;
                                        block22: {
                                            block24: {
                                                block23: {
                                                    block21: {
                                                        dependency = dependencyArray[n];
                                                        if (dependency.getType() == 2) break block19;
                                                        if (dependency.getType() != 1) break block20;
                                                        string = dependency.getName();
                                                        int n5 = string.lastIndexOf(47);
                                                        if (n5 == -1) {
                                                            object = string;
                                                            n2 = -1;
                                                            n4 = -1;
                                                        } else {
                                                            object = string.substring(0, n5);
                                                            object2 = string.substring(n5 + 1);
                                                            n3 = ((String)object2).indexOf(45);
                                                            if (n3 == -1) {
                                                                n4 = n2 = Integer.parseInt((String)object2);
                                                            } else {
                                                                n2 = Integer.parseInt(((String)object2).substring(0, n3));
                                                                n4 = Integer.parseInt(((String)object2).substring(n3 + 1));
                                                            }
                                                        }
                                                        object2 = this.get((String)object);
                                                        if (object2 != null) break block21;
                                                        dependencyArray2.add(dependency);
                                                        break block19;
                                                    }
                                                    if (n2 != n4) break block22;
                                                    if (n2 == ((Module)((Object)object2)).getCodeNameRelease()) break block23;
                                                    dependencyArray2.add(dependency);
                                                    break block19;
                                                }
                                                if (dependency.getComparison() != 2 || Utilities.compareObjects((Object)dependency.getVersion(), (Object)object2.getImplementationVersion())) break block24;
                                                dependencyArray2.add(dependency);
                                                break block19;
                                            }
                                            if (dependency.getComparison() != 1 || new SpecificationVersion(dependency.getVersion()).compareTo((Object)((Module)((Object)object2)).getSpecificationVersion()) <= 0) break block25;
                                            dependencyArray2.add(dependency);
                                            break block19;
                                        }
                                        if (n2 >= n4) break block26;
                                        n3 = ((Module)((Object)object2)).getCodeNameRelease();
                                        if (n3 >= n2 && n3 <= n4) break block27;
                                        dependencyArray2.add(dependency);
                                        break block19;
                                    }
                                    if (dependency.getComparison() == 2) {
                                        throw new IllegalStateException("No such thing as ranged impl dep");
                                    }
                                    if (dependency.getComparison() != 1 || n3 != n2 || new SpecificationVersion(dependency.getVersion()).compareTo((Object)((Module)((Object)object2)).getSpecificationVersion()) <= 0) break block25;
                                    dependencyArray2.add(dependency);
                                    break block19;
                                }
                                throw new IllegalStateException("Upside-down rel vers range");
                            }
                            if (!((Module)((Object)object2)).isEnabled() && !this.missingDependencies((Module)((Object)object2)).isEmpty()) {
                                dependencyArray2.add(dependency);
                            }
                            break block19;
                        }
                        if (dependency.getType() == 5) {
                            string = dependency.getName();
                            Set set = (Set)this.providersOf.get(string);
                            if (set == null) {
                                dependencyArray2.add(dependency);
                            } else {
                                object = set.iterator();
                                n2 = 0;
                                while (object.hasNext()) {
                                    Module module2 = (Module)((Object)object.next());
                                    if (module2.isEnabled()) {
                                        n2 = 1;
                                        continue;
                                    }
                                    if (!this.missingDependencies(module2).isEmpty()) continue;
                                    n2 = 1;
                                }
                                if (n2 == 0) {
                                    dependencyArray2.add(dependency);
                                }
                            }
                        } else if (!Util.checkJavaOrIDEDependency(dependency)) {
                            dependencyArray2.add(dependency);
                        }
                    }
                    ++n;
                }
                dependencyArray2.remove(PROBING_IN_PROCESS);
            }
            dependencyArray = dependencyArray2;
            return dependencyArray;
        }
    }

    private void clearProblemCache() {
        Iterator iterator = this.moduleProblems.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Set set;
            Map.Entry entry = iterator.next();
            Module module = (Module)((Object)entry.getKey());
            if (module.isEnabled() || (set = (Set)entry.getValue()) == null) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Dependency dependency;
                Object e = iterator2.next();
                if (e instanceof InvalidException || (dependency = (Dependency)e).getType() != 1 && dependency.getType() != 5) continue block0;
            }
            iterator.remove();
            this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        }
    }

    public boolean shutDown() {
        List list;
        try {
            list = Utilities.partialSort(new ArrayList(this.getEnabledModules()), (Comparator)Util.dependencyComparator(true), (boolean)false);
        }
        catch (Utilities.UnorderableException unorderableException) {
            Util.err.notify((Throwable)unorderableException);
            return true;
        }
        if (!this.installer.closing(list)) {
            return false;
        }
        this.installer.close(list);
        this.firer.stopFiring();
        return true;
    }

    private static final class SystemClassLoader
    extends ProxyClassLoader {
        public SystemClassLoader(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
            super(classLoaderArray);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Collected system class loader");
        }
    }
}

