/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLDecoder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.perftool.StartLog;
import org.netbeans.core.projects.SystemFileSystem;
import org.netbeans.core.projects.cache.LayerCacheManager;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NbBundle;

public class ModuleLayeredFileSystem
extends MultiFileSystem {
    private static final long serialVersionUID = 782910986724201983L;
    private static final String LAYER_STAMP = "layer-stamp.txt";
    static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.projects");
    private List urls;
    private File cacheDir;
    private LayerCacheManager manager;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$netbeans$core$projects$ModuleLayeredFileSystem;

    ModuleLayeredFileSystem(FileSystem fileSystem, File file) throws IOException {
        this(fileSystem, file, ModuleLayeredFileSystem.manager(file));
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, File file, LayerCacheManager layerCacheManager) throws IOException {
        super(new FileSystem[]{fileSystem, layerCacheManager != null ? ModuleLayeredFileSystem.loadCache(layerCacheManager) : new XMLFileSystem()});
        this.manager = layerCacheManager;
        this.cacheDir = layerCacheManager != null ? file : null;
        this.setPropagateMasks(true);
        this.urls = null;
    }

    private static LayerCacheManager manager(File file) throws IOException {
        if (file != null) {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Could not make dir: " + file);
            }
            String string = System.getProperty("netbeans.cache.layers", "org.netbeans.core.projects.cache.XMLLayerCacheManagerImpl");
            if (string.equals("-")) {
                err.log("Cache manager disabled");
                return null;
            }
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(class$java$io$File == null ? (class$java$io$File = ModuleLayeredFileSystem.class$("java.io.File")) : class$java$io$File);
                LayerCacheManager layerCacheManager = (LayerCacheManager)constructor.newInstance(file);
                err.log("Using cache manager of type " + string + " in " + file);
                return layerCacheManager;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.toString());
                err.annotate((Throwable)iOException, (Throwable)exception);
                throw iOException;
            }
        }
        err.log("No cache manager");
        return null;
    }

    private static FileSystem loadCache(LayerCacheManager layerCacheManager) throws IOException {
        if (layerCacheManager.cacheExists()) {
            FileSystem fileSystem;
            TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$ModuleLayeredFileSystem == null ? (class$org$netbeans$core$projects$ModuleLayeredFileSystem = ModuleLayeredFileSystem.class$("org.netbeans.core.projects.ModuleLayeredFileSystem")) : class$org$netbeans$core$projects$ModuleLayeredFileSystem), (String)"MSG_start_load_cache"));
            String string = "Loading layers from " + layerCacheManager.getCacheDirectory();
            StartLog.logStart(string);
            try {
                fileSystem = layerCacheManager.createLoadedFileSystem();
            }
            catch (IOException iOException) {
                err.notify(1, (Throwable)iOException);
                layerCacheManager.cleanupCache();
                ModuleLayeredFileSystem.cleanStamp(layerCacheManager.getCacheDirectory());
                fileSystem = layerCacheManager.createEmptyFileSystem();
            }
            TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$ModuleLayeredFileSystem == null ? (class$org$netbeans$core$projects$ModuleLayeredFileSystem = ModuleLayeredFileSystem.class$("org.netbeans.core.projects.ModuleLayeredFileSystem")) : class$org$netbeans$core$projects$ModuleLayeredFileSystem), (String)"MSG_end_load_cache"));
            StartLog.logEnd(string);
            return fileSystem;
        }
        return layerCacheManager.createEmptyFileSystem();
    }

    private static void cleanStamp(File file) throws IOException {
        File file2 = new File(file, LAYER_STAMP);
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Could not delete: " + file2);
        }
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.getDelegates()[0];
    }

    public static FileSystem create(File file, File file2) throws PropertyVetoException, IOException {
        return SystemFileSystem.create(file, file2);
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        SystemFileSystem systemFileSystem = (SystemFileSystem)TopManager.getDefault().getRepository().getDefaultFileSystem();
        ModuleLayeredFileSystem moduleLayeredFileSystem = systemFileSystem.getInstallationLayer();
        if (moduleLayeredFileSystem != null) {
            return moduleLayeredFileSystem;
        }
        return systemFileSystem.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem systemFileSystem = (SystemFileSystem)TopManager.getDefault().getRepository().getDefaultFileSystem();
        return systemFileSystem.getUserLayer();
    }

    public void setURLs(final List list) throws Exception {
        Stamp stamp;
        File file;
        if (list.contains(null)) {
            throw new NullPointerException("urls=" + list);
        }
        if (err.isLoggable(1)) {
            err.log("setURLs: " + list);
        }
        if (this.urls != null && list.equals(this.urls)) {
            err.log("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        if (this.cacheDir != null) {
            file = new File(this.cacheDir, LAYER_STAMP);
            stamp = new Stamp(list);
        } else {
            file = null;
            stamp = null;
        }
        if (this.cacheDir != null && file.isFile()) {
            BufferedReader bufferedReader;
            block10: {
                err.log("Stamp of new URLs: " + stamp.getHash());
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                try {
                    long l;
                    String string = bufferedReader.readLine();
                    try {
                        l = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException(numberFormatException.toString());
                    }
                    err.log("Stamp in the cache: " + l);
                    if (l != stamp.getHash()) break block10;
                    err.log("Cache hit!");
                    this.urls = list;
                    StartLog.logEnd("setURLs");
                    Object var10_8 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    bufferedReader.close();
                    throw throwable;
                }
                bufferedReader.close();
                return;
            }
            Object var10_9 = null;
            bufferedReader.close();
            {
            }
        }
        this.runAtomicAction(new FileSystem.AtomicAction(){
            static /* synthetic */ Class class$org$netbeans$core$projects$ModuleLayeredFileSystem;

            public void run() throws IOException {
                ModuleLayeredFileSystem moduleLayeredFileSystem = ModuleLayeredFileSystem.this;
                synchronized (moduleLayeredFileSystem) {
                    if (ModuleLayeredFileSystem.this.manager != null) {
                        TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$ModuleLayeredFileSystem == null ? (class$org$netbeans$core$projects$ModuleLayeredFileSystem = 1.class$("org.netbeans.core.projects.ModuleLayeredFileSystem")) : class$org$netbeans$core$projects$ModuleLayeredFileSystem), (String)"MSG_start_rewrite_cache"));
                        err.log("Rewriting cache in " + ModuleLayeredFileSystem.this.cacheDir);
                        try {
                            ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.super.getDelegates()[1], list);
                        }
                        catch (IOException iOException) {
                            err.notify(1, (Throwable)iOException);
                            err.log("Abandoning cache manager");
                            ModuleLayeredFileSystem.this.manager.cleanupCache();
                            ModuleLayeredFileSystem.cleanStamp(ModuleLayeredFileSystem.this.cacheDir);
                            ModuleLayeredFileSystem.this.manager = null;
                            ModuleLayeredFileSystem.this.cacheDir = null;
                            XMLFileSystem xMLFileSystem = new XMLFileSystem();
                            try {
                                xMLFileSystem.setXmlUrls(list.toArray(new URL[list.size()]));
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                IOException iOException2 = new IOException(propertyVetoException.toString());
                                err.annotate((Throwable)iOException2, (Throwable)propertyVetoException);
                                throw iOException2;
                            }
                            ModuleLayeredFileSystem.super.setDelegates(new FileSystem[]{ModuleLayeredFileSystem.super.getDelegates()[0], xMLFileSystem});
                            return;
                        }
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                        try {
                            outputStreamWriter.write(Long.toString(stamp.getHash()));
                            outputStreamWriter.write("\nLine above is identifying hash key, do not edit!\nBelow is metadata about all-layer.xml, for debugging purposes.\n");
                            outputStreamWriter.write(stamp.toString());
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            ((Writer)outputStreamWriter).close();
                            throw throwable;
                        }
                        ((Writer)outputStreamWriter).close();
                        TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$ModuleLayeredFileSystem == null ? (class$org$netbeans$core$projects$ModuleLayeredFileSystem = 1.class$("org.netbeans.core.projects.ModuleLayeredFileSystem")) : class$org$netbeans$core$projects$ModuleLayeredFileSystem), (String)"MSG_end_rewrite_cache"));
                    } else {
                        try {
                            ((XMLFileSystem)ModuleLayeredFileSystem.super.getDelegates()[1]).setXmlUrls(list.toArray(new URL[list.size()]));
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            IOException iOException = new IOException(propertyVetoException.toString());
                            err.annotate((Throwable)iOException, (Throwable)propertyVetoException);
                            throw iOException;
                        }
                    }
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        this.urls = list;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList arrayList = new ArrayList(collection);
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        this.setURLs(arrayList);
    }

    public void removeURLs(Collection collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList arrayList = new ArrayList();
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        ((AbstractCollection)arrayList).removeAll(collection);
        this.setURLs(arrayList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Stamp
    implements Comparator {
        private final List urls;
        private final long[] times;
        private final long hash;
        private static final boolean isJDK14 = false;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$io$File;

        public Stamp(List list) throws IOException {
            this.urls = new ArrayList(list);
            Collections.sort(this.urls, this);
            this.times = new long[this.urls.size()];
            long l = 17L;
            Iterator iterator = this.urls.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                String string = uRL.toString();
                l += 3199876987199633L;
                l ^= (long)string.hashCode();
                File file = Stamp.findFile(string);
                if (file != null) {
                    int n2 = n++;
                    long l2 = file.lastModified();
                    this.times[n2] = l2;
                    l ^= l2;
                    continue;
                }
                this.times[n++] = 0L;
            }
            this.hash = l;
        }

        private static File findFile(String string) throws IOException {
            if (string.startsWith("jar:") && string.lastIndexOf("!/") != -1) {
                string = string.substring(4, string.lastIndexOf("!/"));
            }
            if (string.startsWith("file:")) {
                URL uRL = new URL(string);
                String string2 = URLDecoder.decode(uRL.getPath());
                if (File.separatorChar != '/') {
                    string2 = string2.replace('/', File.separatorChar);
                }
                return new File(string2);
            }
            return null;
        }

        public long getHash() {
            return this.hash;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.urls.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                long l;
                if ((l = this.times[n++]) == 0L) {
                    stringBuffer.append("<file not found>");
                } else {
                    stringBuffer.append(new Date(l));
                }
                stringBuffer.append('\t');
                stringBuffer.append(iterator.next());
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }

        public int compare(Object object, Object object2) {
            return ((URL)object).toString().compareTo(((URL)object2).toString());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

