/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.core.projects.FixedFileSystem;
import org.netbeans.core.projects.LocalFileSystemEx;
import org.netbeans.core.projects.ModuleLayeredFileSystem;
import org.netbeans.core.projects.SessionManager;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public final class SystemFileSystem
extends MultiFileSystem
implements FileSystem.Status {
    static final long serialVersionUID = -7761052280240991668L;
    private static final String SYSTEM_NAME = "SystemFileSystem";
    private static final String ATTR_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final String ATTR_ICON_16 = "SystemFileSystem.icon";
    private static final String ATTR_ICON_32 = "SystemFileSystem.icon32";
    static final String ATTR_LAYER = "SystemFileSystem.layer";
    private ModuleLayeredFileSystem user;
    private ModuleLayeredFileSystem home;
    private static MessageFormat homeFormat;
    private static MessageFormat userFormat;
    private static final ThreadLocal newFiles;
    static /* synthetic */ Class class$org$netbeans$core$projects$SystemFileSystem;

    private SystemFileSystem(FileSystem[] fileSystemArray) throws PropertyVetoException {
        super(fileSystemArray);
        this.user = (ModuleLayeredFileSystem)fileSystemArray[0];
        this.home = fileSystemArray.length > 2 ? (ModuleLayeredFileSystem)fileSystemArray[1] : null;
        this.setSystemName(SYSTEM_NAME);
        this.setHidden(true);
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$projects$SystemFileSystem == null ? (class$org$netbeans$core$projects$SystemFileSystem = SystemFileSystem.class$("org.netbeans.core.projects.SystemFileSystem")) : class$org$netbeans$core$projects$SystemFileSystem), (String)"CTL_SystemFileSystem");
    }

    public ModuleLayeredFileSystem getInstallationLayer() {
        return this.home;
    }

    public ModuleLayeredFileSystem getUserLayer() {
        return this.user;
    }

    public final void setLayers(FileSystem[] fileSystemArray) throws IllegalArgumentException {
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (hashSet.contains(fileSystemArray[n])) {
                throw new IllegalArgumentException("Overlap in filesystem layers");
            }
            hashSet.add(fileSystemArray[n]);
            ++n;
        }
        this.setDelegates((FileSystem[])fileSystemArray.clone());
        this.firePropertyChange("layers", null, null);
    }

    public FileSystem[] getLayers() {
        return (FileSystem[])this.getDelegates().clone();
    }

    public static void setLayerForNew(String string, String string2) {
        if (string2 == null) {
            newFiles.set(null);
        } else {
            newFiles.set(new String[]{string, string2});
        }
    }

    protected FileSystem createWritableOnForRename(String string, String string2) throws IOException {
        return this.createWritableOn(string);
    }

    protected FileSystem createWritableOn(String string) throws IOException {
        FileSystem fileSystem;
        FileObject fileObject = this.findResource(string);
        int n = 0;
        FileSystem fileSystem2 = SessionManager.getDefault().getLayer("project");
        FileSystem fileSystem3 = SessionManager.getDefault().getLayer("session");
        if (fileSystem2 != null) {
            n = 1;
            if (fileObject != null) {
                Boolean bl;
                fileSystem = this.findSystem(fileObject);
                if (fileSystem == fileSystem2 && SystemFileSystem.isWritableOn(string, fileSystem)) {
                    return fileSystem2;
                }
                if (fileSystem == fileSystem3 && SystemFileSystem.isWritableOn(string, fileSystem)) {
                    return fileSystem3;
                }
                String string2 = (String)fileObject.getAttribute(ATTR_LAYER);
                if (string2 != null) {
                    if (string2.equals("project")) {
                        return fileSystem2;
                    }
                    if (string2.equals("session")) {
                        return fileSystem3;
                    }
                }
                if ((bl = (Boolean)fileObject.getAttribute("global-layer")) != null && bl.equals(Boolean.FALSE)) {
                    return fileSystem2;
                }
            }
            if (this.isProjectSubFolder(string)) {
                return fileSystem2;
            }
        }
        fileSystem = this.getDelegates();
        while (n < ((FileSystem[])fileSystem).length) {
            if (!fileSystem[n].isReadOnly()) {
                return fileSystem[n];
            }
            ++n;
        }
        throw new IOException("No writable filesystems in our delegates");
    }

    protected Set createLocksOn(String string) throws IOException {
        LocalFileSystemEx.potentialLock(string);
        return super.createLocksOn(string);
    }

    private static boolean isWritableOn(String string, FileSystem fileSystem) {
        if (fileSystem.isReadOnly()) {
            return false;
        }
        if (fileSystem instanceof ModuleLayeredFileSystem) {
            FileSystem[] fileSystemArray = ((ModuleLayeredFileSystem)fileSystem).getLayers();
            int n = 0;
            while (n < fileSystemArray.length) {
                if (fileSystemArray[n].findResource(string) != null) {
                    return !fileSystemArray[n].isReadOnly();
                }
                ++n;
            }
            throw new IllegalArgumentException("did not find " + string + " on " + fileSystem);
        }
        return true;
    }

    private boolean isProjectSubFolder(String string) {
        FileObject fileObject;
        String string2;
        int n = string.lastIndexOf(47);
        boolean bl = false;
        if (n != -1) {
            string2 = string.substring(0, n);
        } else {
            string2 = string;
            bl = true;
        }
        String[] stringArray = (String[])newFiles.get();
        if (stringArray != null && string2.equals(stringArray[0])) {
            if (stringArray[1].equals("project")) {
                return true;
            }
            if (stringArray[1].equals("session")) {
                return false;
            }
        }
        if ((fileObject = this.findResource(string2)) != null) {
            Boolean bl2;
            String string3 = (String)fileObject.getAttribute(ATTR_LAYER);
            if (string3 != null) {
                if (string3.equals("project")) {
                    return true;
                }
                if (string3.equals("session")) {
                    return false;
                }
            }
            if ((bl2 = (Boolean)fileObject.getAttribute("global-layer")) != null && bl2.equals(Boolean.FALSE)) {
                return true;
            }
        }
        return bl ? false : this.isProjectSubFolder(string2);
    }

    public boolean isPersistent() {
        return true;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String string, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            FileObject fileObject = (FileObject)iterator.next();
            String string2 = (String)fileObject.getAttribute(ATTR_BUNDLE);
            if (string2 != null) {
                try {
                    string2 = Utilities.translate((String)string2);
                    object = NbBundle.getBundle((String)string2, (Locale)Locale.getDefault(), (ClassLoader)TopManager.getDefault().systemClassLoader());
                    try {
                        return ((ResourceBundle)object).getString(fileObject.getPackageNameExt('/', '.'));
                    }
                    catch (MissingResourceException missingResourceException) {
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().annotate((Throwable)missingResourceException, 0, "Computing display name for " + fileObject, null, null, null);
                    ErrorManager.getDefault().notify(1, (Throwable)missingResourceException);
                }
            }
            if ((object = FixedFileSystem.deflt.annotateName(fileObject.toString())) == null) continue;
            return object;
        }
        return this.annotateNameNoLocalization(string, set);
    }

    private String annotateNameNoLocalization(String string, Set set) {
        if (this.home == null || this.user == null) {
            return string;
        }
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (!fileObject.isRoot()) {
                ++n;
            }
            if (this.findSystem(fileObject) != this.home) continue;
            return SystemFileSystem.getHomeFormat().format(new Object[]{string});
        }
        if (n == 0) {
            return string;
        }
        return SystemFileSystem.getUserFormat().format(new Object[]{string});
    }

    public Image annotateIcon(Image image, int n, Set set) {
        String string;
        if (n == 1) {
            string = ATTR_ICON_16;
        } else if (n == 2) {
            string = ATTR_ICON_32;
        } else {
            return image;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Image image2;
            FileObject fileObject = (FileObject)iterator.next();
            Object object = fileObject.getAttribute(string);
            if (object != null) {
                if (object instanceof URL) {
                    return Toolkit.getDefaultToolkit().getImage((URL)object);
                }
                if (object instanceof Image) {
                    return (Image)object;
                }
                ErrorManager.getDefault().log(16, "Attribute " + string + " on " + fileObject + " expected to be a URL or Image; was: " + object);
            }
            if ((image2 = FixedFileSystem.deflt.annotateIcon(fileObject.toString())) == null) continue;
            return image2;
        }
        return image;
    }

    static SystemFileSystem create(File file, File file2) throws PropertyVetoException, IOException {
        LocalFileSystemEx localFileSystemEx;
        Object object;
        FileSystem[] fileSystemArray;
        if (file != null) {
            fileSystemArray = new LocalFileSystemEx();
            fileSystemArray.setRootDirectory(file);
            object = fileSystemArray;
        } else {
            object = new XMLFileSystem();
        }
        if (Utilities.compareObjects((Object)file, (Object)file2)) {
            localFileSystemEx = null;
        } else {
            localFileSystemEx = new LocalFileSystemEx();
            localFileSystemEx.setRootDirectory(file2);
            localFileSystemEx.setReadOnly(true);
        }
        fileSystemArray = new FileSystem[localFileSystemEx == null ? 2 : 3];
        fileSystemArray[0] = new ModuleLayeredFileSystem((FileSystem)object, null);
        if (localFileSystemEx != null) {
            File file3 = new File(file.getParentFile(), "cache");
            fileSystemArray[1] = new ModuleLayeredFileSystem((FileSystem)localFileSystemEx, file3);
        }
        FixedFileSystem.deflt = new FixedFileSystem("org.netbeans.core.projects.FixedFileSystem", "Automatic Manifest Installation");
        fileSystemArray[localFileSystemEx == null ? 1 : 2] = FixedFileSystem.deflt;
        return new SystemFileSystem(fileSystemArray);
    }

    private static MessageFormat getUserFormat() {
        if (userFormat == null) {
            userFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$SystemFileSystem == null ? (class$org$netbeans$core$projects$SystemFileSystem = SystemFileSystem.class$("org.netbeans.core.projects.SystemFileSystem")) : class$org$netbeans$core$projects$SystemFileSystem), (String)"CTL_UserFile"));
        }
        return userFormat;
    }

    private static MessageFormat getHomeFormat() {
        if (homeFormat == null) {
            homeFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$SystemFileSystem == null ? (class$org$netbeans$core$projects$SystemFileSystem = SystemFileSystem.class$("org.netbeans.core.projects.SystemFileSystem")) : class$org$netbeans$core$projects$SystemFileSystem), (String)"CTL_HomeFile"));
        }
        return homeFormat;
    }

    protected void notifyMigration(FileObject fileObject) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fileObject, false, true));
    }

    private Object writeReplace() throws ObjectStreamException {
        new NotSerializableException("WARNING - SystemFileSystem is not designed to be serialized").printStackTrace();
        return new SingletonSerializer();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        newFiles = new ThreadLocal();
    }

    public static class StructureNode
    extends AbstractNode {
        public StructureNode() {
            this(TopManager.getDefault().getRepository().getDefaultFileSystem());
        }

        public StructureNode(FileSystem fileSystem) {
            super((Children)new StructureChildren(fileSystem));
            this.setName(fileSystem.getSystemName());
            this.setDisplayName(fileSystem.getDisplayName());
        }

        private static class StructureChildren
        extends Children.Keys
        implements PropertyChangeListener {
            private FileSystem fs;

            public StructureChildren(FileSystem fileSystem) {
                this.fs = fileSystem;
                if (fileSystem instanceof SystemFileSystem || fileSystem instanceof ModuleLayeredFileSystem) {
                    fileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)fileSystem));
                }
            }

            protected void addNotify() {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this.fs.getRoot());
                if (this.fs instanceof SystemFileSystem) {
                    arrayList.addAll(Arrays.asList(((SystemFileSystem)this.fs).getLayers()));
                } else if (this.fs instanceof ModuleLayeredFileSystem) {
                    arrayList.addAll(Arrays.asList(((ModuleLayeredFileSystem)this.fs).getLayers()));
                }
                this.setKeys(arrayList);
            }

            protected void removeNotify() {
                this.setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object object) {
                if (object instanceof FileObject) {
                    try {
                        return new Node[]{new RootNode(this.fs, DataObject.find((FileObject)((FileObject)object)).getNodeDelegate())};
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                        return new Node[0];
                    }
                }
                return new Node[]{new StructureNode((FileSystem)object)};
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("layers".equals(propertyChangeEvent.getPropertyName())) {
                    RequestProcessor.postRequest((Runnable)new Runnable(){

                        public void run() {
                            this.addNotify();
                        }
                    });
                }
            }

            private static class RootNode
            extends FilterNode {
                public RootNode(FileSystem fileSystem, Node node) {
                    super(node);
                    this.disableDelegation(15);
                    this.setName(fileSystem.getSystemName());
                    this.setDisplayName("Root of " + fileSystem.getDisplayName());
                }
            }
        }
    }

    private static final class SingletonSerializer
    implements Serializable {
        private static final long serialVersionUID = 6436781994611L;

        private SingletonSerializer() {
        }

        private Object readResolve() throws ObjectStreamException {
            return TopManager.getDefault().getRepository().getDefaultFileSystem();
        }
    }
}

