/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import org.openide.awt.JPopupMenuPlus;

public class ArrowsTabbedPaneUI
extends TabbedPaneUI {
    public static final int TAB_LIST_INDICATE_NONE = 0;
    public static final int TAB_LIST_INDICATE_CHECKBOX = 1;
    public static final int TAB_LIST_INDICATE_CHECKBOXALL = 2;
    public static final int TAB_LIST_INDICATE_RADIOBUTTON = 3;
    public static final int TAB_LIST_INDICATE_RADIOBUTTONALL = 4;
    private static final int TAB_LIST_INDICATE_DEFAULT = 3;
    private static final int TAB_LIST_INDICATE_MIN = 0;
    private static final int TAB_LIST_INDICATE_MAX = 4;
    private static final boolean SORT_TABLIST_DEFAULT = false;
    private static final String SORT_TEXT_DEFAULT = null;
    private static final int SIZE_MINIMUM = 1;
    private static final int SIZE_MAXIMUM = 2;
    private static final int SIZE_PREFERRED = 3;
    private static final int TAB_SPACEX = 2;
    private static final int TAB_SPACEY = 2;
    private static final int TAB_2SPACEX = 4;
    private static final int TAB_2SPACEY = 4;
    private static final int SPACE_TAB = 0;
    private static final int SPACE_ARROWS = 2;
    private static final int SPACE_TAB_BORDER_LEFT = 3;
    private static final int SPACE_TAB_BORDER_RIGHT = 3;
    private static final int SPACE_TAB_BORDER_TOP = 2;
    private static final int SPACE_TAB_BORDER_BOTTOM = 2;
    private static final int SPACE_TAB_TEXTICON = 3;
    private static final int SPACE_TAB_BORDER_LEFT_RIGHT = 6;
    private static final int SPACE_TAB_BORDER_TOP_BOTTOM = 4;
    private static final int SPACE_TAB_BORDER_LEFT_TEXTICON = 6;
    private static final Color COLOR_BORDER_LEFTTOP = UIManager.getColor("TabbedPane.lightHighlight");
    private static final Color COLOR_BORDER_RIGHTBOTTOM = UIManager.getColor("TabbedPane.darkShadow");
    private static final Color COLOR_BORDER_TABNOACTUAL = UIManager.getColor("TabbedPane.highlight");
    private static final Color COLOR_BACKGROUND_TABNOACTUAL = UIManager.getColor("TabbedPane.shadow");
    private static final Color COLOR_BORDER_FOCUS = UIManager.getColor("TabbedPane.focus");
    private static final String IMAGE_PACKAGE = "org/netbeans/core/resources/";
    private static final String IMAGE_ARROW_PREVIOUS_HORIZONTAL = "org/netbeans/core/resources/arrowleft.gif";
    private static final String IMAGE_ARROW_PREVIOUS_VERTICAL = "org/netbeans/core/resources/arrowtop.gif";
    private static final String IMAGE_ARROW_NEXT_HORIZONTAL = "org/netbeans/core/resources/arrowright.gif";
    private static final String IMAGE_ARROW_NEXT_VERTICAL = "org/netbeans/core/resources/arrowbottom.gif";
    private static final String IMAGE_LIST = "org/netbeans/core/resources/listoftabs.gif";
    private boolean sortTabsList = false;
    private int tabStart = 0;
    private boolean explicitTabStart = false;
    private int listTabIndicate = 3;
    private String sortText = SORT_TEXT_DEFAULT;
    private JPopupMenuPlus popupMenu = null;
    private JTabbedPane tabbedPane = null;
    private LayoutManager layoutManager = null;
    private Rectangle[] tabBounds = null;
    private Rectangle boundsArrowPrevious = null;
    private Rectangle boundsArrowNext = null;
    private Rectangle boundsArrowList = null;
    private HashMap images = new HashMap();
    private ChangeListener changeListener = new TabbedPaneChangeListener();
    private TabbedPaneMouseListener mouseListener = new TabbedPaneMouseListener();
    private TabbedPaneFocusListener focusListener = new TabbedPaneFocusListener();
    private MenuItemComparator comparator = null;
    private boolean recursePaintTabs = false;

    public ArrowsTabbedPaneUI() {
        this(false, 3, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(boolean bl) {
        this(bl, 3, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(int n) {
        this(false, n, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(String string) {
        this(false, 3, string);
    }

    public ArrowsTabbedPaneUI(boolean bl, int n) {
        this(bl, n, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(boolean bl, String string) {
        this(bl, 3, string);
    }

    public ArrowsTabbedPaneUI(int n, String string) {
        this(false, n, string);
    }

    public ArrowsTabbedPaneUI(boolean bl, int n, String string) {
        this.setSortTabsList(bl);
        this.setListTabIndicate(n);
        this.setSortText(string);
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        int n3 = this.tabBounds != null ? this.tabBounds.length : 0;
        int n4 = 0;
        while (n4 < n3) {
            if (this.tabBounds[n4] != null && this.tabBounds[n4].contains(n, n2)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        if (this.tabBounds != null && n >= 0 && n < this.tabBounds.length) {
            return this.tabBounds[n];
        }
        return null;
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return 1;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new ArrowsTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.tabbedPane = (JTabbedPane)jComponent;
        this.layoutManager = this.tabbedPane.getLayout();
        this.tabbedPane.setLayout(this.createLayoutManager());
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.tabbedPane.setLayout(this.layoutManager);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
        }
        this.tabbedPane = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTabs(graphics);
        this.paintBorder(graphics);
    }

    public void setSortTabsList(boolean bl) {
        this.sortTabsList = bl;
    }

    public boolean getSortTabsList() {
        return this.sortTabsList;
    }

    private void changeSortTabsList(int n, int n2) {
        this.sortTabsList = !this.sortTabsList;
        this.displayTabList(n, n2);
    }

    public boolean setListTabIndicate(int n) {
        if (n < 0 || n > 4) {
            return false;
        }
        this.listTabIndicate = n;
        return true;
    }

    public int getListTabIndicate() {
        return this.listTabIndicate;
    }

    public void setSortText(String string) {
        this.sortText = string;
    }

    public String getSortText() {
        return this.sortText;
    }

    private void setTabStart(int n) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            this.tabStart = n;
            this.tabbedPane.setSelectedIndex(n);
            this.tabbedPane.revalidate();
            this.tabbedPane.repaint();
        }
    }

    private LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    private void installListeners() {
        this.tabbedPane.addChangeListener(this.changeListener);
        this.tabbedPane.addMouseListener(this.mouseListener);
        this.tabbedPane.addFocusListener(this.focusListener);
    }

    private void uninstallListeners() {
        this.tabbedPane.removeChangeListener(this.changeListener);
        this.tabbedPane.removeMouseListener(this.mouseListener);
        this.tabbedPane.removeFocusListener(this.focusListener);
    }

    private void installKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 1, (InputMap)UIManager.get("TabbedPane.ancestorInputMap"));
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 1, (InputMap)UIManager.get("TabbedPane.focusInputMap"));
        SwingUtilities.replaceUIActionMap(this.tabbedPane, this.createActionMap());
    }

    private void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 0, null);
        SwingUtilities.replaceUIActionMap(this.tabbedPane, null);
    }

    private ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateRight", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ArrowsTabbedPaneUI.this.tabbedPane.hasFocus() && ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() + 1 < ArrowsTabbedPaneUI.this.tabbedPane.getTabCount()) {
                    ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() + 1);
                    ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                    ArrowsTabbedPaneUI.this.tabbedPane.repaint();
                }
            }
        });
        actionMapUIResource.put("navigateLeft", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ArrowsTabbedPaneUI.this.tabbedPane.hasFocus() && ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() > 0) {
                    ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() - 1);
                    ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                    ArrowsTabbedPaneUI.this.tabbedPane.repaint();
                }
            }
        });
        actionMapUIResource.put("requestFocus", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrowsTabbedPaneUI.this.tabbedPane.requestFocus();
            }
        });
        return actionMapUIResource;
    }

    private void paintTabs(Graphics graphics) {
        boolean bl = true;
        int n = this.tabbedPane.getTabCount();
        if (this.tabStart >= n && n > 0) {
            this.tabStart = n - 1;
        }
        int n2 = this.tabbedPane.getSelectedIndex();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Dimension dimension = this.calculateTabsDimension(fontMetrics);
        Rectangle rectangle = new Rectangle(0, 0, this.tabbedPane.getWidth(), this.tabbedPane.getHeight());
        Rectangle rectangle2 = new Rectangle(2, 2, 0, 0);
        this.tabBounds = new Rectangle[n];
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n) {
            if (n5 < this.tabStart) {
                this.tabBounds[n5] = null;
            } else if (bl && (bl = this.calculateTabBounds(rectangle, n5, dimension, fontMetrics, rectangle2))) {
                this.tabBounds[n5] = new Rectangle(rectangle2);
                if (n3 == -1) {
                    n3 = n5;
                }
                n4 = n5;
            } else {
                this.tabBounds[n5] = null;
            }
            ++n5;
        }
        if (!this.explicitTabStart && n3 != -1 && !this.recursePaintTabs && this.tabBounds[n2] == null) {
            if (n2 < n3) {
                this.tabStart = n2;
                this.recursePaintTabs = true;
                try {
                    this.paintTabs(graphics);
                    Object var13_12 = null;
                    this.recursePaintTabs = false;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.recursePaintTabs = false;
                    throw throwable;
                }
                return;
            }
            if (n2 > n4) {
                if (this.tabStart + 1 < n) {
                    ++this.tabStart;
                    this.paintTabs(graphics);
                    return;
                }
            } else {
                throw new IllegalStateException("tabStart=" + this.tabStart + " actual=" + n2 + " firstDisplayed=" + n3 + " lastDisplayed=" + n4);
            }
        }
        this.calculateTabsCorrection(rectangle, dimension, this.tabStart > 0, !bl);
        int n6 = this.tabStart;
        while (n6 < n && this.tabBounds[n6] != null) {
            this.paintTab(graphics, n6, n6 == n2, this.tabBounds[n6], fontMetrics);
            ++n6;
        }
        this.paintArrows(graphics, rectangle, dimension, this.tabStart > 0, !bl);
    }

    private void paintBorder(Graphics graphics) {
        if (this.tabBounds != null && this.tabStart >= 0 && this.tabStart < this.tabBounds.length && this.tabBounds[this.tabStart] != null) {
            switch (this.tabbedPane.getTabPlacement()) {
                case 3: {
                    this.paintBorderBottom(graphics);
                    break;
                }
                case 2: {
                    this.paintBorderLeft(graphics);
                    break;
                }
                case 4: {
                    this.paintBorderRight(graphics);
                    break;
                }
                default: {
                    this.paintBorderTop(graphics);
                }
            }
        }
    }

    private void paintBorderTop(Graphics graphics) {
        int n = 0;
        int n2 = this.tabbedPane.getWidth() - 1;
        int n3 = this.tabBounds[this.tabStart].y + this.tabBounds[this.tabStart].height;
        int n4 = this.tabbedPane.getHeight() - 1;
        int n5 = this.calculateTabBoundsHorizontalStart();
        int n6 = this.calculateTabBoundsHorizontalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(n, n3, n5, n3);
        graphics.drawLine(n6, n3, n2, n3);
        graphics.drawLine(n, n3, n, n4);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(n, n4, n2, n4);
        graphics.drawLine(n2, n3, n2, n4);
        graphics.setColor(color);
    }

    private void paintBorderBottom(Graphics graphics) {
        int n = 0;
        int n2 = this.tabbedPane.getWidth() - 1;
        int n3 = 0;
        int n4 = this.tabBounds[this.tabStart].y;
        int n5 = this.calculateTabBoundsHorizontalStart();
        int n6 = this.calculateTabBoundsHorizontalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(n, n3, n2, n3);
        graphics.drawLine(n, n3, n, n4);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(n, n4, n5, n4);
        graphics.drawLine(n6, n4, n2, n4);
        graphics.drawLine(n2, n3, n2, n4);
        graphics.setColor(color);
    }

    private void paintBorderLeft(Graphics graphics) {
        int n = this.tabBounds[this.tabStart].x + this.tabBounds[this.tabStart].width;
        int n2 = this.tabbedPane.getWidth() - 1;
        int n3 = 0;
        int n4 = this.tabbedPane.getHeight() - 1;
        int n5 = this.calculateTabBoundsVerticalStart();
        int n6 = this.calculateTabBoundsVerticalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(n, n3, n2, n3);
        graphics.drawLine(n, n3, n, n5);
        graphics.drawLine(n, n6, n, n4);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(n, n4, n2, n4);
        graphics.drawLine(n2, n3, n2, n4);
        graphics.setColor(color);
    }

    private void paintBorderRight(Graphics graphics) {
        int n = 0;
        int n2 = this.tabBounds[this.tabStart].x;
        int n3 = 0;
        int n4 = this.tabbedPane.getHeight() - 1;
        int n5 = this.calculateTabBoundsVerticalStart();
        int n6 = this.calculateTabBoundsVerticalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(n, n3, n2, n3);
        graphics.drawLine(n, n3, n, n4);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(n, n4, n2, n4);
        graphics.drawLine(n2, n3, n2, n5);
        graphics.drawLine(n2, n6, n2, n4);
        graphics.setColor(color);
    }

    private int calculateTabBoundsHorizontalStart() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0 || this.tabBounds[n] == null) {
            return 0;
        }
        return this.tabBounds[n].x;
    }

    private int calculateTabBoundsHorizontalEnd() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0 || this.tabBounds[n] == null) {
            return 0;
        }
        return this.tabBounds[n].x + this.tabBounds[n].width;
    }

    private int calculateTabBoundsVerticalStart() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0 || this.tabBounds[n] == null) {
            return 0;
        }
        return this.tabBounds[n].y;
    }

    private int calculateTabBoundsVerticalEnd() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0 || this.tabBounds[n] == null) {
            return 0;
        }
        return this.tabBounds[n].y + this.tabBounds[n].height;
    }

    private void paintTab(Graphics graphics, int n, boolean bl, Rectangle rectangle, FontMetrics fontMetrics) {
        String string = this.tabbedPane.getTitleAt(n);
        this.paintTabBorder(graphics, bl, rectangle);
        int n2 = this.paintTabIcon(graphics, n, rectangle);
        graphics.drawString(string, n2 + this.calculateCenter(rectangle.width + rectangle.x - n2, fontMetrics.stringWidth(string)) - 1, rectangle.y + fontMetrics.getHeight() + this.calculateCenter(rectangle.height, fontMetrics.getHeight() + fontMetrics.getDescent()) - fontMetrics.getDescent());
    }

    private void paintTabBorder(Graphics graphics, boolean bl, Rectangle rectangle) {
        switch (this.tabbedPane.getTabPlacement()) {
            case 3: {
                this.paintTabBorderBottom(graphics, bl, this.tabbedPane.hasFocus(), rectangle);
                break;
            }
            case 2: {
                this.paintTabBorderLeft(graphics, bl, this.tabbedPane.hasFocus(), rectangle);
                break;
            }
            case 4: {
                this.paintTabBorderRight(graphics, bl, this.tabbedPane.hasFocus(), rectangle);
                break;
            }
            default: {
                this.paintTabBorderTop(graphics, bl, this.tabbedPane.hasFocus(), rectangle);
            }
        }
    }

    private void paintTabBorderTop(Graphics graphics, boolean bl, boolean bl2, Rectangle rectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int n = this.calculateTabSlait(rectangle);
        int[] nArray = new int[]{rectangle.x, rectangle.x, rectangle.x + n, rectangle.x + rectangle.width, rectangle.x + rectangle.width};
        int[] nArray2 = new int[]{rectangle.y + rectangle.height, rectangle.y + n, rectangle.y, rectangle.y, rectangle.y + rectangle.height};
        Color color = graphics.getColor();
        if (bl) {
            if (bl2) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colorArray7 = colorArray3;
        if (!bl) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
        }
        int n2 = 0;
        while (n2 < colorArray7.length) {
            graphics.setColor(colorArray7[n2]);
            graphics.drawLine(nArray[0] + n2, nArray2[0] - n2 / 2, nArray[1] + n2, nArray2[1]);
            graphics.drawLine(nArray[1] + n2, nArray2[1], nArray[2], nArray2[2] + n2);
            graphics.drawLine(nArray[2], nArray2[2] + n2, nArray[3], nArray2[3] + n2);
            ++n2;
        }
        if (bl && bl2) {
            Color[] colorArray8 = new Color[2];
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray8;
            colorArray8[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray9 = new Color[1];
            colorArray2 = colorArray9;
            colorArray9[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colorArray7 = colorArray2;
        int n3 = 0;
        while (n3 < colorArray7.length) {
            graphics.setColor(colorArray7[n3]);
            graphics.drawLine(nArray[3] - n3, nArray2[3] + 2 * n3, nArray[4] - n3, nArray2[4] - n3);
            ++n3;
        }
        if (bl && bl2) {
            Color[] colorArray10 = new Color[1];
            colorArray = colorArray10;
            colorArray10[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colorArray7 = colorArray;
        int n4 = 0;
        while (n4 < colorArray7.length) {
            graphics.setColor(colorArray7[n4]);
            graphics.drawLine(nArray[0] + 2, nArray2[0] - n4 - 1, nArray[4], nArray2[4] - n4 - 1);
            ++n4;
        }
        graphics.setColor(color);
    }

    private void paintTabBorderBottom(Graphics graphics, boolean bl, boolean bl2, Rectangle rectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int n = this.calculateTabSlait(rectangle);
        int[] nArray = new int[]{rectangle.x, rectangle.x, rectangle.x + n, rectangle.x + rectangle.width, rectangle.x + rectangle.width};
        int[] nArray2 = new int[]{rectangle.y, rectangle.y + rectangle.height - n - 1, rectangle.y + rectangle.height - 1, rectangle.y + rectangle.height - 1, rectangle.y};
        Color color = graphics.getColor();
        if (bl) {
            if (bl2) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colorArray7 = colorArray3;
        if (!bl) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
        }
        int n2 = 0;
        while (n2 < colorArray7.length) {
            graphics.setColor(colorArray7[n2]);
            graphics.drawLine(nArray[0] + n2, nArray2[0] + n2 / 2, nArray[1] + n2, nArray2[1]);
            graphics.drawLine(nArray[1] + n2, nArray2[1], nArray[2] + n2, nArray2[2]);
            ++n2;
        }
        if (bl && bl2) {
            Color[] colorArray8 = new Color[2];
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray8;
            colorArray8[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray9 = new Color[1];
            colorArray2 = colorArray9;
            colorArray9[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colorArray7 = colorArray2;
        int n3 = 0;
        while (n3 < colorArray7.length) {
            graphics.setColor(colorArray7[n3]);
            graphics.drawLine(nArray[2] + n3, nArray2[2] - n3, nArray[3] - n3, nArray2[3] - n3);
            graphics.drawLine(nArray[3] - n3, nArray2[3] - n3, nArray[4] - n3, nArray2[4] - n3 + 2 * n3);
            ++n3;
        }
        if (bl && bl2) {
            Color[] colorArray10 = new Color[1];
            colorArray = colorArray10;
            colorArray10[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colorArray7 = colorArray;
        int n4 = 0;
        while (n4 < colorArray7.length) {
            graphics.setColor(colorArray7[n4]);
            graphics.drawLine(nArray[0] + 2, nArray2[0] - n4 + 1, nArray[4], nArray2[4] - n4 + 1);
            ++n4;
        }
        graphics.setColor(color);
    }

    private void paintTabBorderLeft(Graphics graphics, boolean bl, boolean bl2, Rectangle rectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int n = this.calculateTabSlait(rectangle);
        int[] nArray = new int[]{rectangle.x + rectangle.width, rectangle.x + n, rectangle.x, rectangle.x, rectangle.x + rectangle.width};
        int[] nArray2 = new int[]{rectangle.y, rectangle.y, rectangle.y + n, rectangle.y + rectangle.height, rectangle.y + rectangle.height};
        Color color = graphics.getColor();
        if (bl) {
            if (bl2) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colorArray7 = colorArray3;
        if (!bl) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
        }
        int n2 = 0;
        while (n2 < colorArray7.length) {
            graphics.setColor(colorArray7[n2]);
            graphics.drawLine(nArray[0] - n2 / 2, nArray2[0] + n2, nArray[1], nArray2[1] + n2);
            graphics.drawLine(nArray[1], nArray2[1] + n2, nArray[2] + n2, nArray2[2]);
            graphics.drawLine(nArray[2] + n2, nArray2[2], nArray[3] + n2, nArray2[3]);
            ++n2;
        }
        if (bl && bl2) {
            Color[] colorArray8 = new Color[2];
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray8;
            colorArray8[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray9 = new Color[1];
            colorArray2 = colorArray9;
            colorArray9[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colorArray7 = colorArray2;
        int n3 = 0;
        while (n3 < colorArray7.length) {
            graphics.setColor(colorArray7[n3]);
            graphics.drawLine(nArray[3] + 2 * n3, nArray2[3] - n3, nArray[4] - n3, nArray2[4] - n3);
            ++n3;
        }
        if (bl && bl2) {
            Color[] colorArray10 = new Color[1];
            colorArray = colorArray10;
            colorArray10[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colorArray7 = colorArray;
        int n4 = 0;
        while (n4 < colorArray7.length) {
            graphics.setColor(colorArray7[n4]);
            graphics.drawLine(nArray[0] - 1, nArray2[0] + 2, nArray[4] - 1, nArray2[4]);
            ++n4;
        }
        graphics.setColor(color);
    }

    private void paintTabBorderRight(Graphics graphics, boolean bl, boolean bl2, Rectangle rectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int n = this.calculateTabSlait(rectangle);
        int[] nArray = new int[]{rectangle.x, rectangle.x + rectangle.width - n, rectangle.x + rectangle.width, rectangle.x + rectangle.width, rectangle.x};
        int[] nArray2 = new int[]{rectangle.y, rectangle.y, rectangle.y + n, rectangle.y + rectangle.height, rectangle.y + rectangle.height};
        Color color = graphics.getColor();
        if (bl) {
            if (bl2) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colorArray7 = colorArray3;
        if (!bl) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
        }
        int n2 = 0;
        while (n2 < colorArray7.length) {
            graphics.setColor(colorArray7[n2]);
            graphics.drawLine(nArray[0] + n2 / 2, nArray2[0] + n2, nArray[1] - 1, nArray2[1] + n2);
            graphics.drawLine(nArray[1] - 1, nArray2[1] + n2, nArray[2] - n2 - 1, nArray2[2]);
            ++n2;
        }
        if (bl && bl2) {
            Color[] colorArray8 = new Color[2];
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray8;
            colorArray8[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray9 = new Color[1];
            colorArray2 = colorArray9;
            colorArray9[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colorArray7 = colorArray2;
        int n3 = 0;
        while (n3 < colorArray7.length) {
            graphics.setColor(colorArray7[n3]);
            graphics.drawLine(nArray[2] - n3 - 1, nArray2[2] + n3, nArray[3] - n3 - 1, nArray2[3] - 2 * n3);
            graphics.drawLine(nArray[3] - n3 - 1, nArray2[3] - n3, nArray[4] + 1, nArray2[4] - n3);
            ++n3;
        }
        if (bl && bl2) {
            Color[] colorArray10 = new Color[1];
            colorArray = colorArray10;
            colorArray10[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colorArray7 = colorArray;
        int n4 = 0;
        while (n4 < colorArray7.length) {
            graphics.setColor(colorArray7[n4]);
            graphics.drawLine(nArray[0] + 1, nArray2[0] + 2, nArray[4] + 1, nArray2[4]);
            ++n4;
        }
        graphics.setColor(color);
    }

    private int paintTabIcon(Graphics graphics, int n, Rectangle rectangle) {
        int n2 = this.calculateTabSlait(rectangle);
        Icon icon = this.tabbedPane.getIconAt(n);
        if (icon == null) {
            return rectangle.x + n2;
        }
        icon.paintIcon(this.tabbedPane, graphics, rectangle.x + 3 + n2, rectangle.y + 2);
        return rectangle.x + n2 + icon.getIconWidth() + 6;
    }

    private void paintArrows(Graphics graphics, Rectangle rectangle, Dimension dimension, boolean bl, boolean bl2) {
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        boolean bl3 = this.calculateArrowsPoints(rectangle, dimension, point, point2, point3);
        this.paintArrowPrevious(graphics, bl && bl2 ? point : (bl ? point2 : null), bl3);
        this.paintArrowNext(graphics, bl2 ? point3 : null, bl3);
        this.paintArrowList(graphics, bl2 ? point2 : (bl ? point3 : null));
    }

    private void paintArrowPrevious(Graphics graphics, Point point, boolean bl) {
        if (point == null) {
            this.boundsArrowPrevious = null;
        } else {
            Image image = this.getImage(bl ? IMAGE_ARROW_PREVIOUS_HORIZONTAL : IMAGE_ARROW_PREVIOUS_VERTICAL);
            graphics.drawImage(image, point.x, point.y, this.tabbedPane);
            this.boundsArrowPrevious = new Rectangle(point.x, point.y, this.getImageWidth(image), this.getImageHeight(image));
        }
    }

    private void paintArrowNext(Graphics graphics, Point point, boolean bl) {
        if (point == null) {
            this.boundsArrowNext = null;
        } else {
            Image image = this.getImage(bl ? IMAGE_ARROW_NEXT_HORIZONTAL : IMAGE_ARROW_NEXT_VERTICAL);
            graphics.drawImage(image, point.x, point.y, this.tabbedPane);
            this.boundsArrowNext = new Rectangle(point.x, point.y, this.getImageWidth(image), this.getImageHeight(image));
        }
    }

    private void paintArrowList(Graphics graphics, Point point) {
        if (point == null) {
            this.boundsArrowList = null;
        } else {
            Image image = this.getImage(IMAGE_LIST);
            graphics.drawImage(image, point.x, point.y, this.tabbedPane);
            this.boundsArrowList = new Rectangle(point.x, point.y, this.getImageWidth(image), this.getImageHeight(image));
        }
    }

    private Image getImage(String string) {
        URL uRL;
        Image image = (Image)this.images.get(string);
        if (image == null && (uRL = this.getClass().getClassLoader().getResource(string)) != null && (image = Toolkit.getDefaultToolkit().getImage(uRL)) != null) {
            this.images.put(string, image);
        }
        return image;
    }

    private int getImageWidth(Image image) {
        return image.getWidth(this.tabbedPane);
    }

    private int getImageWidth(String string) {
        return this.getImage(string).getWidth(this.tabbedPane);
    }

    private int getImageHeight(Image image) {
        return image.getHeight(this.tabbedPane);
    }

    private int getImageHeight(String string) {
        return this.getImage(string).getHeight(this.tabbedPane);
    }

    private boolean calculateArrowsPoints(Rectangle rectangle, Dimension dimension, Point point, Point point2, Point point3) {
        switch (this.tabbedPane.getTabPlacement()) {
            case 3: {
                return this.calculateArrowsPointsBottom(rectangle, dimension, point, point2, point3);
            }
            case 2: {
                return this.calculateArrowsPointsLeft(rectangle, dimension, point, point2, point3);
            }
            case 4: {
                return this.calculateArrowsPointsRight(rectangle, dimension, point, point2, point3);
            }
        }
        return this.calculateArrowsPointsTop(rectangle, dimension, point, point2, point3);
    }

    private boolean calculateArrowsPointsTop(Rectangle rectangle, Dimension dimension, Point point, Point point2, Point point3) {
        int n = this.getImageWidth(IMAGE_ARROW_PREVIOUS_HORIZONTAL);
        point.x = rectangle.x + rectangle.width - n - this.getImageWidth(IMAGE_ARROW_NEXT_HORIZONTAL) - this.getImageWidth(IMAGE_LIST) - 4;
        point.y = rectangle.y + this.calculateCenter(dimension.height, this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL));
        point2.x = point.x + n + 2;
        point2.y = point.y;
        point3.x = point2.x + n + 2;
        point3.y = point.y;
        return true;
    }

    private boolean calculateArrowsPointsBottom(Rectangle rectangle, Dimension dimension, Point point, Point point2, Point point3) {
        int n = this.getImageWidth(IMAGE_ARROW_PREVIOUS_HORIZONTAL);
        point.x = rectangle.x + rectangle.width - n - this.getImageWidth(IMAGE_ARROW_NEXT_HORIZONTAL) - this.getImageWidth(IMAGE_LIST) - 4;
        point.y = rectangle.y + rectangle.height - dimension.height + this.calculateCenter(dimension.height, this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL));
        point2.x = point.x + n + 2;
        point2.y = point.y;
        point3.x = point2.x + n + 2;
        point3.y = point.y;
        return true;
    }

    private boolean calculateArrowsPointsLeft(Rectangle rectangle, Dimension dimension, Point point, Point point2, Point point3) {
        int n = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL);
        point.x = rectangle.x + this.calculateCenter(dimension.width, this.getImageWidth(IMAGE_ARROW_PREVIOUS_VERTICAL));
        point.y = rectangle.y + rectangle.height - n - this.getImageHeight(IMAGE_ARROW_NEXT_VERTICAL) - this.getImageHeight(IMAGE_LIST) - 4;
        point2.x = point.x;
        point2.y = point.y + n + 2;
        point3.x = point.x;
        point3.y = point2.y + n + 2;
        return false;
    }

    private boolean calculateArrowsPointsRight(Rectangle rectangle, Dimension dimension, Point point, Point point2, Point point3) {
        int n = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL);
        point.x = rectangle.x + rectangle.width - dimension.width + this.calculateCenter(dimension.width, this.getImageWidth(IMAGE_ARROW_PREVIOUS_VERTICAL));
        point.y = rectangle.y + rectangle.height - n - this.getImageHeight(IMAGE_ARROW_NEXT_VERTICAL) - this.getImageHeight(IMAGE_LIST) - 4;
        point2.x = point.x;
        point2.y = point.y + n + 2;
        point3.x = point.x;
        point3.y = point2.y + n + 2;
        return false;
    }

    private Dimension calculateTabsDimension(FontMetrics fontMetrics) {
        int n = this.tabbedPane.getTabCount();
        if (fontMetrics == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.calculateTabWidth(n2, fontMetrics);
            if (n3 > dimension.width) {
                dimension.width = n3;
            }
            if ((n3 = this.calculateTabHeight(n2, fontMetrics)) > dimension.height) {
                dimension.height = n3;
            }
            ++n2;
        }
        return dimension;
    }

    private void calculateTabsCorrection(Rectangle rectangle, Dimension dimension, boolean bl, boolean bl2) {
        int n = this.tabBounds.length;
        int n2 = this.tabStart;
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        if (bl || bl2) {
            while (n2 < n && this.tabBounds[n2] != null) {
                ++n2;
            }
            if (n2 == n || this.tabBounds[n2] == null) {
                --n2;
            }
            if (n2 >= this.tabStart && this.tabBounds[n2] != null) {
                this.calculateArrowsPoints(rectangle, dimension, point, point2, point3);
                switch (this.tabbedPane.getTabPlacement()) {
                    case 2: 
                    case 4: {
                        this.calculateTabsCorrectionVertical(n2, bl && bl2 ? point.x : point2.x);
                        break;
                    }
                    default: {
                        this.calculateTabsCorrectionHorizontal(n2, bl && bl2 ? point.y : point2.y);
                    }
                }
            }
        }
    }

    private void calculateTabsCorrectionHorizontal(int n, int n2) {
    }

    private void calculateTabsCorrectionVertical(int n, int n2) {
    }

    private int calculateTabWidth(int n, FontMetrics fontMetrics) {
        Icon icon = this.tabbedPane.getIconAt(n);
        return fontMetrics.stringWidth(this.tabbedPane.getTitleAt(n)) + 6 + this.calculateTabSlait(this.calculateTabHeight(n, fontMetrics)) + (icon == null ? 0 : icon.getIconWidth() + 3);
    }

    private int calculateTabHeight(int n, FontMetrics fontMetrics) {
        int n2;
        int n3 = fontMetrics.getHeight();
        Icon icon = this.tabbedPane.getIconAt(n);
        return (icon == null || n3 > (n2 = icon.getIconHeight()) ? n3 : n2) + 4;
    }

    private boolean calculateTabBounds(Rectangle rectangle, int n, Dimension dimension, FontMetrics fontMetrics, Rectangle rectangle2) {
        switch (this.tabbedPane.getTabPlacement()) {
            case 3: {
                return this.calculateTabBoundsBottom(rectangle, dimension, n, fontMetrics, rectangle2);
            }
            case 2: {
                return this.calculateTabBoundsLeft(rectangle, dimension, n, fontMetrics, rectangle2);
            }
            case 4: {
                return this.calculateTabBoundsRight(rectangle, dimension, n, fontMetrics, rectangle2);
            }
        }
        return this.calculateTabBoundsTop(rectangle, dimension, n, fontMetrics, rectangle2);
    }

    private boolean calculateTabBoundsTop(Rectangle rectangle, Dimension dimension, int n, FontMetrics fontMetrics, Rectangle rectangle2) {
        rectangle2.x += rectangle2.width;
        rectangle2.width = this.calculateTabWidth(n, fontMetrics) - 2;
        rectangle2.y = rectangle.y;
        rectangle2.height = dimension.height + 4 - 2;
        return this.canDisplayHorizontal(n, rectangle, rectangle2);
    }

    private boolean calculateTabBoundsBottom(Rectangle rectangle, Dimension dimension, int n, FontMetrics fontMetrics, Rectangle rectangle2) {
        rectangle2.x += rectangle2.width;
        rectangle2.width = this.calculateTabWidth(n, fontMetrics) - 2;
        rectangle2.height = dimension.height + 2 - 2;
        rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
        return this.canDisplayHorizontal(n, rectangle, rectangle2);
    }

    private boolean calculateTabBoundsLeft(Rectangle rectangle, Dimension dimension, int n, FontMetrics fontMetrics, Rectangle rectangle2) {
        rectangle2.x = rectangle.x;
        rectangle2.width = dimension.width + 6 - 2;
        rectangle2.y += rectangle2.height;
        rectangle2.height = this.calculateTabHeight(n, fontMetrics) - 2;
        return this.canDisplayVertical(n, rectangle, rectangle2);
    }

    private boolean calculateTabBoundsRight(Rectangle rectangle, Dimension dimension, int n, FontMetrics fontMetrics, Rectangle rectangle2) {
        rectangle2.width = dimension.width + 6 - 2;
        rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
        rectangle2.y += rectangle2.height;
        rectangle2.height = this.calculateTabHeight(n, fontMetrics) - 2;
        return this.canDisplayVertical(n, rectangle, rectangle2);
    }

    private int calculateTabSlait(Rectangle rectangle) {
        return this.calculateTabSlait(rectangle.height);
    }

    private int calculateTabSlait(int n) {
        return n / 4;
    }

    private boolean canDisplayHorizontal(int n, Rectangle rectangle, Rectangle rectangle2) {
        int n2 = this.tabbedPane.getTabCount();
        int n3 = 0;
        if (this.tabStart > 0 && n + 1 < n2) {
            n3 = this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL) + this.getImageHeight(IMAGE_ARROW_NEXT_HORIZONTAL) + this.getImageHeight(IMAGE_LIST) + 4;
        } else if (this.tabStart > 0 || n + 1 < n2) {
            n3 = this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL) + this.getImageHeight(IMAGE_LIST) + 2;
        }
        return rectangle2.x + rectangle2.width + n3 < rectangle.x + rectangle.width;
    }

    private boolean canDisplayVertical(int n, Rectangle rectangle, Rectangle rectangle2) {
        int n2 = this.tabbedPane.getTabCount();
        int n3 = 0;
        if (this.tabStart > 0 && n + 1 < n2) {
            n3 = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL) + this.getImageHeight(IMAGE_ARROW_NEXT_VERTICAL) + this.getImageHeight(IMAGE_LIST) + 4;
        } else if (this.tabStart > 0 || n + 1 < n2) {
            n3 = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL) + this.getImageHeight(IMAGE_LIST) + 2;
        }
        return rectangle2.y + rectangle2.height + n3 < rectangle.y + rectangle.height;
    }

    private int getComponentWidth(Component component, int n) {
        switch (n) {
            case 1: {
                return component.getMinimumSize().width;
            }
            case 2: {
                return component.getMaximumSize().width;
            }
            case 3: {
                return component.getPreferredSize().width;
            }
        }
        return 0;
    }

    private int getComponentHeight(Component component, int n) {
        switch (n) {
            case 1: {
                return component.getMinimumSize().height;
            }
            case 2: {
                return component.getMaximumSize().height;
            }
            case 3: {
                return component.getPreferredSize().height;
            }
        }
        return 0;
    }

    private Dimension calculateSize(int n) {
        int n2 = this.tabbedPane.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        Insets insets = this.tabbedPane.getInsets();
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.tabbedPane.getComponent(n3);
            int n4 = this.getComponentWidth(component, n);
            if (n4 > dimension.width) {
                dimension.width = n4;
            }
            if ((n4 = this.getComponentHeight(component, n)) > dimension.height) {
                dimension.height = n4;
            }
            ++n3;
        }
        return dimension;
    }

    private int calculateCenter(int n, int n2) {
        if (n2 >= n) {
            return 0;
        }
        return (n - n2) / 2;
    }

    private Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new MenuItemComparator();
        }
        return this.comparator;
    }

    private void displayTabList(int n, int n2) {
        int n3;
        int n4;
        JCheckBoxMenuItem jCheckBoxMenuItem;
        int n5 = this.tabbedPane.getTabCount();
        int n6 = this.tabbedPane.getSelectedIndex();
        Object[] objectArray = this.sortTabsList ? new Object[n5] : null;
        this.initPopupMenu();
        if (this.sortText != null) {
            jCheckBoxMenuItem = new JCheckBoxMenuItem(this.sortText, this.sortTabsList);
            n4 = n;
            n3 = n2;
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ArrowsTabbedPaneUI.this.changeSortTabsList(n4, n3);
                }
            });
            this.popupMenu.add(jCheckBoxMenuItem);
            this.popupMenu.add(new JSeparator());
        }
        n4 = 0;
        while (n4 < n5) {
            n3 = n4;
            jCheckBoxMenuItem = this.listTabIndicate == 2 || this.listTabIndicate == 1 && n4 == n6 ? new JCheckBoxMenuItem(this.tabbedPane.getTitleAt(n4), n4 == n6) : (this.listTabIndicate == 4 || this.listTabIndicate == 3 && n4 == n6 ? new JRadioButtonMenuItem(this.tabbedPane.getTitleAt(n4), n4 == n6) : new JMenuItem(this.tabbedPane.getTitleAt(n4)));
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ArrowsTabbedPaneUI.this.popupMenu.setVisible(false);
                    ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(n3);
                    ArrowsTabbedPaneUI.this.explicitTabStart = false;
                    ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                    ArrowsTabbedPaneUI.this.tabbedPane.repaint();
                }
            });
            if (this.sortTabsList) {
                objectArray[n4] = jCheckBoxMenuItem;
            } else {
                this.popupMenu.add(jCheckBoxMenuItem);
            }
            ++n4;
        }
        if (this.sortTabsList) {
            Arrays.sort(objectArray, this.getComparator());
            n3 = 0;
            while (n3 < n5) {
                this.popupMenu.add((JMenuItem)objectArray[n3]);
                ++n3;
            }
        }
        try {
            this.popupMenu.show((Component)this.tabbedPane, n, n2);
        }
        catch (Exception exception) {
            this.popupMenu.setLocation(n, n2);
            this.popupMenu.setVisible(true);
        }
    }

    private void initPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenuPlus();
        } else {
            this.popupMenu.removeAll();
        }
    }

    private class MenuItemComparator
    implements Comparator {
        private MenuItemComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((JMenuItem)object).getText().toUpperCase().compareTo(((JMenuItem)object2).getText().toUpperCase());
        }
    }

    private class TabbedPaneChangeListener
    implements ChangeListener {
        private TabbedPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ArrowsTabbedPaneUI.this.explicitTabStart = false;
            ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
            ArrowsTabbedPaneUI.this.tabbedPane.repaint();
        }
    }

    private class TabbedPaneFocusListener
    implements FocusListener {
        private TabbedPaneFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            ArrowsTabbedPaneUI.this.tabbedPane.repaint();
        }

        public void focusGained(FocusEvent focusEvent) {
            ArrowsTabbedPaneUI.this.tabbedPane.repaint();
        }
    }

    private class TabbedPaneMouseListener
    extends MouseAdapter {
        private TabbedPaneMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if ((mouseEvent.getModifiers() & 0x10) > 0 && ArrowsTabbedPaneUI.this.boundsArrowPrevious != null && ArrowsTabbedPaneUI.this.boundsArrowPrevious.contains(n, n2)) {
                ArrowsTabbedPaneUI.this.tabStart--;
                bl = true;
                ArrowsTabbedPaneUI.this.explicitTabStart = true;
            } else if ((mouseEvent.getModifiers() & 0x10) > 0 && ArrowsTabbedPaneUI.this.boundsArrowNext != null && ArrowsTabbedPaneUI.this.boundsArrowNext.contains(n, n2)) {
                ArrowsTabbedPaneUI.this.tabStart++;
                bl = true;
                ArrowsTabbedPaneUI.this.explicitTabStart = true;
            } else if ((mouseEvent.getModifiers() & 0x10) > 0 && ArrowsTabbedPaneUI.this.boundsArrowList != null && ArrowsTabbedPaneUI.this.boundsArrowList.contains(n, n2)) {
                ArrowsTabbedPaneUI.this.displayTabList(n, n2);
            } else {
                int n3 = ArrowsTabbedPaneUI.this.tabForCoordinate(ArrowsTabbedPaneUI.this.tabbedPane, n, n2);
                if (n3 >= 0) {
                    if (ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() == n3) {
                        ArrowsTabbedPaneUI.this.tabbedPane.requestFocus();
                    } else {
                        ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(n3);
                        bl = true;
                    }
                }
            }
            if (bl) {
                ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                ArrowsTabbedPaneUI.this.tabbedPane.repaint();
            }
        }
    }

    private class TabbedPaneLayout
    implements LayoutManager {
        private TabbedPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return ArrowsTabbedPaneUI.this.calculateSize(1);
        }

        public Dimension maximumLayoutSize(Container container) {
            return ArrowsTabbedPaneUI.this.calculateSize(2);
        }

        public Dimension preferredLayoutSize(Container container) {
            return ArrowsTabbedPaneUI.this.calculateSize(3);
        }

        public void layoutContainer(Container container) {
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (ArrowsTabbedPaneUI.this.tabbedPane != null) {
                int n = ArrowsTabbedPaneUI.this.tabbedPane.getTabCount();
                Dimension dimension = ArrowsTabbedPaneUI.this.calculateTabsDimension(ArrowsTabbedPaneUI.this.tabbedPane.getGraphics() != null ? ArrowsTabbedPaneUI.this.tabbedPane.getGraphics().getFontMetrics() : null);
                Insets insets = ArrowsTabbedPaneUI.this.tabbedPane.getInsets();
                if (insets == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                Rectangle rectangle2 = new Rectangle(2 + insets.left, 2 + insets.top, ArrowsTabbedPaneUI.this.tabbedPane.getWidth() - 4 - insets.left - insets.right, ArrowsTabbedPaneUI.this.tabbedPane.getHeight() - 4 - insets.top - insets.bottom);
                int n2 = 0;
                while (n2 < n) {
                    ArrowsTabbedPaneUI.this.tabbedPane.getComponent(n2).setVisible(false);
                    ++n2;
                }
                Component component = ArrowsTabbedPaneUI.this.tabbedPane.getSelectedComponent();
                if (component != null) {
                    switch (ArrowsTabbedPaneUI.this.tabbedPane.getTabPlacement()) {
                        case 3: {
                            this.calculateBoundsBottom(rectangle2, dimension, rectangle);
                            break;
                        }
                        case 2: {
                            this.calculateBoundsLeft(rectangle2, dimension, rectangle);
                            break;
                        }
                        case 4: {
                            this.calculateBoundsRight(rectangle2, dimension, rectangle);
                            break;
                        }
                        default: {
                            this.calculateBoundsTop(rectangle2, dimension, rectangle);
                        }
                    }
                    component.setVisible(true);
                    component.setBounds(rectangle);
                }
            }
        }

        private void calculateBoundsTop(Rectangle rectangle, Dimension dimension, Rectangle rectangle2) {
            rectangle2.x = rectangle.x;
            rectangle2.width = rectangle.width;
            rectangle2.y = rectangle.y + dimension.height + 0;
            rectangle2.height = rectangle.height - rectangle2.y;
        }

        private void calculateBoundsBottom(Rectangle rectangle, Dimension dimension, Rectangle rectangle2) {
            rectangle2.x = rectangle.x;
            rectangle2.width = rectangle.width;
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height - rectangle2.y - dimension.height - 0;
        }

        private void calculateBoundsLeft(Rectangle rectangle, Dimension dimension, Rectangle rectangle2) {
            rectangle2.x = rectangle.x + dimension.width + 0;
            rectangle2.width = rectangle.width - rectangle2.x;
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
        }

        private void calculateBoundsRight(Rectangle rectangle, Dimension dimension, Rectangle rectangle2) {
            rectangle2.x = rectangle.x;
            rectangle2.width = rectangle.width - rectangle2.x - dimension.width - 0;
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
        }
    }
}

