/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import org.openide.awt.JPopupMenuPlus;

public class PopupTabbedPaneUI
extends TabbedPaneUI {
    public static final int TAB_LIST_INDICATE_NONE = 0;
    public static final int TAB_LIST_INDICATE_CHECKBOX = 1;
    public static final int TAB_LIST_INDICATE_CHECKBOXALL = 2;
    public static final int TAB_LIST_INDICATE_RADIOBUTTON = 3;
    public static final int TAB_LIST_INDICATE_RADIOBUTTONALL = 4;
    private static final int TAB_LIST_INDICATE_DEFAULT = 3;
    private static final int TAB_LIST_INDICATE_MIN = 0;
    private static final int TAB_LIST_INDICATE_MAX = 4;
    private static final boolean SORT_TABLIST_DEFAULT = false;
    private static final String SORT_TEXT_DEFAULT = null;
    private static final int SIZE_MINIMUM = 1;
    private static final int SIZE_MAXIMUM = 2;
    private static final int SIZE_PREFERRED = 3;
    private static final int TAB_SPACE_LEFT = 2;
    private static final int TAB_SPACE_RIGHT = 3;
    private static final int TAB_SPACE_TOP = 2;
    private static final int TAB_SPACE_BOTTOM = 3;
    private static final int TAB_SPACE_MIDDLE = 3;
    private static final int TAB_SPACE_LINE_STRAIGHT = 3;
    private static final int TAB_SPACE_LINE_ASKEW = 3;
    private static final int TAB_SPACE_LINE_LENGTH = 10;
    private static final int TAB_SPACE_LINE_WIDTH = 6;
    private static final int TAB_SPACE_LEFTRIGHT = 5;
    private static final int TAB_SPACE_LEFTRIGHTMIDDLE = 8;
    private static final int TAB_SPACE_LEFTMIDDLELINE = 11;
    private static final int TAB_SPACE_LEFTRIGHTMIDDLELINE = 14;
    private static final int TAB_SPACE_RIGHTLINE = 9;
    private static final int TAB_SPACE_TOPBOTTOM = 5;
    private static final int TAB_SPACE_TOPBOTTOMMIDDLE = 8;
    private static final int TAB_SPACE_TOPMIDDLELINE = 11;
    private static final int TAB_SPACE_TOPBOTTOMMIDDLELINE = 14;
    private static final int TAB_SPACE_BOTTOMLINE = 9;
    private static final Color COLOR_LINE = Color.black;
    private static final Color COLOR_BORDER_LEFTTOP = Color.white;
    private static final Color COLOR_BORDER_RIGHTBOTTOM = new Color(102, 102, 102);
    private boolean sorttabslist = false;
    private int listtabindicate = 3;
    private String sorttext = SORT_TEXT_DEFAULT;
    private JTabbedPane tabbedpane = null;
    private JPopupMenuPlus popupmenu = null;
    private LayoutManager layoutmanager = null;
    private Rectangle tabbounds = new Rectangle(0, 0, 0, 0);
    private ChangeListener changeListener = new TabbedPabeChangeListener();
    private TabbedPaneMouseListener mouselistener = new TabbedPaneMouseListener();
    private MenuItemComparator comparator = null;

    public PopupTabbedPaneUI() {
        this(false, 3, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(boolean bl) {
        this(bl, 3, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(int n) {
        this(false, n, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(String string) {
        this(false, 3, string);
    }

    public PopupTabbedPaneUI(boolean bl, int n) {
        this(bl, n, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(boolean bl, String string) {
        this(bl, 3, string);
    }

    public PopupTabbedPaneUI(int n, String string) {
        this(false, n, string);
    }

    public PopupTabbedPaneUI(boolean bl, int n, String string) {
        this.setSortTabsList(bl);
        this.setListTabIndicate(n);
        this.setSortText(string);
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        return this.tabbedpane.getSelectedIndex();
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        return null;
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return 0;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new PopupTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.tabbedpane = (JTabbedPane)jComponent;
        this.layoutmanager = this.tabbedpane.getLayout();
        this.tabbedpane.setLayout(this.createLayoutManager());
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.tabbedpane.setLayout(this.layoutmanager);
        this.uninstallListeners();
        if (this.popupmenu != null) {
            this.popupmenu.setVisible(false);
        }
        this.tabbedpane = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTabs(graphics);
        this.paintBorder(graphics);
    }

    public void setSortTabsList(boolean bl) {
        this.sorttabslist = bl;
    }

    public boolean getSortTabsList() {
        return this.sorttabslist;
    }

    private void changeSortTabsList(int n, int n2) {
        this.sorttabslist = !this.sorttabslist;
        this.displayTabList(n, n2);
    }

    public boolean setListTabIndicate(int n) {
        if (n < 0 || n > 4) {
            return false;
        }
        this.listtabindicate = n;
        return true;
    }

    public int getListTabIndicate() {
        return this.listtabindicate;
    }

    public void setSortText(String string) {
        this.sorttext = string;
    }

    public String getSortText() {
        return this.sorttext;
    }

    private LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    private void installListeners() {
        this.tabbedpane.addChangeListener(this.changeListener);
        this.tabbedpane.addMouseListener(this.mouselistener);
    }

    private void uninstallListeners() {
        this.tabbedpane.removeChangeListener(this.changeListener);
        this.tabbedpane.removeMouseListener(this.mouselistener);
    }

    private void paintTabs(Graphics graphics) {
        int n;
        int n2 = this.tabbedpane.getTabPlacement();
        int n3 = this.tabbedpane.getWidth();
        int n4 = this.tabbedpane.getHeight();
        Insets insets = this.tabbedpane.getInsets();
        int n5 = n = n2 == 1 || n2 == 3 ? n3 - insets.left - insets.right - 5 : n4 - insets.top - insets.bottom - 5;
        if (n > 0) {
            int n6 = n / 10;
            Point point = new Point(n2 == 4 ? n3 - insets.right - 9 : insets.left + 2, n2 == 3 ? n4 - insets.bottom - 9 : insets.top + 2);
            this.tabbounds.setBounds(point.x, point.y, 0, 0);
            if (n6 == 0) {
                this.paintTab(graphics, point, n, n2);
            } else {
                int n7 = 0;
                while (n7 < n6) {
                    this.paintTab(graphics, point, 10, n2);
                    ++n7;
                }
            }
            this.tabbounds.setSize(n2 == 1 || n2 == 3 ? n : 6, n2 == 2 || n2 == 4 ? n : 6);
        } else {
            this.tabbounds.setBounds(0, 0, 0, 0);
        }
    }

    private void paintTab(Graphics graphics, Point point, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(COLOR_LINE);
        switch (n2) {
            case 3: {
                graphics.drawLine(point.x, point.y, point.x + n, point.y);
                graphics.drawLine(point.x, point.y, point.x, point.y + 3);
                graphics.drawLine(point.x, point.y + 3, point.x + 3, point.y + 6);
                graphics.drawLine(point.x + 3, point.y + 6, point.x + n, point.y + 6);
                graphics.drawLine(point.x + n, point.y, point.x + n, point.y + 6);
                point.x += n;
                break;
            }
            case 2: {
                graphics.drawLine(point.x + 6, point.y, point.x + 6, point.y + n);
                graphics.drawLine(point.x + 6, point.y, point.x + 3, point.y);
                graphics.drawLine(point.x + 3, point.y, point.x, point.y + 3);
                graphics.drawLine(point.x, point.y + 3, point.x, point.y + n);
                graphics.drawLine(point.x + 6, point.y + n, point.x, point.y + n);
                point.y += n;
                break;
            }
            case 4: {
                graphics.drawLine(point.x, point.y, point.x, point.y + n);
                graphics.drawLine(point.x, point.y, point.x + 3, point.y);
                graphics.drawLine(point.x + 3, point.y, point.x + 6, point.y + 3);
                graphics.drawLine(point.x + 6, point.y + 3, point.x + 6, point.y + n);
                graphics.drawLine(point.x, point.y + n, point.x + 6, point.y + n);
                point.y += n;
                break;
            }
            default: {
                graphics.drawLine(point.x, point.y + 6, point.x + n, point.y + 6);
                graphics.drawLine(point.x, point.y + 6, point.x, point.y + 3);
                graphics.drawLine(point.x, point.y + 3, point.x + 3, point.y);
                graphics.drawLine(point.x + 3, point.y, point.x + n, point.y);
                graphics.drawLine(point.x + n, point.y, point.x + n, point.y + 6);
                point.x += n;
            }
        }
        graphics.setColor(color);
    }

    private void paintBorder(Graphics graphics) {
        int n = this.tabbedpane.getWidth() - 1;
        int n2 = this.tabbedpane.getHeight() - 1;
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(0, 0, n, 0);
        graphics.drawLine(0, 0, 0, n2);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(0, n2, n, n2);
        graphics.drawLine(n, 0, n, n2);
        graphics.setColor(color);
    }

    private Dimension calculateSize(int n) {
        int n2 = this.tabbedpane.getTabCount();
        int n3 = this.tabbedpane.getTabPlacement();
        Dimension dimension = new Dimension(0, 0);
        Insets insets = this.tabbedpane.getInsets();
        int n4 = 0;
        while (n4 < n2) {
            Dimension dimension2 = this.getComponentSize(this.tabbedpane.getComponent(n4), n);
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height > dimension.height) {
                dimension.height = dimension2.height;
            }
            ++n4;
        }
        dimension.width = dimension.width + ((n3 == 2 || n3 == 4 ? 8 : 5) + insets.left + insets.right);
        dimension.height = dimension.height + ((n3 == 1 || n3 == 3 ? 8 : 5) + insets.top + insets.bottom);
        return dimension;
    }

    private Dimension getComponentSize(Component component, int n) {
        switch (n) {
            case 1: {
                return component.getMinimumSize();
            }
            case 2: {
                return component.getMaximumSize();
            }
        }
        return component.getPreferredSize();
    }

    private void initPopupMenu() {
        if (this.popupmenu == null) {
            this.popupmenu = new JPopupMenuPlus();
        } else {
            this.popupmenu.removeAll();
        }
    }

    private Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new MenuItemComparator();
        }
        return this.comparator;
    }

    private void displayTabList(int n, int n2) {
        int n3;
        int n4;
        JCheckBoxMenuItem jCheckBoxMenuItem;
        int n5 = this.tabbedpane.getTabCount();
        int n6 = this.tabbedpane.getSelectedIndex();
        Object[] objectArray = this.sorttabslist ? new Object[n5] : null;
        this.initPopupMenu();
        if (this.sorttext != null) {
            jCheckBoxMenuItem = new JCheckBoxMenuItem(this.sorttext, this.sorttabslist);
            n4 = n;
            n3 = n2;
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PopupTabbedPaneUI.this.changeSortTabsList(n4, n3);
                }
            });
            this.popupmenu.add(jCheckBoxMenuItem);
            this.popupmenu.add(new JSeparator());
        }
        n4 = 0;
        while (n4 < n5) {
            n3 = n4;
            jCheckBoxMenuItem = this.listtabindicate == 2 || this.listtabindicate == 1 && n4 == n6 ? new JCheckBoxMenuItem(this.tabbedpane.getTitleAt(n4), n4 == n6) : (this.listtabindicate == 4 || this.listtabindicate == 3 && n4 == n6 ? new JRadioButtonMenuItem(this.tabbedpane.getTitleAt(n4), n4 == n6) : new JMenuItem(this.tabbedpane.getTitleAt(n4)));
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PopupTabbedPaneUI.this.popupmenu.setVisible(false);
                    PopupTabbedPaneUI.this.tabbedpane.setSelectedIndex(n3);
                    PopupTabbedPaneUI.this.tabbedpane.revalidate();
                    PopupTabbedPaneUI.this.tabbedpane.repaint();
                }
            });
            if (this.sorttabslist) {
                objectArray[n4] = jCheckBoxMenuItem;
            } else {
                this.popupmenu.add(jCheckBoxMenuItem);
            }
            ++n4;
        }
        if (this.sorttabslist) {
            Arrays.sort(objectArray, this.getComparator());
            n3 = 0;
            while (n3 < n5) {
                this.popupmenu.add((JMenuItem)objectArray[n3]);
                ++n3;
            }
        }
        try {
            this.popupmenu.show((Component)this.tabbedpane, n, n2);
        }
        catch (Exception exception) {
            this.popupmenu.setLocation(n, n2);
            this.popupmenu.setVisible(true);
        }
    }

    private class MenuItemComparator
    implements Comparator {
        private MenuItemComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((JMenuItem)object).getText().toUpperCase().compareTo(((JMenuItem)object2).getText().toUpperCase());
        }
    }

    private class TabbedPabeChangeListener
    implements ChangeListener {
        private TabbedPabeChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PopupTabbedPaneUI.this.tabbedpane.revalidate();
            PopupTabbedPaneUI.this.tabbedpane.repaint();
        }
    }

    private class TabbedPaneMouseListener
    extends MouseAdapter {
        private TabbedPaneMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) > 0) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (PopupTabbedPaneUI.this.tabbounds.contains(n, n2)) {
                    PopupTabbedPaneUI.this.tabbedpane.requestFocus();
                    PopupTabbedPaneUI.this.displayTabList(n, n2);
                }
            }
        }
    }

    private class TabbedPaneLayout
    implements LayoutManager {
        private TabbedPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return PopupTabbedPaneUI.this.calculateSize(1);
        }

        public Dimension maximumLayoutSize(Container container) {
            return PopupTabbedPaneUI.this.calculateSize(2);
        }

        public Dimension preferredLayoutSize(Container container) {
            return PopupTabbedPaneUI.this.calculateSize(3);
        }

        public void layoutContainer(Container container) {
            int n = PopupTabbedPaneUI.this.tabbedpane.getTabCount();
            int n2 = PopupTabbedPaneUI.this.tabbedpane.getTabPlacement();
            int n3 = PopupTabbedPaneUI.this.tabbedpane.getWidth();
            int n4 = PopupTabbedPaneUI.this.tabbedpane.getHeight();
            Rectangle rectangle = new Rectangle();
            Insets insets = PopupTabbedPaneUI.this.tabbedpane.getInsets();
            int n5 = 0;
            while (n5 < n) {
                PopupTabbedPaneUI.this.tabbedpane.getComponent(n5).setVisible(false);
                ++n5;
            }
            Component component = PopupTabbedPaneUI.this.tabbedpane.getSelectedComponent();
            if (component != null) {
                component.setBounds(insets.left + (n2 == 2 ? 11 : 2), insets.top + (n2 == 1 ? 11 : 2), n3 - insets.left - insets.right - (n2 == 2 || n2 == 4 ? 14 : 5), n4 - insets.top - insets.bottom - (n2 == 1 || n2 == 3 ? 14 : 5));
                component.setVisible(true);
            }
        }
    }
}

