/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.openide.windows.WindowManager;

final class BoundsConvertor {
    private static BoundsConvertor instance;
    private ArrayList convertors;
    private String previousFrameType;

    private BoundsConvertor() {
    }

    public static final BoundsConvertor getInstance() {
        if (instance == null) {
            instance = new BoundsConvertor();
        }
        return instance;
    }

    public Rectangle convertBounds(ModeImpl modeImpl, String string, String string2) {
        if (this.convertors == null) {
            this.convertors = this.createConversions();
        }
        Conversion conversion = null;
        Iterator iterator = ((AbstractList)this.convertors).iterator();
        while (iterator.hasNext()) {
            conversion = (Conversion)iterator.next();
            if (!conversion.accept(modeImpl, string, string2)) continue;
            return conversion.convertBounds(modeImpl, string, string2);
        }
        return modeImpl.getBounds();
    }

    public boolean updateBounds(ModeImpl modeImpl) {
        return this.updateBounds(modeImpl, this.previousFrameType, modeImpl.getFrameType());
    }

    public boolean updateBounds(ModeImpl modeImpl, String string, String string2) {
        if (string == null) {
            return false;
        }
        WindowManagerImpl cfr_ignored_0 = (WindowManagerImpl)WindowManager.getDefault();
        if (!WindowManagerImpl.deferredPerformer().canImmediatelly()) {
            if (this.previousFrameType == null) {
                this.previousFrameType = string;
            }
            return false;
        }
        if (modeImpl.getBounds() == null) {
            return false;
        }
        modeImpl.setBounds(this.convertBounds(modeImpl, string, string2));
        this.previousFrameType = null;
        return true;
    }

    private ArrayList createConversions() {
        ArrayList<Conversion> arrayList = new ArrayList<Conversion>(3);
        arrayList.add(new MdiSdi());
        arrayList.add(new Desktop2Internal());
        return arrayList;
    }

    private static final class Desktop2Internal
    implements Conversion {
        private Desktop2Internal() {
        }

        public boolean accept(ModeImpl modeImpl, String string, String string2) {
            return "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(string) && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string2);
        }

        public Rectangle convertBounds(ModeImpl modeImpl, String string, String string2) {
            Rectangle rectangle = modeImpl.getNormalBounds();
            Point point = rectangle.getLocation();
            Point point2 = ((WorkspaceImpl)modeImpl.getWorkspace()).getDesktopScreenLocation();
            WindowManagerImpl cfr_ignored_0 = (WindowManagerImpl)WindowManager.getDefault();
            Point point3 = WindowManagerImpl.mainWindow().getDesktopScreenLocation();
            Rectangle rectangle2 = new Rectangle(point.x - (point2.x - point3.x), point.y - (point2.y - point3.y), rectangle.getSize().width - 10, rectangle.getSize().height - 10);
            return rectangle2;
        }
    }

    private static final class MdiSdi
    implements Conversion {
        private MdiSdi() {
        }

        public boolean accept(ModeImpl modeImpl, String string, String string2) {
            boolean bl = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(string);
            boolean bl2 = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string2) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(string2);
            return bl != bl2;
        }

        public Rectangle convertBounds(ModeImpl modeImpl, String string, String string2) {
            boolean bl = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(string);
            boolean bl2 = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string2) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(string2);
            Rectangle rectangle = modeImpl.getNormalBounds();
            Point point = rectangle.getLocation();
            Object object = modeImpl.getConstraints();
            Point point2 = null;
            Rectangle rectangle2 = null;
            if (object == null || "CENTER".equals(object)) {
                point2 = ((WorkspaceImpl)modeImpl.getWorkspace()).getDesktopScreenLocation();
            } else {
                WindowManagerImpl cfr_ignored_0 = (WindowManagerImpl)WindowManager.getDefault();
                point2 = WindowManagerImpl.mainWindow().getDesktopScreenLocation();
            }
            if (bl && !bl2) {
                point.translate(point2.x, point2.y);
            } else {
                point.translate(-point2.x, -point2.y);
            }
            rectangle2 = new Rectangle(point, rectangle.getSize());
            return rectangle2;
        }
    }

    private static interface Conversion {
        public boolean accept(ModeImpl var1, String var2, String var3);

        public Rectangle convertBounds(ModeImpl var1, String var2, String var3);
    }
}

