/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class PersistenceManager {
    public static final String ROOT_FOLDER = "Windows";
    public static final String COMPS_FOLDER = "Components";
    public static final String WINDOWMANAGER_FOLDER = "WindowManager";
    public static final String PERSISTENCE_TYPE = "PersistenceType";
    public static final String NEVER_PERSISTENT = "Never";
    public static final String ONLY_OPENED_PERSISTENT = "OnlyOpened";
    private static final String DEFAULT_TC_NAME = "untitled_tc";
    private FileObject rootFolder;
    private FileObject componentsFolder;
    private FileObject wmFolder;
    private WeakHashMap createdTCPairs;
    private Map createdStringIDPairs;
    private Set invalidIds;
    private FileSystem rwFS;
    private boolean readProcessed = false;
    private Set removalCandidates;
    private boolean isSaveInProgress;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$PersistenceManager;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;

    PersistenceManager() {
    }

    public void setRootFolder(FileObject fileObject) {
        this.rootFolder = fileObject;
        this.clearCache();
    }

    public FileObject getRootFolder() {
        try {
            if (this.rootFolder == null) {
                this.rootFolder = FileUtil.createFolder((FileObject)this.getFileSystem().getRoot(), (String)ROOT_FOLDER);
            }
            return this.rootFolder;
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_RootFolder"), ROOT_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)iOException, string);
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public FileObject getComponentsFolder() {
        try {
            if (this.componentsFolder == null) {
                this.componentsFolder = FileUtil.createFolder((FileObject)this.getRootFolder(), (String)COMPS_FOLDER);
            }
            return this.componentsFolder;
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_CompsFolder"), COMPS_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)iOException, string);
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public FileObject getWindowManagerFolder() {
        try {
            if (this.wmFolder == null) {
                this.wmFolder = FileUtil.createFolder((FileObject)this.getRootFolder(), (String)WINDOWMANAGER_FOLDER);
                StringBuffer stringBuffer = new StringBuffer(WINDOWMANAGER_FOLDER);
                stringBuffer.append('.');
                stringBuffer.append("wswmgr");
                FileUtil.createData((FileObject)this.getRootFolder(), (String)stringBuffer.toString());
            }
            return this.wmFolder;
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_WindowManagerFolder"), WINDOWMANAGER_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)iOException, string);
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public void cleanXML() throws IOException {
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
        Workspace[] workspaceArray = windowManagerImpl.getWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            Set set = workspaceArray[n].getModes();
            ++n;
        }
    }

    public void writeXML() throws IOException {
        if (!this.readProcessed) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)this.getWindowManagerFolder());
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PersistenceManager.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            this.setSaveInProgress(true);
            if (saveCookie != null) {
                this.forceSaveOfTopComponents();
                PersistenceManager persistenceManager = this;
                synchronized (persistenceManager) {
                    saveCookie.save();
                }
                this.cleanupComponents();
            } else {
                Throwable throwable = new Throwable("Window system could not be saved.");
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(4096, "No save cookie for window system.");
                errorManager.log(4096, "DataObject: " + dataObject);
                errorManager.log(4096, "FileObject: " + this.getWindowManagerFolder());
                errorManager.notify(throwable);
            }
            Object var6_7 = null;
            this.setSaveInProgress(false);
            ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(false);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.setSaveInProgress(false);
            ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(false);
            throw throwable;
        }
    }

    public void setSaveInProgress(boolean bl) {
        this.isSaveInProgress = bl;
    }

    public boolean isSaveInProgress() {
        return this.isSaveInProgress;
    }

    public void readXML() throws IOException, ClassNotFoundException {
        this.readProcessed = true;
        try {
            DataObject dataObject = DataObject.find((FileObject)this.getWindowManagerFolder());
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PersistenceManager.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (instanceCookie == null) {
                Object var6_3 = null;
                ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(true);
                return;
            }
            PersistenceManager persistenceManager = this;
            synchronized (persistenceManager) {
                instanceCookie.instanceCreate();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(true);
            throw throwable;
        }
        Object var6_4 = null;
        ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(true);
    }

    public String lookupTCStringId(TopComponent topComponent) throws IOException {
        String string = (String)this.createdTCPairs().get(topComponent);
        if (this.isInvalidId(string)) {
            return this.restorePair(topComponent, string, true);
        }
        if (string != null) {
            return string;
        }
        return this.createNewPair(topComponent);
    }

    public String lookupIdWithoutCreation(TopComponent topComponent) throws IOException {
        String string = (String)this.createdTCPairs().get(topComponent);
        if (this.isInvalidId(string)) {
            string = this.restorePair(topComponent, string, false);
        }
        return string;
    }

    public TopComponent lookupTCInstance(String string) throws IOException {
        Object object;
        WeakReference weakReference = (WeakReference)this.createdStringIDPairs().get(string);
        if (weakReference != null) {
            object = (TopComponent)weakReference.get();
            if (object != null) {
                return object;
            }
            this.createdStringIDPairs().remove(string);
            this.removalCandidates().add(string);
        }
        object = null;
        Object object2 = PersistenceManager.locateTCRef(this.getComponentsFolder(), string);
        if (object2 != null) {
            DataObject dataObject = object2 instanceof DataObject ? (DataObject)object2 : DataObject.find((FileObject)((FileObject)object2));
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PersistenceManager.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (instanceCookie != null) {
                try {
                    TopComponent topComponent = (TopComponent)instanceCookie.instanceCreate();
                    this.createdTCPairs().put(topComponent, string);
                    this.createdStringIDPairs().put(string, new WeakReference<TopComponent>(topComponent));
                    return topComponent;
                }
                catch (InvalidObjectException invalidObjectException) {
                    ErrorManager.getDefault().log(16, "[WinSys] " + invalidObjectException.getMessage());
                    throw new SafeException((Exception)invalidObjectException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = new IOException();
                    ErrorManager.getDefault().annotate((Throwable)object, (Throwable)classNotFoundException);
                }
                catch (ClassCastException classCastException) {
                    object = new IOException();
                    ErrorManager.getDefault().annotate((Throwable)object, (Throwable)classCastException);
                }
            } else {
                String string2 = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_BrokenTCSetting"), string);
                object = new SafeException((Exception)new IOException(string2));
            }
        } else {
            String string3 = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_FailedLocateTC"), string);
            object = new FileNotFoundException(string3);
        }
        throw object;
    }

    public void deleteTCData(String string) throws IOException {
        Object object = PersistenceManager.locateTCRef(this.getComponentsFolder(), string);
        if (object != null && object instanceof DataObject) {
            ((DataObject)object).delete();
        } else if (object != null) {
            DataObject.find((FileObject)((FileObject)object)).delete();
        }
    }

    private static Object locateTCRef(FileObject fileObject, String string) throws IOException {
        DataFolder dataFolder;
        FileObject fileObject2 = fileObject.getFileObject(string, "settings");
        if (fileObject2 != null) {
            return fileObject2;
        }
        fileObject2 = fileObject.getFileObject(string, "ser");
        if (fileObject2 != null) {
            return fileObject2;
        }
        fileObject2 = fileObject.getFileObject(string, "xml");
        if (fileObject2 != null) {
            return fileObject2;
        }
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            dataFolder = DataObject.find((FileObject)fileObject2);
            if (!dataFolder.getName().equals(string)) continue;
            return dataFolder;
        }
        dataFolder = DataFolder.findFolder((FileObject)fileObject);
        enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!dataObject.getName().equals(string)) continue;
            return dataObject;
        }
        return null;
    }

    public boolean isPersistent(TopComponent topComponent, String string, Workspace workspace) {
        String string2 = (String)topComponent.getClientProperty(PERSISTENCE_TYPE);
        if (NEVER_PERSISTENT.equals(string2) || ONLY_OPENED_PERSISTENT.equals(string2) && !topComponent.isOpened(workspace)) {
            if (string != null) {
                this.removalCandidates().add(string);
            }
            return false;
        }
        return true;
    }

    private void cleanupComponents() {
        String[] stringArray;
        Map map;
        String string = null;
        Map map2 = map = this.createdStringIDPairs();
        synchronized (map2) {
            stringArray = map.keySet().toArray(new String[0]);
        }
        Object var5_6 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (((WeakReference)map.get(stringArray[n])).get() == null) {
                this.createdStringIDPairs().remove(stringArray[n]);
                this.removalCandidates().add(stringArray[n]);
            }
            ++n;
        }
        FileObject fileObject = null;
        Iterator iterator = this.removalCandidates().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            fileObject = this.findTcRef(this.getWindowManagerFolder(), string);
            if (fileObject != null) continue;
            try {
                this.deleteTCData(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.removalCandidates().clear();
    }

    void forceSaveOfTopComponents() {
        HashMap hashMap;
        Map map;
        DataFolder dataFolder = DataFolder.findFolder((FileObject)this.getComponentsFolder());
        Map map2 = map = this.createdStringIDPairs();
        synchronized (map2) {
            hashMap = new HashMap(map);
        }
        TopComponent topComponent = null;
        Map.Entry entry = null;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            topComponent = (TopComponent)((WeakReference)entry.getValue()).get();
            if (topComponent == null) continue;
            try {
                FileObject fileObject = dataFolder.getPrimaryFile().getFileObject((String)entry.getKey(), "settings");
                DataObject dataObject = null;
                if (fileObject != null) {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                if (dataObject == null) {
                    InstanceDataObject.create((DataFolder)dataFolder, (String)((String)entry.getKey()), (Object)topComponent, null);
                    continue;
                }
                SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? PersistenceManager.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (saveCookie == null) continue;
                saveCookie.save();
            }
            catch (NotSerializableException notSerializableException) {
                this.createdTCPairs().remove(topComponent);
                iterator.remove();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                String string = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager") : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_CannotSaveTCSettings", (Object)topComponent.getName());
                ErrorManager.getDefault().annotate((Throwable)runtimeException, string);
                ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            }
            catch (LinkageError linkageError) {
                String string = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager") : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_CannotSaveTCSettings", (Object)topComponent.getName());
                ErrorManager.getDefault().annotate((Throwable)linkageError, string);
                ErrorManager.getDefault().notify(1, (Throwable)linkageError);
            }
        }
    }

    private FileObject findTcRef(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getFileObject(string, "wstcref");
        if (fileObject2 != null) {
            return fileObject2;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            if (fileObjectArray[n].isFolder() && (fileObject2 = this.findTcRef(fileObjectArray[n], string)) != null) {
                return fileObject2;
            }
            ++n;
        }
        return null;
    }

    private Set removalCandidates() {
        if (this.removalCandidates == null) {
            this.removalCandidates = new HashSet(20);
        }
        return this.removalCandidates;
    }

    private FileSystem getFileSystem() {
        if (this.rwFS == null) {
            this.rwFS = Repository.getDefault().getDefaultFileSystem();
        }
        return this.rwFS;
    }

    private void clearCache() {
        this.componentsFolder = null;
        this.wmFolder = null;
    }

    private static String convertString2ValidFileName(String string) {
        String string2 = string.replace('/', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace('[', '_');
        string2 = string2.replace(']', '_');
        string2 = string2.replace(' ', '_');
        return string2;
    }

    private static String escape(String string) throws IOException {
        try {
            Method method = (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = PersistenceManager.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject).getDeclaredMethod("escapeAndCut", class$java$lang$String == null ? (class$java$lang$String = PersistenceManager.class$("java.lang.String")) : class$java$lang$String);
            ((AccessibleObject)method).setAccessible(true);
            return (String)method.invoke(null, (Object[])new String[]{string});
        }
        catch (Exception exception) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Escape support failed"), (Throwable)exception);
        }
    }

    private String createNewPair(TopComponent topComponent) throws IOException {
        String string;
        String string2;
        DataFolder dataFolder = DataFolder.findFolder((FileObject)this.getComponentsFolder());
        String string3 = topComponent.getName();
        if (string3 == null || string3.length() == 0) {
            string3 = DEFAULT_TC_NAME;
        }
        boolean bl = true;
        String string4 = string3;
        int n = 1;
        while (bl) {
            bl = false;
            string2 = PersistenceManager.escape(string4);
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)string2, (String)"settings");
            if ((this.invalidIds == null || !this.invalidIds.contains(string)) && string2.equals(string)) continue;
            bl = true;
            string4 = string3 + "_" + n;
            ++n;
        }
        string2 = InstanceDataObject.create((DataFolder)dataFolder, (String)string4, (Object)topComponent, null);
        string = string2.getPrimaryFile().getName();
        this.createdTCPairs().put(topComponent, string);
        this.createdStringIDPairs().put(string, new WeakReference<TopComponent>(topComponent));
        return string;
    }

    private String restorePair(TopComponent topComponent, String string, boolean bl) throws IOException {
        FileObject fileObject = this.getComponentsFolder().getFileObject(string, "settings");
        if (fileObject != null) {
            this.createdTCPairs().put(topComponent, string);
            this.createdStringIDPairs().put(string, new WeakReference<TopComponent>(topComponent));
            this.validateId(string);
            return string;
        }
        if (bl) {
            return this.createNewPair(topComponent);
        }
        return null;
    }

    private Map createdTCPairs() {
        if (this.createdTCPairs == null) {
            this.createdTCPairs = new WeakHashMap(30);
        }
        return this.createdTCPairs;
    }

    private Map createdStringIDPairs() {
        if (this.createdStringIDPairs == null) {
            this.createdStringIDPairs = Collections.synchronizedMap(new HashMap(30));
        }
        return this.createdStringIDPairs;
    }

    void resetTCPairs() {
        if (this.createdTCPairs != null) {
            this.invalidIds = new HashSet(((AbstractMap)this.createdTCPairs).values());
        }
        this.createdStringIDPairs = null;
    }

    private boolean isInvalidId(String string) {
        return this.invalidIds == null ? false : this.invalidIds.contains(string);
    }

    private void validateId(String string) {
        if (this.invalidIds != null) {
            this.invalidIds.remove(string);
            if (this.invalidIds.size() == 0) {
                this.invalidIds = null;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

