/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceBoundsManager;
import org.netbeans.core.windows.WorkspaceVisibilityManager;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.netbeans.core.windows.util.VersionSerializator;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.Actions;
import org.openide.awt.ToolbarPool;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WorkspaceImpl
implements Workspace {
    public static final String PROP_MODES = "modes";
    public static final String PROP_NAME = "name";
    public static final int PROPERTIES = 1;
    public static final int MODES = 2;
    static int numberOfWorkspaces = 0;
    static MessageFormat loadingMessage;
    static ToolbarPool toolbarPool;
    private String name;
    private String displayName;
    private String description;
    private String toolbarConfigName = "Standard";
    private ArrayList modes;
    private Mode current;
    private Mode lastActivatedMode;
    private ModeImpl topMaximizedMode;
    private boolean wasMaxMode;
    private WindowManagerImpl.TopComponentManager savedManager;
    private WindowManagerImpl wm;
    private PropertyChangeSupport changeSupport;
    private static MessageFormat defaultWorkspaceName;
    private VersionSerializator serializationManager;
    private WorkspaceVisibilityManager visManager;
    private WorkspaceBoundsManager boundsManager;
    private LazyUpdater updater;
    private String nameBundle;
    private String descriptionBundle;
    private boolean fromBundle;
    private final Set shownTcs = new WeakSet(5);
    private Set pendingShownTcs;
    static final long serialVersionUID = -1865300855714270375L;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceImpl;
    static /* synthetic */ Class class$org$openide$windows$Workspace;

    public WorkspaceImpl() {
        this((String)null);
    }

    public WorkspaceImpl(String string) {
        this(string, string, false);
    }

    public WorkspaceImpl(String string, String string2) {
        this(string, string2, false);
    }

    public WorkspaceImpl(String string, String string2, boolean bl) {
        this.name = string;
        this.fromBundle = bl;
        if (string == null) {
            Object[] objectArray = new Object[]{new Integer(++numberOfWorkspaces)};
            if (defaultWorkspaceName == null) {
                ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = WorkspaceImpl.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl));
                defaultWorkspaceName = new MessageFormat(resourceBundle.getString("WorkspaceNumber"));
            }
            this.name = defaultWorkspaceName.format(objectArray);
        }
        this.displayName = string2 == null ? this.name : string2;
        this.modes = new ArrayList(10);
        this.initialize();
    }

    public WorkspaceImpl(WorkspaceImpl workspaceImpl) {
        this.modes = new ArrayList(10);
        this.initialize();
        int n = 1;
        while (this.wm.findWorkspace(this.name = workspaceImpl.name + "_" + n++) != null) {
        }
        this.displayName = workspaceImpl.getDisplayName() + (n - 1);
        this.boundsManager().copyFrom(workspaceImpl.boundsManager());
        this.toolbarConfigName = new String(workspaceImpl.getToolbarConfigName());
        ModeImpl modeImpl = null;
        ModeImpl modeImpl2 = null;
        Iterator iterator = workspaceImpl.getModeArray().iterator();
        while (iterator.hasNext()) {
            modeImpl = (ModeImpl)iterator.next();
            modeImpl2 = new ModeImpl(this, modeImpl);
            if (modeImpl.equals(workspaceImpl.current)) {
                this.current = modeImpl2;
            }
            this.modes.add(modeImpl2);
            modeImpl2.fillTopComponents(modeImpl);
        }
    }

    public void attachUpdater(LazyUpdater lazyUpdater) {
        this.updater = lazyUpdater;
    }

    private void initialize() {
        this.changeSupport = new PropertyChangeSupport(this);
        this.wm = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
    }

    public void save() throws IOException {
        List list = this.getLoadedModeArray();
        int n = 0;
        while (n < list.size()) {
            try {
                ModeImpl modeImpl = (ModeImpl)list.get(n);
                modeImpl.save();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            ++n;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        this.ensureSectionLoaded(1);
        if (this.fromBundle) {
            String string = this.nameBundle;
            if (string == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Workspace " + this.name + " does not specify nameBundle in xml data!"));
            } else {
                try {
                    return NbBundle.getBundle((String)string).getString(this.displayName);
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().notify(1, (Throwable)missingResourceException);
                }
            }
        }
        return this.displayName;
    }

    public String getDisplayNameXML() {
        this.ensureSectionLoaded(1);
        return this.displayName;
    }

    public String getNameBundle() {
        this.ensureSectionLoaded(1);
        return this.nameBundle;
    }

    public void setNameBundle(String string) {
        this.nameBundle = string;
    }

    public void setDisplayName(String string) {
        String string2 = this.getDisplayName();
        if (string2 != null) {
            string2 = Actions.cutAmpersand((String)string2);
        }
        String string3 = Actions.cutAmpersand((String)string);
        if (string2 != null && string2.equals(string3) || string2 == null && string3 == null) {
            return;
        }
        this.fromBundle = false;
        String string4 = this.displayName;
        this.displayName = string;
        this.changeSupport.firePropertyChange("displayName", string4, this.displayName);
    }

    public void setDisplayNameXML(String string) {
        String string2 = this.displayName;
        this.displayName = string;
        this.changeSupport.firePropertyChange("displayName", string2, this.displayName);
    }

    public String getDescriptionXML() {
        this.ensureSectionLoaded(1);
        return this.description;
    }

    public void setDescriptionXML(String string) {
        this.description = string;
    }

    public String getDescription() {
        this.ensureSectionLoaded(1);
        if (this.descriptionBundle == null || this.description == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Workspace " + this.name + " does not specify description in xml data:" + " descriptionBundle=" + this.descriptionBundle + ", description=" + this.description + " !"));
        } else {
            try {
                return NbBundle.getBundle((String)this.descriptionBundle).getString(this.description);
            }
            catch (MissingResourceException missingResourceException) {
                ErrorManager.getDefault().notify(1, (Throwable)missingResourceException);
            }
        }
        return this.description;
    }

    public String getDescriptionBundle() {
        this.ensureSectionLoaded(1);
        return this.descriptionBundle;
    }

    public void setDescriptionBundle(String string) {
        this.descriptionBundle = string;
    }

    public Mode getActiveMode() {
        this.ensureSectionLoaded(1);
        return this.current;
    }

    public void setActiveMode(Mode mode) {
        ModeImpl modeImpl;
        this.current = mode;
        if (mode != null && !(modeImpl = (ModeImpl)mode).isActive()) {
            modeImpl.requestFocus();
        }
    }

    public Mode getLastActivatedMode() {
        return this.lastActivatedMode;
    }

    public void setLastActivatedMode(Mode mode) {
        this.lastActivatedMode = mode;
    }

    public void setShownTcs(Set set) {
        this.shownTcs.clear();
        this.shownTcs.addAll(set);
    }

    public Set getShownTcs() {
        return new HashSet(this.shownTcs);
    }

    public void addToShownTcs(TopComponent topComponent) {
        if (this.shownTcs.contains(topComponent)) {
            return;
        }
        ((WindowManagerImpl)WindowManager.getDefault()).componentShowing(topComponent);
        this.shownTcs.add(topComponent);
    }

    public void removeFromShownTcs(TopComponent topComponent) {
        if (!this.shownTcs.contains(topComponent)) {
            return;
        }
        ((WindowManagerImpl)WindowManager.getDefault()).componentHidden(topComponent);
        this.shownTcs.remove(topComponent);
    }

    public void setPendingShownTcs(Set set) {
        this.pendingShownTcs = set;
    }

    public Set getPendingShownTcs() {
        HashSet hashSet = new HashSet();
        if (this.pendingShownTcs != null) {
            hashSet.addAll(this.pendingShownTcs);
        }
        return hashSet;
    }

    void setTopMaximizedMode(ModeImpl modeImpl) {
        if (this.topMaximizedMode == null ? this.topMaximizedMode == modeImpl : this.topMaximizedMode.equals(modeImpl)) {
            return;
        }
        if (modeImpl != null) {
            this.wm.addButtons();
        } else {
            this.wm.removeButtons();
        }
        this.topMaximizedMode = modeImpl;
        WindowManagerImpl.mainWindow().updateTitle();
    }

    public ModeImpl getTopMaximizedMode() {
        return this.topMaximizedMode;
    }

    boolean isTopMaximizedMode() {
        return this.topMaximizedMode != null;
    }

    public Set getModes() {
        this.ensureSectionLoaded(2);
        return Collections.unmodifiableSet(new HashSet(this.modes));
    }

    public List getModeArray() {
        return this.doGetModeArray(true);
    }

    public List getLoadedModeArray() {
        return this.doGetModeArray(false);
    }

    private List doGetModeArray(boolean bl) {
        if (bl) {
            this.ensureSectionLoaded(2);
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = this.modes;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this.modes);
        }
        return arrayList;
    }

    public Set getRemovedModeIds() {
        return null;
    }

    public void clearRemovedModeIds() {
    }

    public Rectangle getBounds() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getWorkingSpaceBounds();
    }

    public boolean isNameFromBundle() {
        this.ensureSectionLoaded(1);
        return this.fromBundle;
    }

    public void setNameFromBundle(boolean bl) {
        if (this.fromBundle == bl) {
            return;
        }
        String string = this.getDisplayName();
        this.fromBundle = bl;
        String string2 = this.getDisplayName();
        if (!string.equals(string2)) {
            this.changeSupport.firePropertyChange("displayName", string, string2);
        }
    }

    public void setNameFromBundleXML(boolean bl) {
        this.fromBundle = bl;
    }

    public void activate() {
        if (EventQueue.isDispatchThread()) {
            this.wm.setCurrentWorkspace(this);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    WorkspaceImpl.this.wm.setCurrentWorkspace(WorkspaceImpl.this);
                }
            });
        }
    }

    public Mode createMode(String string, String string2, URL uRL) {
        return this.createMode(string, string2, uRL, false);
    }

    public Mode createMode(String string, String string2, URL uRL, int n, boolean bl) {
        return this.createMode(string, string2, uRL, bl);
    }

    public Mode createMode(String string, String string2, URL uRL, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create mode with null name!");
        }
        Mode mode = this.findLoadedMode(string);
        if (mode == null) {
            mode = new ModeImpl(string, string2, uRL, bl, this);
            this.addMode(mode);
        }
        return mode;
    }

    public Mode findMode(String string) {
        return this.doFindMode(string, true);
    }

    public Mode findLoadedMode(String string) {
        return this.doFindMode(string, false);
    }

    private Mode doFindMode(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot search for mode with null name!");
        }
        if (bl) {
            this.ensureSectionLoaded(2);
        }
        Mode[] modeArray = null;
        ArrayList arrayList = this.modes;
        synchronized (arrayList) {
            modeArray = this.modes.toArray(new Mode[0]);
        }
        int n = 0;
        while (n < modeArray.length) {
            if (string.equals(modeArray[n].getName())) {
                return modeArray[n];
            }
            ++n;
        }
        return null;
    }

    public Mode findMode(TopComponent topComponent) {
        String string;
        TopComponent[] topComponentArray;
        this.ensureSectionLoaded(2);
        ModeImpl[] modeImplArray = null;
        ArrayList arrayList = this.modes;
        synchronized (arrayList) {
            modeImplArray = this.modes.toArray(new ModeImpl[0]);
        }
        int n = 0;
        while (n < modeImplArray.length) {
            topComponentArray = modeImplArray[n].getLoadedTopComponents();
            int n2 = 0;
            while (n2 < topComponentArray.length) {
                if (topComponent.equals(topComponentArray[n2])) {
                    return modeImplArray[n];
                }
                ++n2;
            }
            ++n;
        }
        topComponentArray = ((WindowManagerImpl)WindowManager.getDefault()).persistenceManager();
        try {
            string = topComponentArray.lookupTCStringId(topComponent);
        }
        catch (NotSerializableException notSerializableException) {
            ErrorManager.getDefault().log(16, "[WinSys] " + notSerializableException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        int n3 = 0;
        while (n3 < modeImplArray.length) {
            String[] stringArray = modeImplArray[n3].getTopComponentIds();
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (string.equals(stringArray[n4])) {
                    return modeImplArray[n3];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public boolean isOpened(TopComponent topComponent) {
        return WindowManagerImpl.findManager(topComponent).isOpened(this);
    }

    public void remove() {
        ModeImpl[] modeImplArray = null;
        ArrayList arrayList = this.modes;
        synchronized (arrayList) {
            modeImplArray = this.modes.toArray(new ModeImpl[0]);
        }
        if (modeImplArray.length > 0) {
            int n = 0;
            while (n < modeImplArray.length) {
                modeImplArray[n].close();
                ++n;
            }
            ArrayList arrayList2 = this.modes;
            synchronized (arrayList2) {
                this.modes.clear();
            }
            this.changeSupport.firePropertyChange(PROP_MODES, null, null);
        }
        Workspace[] workspaceArray = this.wm.getWorkspaces();
        int n = 0;
        n = 0;
        while (n < workspaceArray.length) {
            if (this.equals(workspaceArray[n])) break;
            ++n;
        }
        if (n < workspaceArray.length) {
            Workspace[] workspaceArray2 = new Workspace[workspaceArray.length - 1];
            System.arraycopy(workspaceArray, 0, workspaceArray2, 0, n);
            System.arraycopy(workspaceArray, n + 1, workspaceArray2, n, workspaceArray.length - (n + 1));
            this.wm.setWorkspaces(workspaceArray2);
        }
    }

    public void removeModes() {
        ModeImpl[] modeImplArray = null;
        ArrayList arrayList = this.modes;
        synchronized (arrayList) {
            modeImplArray = this.modes.toArray(new ModeImpl[0]);
        }
        if (modeImplArray.length > 0) {
            int n = 0;
            while (n < modeImplArray.length) {
                modeImplArray[n].close();
                ++n;
            }
            ArrayList arrayList2 = this.modes;
            synchronized (arrayList2) {
                this.modes.clear();
            }
            this.changeSupport.firePropertyChange(PROP_MODES, null, null);
        }
    }

    public void closeModes() {
        ModeImpl[] modeImplArray = null;
        ArrayList arrayList = this.modes;
        synchronized (arrayList) {
            modeImplArray = this.modes.toArray(new ModeImpl[0]);
        }
        if (modeImplArray.length > 0) {
            int n = 0;
            while (n < modeImplArray.length) {
                modeImplArray[n].setCloseOnlyInMemory(true);
                modeImplArray[n].close();
                modeImplArray[n].setCloseOnlyInMemory(false);
                modeImplArray[n].resetComponents();
                modeImplArray[n].removeAllClosedComponents();
                modeImplArray[n].setChanged(false);
                ++n;
            }
            ArrayList arrayList2 = this.modes;
            synchronized (arrayList2) {
                this.modes.clear();
            }
            this.changeSupport.firePropertyChange(PROP_MODES, null, null);
        }
        this.visManager().setDominanceList(null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setVisible(boolean bl) {
        this.setVisible(bl, true);
    }

    void setVisible(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.ensureSectionLoaded(3);
        }
        this.visManager().setVisible(bl);
    }

    public boolean isVisible() {
        return this.visManager().isVisible();
    }

    public String getToolbarConfigName() {
        this.ensureSectionLoaded(1);
        return this.toolbarConfigName;
    }

    public void setToolbarConfigName(String string) {
        this.toolbarConfigName = string;
        if (this.equals(this.wm.getCurrentWorkspace())) {
            this.activateConfiguration();
        }
    }

    void activateConfiguration() {
        if (toolbarPool == null) {
            toolbarPool = ToolbarPool.getDefault();
        }
        toolbarPool.setConfiguration(this.toolbarConfigName);
    }

    public void fireModeChange() {
        this.changeSupport.firePropertyChange(PROP_MODES, null, null);
    }

    private static void log(String string) {
    }

    private static void logArray(Object[] objectArray) {
        WorkspaceImpl.log("Array: " + objectArray);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                WorkspaceImpl.log("\t " + n + ": " + objectArray[n]);
                ++n;
            }
        }
    }

    private static void logStack() {
    }

    public void addMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Cannot add null mode to the workspace");
        }
        ArrayList arrayList = this.modes;
        synchronized (arrayList) {
            if (this.modes.contains(mode)) {
                return;
            }
            this.modes.add(mode);
        }
        this.changeSupport.firePropertyChange(PROP_MODES, null, null);
    }

    public void removeMode(Mode mode) {
        boolean bl = false;
        ArrayList arrayList = this.modes;
        synchronized (arrayList) {
            bl = ((AbstractCollection)this.modes).remove(mode);
        }
        if (bl) {
            this.changeSupport.firePropertyChange(PROP_MODES, null, null);
        }
    }

    public void setCascadingOrigin(Point point) {
        this.boundsManager().setCascadingOrigin(point);
    }

    public Point getCascadingOrigin() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadingOrigin();
    }

    public Dimension getCascadeStep() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadeStep();
    }

    public void setCascadeStep(Dimension dimension) {
        this.boundsManager().setCascadeStep(dimension);
    }

    public int getCascadeStepsCount() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadeStepsCount();
    }

    public void setCascadeStepsCount(int n) {
        this.boundsManager().setCascadeStepsCount(n);
    }

    public Point getCascadePoint() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getCascadePoint();
    }

    public void setCascadePoint(Point point) {
        this.boundsManager().setCascadePoint(point);
    }

    void placeMode(ModeImpl modeImpl, TopComponent topComponent) {
        this.boundsManager().placeMode(modeImpl, topComponent);
    }

    void reactivateSavedTc() {
        if (this.savedManager == null) {
            return;
        }
        final TopComponent topComponent = this.savedManager.getComponent();
        this.savedManager = null;
        if (topComponent != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    topComponent.requestFocus();
                }
            });
        }
    }

    void componentActivated(TopComponent topComponent) {
        if (this.visManager().isProcessing()) {
            return;
        }
        Mode mode = this.findMode(topComponent);
        if (mode != null) {
            ArrayList arrayList = this.modes;
            synchronized (arrayList) {
                ((AbstractCollection)this.modes).remove(mode);
                this.modes.add(0, mode);
            }
        }
    }

    static MessageFormat getLoadingMessage() {
        if (loadingMessage == null) {
            loadingMessage = new MessageFormat(NbBundle.getBundle((Class)(class$org$openide$windows$Workspace == null ? (class$org$openide$windows$Workspace = WorkspaceImpl.class$("org.openide.windows.Workspace")) : class$org$openide$windows$Workspace)).getString("FMT_LoadingWorkspace"));
        }
        return loadingMessage;
    }

    void excludeUserOrphans(ArrayList arrayList) {
        Object var2_2 = null;
        ModeImpl[] modeImplArray = arrayList.toArray(new ModeImpl[0]);
        int n = 0;
        while (n < modeImplArray.length) {
            if (modeImplArray[n].isUserDefined() && modeImplArray[n].isOrphan()) {
                ((AbstractCollection)arrayList).remove(modeImplArray[n]);
            }
            ++n;
        }
    }

    public DesktopPane desktopPane() {
        return this.visManager().desktopPane();
    }

    Point getDesktopScreenLocation() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getDesktopScreenLocation();
    }

    public Rectangle getWorkingSpaceBounds() {
        this.ensureSectionLoaded(1);
        return this.boundsManager().getWorkingSpaceBounds();
    }

    private WorkspaceVisibilityManager visManager() {
        if (this.visManager == null) {
            this.visManager = new WorkspaceVisibilityManager(this);
        }
        return this.visManager;
    }

    private WorkspaceBoundsManager boundsManager() {
        if (this.boundsManager == null) {
            this.boundsManager = new WorkspaceBoundsManager(this);
        }
        return this.boundsManager;
    }

    boolean ensureSectionLoaded(int n) {
        if (this.updater == null) {
            return false;
        }
        try {
            if ((n & this.updater.getLoadedSections()) != n) {
                this.updater.loadDataSection(n);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return false;
        }
        return true;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.excludeUserOrphans(this.modes);
        return new SerializationReplacer(this);
    }

    void validateSelf() {
        ModeImpl[] modeImplArray = this.modes.toArray(new ModeImpl[this.modes.size()]);
        int n = 0;
        while (n < modeImplArray.length) {
            modeImplArray[n].validateSelf(this);
            ++n;
        }
    }

    void validateData() {
        this.boundsManager().correctBounds();
        this.visManager().validateModes();
        this.changeSupport.firePropertyChange(PROP_MODES, null, null);
    }

    public List getDominanceList() {
        return this.visManager().getDominanceList();
    }

    void synchronizeMaxMode() {
        if (this.wasMaxMode) {
            this.wasMaxMode = false;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    WorkspaceImpl.this.desktopPane().setMaxMode(true);
                }
            });
        }
    }

    public void setWasMaxMode(boolean bl) {
        this.wasMaxMode = bl;
        this.synchronizeMaxMode();
    }

    public boolean getWasMaxMode() {
        return this.wasMaxMode;
    }

    private VersionSerializator serializationManager() {
        if (this.serializationManager == null) {
            this.serializationManager = WorkspaceImpl.createSerializationManager();
        }
        return this.serializationManager;
    }

    private static VersionSerializator createSerializationManager() {
        VersionSerializator versionSerializator = new VersionSerializator();
        versionSerializator.putVersion(new Version1());
        versionSerializator.putVersion(new Version2());
        versionSerializator.putVersion(new Version3());
        return versionSerializator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class VSAccess
    implements DefaultReplacer.Access {
        private static final long serialVersionUID = 2367034636261092266L;
        transient VersionSerializator vs;

        public VSAccess(VersionSerializator versionSerializator) {
            this.vs = versionSerializator;
        }

        public VersionSerializator getVersionSerializator() {
            return this.vs == null ? WorkspaceImpl.createSerializationManager() : this.vs;
        }
    }

    private static class Version3
    extends Version2 {
        public static final String NAME3 = "Version_3.0";
        boolean fromBundle;

        private Version3() {
        }

        public String getName() {
            return NAME3;
        }

        public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readData(objectInput);
            this.fromBundle = (Boolean)objectInput.readObject();
        }

        public void writeData(ObjectOutput objectOutput) throws IOException {
            throw new InternalError();
        }

        public Object resolveData() throws ObjectStreamException {
            WorkspaceImpl workspaceImpl = (WorkspaceImpl)super.resolveData();
            WorkspaceImpl workspaceImpl2 = (WorkspaceImpl)TopManager.getDefault().getWindowManager().findWorkspace(this.name);
            if (workspaceImpl2 == null) {
                workspaceImpl.fromBundle = this.fromBundle;
            }
            return workspaceImpl;
        }
    }

    private static class Version2
    extends Version1 {
        public static final String NAME2 = "Version_2.0";
        Point cascadingOrigin;
        WindowManagerImpl.TopComponentManager savedManager;

        private Version2() {
        }

        public String getName() {
            return NAME2;
        }

        public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readData(objectInput);
            this.cascadingOrigin = (Point)objectInput.readObject();
            this.savedManager = (WindowManagerImpl.TopComponentManager)objectInput.readObject();
        }

        public void writeData(ObjectOutput objectOutput) throws IOException {
            throw new InternalError();
        }

        public Object resolveData() throws ObjectStreamException {
            WorkspaceImpl workspaceImpl = (WorkspaceImpl)super.resolveData();
            WorkspaceImpl workspaceImpl2 = (WorkspaceImpl)TopManager.getDefault().getWindowManager().findWorkspace(this.name);
            if (workspaceImpl2 == null) {
                workspaceImpl.boundsManager().setCascadingOrigin(this.cascadingOrigin);
                workspaceImpl.savedManager = this.savedManager;
            }
            return workspaceImpl;
        }
    }

    private static class Version1
    implements DefaultReplacer.ResVersionable {
        public static final String NAME = "Version_1.0";
        String name;
        String displayName;
        Dimension cascadeStep;
        int cascadeStepsCount;
        Point cascadePoint;
        String toolbarConfigName;
        HashSet modes;
        Mode current;
        WorkspaceImpl workspace;

        private Version1() {
        }

        public String getName() {
            return NAME;
        }

        public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.name = (String)objectInput.readObject();
            this.displayName = (String)objectInput.readObject();
            this.cascadeStep = (Dimension)objectInput.readObject();
            this.cascadeStepsCount = (Integer)objectInput.readObject();
            this.cascadePoint = (Point)objectInput.readObject();
            this.toolbarConfigName = (String)objectInput.readObject();
            this.modes = (HashSet)objectInput.readObject();
            this.current = (Mode)objectInput.readObject();
        }

        public void writeData(ObjectOutput objectOutput) throws IOException {
            throw new InternalError();
        }

        public Object resolveData() throws ObjectStreamException {
            WorkspaceImpl workspaceImpl = (WorkspaceImpl)TopManager.getDefault().getWindowManager().findWorkspace(this.name);
            if (workspaceImpl == null) {
                workspaceImpl = new WorkspaceImpl(this.name);
                workspaceImpl.displayName = this.displayName;
                WorkspaceBoundsManager workspaceBoundsManager = workspaceImpl.boundsManager();
                workspaceBoundsManager.setCascadeStep(this.cascadeStep);
                workspaceBoundsManager.setCascadeStepsCount(this.cascadeStepsCount);
                workspaceBoundsManager.setCascadePoint(this.cascadePoint);
                workspaceImpl.toolbarConfigName = this.toolbarConfigName;
                workspaceImpl.modes = new ArrayList(this.modes);
                workspaceImpl.current = this.current;
            } else {
                Mode mode = null;
                Iterator iterator = this.modes.iterator();
                while (iterator.hasNext()) {
                    mode = (Mode)iterator.next();
                    if (workspaceImpl.findMode(mode.getName()) != null) continue;
                    workspaceImpl.addMode(mode);
                }
            }
            return workspaceImpl;
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = -1110255063830989275L;
        private static final String NAME = "name";
        private static final String DISPLAY_NAME = "displayName";
        private static final String CASCADE_STEP = "cascadeStep";
        private static final String CASCADE_STEPS_COUNT = "cascadeStepsCount";
        private static final String CASCADE_POINT = "cascadePoint";
        private static final String CASCADING_ORIGIN = "cascadingOrigin";
        private static final String TOOLBAR_CONFIG_NAME = "toolbarConfigName";
        private static final String MODES = "modes";
        private static final String CURRENT_MODE = "current";
        private static final String ACTIVE_TCM = "activeTCM";
        private static final String FROM_BUNDLE = "fromBundle";
        private static final String DOMINANCE_LIST = "domList";
        private static final String MAX_MODE = "maxMode";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("displayName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("cascadeStep", class$java$awt$Dimension == null ? (class$java$awt$Dimension = SerializationReplacer.class$("java.awt.Dimension")) : class$java$awt$Dimension), new ObjectStreamField("cascadeStepsCount", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("cascadePoint", class$java$awt$Point == null ? (class$java$awt$Point = SerializationReplacer.class$("java.awt.Point")) : class$java$awt$Point), new ObjectStreamField("cascadingOrigin", class$java$awt$Point == null ? (class$java$awt$Point = SerializationReplacer.class$("java.awt.Point")) : class$java$awt$Point), new ObjectStreamField("toolbarConfigName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("modes", class$java$util$ArrayList == null ? (class$java$util$ArrayList = SerializationReplacer.class$("java.util.ArrayList")) : class$java$util$ArrayList), new ObjectStreamField("current", class$org$openide$windows$Mode == null ? (class$org$openide$windows$Mode = SerializationReplacer.class$("org.openide.windows.Mode")) : class$org$openide$windows$Mode), new ObjectStreamField("activeTCM", class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager == null ? (class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager = SerializationReplacer.class$("org.netbeans.core.windows.WindowManagerImpl$TopComponentManager")) : class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager), new ObjectStreamField("fromBundle", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializationReplacer.class$("java.lang.Boolean")) : class$java$lang$Boolean), new ObjectStreamField("domList", class$java$util$ArrayList == null ? (class$java$util$ArrayList = SerializationReplacer.class$("java.util.ArrayList")) : class$java$util$ArrayList), new ObjectStreamField("maxMode", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializationReplacer.class$("java.lang.Boolean")) : class$java$lang$Boolean)};
        transient WorkspaceImpl source;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$awt$Dimension;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$awt$Point;
        static /* synthetic */ Class class$java$util$ArrayList;
        static /* synthetic */ Class class$org$openide$windows$Mode;
        static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl$TopComponentManager;
        static /* synthetic */ Class class$java$lang$Boolean;

        SerializationReplacer(WorkspaceImpl workspaceImpl) {
            this.source = workspaceImpl;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            WorkspaceBoundsManager workspaceBoundsManager = this.source.boundsManager();
            putField.put("name", this.source.name);
            putField.put(DISPLAY_NAME, this.source.displayName);
            putField.put(CASCADE_STEP, workspaceBoundsManager.getCascadeStep());
            putField.put(CASCADE_STEPS_COUNT, new Integer(workspaceBoundsManager.getCascadeStepsCount()));
            putField.put(CASCADE_POINT, workspaceBoundsManager.getCascadePoint());
            putField.put(TOOLBAR_CONFIG_NAME, this.source.toolbarConfigName);
            putField.put("modes", this.source.modes);
            putField.put(CURRENT_MODE, this.source.current);
            putField.put(CASCADING_ORIGIN, workspaceBoundsManager.getCascadingOrigin());
            putField.put(FROM_BUNDLE, new Boolean(this.source.fromBundle));
            TopComponent topComponent = this.source.visManager().getSavedActive();
            if (topComponent == null) {
                topComponent = TopComponent.getRegistry().getActivated();
            }
            if (topComponent != null && topComponent.isOpened((Workspace)this.source)) {
                putField.put(ACTIVE_TCM, WindowManagerImpl.findManager(topComponent));
            } else {
                putField.put(ACTIVE_TCM, null);
            }
            List list = this.source.visManager().getDominanceList();
            ArrayList arrayList = null;
            if (list != null) {
                arrayList = new ArrayList(list.size());
                arrayList.addAll(list);
            }
            putField.put(DOMINANCE_LIST, arrayList);
            putField.put(MAX_MODE, new Boolean(WindowUtils.isMdi() && this.source.desktopPane().isMaxMode()));
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            String string = (String)getField.get("name", null);
            this.source = (WorkspaceImpl)TopManager.getDefault().getWindowManager().findWorkspace(string);
            if (this.source == null) {
                this.source = new WorkspaceImpl(string);
            }
            WorkspaceBoundsManager workspaceBoundsManager = this.source.boundsManager();
            workspaceBoundsManager.setCascadeStep((Dimension)getField.get(CASCADE_STEP, null));
            workspaceBoundsManager.setCascadeStepsCount((Integer)getField.get(CASCADE_STEPS_COUNT, null));
            workspaceBoundsManager.setCascadePoint((Point)getField.get(CASCADE_POINT, null));
            this.source.setToolbarConfigName((String)getField.get(TOOLBAR_CONFIG_NAME, null));
            this.source.current = (Mode)getField.get(CURRENT_MODE, null);
            workspaceBoundsManager.setCascadingOrigin((Point)getField.get(CASCADING_ORIGIN, null));
            this.source.fromBundle = (Boolean)getField.get(FROM_BUNDLE, null);
            this.source.savedManager = (WindowManagerImpl.TopComponentManager)getField.get(ACTIVE_TCM, null);
            Collection collection = (Collection)getField.get("modes", null);
            ArrayList arrayList = this.source.modes;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Mode mode = (Mode)iterator.next();
                if (this.source.findLoadedMode(mode.getName()) != null) continue;
                ArrayList arrayList2 = arrayList;
                synchronized (arrayList2) {
                    arrayList.add(mode);
                }
            }
            if (WindowUtils.hasObjectStreamField(getField, DOMINANCE_LIST)) {
                this.source.visManager().setDominanceList((List)getField.get(DOMINANCE_LIST, null));
            }
            if (WindowUtils.hasObjectStreamField(getField, MAX_MODE)) {
                this.source.setWasMaxMode((Boolean)getField.get(MAX_MODE, null));
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.source;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

