/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.util.Utilities;

class ShortcutAndMenuKeyEventProcessor {
    private boolean wasPopupDisplayed;
    private KeyEvent lastKeyPressed;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$javax$swing$JComponent;

    ShortcutAndMenuKeyEventProcessor() {
        try {
            Class<?> clazz = Class.forName("java.awt.KeyEventDispatcher");
            Class<?> clazz2 = Class.forName("java.awt.KeyEventPostProcessor");
            Class<?> clazz3 = Class.forName("java.awt.KeyboardFocusManager");
            Method method = clazz3.getMethod("getCurrentKeyboardFocusManager", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz3.getMethod("addKeyEventDispatcher", Class.forName("java.awt.KeyEventDispatcher"));
            Method method3 = clazz3.getMethod("addKeyEventPostProcessor", Class.forName("java.awt.KeyEventPostProcessor"));
            Object object2 = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, clazz2}, new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    boolean bl = ShortcutAndMenuKeyEventProcessor.this.dispatchKeyEvent((KeyEvent)objectArray[0]);
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            Object object3 = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, clazz2}, new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    boolean bl = ShortcutAndMenuKeyEventProcessor.this.postProcessKeyEvent((KeyEvent)objectArray[0]);
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            method2.invoke(object, object2);
            method3.invoke(object, object3);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        if (this.processShortcut(keyEvent)) {
            return true;
        }
        Window window = SwingUtilities.windowForComponent(keyEvent.getComponent());
        if (window instanceof Dialog) {
            return false;
        }
        MainWindow mainWindow = WindowManagerImpl.mainWindow();
        if (window == mainWindow) {
            return false;
        }
        JMenuBar jMenuBar = mainWindow.getJMenuBar();
        if (jMenuBar == null) {
            return false;
        }
        boolean bl = keyEvent.getID() == 401;
        boolean bl2 = ShortcutAndMenuKeyEventProcessor.invokeProcessKeyBindingsForAllComponents(keyEvent, mainWindow, bl);
        if (bl2) {
            keyEvent.consume();
        }
        return bl2;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        MenuElement[] menuElementArray;
        int n;
        if (Utilities.getOperatingSystem() == 16 && (n = keyEvent.getModifiers()) == 4) {
            n = n & 0xFFFFFFFB | 8;
            keyEvent.setModifiers(n);
        }
        if (keyEvent.getID() == 401 && keyEvent.getModifiers() == 3 && (keyEvent.getKeyCode() == 19 || keyEvent.getKeyCode() == 3)) {
            Object object = keyEvent.getSource();
            if (object instanceof Component) {
                Window window = SwingUtilities.windowForComponent((Component)object);
                Component component = SwingUtilities.findFocusOwner(window);
                System.err.println("*** ShortcutAndMenuKeyEventProcessor: current focus owner = " + component);
            }
            keyEvent.consume();
            return true;
        }
        DefaultContainerImpl.runPendingNodeActivator();
        if (keyEvent.getID() == 401) {
            this.lastKeyPressed = keyEvent;
        }
        if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) == null || menuElementArray.length == 0) {
            this.wasPopupDisplayed = false;
            if (Utilities.isWindows() && keyEvent.getModifiers() == 1 && keyEvent.getKeyCode() == 121) {
                return this.processShortcut(keyEvent);
            }
            return false;
        }
        if (!this.wasPopupDisplayed && this.lastKeyPressed != null && keyEvent.getID() == 400 && this.lastKeyPressed.getModifiers() == 8 && keyEvent.getModifiers() == 8 && this.lastKeyPressed.getKeyChar() == keyEvent.getKeyChar()) {
            this.wasPopupDisplayed = true;
            keyEvent.consume();
            return true;
        }
        this.wasPopupDisplayed = true;
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && menuElementArray[0] instanceof JMenuBar) {
            keyEvent.setSource(WindowManagerImpl.mainWindow());
        }
        return keyEvent.isConsumed();
    }

    private boolean processShortcut(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        Window window = SwingUtilities.windowForComponent(keyEvent.getComponent());
        if (!ShortcutAndMenuKeyEventProcessor.isTransmodalAction(keyStroke) && window instanceof Dialog) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(keyEvent.getSource(), 1001, Utilities.keyToString((KeyStroke)keyStroke));
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        Action action = keymap.getAction(keyStroke);
        if (action != null && action.isEnabled()) {
            TopManager.getDefault().getActionManager().invokeAction(action, actionEvent);
            keyEvent.consume();
            return true;
        }
        return false;
    }

    private static boolean invokeProcessKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl) {
        try {
            Method method = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = ShortcutAndMenuKeyEventProcessor.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getDeclaredMethod("processKeyBindingsForAllComponents", class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = ShortcutAndMenuKeyEventProcessor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent, class$java$awt$Container == null ? (class$java$awt$Container = ShortcutAndMenuKeyEventProcessor.class$("java.awt.Container")) : class$java$awt$Container, Boolean.TYPE);
            if (method == null) {
                return false;
            }
            ((AccessibleObject)method).setAccessible(true);
            Boolean bl2 = (Boolean)method.invoke(null, keyEvent, container, new Boolean(bl));
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isTransmodalAction(KeyStroke keyStroke) {
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        Action action = keymap.getAction(keyStroke);
        if (action == null) {
            return false;
        }
        Object object = action.getValue("OpenIDE-Transmodal-Action");
        return object != null && object.equals(Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

