/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.netbeans.core.ui.ArrowsTabbedPaneUI;
import org.netbeans.core.ui.PopupTabbedPaneUI;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.dnd.WindowDnDManager;
import org.netbeans.core.windows.frames.CloseButtonTabbedPane;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.netbeans.core.windows.frames.SplittedContainerImpl$SerializationReplacer;
import org.netbeans.core.windows.frames.TCCTabbedAreaImpl;
import org.netbeans.core.windows.frames.TabHandlePopupListener;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.actions.NextTabAction;
import org.openide.actions.PreviousTabAction;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SplitContainerImpl
extends DefaultContainerImpl
implements ChangeListener,
ComponentListener {
    private TopComponent wasSelected;
    private static final ArrayList positionNames = new ArrayList(5);
    private final Map constraints = new HashMap(15);
    private final CloseButtonTabbedPane[] tabbedContainer = new CloseButtonTabbedPane[positionNames.size()];
    private final Dimension[] prefTabbedSize = new Dimension[positionNames.size()];
    private final int[] selectedTabs = new int[positionNames.size()];
    private final Map tabbedContainer2Constraint = new HashMap(10);
    private final Map constrs2Areas = new HashMap(10);
    private final List areas = new ArrayList(5);
    private final Map borders = new WeakHashMap(5);
    private int counter = 0;
    private final PerimeterPane contentPane = new PerimeterPane();
    private final FocusListener tabbedFocusListener = new TabbedContainerFocusL();
    private ArrayList serConstraints;
    private ArrayList serSelectedTabs;
    private TopComponent requestedTC = null;
    private final Object COMPONENT_LOCK = new Object();
    private static final int WEST_X = 0;
    private static final int CENTER_X = 1;
    private static final int EAST_X = 2;
    private static final int NORTH_Y = 0;
    private static final int CENTER_Y = 1;
    private static final int SOUTH_Y = 2;
    public static final String DEFAULT_CONTAINER = "defaultContainer";
    public static final String CONSTRAINTS_LIST = "constraintsArray";
    public static final String TABBED_CONTAINERS_SIZE = "tabbedSizesArray";
    public static final String INDEX_OF_SELECTED_TAB = "selectedTabIndexes";
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$SplitContainerImpl;

    public SplitContainerImpl() {
        int n = 0;
        while (n < positionNames.size()) {
            this.selectedTabs[n] = -1;
            ++n;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
    }

    protected void actionPerformed(SystemAction systemAction, boolean bl) {
        if (bl) {
            return;
        }
        if (systemAction instanceof NextTabAction || systemAction instanceof PreviousTabAction) {
            TopComponent topComponent = this.getSelectedTopComponent();
            CloseButtonTabbedPane closeButtonTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
            int n = closeButtonTabbedPane.getTabCount();
            int n2 = closeButtonTabbedPane.getSelectedIndex();
            if (n <= 1 || n2 == -1) {
                return;
            }
            int n3 = systemAction instanceof NextTabAction ? 1 : -1;
            int n4 = (n2 + n3 + n) % n;
            closeButtonTabbedPane.setSelectedIndex(n4);
        }
    }

    void updateNextAndPreviousState() {
        TopComponent topComponent = this.getSelectedTopComponent();
        if (topComponent == null) {
            return;
        }
        Container container = null;
        int n = positionNames.indexOf(this.constraints.get(topComponent));
        if (n >= 0 && n < this.tabbedContainer.length) {
            container = this.tabbedContainer[n];
        }
        if (container != null && container.getComponentCount() > 1) {
            DefaultContainerImpl.nextTab.setActionPerformer((ActionPerformer)this);
            DefaultContainerImpl.prevTab.setActionPerformer((ActionPerformer)this);
        } else {
            DefaultContainerImpl.nextTab.setActionPerformer(null);
            DefaultContainerImpl.prevTab.setActionPerformer(null);
        }
    }

    public void requestVisible(TopComponent topComponent) {
        int n;
        CloseButtonTabbedPane closeButtonTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
        TopComponent topComponent2 = this.getSelectedTopComponent();
        CloseButtonTabbedPane closeButtonTabbedPane2 = null;
        if (topComponent2 != null && (n = positionNames.indexOf(this.constraints.get(topComponent2))) >= 0 && n < this.tabbedContainer.length) {
            closeButtonTabbedPane2 = this.tabbedContainer[n];
        }
        if (this.isActivated()) {
            if (closeButtonTabbedPane == closeButtonTabbedPane2) {
                topComponent.requestFocus();
            } else if (closeButtonTabbedPane != null && closeButtonTabbedPane.indexOfComponent((Component)topComponent) >= 0) {
                closeButtonTabbedPane.removeChangeListener(this);
                closeButtonTabbedPane.setSelectedComponent((Component)topComponent);
                closeButtonTabbedPane.addChangeListener(this);
            }
        } else if (closeButtonTabbedPane != null && closeButtonTabbedPane.indexOfComponent((Component)topComponent) >= 0) {
            closeButtonTabbedPane.removeChangeListener(this);
            this.setSelectedTopComponent(topComponent);
            closeButtonTabbedPane.addChangeListener(this);
            if (closeButtonTabbedPane == closeButtonTabbedPane2) {
                this.requestedTC = topComponent;
            } else if (closeButtonTabbedPane2 != null && closeButtonTabbedPane2.indexOfComponent((Component)topComponent2) >= 0) {
                closeButtonTabbedPane2.removeChangeListener(this);
                this.setSelectedTopComponent(topComponent2);
                closeButtonTabbedPane2.addChangeListener(this);
            }
        }
    }

    public boolean canAdd(TopComponent[] topComponentArray) {
        return true;
    }

    public Object getConstraints(TopComponent topComponent) {
        return this.constraints.get(topComponent);
    }

    public TopComponentContainer.Area getArea(Object object) {
        return (TopComponentContainer.Area)this.constrs2Areas.get(object);
    }

    public List getAreas() {
        return this.areas;
    }

    public List getConstraintsOrder() {
        return ((PerimeterLayout)this.contentPane.getLayout()).getDominance();
    }

    public void setConstraintsOrder(List list) {
        PerimeterLayout perimeterLayout = (PerimeterLayout)this.contentPane.getLayout();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (!"CENTER".equals(e)) {
                perimeterLayout.setDominant((String)list.get(n));
            }
            --n;
        }
    }

    protected void attachComponents() {
        Object object;
        TopComponent[] topComponentArray = this.getTopComponents();
        if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy((TopComponent)(object = this.getSelectedTopComponent()))) {
            this.addTCIntoPane((TopComponent)object);
            this.revalidate();
            return;
        }
        object = new HashMap(5);
        int n = 0;
        while (n < topComponentArray.length) {
            Object v = this.constraints.get(topComponentArray[n]);
            if (object.get(v) == null) {
                object.put(v, topComponentArray[n]);
            } else {
                object.put(v, Boolean.FALSE);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < topComponentArray.length) {
            TopComponent topComponent = topComponentArray[n2];
            if (SplitContainerImpl.hasAlonePolicy(topComponent) && object.containsValue(topComponent)) {
                this.adjustTCBoundsFromArea(topComponent);
                this.addTCIntoPane(topComponent);
            } else {
                int n3 = positionNames.indexOf(this.constraints.get(topComponent));
                this.openTabbedContainer(n3, topComponent, this.constraints.get(topComponent));
                this.tabbedContainer[n3].removeChangeListener(this);
                this.addTCIntoTab(topComponent, n3);
                this.tabbedContainer[n3].addChangeListener(this);
            }
            ++n2;
        }
        this.resetSelection();
    }

    private void resetSelection() {
        int n;
        TopComponent[] topComponentArray = this.getTopComponents();
        TopComponent topComponent = null;
        if (this.wasSelected != null && this.containsTopComponent(this.wasSelected)) {
            topComponent = this.wasSelected;
        } else if (topComponentArray.length > 0) {
            topComponent = topComponentArray[0];
        }
        if (topComponent != null) {
            n = positionNames.indexOf(this.constraints.get(topComponent));
            if (this.tabbedContainer[n] != null) {
                this.tabbedContainer[n].setSelectedComponent((Component)topComponent);
            }
            SplitContainerImpl.ensureTCIsVisible(topComponent);
            this.setSelectedTopComponent(topComponent);
        }
        n = 0;
        while (n < this.tabbedContainer.length) {
            Component component;
            Component component2 = component = this.tabbedContainer[n] == null ? null : this.tabbedContainer[n].getSelectedComponent();
            if (component != null) {
                component.setVisible(true);
            }
            ++n;
        }
    }

    private void adjustTCBoundsFromArea(TopComponent topComponent) {
        Dimension dimension = this.getAreaDimension(this.constraints.get(topComponent));
        if (dimension != null) {
            topComponent.setSize(dimension);
        }
    }

    private void setPrefTabbedSizeForArea(Object object) {
        if (this.prefTabbedSize[positionNames.indexOf(object)] == null) {
            this.prefTabbedSize[SplitContainerImpl.positionNames.indexOf((Object)object)] = this.getAreaDimension(object);
        }
    }

    private Dimension getAreaDimension(Object object) {
        Rectangle rectangle;
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(object);
        if (area != null && (rectangle = area.getBounds()) != null) {
            return new Dimension(rectangle.width, rectangle.height);
        }
        return null;
    }

    protected void detachComponents() {
        TopComponent topComponent;
        if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy(topComponent = this.getSelectedTopComponent())) {
            this.removeTCFromPane(topComponent);
            return;
        }
        this.wasSelected = this.getSelectedTopComponent();
        int n = 0;
        while (n < positionNames.size()) {
            if (this.tabbedContainer[n] != null) {
                this.selectedTabs[n] = this.tabbedContainer[n].getSelectedIndex();
                this.tabbedContainer[n].removeAll();
                if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) < 0) {
                    this.tabbedContainer[n].updateUI();
                    this.changeUI(n);
                }
            } else {
                this.selectedTabs[n] = -1;
                Component component = this.contentPane.getComponentAt((String)positionNames.get(n));
                if (component instanceof TopComponent) {
                    this.removeTCFromPane((TopComponent)component);
                }
            }
            ++n;
        }
    }

    protected void componentAdded(TopComponent topComponent) {
        this.componentAdded(topComponent, "CENTER", Integer.MAX_VALUE, null);
    }

    protected void componentAdded(TopComponent topComponent, Object object, int n, TopComponentContainer.Area area) {
        if (positionNames.indexOf(object) == -1) {
            throw new IllegalArgumentException("invalid constraint: " + object);
        }
        Object object2 = this.COMPONENT_LOCK;
        synchronized (object2) {
            Object object3;
            TopComponent[] topComponentArray = this.getTopComponents();
            this.constraints.put(topComponent, object);
            int n2 = this.addToArea(topComponent, object, n, area);
            if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy(topComponent)) {
                this.setPrefTabbedSizeForArea(this.constraints.get(topComponent));
                this.addTCIntoPane(topComponent);
                this.setSelectedTopComponent(topComponent);
                return;
            }
            if (this.constraints.size() == 2) {
                object3 = topComponentArray[0];
                if (object3.equals(topComponent)) {
                    object3 = topComponentArray[1];
                }
                if (this.constraints.get(object3) == this.constraints.get(topComponent) || !SplitContainerImpl.hasAlonePolicy((TopComponent)object3)) {
                    this.resetTCFromPaneToTab((TopComponent)object3);
                }
            }
            if ((object3 = (TopComponentContainer.Area)this.constrs2Areas.get(object)).getComponentsList().size() == 1 && SplitContainerImpl.hasAlonePolicy(topComponent)) {
                this.adjustTCBoundsFromArea(topComponent);
                this.addTCIntoPane(topComponent);
                this.revalidate();
            } else {
                Component component;
                if (object3.getComponentsList().size() == 2 && (component = this.contentPane.getComponentAt((String)object)) instanceof TopComponent) {
                    this.resetTCFromPaneToTab((TopComponent)component);
                }
                int n3 = positionNames.indexOf(object);
                this.openTabbedContainer(n3, topComponent, object);
                this.insertTCIntoTab(topComponent, n3, n2);
            }
        }
    }

    private void addTCIntoPane(TopComponent topComponent) {
        if (this.isAttached()) {
            SplitContainerImpl.ensureTCIsVisible(topComponent);
            this.updateShownComponents(topComponent);
            Border border = topComponent.getBorder();
            if (!(border instanceof EtchedBorder)) {
                this.borders.put(topComponent, topComponent.getBorder());
                topComponent.setBorder(SplitContainerImpl.createSplitBorder());
            }
            this.contentPane.add((Component)topComponent, this.constraints.get(topComponent));
            topComponent.addComponentListener(this);
        }
    }

    private void resetTCFromPaneToTab(TopComponent topComponent) {
        int n = positionNames.indexOf(this.constraints.get(topComponent));
        this.removeTCFromPane(topComponent);
        this.openTabbedContainer(n, topComponent, this.getConstraints(topComponent));
        this.addTCIntoTab(topComponent, n);
    }

    private void addTCIntoTab(TopComponent topComponent, int n) {
        if (!this.isAttached()) {
            return;
        }
        SplitContainerImpl.ensureTCIsVisible(topComponent);
        if (SplitContainerImpl.containsTC(this.tabbedContainer[n], topComponent)) {
            return;
        }
        Image image = topComponent.getIcon();
        this.tabbedContainer[n].addTab(topComponent.getName() + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE, image == null ? null : new ImageIcon(image), (Component)topComponent, topComponent.getToolTipText());
    }

    private void insertTCIntoTab(TopComponent topComponent, int n, int n2) {
        if (!this.isAttached()) {
            return;
        }
        SplitContainerImpl.ensureTCIsVisible(topComponent);
        CloseButtonTabbedPane closeButtonTabbedPane = this.tabbedContainer[n];
        if (SplitContainerImpl.containsTC(closeButtonTabbedPane, topComponent)) {
            return;
        }
        int n3 = closeButtonTabbedPane.getTabCount();
        if (n2 > n3) {
            n2 = n3;
        }
        Image image = topComponent.getIcon();
        closeButtonTabbedPane.insertTab(topComponent.getName() + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE, image == null ? null : new ImageIcon(image), (Component)topComponent, topComponent.getToolTipText(), n2);
    }

    private static boolean containsTC(JTabbedPane jTabbedPane, TopComponent topComponent) {
        Component[] componentArray = jTabbedPane.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == topComponent) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void ensureTCIsVisible(TopComponent topComponent) {
        if (!topComponent.isVisible()) {
            topComponent.setVisible(true);
        }
    }

    protected void componentRemoved(TopComponent topComponent) {
        Object object = this.COMPONENT_LOCK;
        synchronized (object) {
            TopComponent topComponent2;
            int n;
            TopComponent[] topComponentArray = this.getTopComponents();
            if (this.constraints.size() == 1 && SplitContainerImpl.hasAlonePolicy(topComponent)) {
                this.removeFromArea(topComponent);
                this.constraints.remove(topComponent);
                this.doActivateComponent(null);
                this.removeTCFromPane(topComponent);
                return;
            }
            boolean bl = false;
            if (topComponent == this.contentPane.getComponentAt((String)this.constraints.get(topComponent))) {
                this.removeTCFromPane(topComponent);
                this.revalidate();
            } else {
                this.removeTCFromTab(topComponent);
                n = positionNames.indexOf(this.constraints.get(topComponent));
                if (n >= 0 && n < this.tabbedContainer.length && this.tabbedContainer[n] == null) {
                    this.reactivateSelectedComponent();
                    bl = true;
                }
            }
            n = positionNames.indexOf(this.constraints.get(topComponent));
            this.removeFromArea(topComponent);
            this.constraints.remove(topComponent);
            this.removeTCFromPane(topComponent);
            JTabbedPane jTabbedPane = null;
            if (n >= 0 && n < this.tabbedContainer.length) {
                jTabbedPane = this.tabbedContainer[n];
            }
            if (jTabbedPane != null && jTabbedPane.getTabCount() == 1 && SplitContainerImpl.hasAlonePolicy(topComponent2 = (TopComponent)jTabbedPane.getComponentAt(0))) {
                this.removeTCFromTab(topComponent2);
                this.addTCIntoPane(topComponent2);
                this.setSelectedTopComponent(topComponent2);
                this.reactivateSelectedComponent();
                bl = true;
            }
            if (jTabbedPane != null) {
                topComponent2 = (TopComponent)jTabbedPane.getSelectedComponent();
                this.setSelectedTopComponent(topComponent2);
                this.reactivateSelectedComponent();
                bl = true;
            }
            if (this.constraints.size() == 1) {
                topComponent2 = topComponentArray[0];
                if (SplitContainerImpl.hasAlonePolicy(topComponent2)) {
                    this.removeTCFromTab(topComponent2);
                    this.addTCIntoPane(topComponent2);
                }
                if (this.isAttached()) {
                    this.mode.updateTitle();
                }
            }
            if (topComponentArray.length > 0 && !bl) {
                topComponent2 = topComponentArray[0];
                this.setSelectedTopComponent(topComponent2);
                this.reactivateSelectedComponent();
            }
        }
    }

    private void removeTCFromPane(TopComponent topComponent) {
        topComponent.removeComponentListener(this);
        this.contentPane.remove((Component)topComponent);
        topComponent.setBorder((Border)this.borders.get(topComponent));
    }

    private void removeTCFromTab(TopComponent topComponent) {
        int n = positionNames.indexOf(this.constraints.get(topComponent));
        if (n < 0 || n >= this.tabbedContainer.length) {
            return;
        }
        CloseButtonTabbedPane closeButtonTabbedPane = this.tabbedContainer[n];
        if (closeButtonTabbedPane != null) {
            if (closeButtonTabbedPane.indexOfComponent((Component)topComponent) != -1) {
                closeButtonTabbedPane.removeChangeListener(this);
                closeButtonTabbedPane.remove((Component)topComponent);
                closeButtonTabbedPane.addChangeListener(this);
            }
            if (closeButtonTabbedPane.getTabCount() == 0) {
                this.closeTabbedContainer(n);
            }
        }
    }

    static boolean hasAlonePolicy(TopComponent topComponent) {
        if (topComponent == null) {
            return false;
        }
        String string = (String)topComponent.getClientProperty("TabPolicy");
        return "HideWhenAlone".equals(string);
    }

    private static Border createSplitBorder() {
        return BorderFactory.createEtchedBorder(Color.white, Color.darkGray);
    }

    private int addToArea(TopComponent topComponent, Object object, int n, TopComponentContainer.Area area) {
        TopComponentContainer.Area area2 = (TopComponentContainer.Area)this.constrs2Areas.get(object);
        if (area != null && area2 == null) {
            this.constrs2Areas.put(object, area);
            this.areas.add(area);
            area2 = area;
        }
        if (area2 == null) {
            area2 = new TCCTabbedAreaImpl(object);
            this.constrs2Areas.put(object, area2);
            this.areas.add(area2);
        }
        int n2 = this.findPosition(n, object);
        area2.getComponentsList().add(n2, topComponent);
        return n2;
    }

    private void removeFromArea(TopComponent topComponent) {
        Object v = this.constraints.get(topComponent);
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(v);
        if (area == null) {
            return;
        }
        List list = area.getComponentsList();
        list.remove(topComponent);
        if (list.size() <= 0) {
            this.constrs2Areas.remove(v);
            this.areas.remove(area);
            if (this.isAttached()) {
                HashMap<Object, TopComponentContainer.Area> hashMap = this.mode.getAreas();
                hashMap = hashMap == null ? new HashMap() : new HashMap(hashMap);
                hashMap.put(v, area);
                this.mode.setAreas(hashMap);
            }
        }
    }

    protected void componentIconChanged(TopComponent topComponent, Image image) {
        if (!this.containsTopComponent(topComponent)) {
            return;
        }
        if (this.constraints.size() > 0) {
            CloseButtonTabbedPane closeButtonTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
            if (closeButtonTabbedPane == null) {
                return;
            }
            int n = closeButtonTabbedPane.indexOfComponent((Component)topComponent);
            if (n < 0) {
                return;
            }
            closeButtonTabbedPane.setIconAt(n, new ImageIcon(image));
            if (this.isAttached()) {
                closeButtonTabbedPane.revalidate();
                closeButtonTabbedPane.repaint();
            }
        }
    }

    protected void componentNameChanged(TopComponent topComponent) {
        if (!this.containsTopComponent(topComponent)) {
            return;
        }
        String string = topComponent.getName();
        CloseButtonTabbedPane closeButtonTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
        if (closeButtonTabbedPane != null) {
            int n = closeButtonTabbedPane.indexOfComponent((Component)topComponent);
            if (n < 0) {
                return;
            }
            closeButtonTabbedPane.setTitleAt(n, string + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE);
            closeButtonTabbedPane.setToolTipTextAt(n, topComponent.getToolTipText());
        }
        this.firePropertyChange("name", null, string);
    }

    protected void componentSelected(TopComponent topComponent) {
        Object object;
        if (topComponent == null) {
            return;
        }
        SplitContainerImpl.ensureTCIsVisible(topComponent);
        if (this.constraints.size() > 1 && (object = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))]) != null && ((JTabbedPane)object).indexOfComponent((Component)topComponent) >= 0) {
            ((JTabbedPane)object).setSelectedComponent((Component)topComponent);
            Component[] componentArray = ((Container)object).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] != topComponent && componentArray[n].isVisible()) {
                    componentArray[n].setVisible(false);
                }
                ++n;
            }
        }
        if ((object = (TopComponentContainer.Area)this.constrs2Areas.get(this.constraints.get(topComponent))) != null) {
            object.setSelectedTopComponent(topComponent);
        }
    }

    protected List getHiddingComponents(Set set, TopComponent topComponent) {
        Object v = this.constraints.get(topComponent);
        List<TopComponent> list = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TopComponent topComponent2 = (TopComponent)iterator.next();
            if (this.constraints.get(topComponent2) != v) continue;
            iterator.remove();
            list = Collections.singletonList(topComponent2);
            break;
        }
        return list;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (!this.isVisible() || !this.isShowing() || jTabbedPane.getTabCount() <= 0) {
            return;
        }
        int n = jTabbedPane.getSelectedIndex();
        TopComponent topComponent = n < 0 ? null : (TopComponent)jTabbedPane.getComponentAt(n);
        this.setSelectedTopComponent(topComponent);
        this.reactivateSelectedComponent();
    }

    public void setAttached(boolean bl) {
        super.setAttached(bl);
        if (bl) {
            ActivateTopComponentOnMouseClick.install();
        }
    }

    public void validateData() {
        Iterator iterator;
        super.validateData();
        if (this.serConstraints != null) {
            iterator = ((AbstractList)this.serConstraints).iterator();
            TopComponent[] topComponentArray = this.getTopComponents();
            int n = 0;
            while (n < topComponentArray.length) {
                if (iterator.hasNext()) {
                    Object e = iterator.next();
                    TopComponent topComponent = topComponentArray[n];
                    TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(e);
                    if (area == null || !area.getComponentsList().contains(topComponent)) {
                        this.componentAdded(topComponent, e, Integer.MAX_VALUE, null);
                    }
                }
                ++n;
            }
            this.serConstraints = null;
        }
        if (this.serSelectedTabs != null) {
            iterator = ((AbstractList)this.serSelectedTabs).iterator();
            int n = 0;
            while (n < positionNames.size() && iterator.hasNext()) {
                this.selectedTabs[n] = (Integer)iterator.next();
                ++n;
            }
            this.serConstraints = null;
        } else {
            int n = 0;
            while (n < positionNames.size()) {
                this.selectedTabs[n] = -1;
                ++n;
            }
        }
        this.wasSelected = this.getSelectedTopComponent();
    }

    public void changeUI() {
        int n = this.tabbedContainer.length;
        int n2 = 0;
        while (n2 < n) {
            this.changeUI(n2);
            ++n2;
        }
    }

    public void changeUI(int n) {
        if (this.tabbedContainer[n] != null) {
            boolean bl = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
            WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
            switch (windowManagerImpl.tabbedContainerUIManager().getTabbedContainerUI()) {
                case 1: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(0, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof BasicTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[n], 0);
                    break;
                }
                case 2: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof ArrowsTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[n], 1);
                    break;
                }
                case 3: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof PopupTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[n], 2);
                    break;
                }
                case 4: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof ArrowsTabbedPaneUI) break;
                    SplitContainerImpl.updateUITypeForTab(this.tabbedContainer[n], 1);
                }
            }
        }
    }

    private void openTabbedContainer(int n, TopComponent topComponent, Object object) {
        if (this.tabbedContainer[n] != null) {
            return;
        }
        this.tabbedContainer[n] = new CloseButtonTabbedPane();
        if (WindowManagerImpl.isWindowDnDEnabled()) {
            WindowDnDManager.getDefault().getWindowDragSource().createDefaultDragGestureRecognizer(this.tabbedContainer[n], 3, TopComponentDragSupport.getDefault());
        }
        this.changeUI(n);
        if (!Boolean.getBoolean("netbeans.windows.tabs_on_top")) {
            this.tabbedContainer[n].setTabPlacement(3);
        }
        if (this.prefTabbedSize[n] == null) {
            Dimension dimension = this.getAreaDimension(object);
            if (dimension == null) {
                dimension = topComponent.getSize();
            }
            Insets insets = this.tabbedContainer[n].getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            this.prefTabbedSize[n] = dimension;
        }
        this.tabbedContainer[n].setPreferredSize(this.prefTabbedSize[n]);
        TabHandlePopupListener.install();
        this.tabbedContainer[n].addChangeListener(this);
        this.tabbedContainer[n].addFocusListener(this.tabbedFocusListener);
        this.tabbedContainer[n].addComponentListener(this);
        this.tabbedContainer[n].getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl)).getString("ACSN_TabbedContainer"));
        this.tabbedContainer[n].getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl)).getString("ACSD_TabbedContainer"));
        this.tabbedContainer2Constraint.put(this.tabbedContainer[n], positionNames.get(n));
        this.tabbedContainer[n].setBorder(SplitContainerImpl.createSplitBorder());
        ++this.counter;
        this.contentPane.add((Component)this.tabbedContainer[n], positionNames.get(n));
    }

    private void closeTabbedContainer(int n) {
        if (this.tabbedContainer[n] == null) {
            return;
        }
        this.tabbedContainer[n].removeChangeListener(this);
        this.tabbedContainer[n].removeFocusListener(this.tabbedFocusListener);
        this.tabbedContainer[n].removeComponentListener(this);
        this.tabbedContainer2Constraint.remove(this.tabbedContainer[n]);
        this.prefTabbedSize[n] = this.tabbedContainer[n].getSize();
        this.contentPane.remove(this.tabbedContainer[n]);
        this.tabbedContainer[n] = null;
        --this.counter;
        int n2 = 0;
        while (n2 < positionNames.size()) {
            if (this.tabbedContainer[n2] != null) {
                this.tabbedContainer[n2].setPreferredSize(this.tabbedContainer[n2].getSize());
                this.setSelectedTopComponent((TopComponent)this.tabbedContainer[n2].getSelectedComponent());
            }
            ++n2;
        }
    }

    public Object getConstraintForLocation(Point point) {
        Rectangle rectangle = this.getBounds();
        return SplitContainerImpl.extractConstraint(this.getPosition(new int[]{0, 0, 0}, new int[]{0, 0, 0}, point, rectangle));
    }

    public String getDescriptionForLocation(Point point) {
        Object object = this.getConstraintForLocation(point);
        String string = null;
        if (object == "CENTER") {
            string = "LBL_PerimeterLayoutCenter";
        } else if (object == "NORTH") {
            string = "LBL_PerimeterLayoutNorth";
        } else if (object == "SOUTH") {
            string = "LBL_PerimeterLayoutSouth";
        } else if (object == "WEST") {
            string = "LBL_PerimeterLayoutWest";
        } else if (object == "EAST") {
            string = "LBL_PerimeterLayoutEast";
        }
        return string == null ? null : NbBundle.getBundle((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl)).getString(string);
    }

    public Shape getIndicationForLocation(Point point) {
        String string;
        Rectangle rectangle = this.getBounds();
        int[] nArray = new int[]{0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0};
        Point point2 = this.getPosition(nArray, nArray2, point, rectangle);
        if (point2.x == 1) {
            rectangle.y = this.sumArray(nArray2, point2.y);
            rectangle.height = nArray2[point2.y];
        }
        if (point2.y == 1) {
            rectangle.x = this.sumArray(nArray, point2.x);
            rectangle.width = nArray[point2.x];
        }
        if ((string = SplitContainerImpl.extractConstraint(point2)) != null) {
            Component component = this.contentPane.getComponentAt(string);
            if (component != null) {
                return component.getBounds();
            }
            PerimeterLayout perimeterLayout = (PerimeterLayout)this.contentPane.getLayout();
            Rectangle rectangle2 = perimeterLayout.getPossibleBounds(this, PerimeterLayout.sideNames.indexOf(string), (Rectangle)WindowDnDManager.getDefault().getOriginalBounds().clone());
            if (rectangle2 != null) {
                return rectangle2;
            }
        }
        return rectangle;
    }

    private Point getPosition(int[] nArray, int[] nArray2, Point point, Rectangle rectangle) {
        int n;
        this.getSectorLengths(true, nArray, new int[]{3, 4, 2}, rectangle.width);
        this.getSectorLengths(false, nArray2, new int[]{0, 4, 1}, rectangle.height);
        int n2 = point.x < nArray[0] ? 0 : (n = point.x < nArray[0] + nArray[1] ? 1 : 2);
        int n3 = point.y < nArray2[0] ? 0 : (point.y < nArray2[0] + nArray2[1] ? 1 : 2);
        int n4 = SplitContainerImpl.adjustPosition(n, n3, point, rectangle);
        if (n4 == -1) {
            n = 1;
        } else if (n4 == 1) {
            n3 = 1;
        }
        return new Point(n, n3);
    }

    private static int adjustPosition(int n, int n2, Point point, Rectangle rectangle) {
        if (n == 1 || n2 == 1) {
            return 0;
        }
        if (n == 0 && n2 == 0 && point.x > point.y || n == 2 && n2 == 0 && rectangle.width - point.x > point.y || n == 0 && n2 == 2 && point.x > rectangle.height - point.y || n == 2 && n2 == 2 && rectangle.width - point.x > rectangle.height - point.y) {
            return -1;
        }
        return 1;
    }

    private static String extractConstraint(Point point) {
        String string = "CENTER";
        if (point.x == 0) {
            string = "WEST";
        } else if (point.x == 1) {
            if (point.y == 0) {
                string = "NORTH";
            } else if (point.y == 1) {
                string = "CENTER";
            } else if (point.y == 2) {
                string = "SOUTH";
            }
        } else if (point.x == 2) {
            string = "EAST";
        }
        return string;
    }

    private void getSectorLengths(boolean bl, int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        if (nArray.length != nArray2.length) {
            throw new IllegalStateException("Diff array lengths:" + nArray.length + "<>" + nArray2.length);
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = this.getSectorLength(bl, nArray2[n4], n2);
            n2 += nArray[n4];
            if (nArray[n4] > 0) {
                ++n3;
            }
            ++n4;
        }
        if (n3 == 0 || n3 == 1) {
            nArray[0] = nArray[2] = n / 4;
            nArray[1] = n / 2;
        } else if (n3 == 2) {
            if (nArray[0] != 0) {
                if (nArray[1] != 0) {
                    nArray[1] = nArray[2] = nArray[1] / 2;
                } else {
                    nArray[1] = nArray[0] / 2 + nArray[2] / 2;
                    nArray[0] = nArray[0] / 2;
                    nArray[2] = nArray[2] / 2;
                }
            } else {
                nArray[0] = nArray[1] = nArray[1] / 2;
            }
        }
    }

    private int getSectorLength(boolean bl, int n, int n2) {
        if (this.tabbedContainer[n] == null) {
            return 0;
        }
        Rectangle rectangle = this.tabbedContainer[n].getBounds();
        if (bl) {
            return rectangle.x + rectangle.width - n2;
        }
        return rectangle.y + rectangle.height - n2;
    }

    private int sumArray(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += nArray[n3];
            ++n3;
        }
        return n2;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateAreaBounds(componentEvent);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.updateAreaBounds(componentEvent);
    }

    private void updateAreaBounds(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        Object var3_3 = null;
        if (component instanceof JTabbedPane) {
            var3_3 = this.tabbedContainer2Constraint.get(component);
        } else if (component instanceof TopComponent) {
            if (!this.containsTopComponent((TopComponent)component)) {
                component.removeComponentListener(this);
                return;
            }
            var3_3 = this.constraints.get(component);
        }
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(var3_3);
        area.setBounds(component.getBounds());
    }

    protected void componentFocusGained(TopComponent topComponent, FocusEvent focusEvent) {
        if (topComponent != this.getSelectedTopComponent() && this.requestedTC != null && this.containsTopComponent(this.requestedTC)) {
            topComponent = this.requestedTC;
        }
        this.requestedTC = null;
        super.componentFocusGained(topComponent, focusEvent);
        if (topComponent != this.getSelectedTopComponent()) {
            int n = positionNames.indexOf(this.constraints.get(topComponent));
            CloseButtonTabbedPane closeButtonTabbedPane = this.tabbedContainer[n];
            if (closeButtonTabbedPane != null) {
                closeButtonTabbedPane.removeChangeListener(this);
            }
            this.setSelectedTopComponent(topComponent);
            this.reactivateWithDelay();
            if (closeButtonTabbedPane != null) {
                closeButtonTabbedPane.addChangeListener(this);
            }
        }
    }

    private static void updateUITypeForTab(CloseButtonTabbedPane closeButtonTabbedPane, int n) {
        closeButtonTabbedPane.setUIType(n);
        SwingUtilities.updateComponentTreeUI(closeButtonTabbedPane);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SplittedContainerImpl$SerializationReplacer(this);
    }

    void writeData(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put(DEFAULT_CONTAINER, new DefaultContainerImpl.SerializedData(this));
        List<TopComponent> list = Arrays.asList(this.getTopComponents());
        ArrayList arrayList = new ArrayList(list.size());
        Iterator<TopComponent> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.constraints.get(iterator.next()));
        }
        putField.put(CONSTRAINTS_LIST, arrayList);
        ArrayList<Dimension> arrayList2 = new ArrayList<Dimension>(this.prefTabbedSize.length);
        int n = 0;
        while (n < this.prefTabbedSize.length) {
            arrayList2.add(this.tabbedContainer[n] == null ? this.prefTabbedSize[n] : this.tabbedContainer[n].getSize());
            ++n;
        }
        putField.put(TABBED_CONTAINERS_SIZE, arrayList2);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(positionNames.size());
        int n2 = 0;
        while (n2 < positionNames.size()) {
            arrayList3.add(this.tabbedContainer[n2] == null ? new Integer(-1) : new Integer(this.tabbedContainer[n2].getSelectedIndex()));
            ++n2;
        }
        putField.put(INDEX_OF_SELECTED_TAB, arrayList3);
        objectOutputStream.writeFields();
    }

    void readData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ArrayList arrayList;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.attachData((DefaultContainerImpl.SerializedData)getField.get(DEFAULT_CONTAINER, null));
        this.serConstraints = (ArrayList)getField.get(CONSTRAINTS_LIST, null);
        if (WindowUtils.hasObjectStreamField(getField, TABBED_CONTAINERS_SIZE) && (arrayList = (ArrayList)getField.get(TABBED_CONTAINERS_SIZE, null)) != null) {
            Dimension[] dimensionArray = arrayList.toArray(new Dimension[0]);
            System.arraycopy(dimensionArray, 0, this.prefTabbedSize, 0, this.prefTabbedSize.length);
        }
        if (WindowUtils.hasObjectStreamField(getField, INDEX_OF_SELECTED_TAB)) {
            this.serSelectedTabs = (ArrayList)getField.get(INDEX_OF_SELECTED_TAB, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        positionNames.add("NORTH");
        positionNames.add("SOUTH");
        positionNames.add("EAST");
        positionNames.add("WEST");
        positionNames.add("CENTER");
    }

    private class TabbedContainerFocusL
    extends FocusAdapter {
        private TabbedContainerFocusL() {
        }

        public void focusGained(FocusEvent focusEvent) {
            TopComponent topComponent = (TopComponent)((JTabbedPane)focusEvent.getComponent()).getSelectedComponent();
            if (topComponent != null && topComponent != SplitContainerImpl.this.getSelectedTopComponent()) {
                if (!SplitContainerImpl.this.containsTopComponent(topComponent)) {
                    ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("TopComponent " + topComponent + " is not in container for mode " + SplitContainerImpl.this.mode + "!"));
                    return;
                }
                SplitContainerImpl.this.setSelectedTopComponent(topComponent);
                SplitContainerImpl.this.reactivateWithDelay();
            }
        }
    }

    private static class ActivateTopComponentOnMouseClick
    implements AWTEventListener {
        private static boolean installed;

        private ActivateTopComponentOnMouseClick() {
        }

        static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new ActivateTopComponentOnMouseClick(), 16L);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() != 501) {
                return;
            }
            if (!(aWTEvent.getSource() instanceof Component)) {
                return;
            }
            Component component = (Component)aWTEvent.getSource();
            while (component != null && !(component instanceof SplitContainerImpl) && !(component instanceof TopComponent)) {
                component = component.getParent();
            }
            if (component instanceof TopComponent) {
                TopComponentContainer topComponentContainer;
                TopComponent topComponent = (TopComponent)component;
                while (component != null && !(component instanceof SplitContainerImpl)) {
                    component = component.getParent();
                }
                if (component instanceof TopComponentContainer && (topComponentContainer = (TopComponentContainer)((Object)component)).containsTopComponent(topComponent)) {
                    topComponentContainer.setSelectedTopComponent(topComponent);
                }
                if (component instanceof SplitContainerImpl) {
                    ((SplitContainerImpl)component).reactivateSelectedComponent();
                }
            }
        }
    }
}

