/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.TCCTabbedAreaImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.InvalidDataException;
import org.netbeans.core.windows.layers.ProducerCookie;
import org.netbeans.core.windows.layers.TCRef;
import org.netbeans.core.windows.layers.TCRefImpl;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.io.FoldingIOException;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ModeData
extends DataFolder
implements CookieSet.Factory {
    private static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Mode Properties 1.0//EN";
    private static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Mode Properties 1.1//EN";
    private static final String INSTANCE_DTD_ID_1_2 = "-//NetBeans//DTD Mode Properties 1.2//EN";
    private FileObject modeConfigFO;
    private CookiesImpl cookiesImpl;
    private boolean initDone = false;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;

    public ModeData(FileObject fileObject, FileObject fileObject2, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.initCookies();
        this.initDone = true;
        this.modeConfigFO = fileObject2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = ModeData.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    private void initCookies() {
        this.getCookieSet().add(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = ModeData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ModeData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = ModeData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie, (CookieSet.Factory)this);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (!this.initDone) {
            this.initCookies();
            this.initDone = true;
        }
        return super.getCookie(clazz);
    }

    ModeImpl getModeImpl() throws IOException {
        return this.cookiesImpl().obtainModeImpl();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz == (class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ModeData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) || clazz == (class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = ModeData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) || clazz == (class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = ModeData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie)) {
            return this.cookiesImpl();
        }
        return null;
    }

    private synchronized CookiesImpl cookiesImpl() {
        if (this.cookiesImpl != null) {
            return this.cookiesImpl;
        }
        this.cookiesImpl = new CookiesImpl(this, this.modeConfigFO);
        return this.cookiesImpl;
    }

    FileObject getModeConfigFO() {
        if (this.modeConfigFO == null) {
            Iterator iterator = this.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                this.modeConfigFO = ((MultiDataObject.Entry)iterator.next()).getFile();
            }
        }
        return this.modeConfigFO;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class PropertyHandler
    extends DefaultHandler
    implements FileSystem.AtomicAction {
        private ModeData folder;
        private FileObject fo;
        private ModeConfig modeConfig;
        private StringBuffer buffer;
        private boolean rightProps;
        private boolean ignoreFurther;
        private boolean ignoreCurrent;
        private boolean shouldParse;
        private final Object RW_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData;

        public PropertyHandler(ModeData modeData) {
            this.folder = modeData;
            this.fo = modeData.getModeConfigFO();
            this.shouldParse = true;
        }

        public ModeConfig readData() throws SAXException, IOException {
            if (this.shouldParse) {
                this.modeConfig = new ModeConfig();
                this.ignoreCurrent = false;
                this.ignoreFurther = false;
                this.rightProps = false;
                this.modeConfig.invalid = true;
                Object object = this.RW_LOCK;
                synchronized (object) {
                    this.getXMLParser().parse(new InputSource(this.fo.getInputStream()));
                }
            }
            return this.modeConfig;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!this.ignoreCurrent && !this.ignoreFurther) {
                if ("other".equals(string3)) {
                    this.handleOther(attributes);
                } else if ("icon".equals(string3)) {
                    this.handleIcon(attributes);
                } else if ("bounds".equals(string3)) {
                    this.handleBounds(attributes);
                } else if ("maximized-bounds".equals(string3)) {
                    this.handleMaximizedBounds(attributes);
                } else if ("relative-bounds".equals(string3)) {
                    this.handleRelativeBounds(attributes);
                } else if ("frame".equals(string3)) {
                    this.handleFrame(attributes);
                } else if ("area".equals(string3)) {
                    this.handleDominance(attributes);
                } else if ("container".equals(string3)) {
                    this.startContainer(attributes);
                }
            }
            if ("mode".equals(string3)) {
                this.startMode(attributes);
            } else if ("ui-type".equals(string3)) {
                this.startUIType(attributes);
            } else if ("name".equals(string3)) {
                this.handleName(attributes);
            } else if ("module".equals(string3)) {
                this.handleModule(attributes);
            } else if ("description".equals(string3)) {
                this.handleDescription(attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("ui-type".equals(string3)) {
                this.endUIType();
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        private void handleOther(Attributes attributes) {
            String string = attributes.getValue("defined-by");
            this.modeConfig.userDefined = "user".equals(string) ? 1 : ("module".equals(string) ? 0 : -1);
            string = attributes.getValue("mode-state");
            this.modeConfig.modeState = "visible".equals(string) || string == null ? 1 : ("hidden".equals(string) ? 0 : -1);
        }

        private void handleName(Attributes attributes) {
            this.modeConfig.name = attributes.getValue("unique");
            this.modeConfig.displayName = attributes.getValue("display");
            String string = attributes.getValue("from-bundle");
            if ("true".equals(string)) {
                this.modeConfig.fromBundle = 1;
                this.modeConfig.nameBundle = attributes.getValue("bundle");
            } else {
                this.modeConfig.fromBundle = "false".equals(string) ? 0 : -1;
            }
        }

        private void handleDescription(Attributes attributes) {
            this.modeConfig.description = attributes.getValue("display");
            this.modeConfig.descriptionBundle = attributes.getValue("bundle");
        }

        private void handleModule(Attributes attributes) {
            String string = attributes.getValue("name");
            this.modeConfig.moduleCodeNameBase = null;
            this.modeConfig.moduleCodeNameRelease = null;
            this.modeConfig.moduleSpecificationVersion = null;
            if (string != null) {
                int n = string.indexOf(47);
                if (n != -1) {
                    this.modeConfig.moduleCodeNameBase = string.substring(0, n);
                    this.modeConfig.moduleCodeNameRelease = string.substring(n + 1);
                    PropertyHandler.checkReleaseCode(this.modeConfig);
                } else {
                    this.modeConfig.moduleCodeNameBase = string;
                }
                this.modeConfig.moduleSpecificationVersion = attributes.getValue("spec");
            }
        }

        private static void checkReleaseCode(ModeConfig modeConfig) {
            if ("null".equals(modeConfig.moduleCodeNameRelease)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Module release code was saved as null string for module " + modeConfig.moduleCodeNameBase + "! Repairing."));
                modeConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleIcon(Attributes attributes) {
            try {
                this.modeConfig.iconURL = new URL(attributes.getValue("url"));
            }
            catch (MalformedURLException malformedURLException) {
                this.modeConfig.iconURL = null;
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_ModeIcon"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)malformedURLException, string);
                ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            }
        }

        private void handleBounds(Attributes attributes) {
            if (this.modeConfig.bounds == null) {
                this.modeConfig.bounds = new Rectangle();
            }
            try {
                this.modeConfig.bounds.x = Integer.parseInt(attributes.getValue("x"));
                this.modeConfig.bounds.y = Integer.parseInt(attributes.getValue("y"));
                this.modeConfig.bounds.width = Integer.parseInt(attributes.getValue("width"));
                this.modeConfig.bounds.height = Integer.parseInt(attributes.getValue("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.modeConfig.bounds = null;
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_ModeBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
            }
        }

        private void handleMaximizedBounds(Attributes attributes) {
            if (this.modeConfig.maximizedBounds == null) {
                this.modeConfig.maximizedBounds = new Rectangle();
            }
            try {
                this.modeConfig.maximizedBounds.x = Integer.parseInt(attributes.getValue("x"));
                this.modeConfig.maximizedBounds.y = Integer.parseInt(attributes.getValue("y"));
                this.modeConfig.maximizedBounds.width = Integer.parseInt(attributes.getValue("width"));
                this.modeConfig.maximizedBounds.height = Integer.parseInt(attributes.getValue("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.modeConfig.maximizedBounds = null;
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_ModeMaximizedBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
            }
        }

        private void handleRelativeBounds(Attributes attributes) {
            if (this.modeConfig.relativeBounds == null) {
                this.modeConfig.relativeBounds = new Rectangle();
            }
            try {
                this.modeConfig.relativeBounds.x = Integer.parseInt(attributes.getValue("x"));
                this.modeConfig.relativeBounds.y = Integer.parseInt(attributes.getValue("y"));
                this.modeConfig.relativeBounds.width = Integer.parseInt(attributes.getValue("width"));
                this.modeConfig.relativeBounds.height = Integer.parseInt(attributes.getValue("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.modeConfig.relativeBounds = null;
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_ModeRelativeBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
            }
        }

        private void handleFrame(Attributes attributes) {
            String string = attributes.getValue("type");
            this.modeConfig.frameType = "internal".equals(string) ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : ("desktop".equals(string) ? "org.netbeans.core.windows.frames.DesktopFrameTypeImpl" : ("window".equals(string) ? "org.netbeans.core.windows.frames.TopFrameTypeImpl" : null));
            this.modeConfig.constraints = WindowUtils.convertConstraint2Perim(attributes.getValue("constraints"));
            String string2 = attributes.getValue("state");
            if ("iconified".equals(string2)) {
                this.modeConfig.frameState = 1;
            } else if ("maximized".equals(string2)) {
                this.modeConfig.frameState = 6;
                String string3 = attributes.getValue("restored-state");
                this.modeConfig.restoredFrameState = "iconified".equals(string3) ? 1 : ("normal".equals(string3) ? 0 : -1);
            } else {
                this.modeConfig.frameState = "normal".equals(string2) ? 0 : -1;
            }
        }

        private void handleDominance(Attributes attributes) {
            DominanceEntry dominanceEntry = new DominanceEntry();
            if (this.modeConfig.dominance == null) {
                this.modeConfig.dominance = new ArrayList(5);
            }
            dominanceEntry.constraint = WindowUtils.convertConstraint2Perim(attributes.getValue("constraint"));
            try {
                String string = attributes.getValue("x");
                if (string != null && string.length() > 0) {
                    dominanceEntry.absBounds = new Rectangle();
                    dominanceEntry.relBounds = null;
                    dominanceEntry.absBounds.x = Integer.parseInt(attributes.getValue("x"));
                    dominanceEntry.absBounds.y = Integer.parseInt(attributes.getValue("y"));
                    dominanceEntry.absBounds.width = Integer.parseInt(attributes.getValue("width"));
                    dominanceEntry.absBounds.height = Integer.parseInt(attributes.getValue("height"));
                } else {
                    dominanceEntry.relBounds = new Rectangle();
                    dominanceEntry.absBounds = null;
                    dominanceEntry.relBounds.x = Integer.parseInt(attributes.getValue("relative-x"));
                    dominanceEntry.relBounds.y = Integer.parseInt(attributes.getValue("relative-y"));
                    dominanceEntry.relBounds.width = Integer.parseInt(attributes.getValue("relative-width"));
                    dominanceEntry.relBounds.height = Integer.parseInt(attributes.getValue("relative-height"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                dominanceEntry.absBounds = null;
                dominanceEntry.relBounds = null;
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_WrongAreaBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
            }
            this.modeConfig.dominance.add(dominanceEntry);
        }

        private void startMode(Attributes attributes) {
        }

        private void startContainer(Attributes attributes) {
            String string = attributes.getValue("type");
            this.modeConfig.containerType = "split".equals(string) ? "org.netbeans.core.windows.frames.SplitContainerImpl" : ("tabbed".equals(string) ? "org.netbeans.core.windows.frames.MultiTabbedContainerImpl" : null);
            this.modeConfig.activeTc = attributes.getValue("active-tc");
        }

        private void startUIType(Attributes attributes) {
            String string = attributes.getValue("type");
            int n = ((WindowManagerImpl)WindowManager.getDefault()).uiModeManager().getUIMode();
            if (n == WindowUtils.parseUIType(string)) {
                this.rightProps = true;
                this.modeConfig.invalid = false;
                this.modeConfig.clear();
            } else if ("any".equals(string)) {
                this.modeConfig.invalid = false;
            } else {
                this.ignoreCurrent = true;
            }
        }

        private void endUIType() {
            if (this.rightProps) {
                this.ignoreFurther = true;
            }
            this.ignoreCurrent = false;
        }

        public void writeData() throws IOException {
            this.fillBuffer();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.fo.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            }
        }

        private void fillBuffer() throws IOException {
            ModeImpl modeImpl = this.folder.getModeImpl();
            this.buffer = new StringBuffer(800);
            Object var2_2 = null;
            this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            this.buffer.append("<mode version=\"1.2\">\n");
            this.appendName(modeImpl);
            this.appendDescription(modeImpl);
            this.appendModule(modeImpl);
            this.buffer.append("    <ui-type type=\"any\" >\n");
            this.appendBounds(modeImpl);
            if (modeImpl.isMaxMode() && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(modeImpl.getFrameType())) {
                this.appendMaximizedBounds(modeImpl);
            }
            this.appendFrame(modeImpl);
            this.appendDominance(modeImpl);
            this.appendRest(modeImpl);
            this.buffer.append("    </ui-type>\n");
            this.buffer.append("</mode>\n");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            FileLock fileLock;
            block3: {
                fileLock = this.fo.lock();
                OutputStreamWriter outputStreamWriter = null;
                try {
                    OutputStream outputStream = this.fo.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(this.buffer.toString());
                    Object var5_4 = null;
                    this.buffer = null;
                    if (outputStreamWriter == null) break block3;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.buffer = null;
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    fileLock.releaseLock();
                    throw throwable;
                }
                outputStreamWriter.close();
            }
            fileLock.releaseLock();
        }

        private void appendName(ModeImpl modeImpl) throws CharConversionException {
            this.buffer.append("    <name unique=\"");
            this.buffer.append(XMLUtil.toAttributeValue((String)modeImpl.getName()));
            String string = modeImpl.getDisplayNameXML();
            if (string != null) {
                this.buffer.append("\" display=\"");
                this.buffer.append(XMLUtil.toAttributeValue((String)string));
            }
            this.buffer.append("\" from-bundle=\"");
            if (modeImpl.isNameFromBundle()) {
                this.buffer.append("true");
                this.buffer.append("\" bundle=\"");
                this.buffer.append(modeImpl.getNameBundle());
            } else {
                this.buffer.append("false");
            }
            this.buffer.append("\" />\n");
        }

        private void appendDescription(ModeImpl modeImpl) throws CharConversionException {
            if (modeImpl.getDescriptionXML() == null) {
                return;
            }
            this.buffer.append("    <description display=\"");
            this.buffer.append(XMLUtil.toAttributeValue((String)modeImpl.getDescriptionXML()));
            this.buffer.append("\" bundle=\"");
            this.buffer.append(modeImpl.getDescriptionBundle());
            this.buffer.append("\" />\n");
        }

        private void appendModule(ModeImpl modeImpl) {
            if (this.modeConfig == null) {
                return;
            }
            if (this.modeConfig.moduleCodeNameBase != null) {
                this.buffer.append("    <module");
                this.buffer.append(" name=\"");
                this.buffer.append(this.modeConfig.moduleCodeNameBase);
                if (this.modeConfig.moduleCodeNameRelease != null) {
                    this.buffer.append("/" + this.modeConfig.moduleCodeNameRelease);
                }
                if (this.modeConfig.moduleSpecificationVersion != null) {
                    this.buffer.append("\" spec=\"");
                    this.buffer.append(this.modeConfig.moduleSpecificationVersion);
                }
                this.buffer.append("\" />\n");
            }
        }

        private void appendBounds(ModeImpl modeImpl) {
            Rectangle rectangle = modeImpl.getNormalBounds();
            if (rectangle == null) {
                return;
            }
            this.buffer.append("        <bounds x=\"");
            this.buffer.append(rectangle.x);
            this.buffer.append("\" y=\"");
            this.buffer.append(rectangle.y);
            this.buffer.append("\" width=\"");
            this.buffer.append(rectangle.width);
            this.buffer.append("\" height=\"");
            this.buffer.append(rectangle.height);
            this.buffer.append("\" />\n");
        }

        private void appendMaximizedBounds(ModeImpl modeImpl) {
            Rectangle rectangle = modeImpl.getBounds();
            if (rectangle == null) {
                return;
            }
            this.buffer.append("        <maximized-bounds x=\"");
            this.buffer.append(rectangle.x);
            this.buffer.append("\" y=\"");
            this.buffer.append(rectangle.y);
            this.buffer.append("\" width=\"");
            this.buffer.append(rectangle.width);
            this.buffer.append("\" height=\"");
            this.buffer.append(rectangle.height);
            this.buffer.append("\" />\n");
        }

        private void appendRelativeBounds(ModeImpl modeImpl) {
            Rectangle rectangle = modeImpl.getRelativeBounds();
            if (rectangle == null) {
                return;
            }
            this.buffer.append("        <relative-bounds x=\"");
            this.buffer.append(rectangle.x);
            this.buffer.append("\" y=\"");
            this.buffer.append(rectangle.y);
            this.buffer.append("\" width=\"");
            this.buffer.append(rectangle.width);
            this.buffer.append("\" height=\"");
            this.buffer.append(rectangle.height);
            this.buffer.append("\" />\n");
        }

        private void appendFrame(ModeImpl modeImpl) {
            this.buffer.append("        <frame type=\"");
            String string = modeImpl.getFrameType();
            if ("org.netbeans.core.windows.frames.TopFrameTypeImpl".equals(string)) {
                this.buffer.append("window");
            } else if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string)) {
                this.buffer.append("internal");
            } else if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(string)) {
                this.buffer.append("desktop");
            } else {
                this.buffer.append("dialog");
            }
            Object object = modeImpl.getConstraints();
            if (object != null) {
                this.buffer.append("\" constraints=\"");
                this.buffer.append(WindowUtils.convertConstraint2Xml((String)object));
            }
            this.buffer.append("\" state=\"");
            int n = modeImpl.getFrameState();
            if (0 == n) {
                this.buffer.append("normal");
            } else if (1 == n) {
                this.buffer.append("iconified");
            } else {
                this.buffer.append("maximized");
            }
            if (6 == n) {
                int n2 = modeImpl.getRestoredFrameState();
                this.buffer.append("\" restored-state=\"");
                if (0 == n2) {
                    this.buffer.append("normal");
                } else {
                    this.buffer.append("iconified");
                }
            }
            this.buffer.append("\" />\n");
        }

        private void appendRest(ModeImpl modeImpl) {
            URL uRL = modeImpl.getIconURL();
            if (uRL != null) {
                this.buffer.append("        <icon url=\"");
                this.buffer.append(uRL.toString());
                this.buffer.append("\" />\n");
            }
            this.buffer.append("        <other defined-by=\"");
            this.buffer.append(modeImpl.isUserDefined() ? "user" : "module");
            this.buffer.append("\" mode-state=\"");
            this.buffer.append(modeImpl.isHidden() ? "hidden" : "visible");
            this.buffer.append("\" />\n");
        }

        private void appendDominance(ModeImpl modeImpl) throws IOException {
            Object object;
            Object object2;
            Object object3;
            TopComponentContainer topComponentContainer;
            this.buffer.append("        <container type=\"");
            String string = modeImpl.getContainerType();
            if ("org.netbeans.core.windows.frames.SplitContainerImpl".equals(string)) {
                this.buffer.append("split");
            } else {
                this.buffer.append("tabbed");
            }
            Object object4 = null;
            Map map = modeImpl.getAreas();
            if (map != null) {
                object4 = new ArrayList(map.values());
            }
            if ((topComponentContainer = modeImpl.getContainerInstance()) != null) {
                object3 = topComponentContainer.getSelectedTopComponent();
                if (object3 != null) {
                    object2 = ((WindowManagerImpl)WindowManager.getDefault()).persistenceManager();
                    object = this.folder.getModeImpl();
                    String string2 = ((PersistenceManager)object2).lookupIdWithoutCreation((TopComponent)object3);
                    if (!((PersistenceManager)object2).isPersistent((TopComponent)object3, string2, ((ModeImpl)object).getWorkspace())) {
                        object3 = null;
                    } else {
                        try {
                            string2 = ((PersistenceManager)object2).lookupTCStringId((TopComponent)object3);
                        }
                        catch (NotSerializableException notSerializableException) {
                            object3 = null;
                        }
                    }
                }
                if (object3 != null) {
                    this.buffer.append("\" active-tc=\"");
                    this.buffer.append(XMLUtil.toAttributeValue((String)((WindowManagerImpl)WindowManager.getDefault()).lookupTCStringId((TopComponent)object3)));
                }
            }
            this.buffer.append("\" >\n");
            if ("org.netbeans.core.windows.frames.SplitContainerImpl".equals(string) && (topComponentContainer != null || object4 != null)) {
                List list = object3 = topComponentContainer != null ? topComponentContainer.getAreas() : null;
                if (object4 == null) {
                    object4 = object3;
                } else if (object3 != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (object4.contains(object)) continue;
                        object4.add(object);
                    }
                }
                if (object4 != null) {
                    object2 = null;
                    object = null;
                    boolean bl = modeImpl.isMaxMode();
                    String string3 = modeImpl.getFrameType();
                    Rectangle rectangle = null;
                    Rectangle rectangle2 = null;
                    if (bl && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string3)) {
                        rectangle = modeImpl.getBounds();
                        rectangle2 = modeImpl.getNormalBounds();
                    }
                    TopComponentContainer.Area area = null;
                    int n = 0;
                    while (n < object4.size()) {
                        area = (TopComponentContainer.Area)object4.get(n);
                        object2 = (String)area.getConstraint();
                        object = area.getBounds();
                        if (object != null) {
                            if (bl && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(string3)) {
                                float f = (float)rectangle2.width / (float)rectangle.width;
                                ((Rectangle)object).x = (int)((float)((Rectangle)object).x * f);
                                ((Rectangle)object).width = (int)((float)((Rectangle)object).width * f);
                                f = (float)rectangle2.height / (float)rectangle.height;
                                ((Rectangle)object).y = (int)((float)((Rectangle)object).y * f);
                                ((Rectangle)object).height = (int)((float)((Rectangle)object).height * f);
                            }
                            this.buffer.append("            <area constraint=\"");
                            object2 = WindowUtils.convertConstraint2Xml((String)object2);
                            this.buffer.append((String)object2);
                            this.buffer.append("\" x=\"" + ((Rectangle)object).x);
                            this.buffer.append("\" y=\"" + ((Rectangle)object).y);
                            this.buffer.append("\" width=\"" + ((Rectangle)object).width);
                            this.buffer.append("\" height=\"" + ((Rectangle)object).height);
                            this.buffer.append("\" />\n");
                        }
                        ++n;
                    }
                }
            }
            this.buffer.append("        </container>\n");
        }

        private Map obtainConstraintsBounds(ModeImpl modeImpl, TopComponentContainer topComponentContainer) {
            TopComponent[] topComponentArray = modeImpl.getOpenedTopComponents();
            HashMap<Object, Rectangle> hashMap = new HashMap<Object, Rectangle>(10);
            Object object = null;
            int n = 0;
            while (n < topComponentArray.length) {
                object = topComponentContainer.getConstraints(topComponentArray[n]);
                if (object == null) {
                    object = "CENTER";
                }
                if (hashMap.get(object) == null) {
                    hashMap.put(object, topComponentArray[n].getBounds());
                }
                ++n;
            }
            return hashMap;
        }

        private XMLReader getXMLParser() throws SAXException {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setEntityResolver(this);
            return xMLReader;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (ModeData.INSTANCE_DTD_ID_1_0.equals(string) || ModeData.INSTANCE_DTD_ID_1_1.equals(string) || ModeData.INSTANCE_DTD_ID_1_2.equals(string)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                return new InputSource(byteArrayInputStream);
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static final class CookiesImpl
    extends ICFolderImpl
    implements SaveCookie,
    LazyUpdater,
    DeferredPerformer.DeferredCommand,
    PropertyChangeListener {
        private InstanceCookie[] childrenCookies;
        private ModeImpl modeImpl;
        private PropertyHandler propertyHandler;
        ModeConfig mc;
        private int loadedSections;
        private int currLoadedSections;
        private PropertyChangeListener weakPropertyChangeL;
        private boolean visualUpdate = true;
        private ThreadLocal componentsUpdated;
        private final Object DATA_ID_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$TCRef;
        static /* synthetic */ Class class$org$netbeans$core$windows$ModeImpl;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ProducerCookie;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData$CookiesImpl;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        public CookiesImpl(DataFolder dataFolder, FileObject fileObject) {
            super(dataFolder, fileObject, class$org$netbeans$core$windows$layers$TCRef == null ? (class$org$netbeans$core$windows$layers$TCRef = CookiesImpl.class$("org.netbeans.core.windows.layers.TCRef")) : class$org$netbeans$core$windows$layers$TCRef);
            this.componentsUpdated = new ThreadLocal();
        }

        public String instanceName() {
            return (class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = CookiesImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl).getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = CookiesImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl;
        }

        protected void clean() {
            this.childrenCookies = null;
            if (this.modeImpl != null) {
                this.modeImpl.close();
                ((WorkspaceImpl)this.modeImpl.getWorkspace()).removeMode(this.modeImpl);
                this.modeImpl.attachUpdater(null);
                this.modeImpl = null;
            }
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz;
            if ((class$org$netbeans$core$windows$layers$TCRef == null ? (class$org$netbeans$core$windows$layers$TCRef = CookiesImpl.class$("org.netbeans.core.windows.layers.TCRef")) : class$org$netbeans$core$windows$layers$TCRef).isAssignableFrom(clazz = instanceCookie.instanceClass())) {
                return instanceCookie;
            }
            return null;
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            if (!(this.folder.isValid() && this.folder.getPrimaryFile().isValid() && ((ModeData)this.folder).getModeConfigFO().isValid() && this.folder.getPrimaryFile().getParent().isValid() && DataObject.find((FileObject)this.folder.getPrimaryFile().getParent()).getCookie(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = CookiesImpl.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie) != null)) {
                throw new InvalidDataException((Object)this.folder.getName());
            }
            ModeImpl modeImpl = this.obtainModeImpl();
            if (this.childrenCookies == null) {
                modeImpl.attachUpdater(this);
            }
            InstanceCookie[] instanceCookieArray2 = this.childrenCookies;
            if (this.underCurrentWS()) {
                Object object = this.DATA_ID_LOCK;
                synchronized (object) {
                    this.loadedSections |= 1;
                }
            }
            try {
                this.updateAll(instanceCookieArray2, instanceCookieArray, this.loadedSections);
                Object var7_6 = null;
                this.currLoadedSections = this.loadedSections;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.currLoadedSections = this.loadedSections;
                throw throwable;
            }
            return modeImpl;
        }

        public void resetComponents() {
            this.childrenCookies = null;
        }

        public void reset() {
            super.reset();
            this.modeImpl = null;
            this.loadedSections = 0;
            this.currLoadedSections = 0;
            this.childrenCookies = null;
        }

        private void deleteFiles(boolean bl) {
            WindowUtils.deleteOneFO(((ModeData)this.folder).getModeConfigFO());
            if (bl) {
                WindowUtils.deleteOneFO(this.folder.getPrimaryFile());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                ModuleInfo moduleInfo = (ModuleInfo)propertyChangeEvent.getSource();
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    if (this.modeImpl != null) {
                        this.modeImpl.setValidForSaving(false);
                    }
                    this.deleteFiles(false);
                }
            }
        }

        private void updateAll(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2, int n) throws IOException {
            if (CookiesImpl.simpleArrayCompare(instanceCookieArray, instanceCookieArray2)) {
                return;
            }
            this.componentsUpdated.set(Boolean.TRUE);
            this.updateProperties(instanceCookieArray, instanceCookieArray2, n);
            if (this.componentsUpdated.get() == Boolean.TRUE) {
                this.componentsUpdated.set(Boolean.FALSE);
                this.updateComponents(this.mc, instanceCookieArray, instanceCookieArray2, n);
            }
        }

        private static boolean simpleArrayCompare(Object[] objectArray, Object[] objectArray2) {
            if (objectArray == objectArray2) {
                return true;
            }
            if (objectArray == null || objectArray2 == null) {
                return false;
            }
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            int n = objectArray.length;
            while (--n >= 0) {
                if (objectArray[n] == objectArray2[n]) continue;
                if (objectArray[n] == null) {
                    return false;
                }
                if (objectArray[n].equals(objectArray2[n])) continue;
                return false;
            }
            return true;
        }

        protected void updateProperties() throws IOException {
            try {
                InstanceCookie[] instanceCookieArray = this.childrenCookies;
                this.childrenCookies = this.createCookies();
                this.updateProperties(instanceCookieArray, this.childrenCookies, 1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                IOException iOException = new IOException();
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)classNotFoundException);
            }
        }

        protected Object getDataLock() {
            return this.DATA_ID_LOCK;
        }

        private void updateProperties(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2, int n) throws IOException {
            if ((n & 1) != 0) {
                this.mc = this.readProperties();
                if (this.mc == null) {
                    return;
                }
                if (this.mc.moduleCodeNameBase != null) {
                    ModuleInfo moduleInfo = WindowUtils.findModule(this.mc.moduleCodeNameBase, this.mc.moduleCodeNameRelease, this.mc.moduleSpecificationVersion);
                    if (moduleInfo != null && moduleInfo.isEnabled()) {
                        if (this.weakPropertyChangeL == null) {
                            this.weakPropertyChangeL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)moduleInfo);
                            moduleInfo.addPropertyChangeListener(this.weakPropertyChangeL);
                        }
                    } else {
                        this.deleteFiles(false);
                        return;
                    }
                }
                if (this.setProps2Mode(this.mc) && this.underCurrentWS()) {
                    boolean bl = (this.loadedSections & 2) == 2;
                    this.componentsUpdated.set(bl ? Boolean.TRUE : Boolean.FALSE);
                    this.loadDataSection(2, this.mc, instanceCookieArray, instanceCookieArray2);
                }
            } else {
                this.childrenCookies = instanceCookieArray;
                return;
            }
        }

        private boolean underCurrentWS() throws IOException {
            FileObject fileObject = this.folder.getPrimaryFile();
            ProducerCookie producerCookie = (ProducerCookie)DataObject.find((FileObject)fileObject.getParent()).getCookie(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = CookiesImpl.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie);
            Workspace workspace = (Workspace)producerCookie.getProduct();
            return WindowManager.getDefault().getCurrentWorkspace().equals(workspace);
        }

        private ModeConfig readProperties() throws IOException {
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((ModeData)this.folder);
            }
            ModeConfig modeConfig = null;
            try {
                modeConfig = this.propertyHandler.readData();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = CookiesImpl.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_ModeParse"), this.folder.getName());
                IOException iOException = new IOException(string);
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)sAXException);
                throw iOException;
            }
            return modeConfig;
        }

        private void updateComponentIds() throws IOException {
            ModeImpl modeImpl = this.obtainModeImpl();
            FileObject fileObject = this.folder.getPrimaryFile();
            FileObject[] fileObjectArray = fileObject.getChildren();
            String[] stringArray = new String[fileObjectArray.length];
            int n = 0;
            while (n < fileObjectArray.length) {
                stringArray[n] = fileObjectArray[n].getName();
                ++n;
            }
            modeImpl.setTopComponentIds(stringArray);
        }

        private boolean setProps2Mode(ModeConfig modeConfig) throws IOException {
            if (modeConfig.invalid) {
                return false;
            }
            boolean bl = false;
            ModeImpl modeImpl = this.obtainModeImpl();
            if (modeConfig.displayName != null) {
                modeImpl.setDisplayName(modeConfig.displayName);
            }
            if (modeConfig.description != null) {
                modeImpl.setDescriptionXML(modeConfig.description);
            }
            if (modeConfig.descriptionBundle != null) {
                modeImpl.setDescriptionBundle(modeConfig.descriptionBundle);
            }
            if (modeConfig.frameType != null) {
                WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
                int n = windowManagerImpl.uiModeManager().getUIMode();
                boolean bl2 = n != windowManagerImpl.getSavedUIMode();
                String string = modeConfig.frameType;
                if (bl2) {
                    string = WindowUtils.convertFrameType(n, modeConfig.constraints);
                }
                if (!string.equals(modeConfig.frameType)) {
                    modeImpl.restoreFrameType(modeConfig.frameType, string);
                } else {
                    modeImpl.setFrameType(string);
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                CookiesImpl.doSetBounds(modeConfig, modeImpl);
            } else {
                SwingUtilities.invokeLater(new Runnable(this, modeConfig, modeImpl){
                    private final /* synthetic */ ModeConfig val$mc;
                    private final /* synthetic */ ModeImpl val$mi;
                    private final /* synthetic */ CookiesImpl this$0;
                    {
                        this.this$0 = cookiesImpl;
                        this.val$mc = modeConfig;
                        this.val$mi = modeImpl;
                    }

                    public void run() {
                        CookiesImpl.access$000(this.val$mc, this.val$mi);
                    }
                });
            }
            if (modeConfig.containerType != null) {
                modeImpl.setContainerType(modeConfig.containerType);
            }
            if (modeConfig.constraints != null) {
                WindowUtils.changeModeConstraints(modeImpl, modeConfig.constraints, modeConfig.modeState == 0);
            }
            if (modeConfig.iconURL != null) {
                modeImpl.setIconURL(modeConfig.iconURL);
            }
            if (modeConfig.frameState >= 0) {
                modeImpl.setFrameState(modeConfig.frameState);
                if (modeConfig.frameState == 6) {
                    // empty if block
                }
            }
            if (modeConfig.userDefined >= 0) {
                modeImpl.setUserDefined(modeConfig.userDefined > 0);
            }
            if (modeConfig.fromBundle >= 0) {
                modeImpl.setNameFromBundle(modeConfig.fromBundle > 0);
                if (modeConfig.fromBundle > 0) {
                    modeImpl.setNameBundle(modeConfig.nameBundle);
                }
            }
            if (modeConfig.modeState >= 0 && modeImpl.isHidden() != (modeConfig.modeState == 0)) {
                modeImpl.setHidden(modeConfig.modeState == 0);
                if ((modeConfig.modeState != 0 || modeImpl.isVisible()) && (this.loadedSections & 2) == 0) {
                    bl = true;
                }
            }
            return bl;
        }

        private static void doSetBounds(ModeConfig modeConfig, ModeImpl modeImpl) {
            Rectangle rectangle = modeConfig.relativeBounds;
            if (rectangle != null) {
                modeImpl.setRelativeBounds(rectangle);
            } else {
                rectangle = modeConfig.bounds;
                if (rectangle != null) {
                    modeImpl.setNormalBounds(rectangle);
                }
            }
        }

        private void updateComponents(ModeConfig modeConfig, InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2, int n) throws IOException {
            if ((n & 2) == 0) {
                this.childrenCookies = instanceCookieArray;
                return;
            }
            if (instanceCookieArray2 == null || modeConfig == null || modeConfig.invalid) {
                this.childrenCookies = instanceCookieArray;
                return;
            }
            if (modeConfig.dominance != null && this.isVisualUpdate()) {
                this.setAreaBounds(modeConfig);
            }
            Set[] setArray = CookiesImpl.computeSets(instanceCookieArray, instanceCookieArray2);
            if (this.isVisualUpdate()) {
                this.removeComponents(setArray[0]);
            }
            Map map = this.createTCRefs(instanceCookieArray2);
            if (this.isVisualUpdate()) {
                Object object;
                if (setArray[1].size() > 0) {
                    object = this.addComponents(setArray[1], instanceCookieArray2, map);
                    this.reorderComps((List)object);
                }
                this.setDominance(instanceCookieArray2);
                if (modeConfig.activeTc != null && WindowManagerImpl.isProjectOpen()) {
                    object = (WindowManagerImpl)WindowManager.getDefault();
                    WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(null, true));
                }
            }
        }

        public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
            try {
                if (this.mc == null || this.mc.invalid || this.mc.activeTc == null) {
                    return;
                }
                ModeImpl modeImpl = this.obtainModeImpl();
                if (!modeImpl.isVisible()) {
                    return;
                }
                TopComponentContainer topComponentContainer = modeImpl.getContainerInstance();
                TopComponent topComponent = ((WindowManagerImpl)WindowManager.getDefault()).lookupTCInstance(this.mc.activeTc);
                if (topComponent != null && topComponentContainer != null && topComponentContainer.containsTopComponent(topComponent)) {
                    topComponentContainer.setSelectedTopComponent(topComponent);
                } else {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    if (topComponent == null) {
                        errorManager.log(16, "Core, window system warning: Cannot find component with ID " + this.mc.activeTc + " for activation!");
                    } else {
                        errorManager.log(16, "Core, window system warning: cannot set component with ID " + this.mc.activeTc + " as active in mode " + modeImpl.getName() + ", component not present!");
                    }
                }
            }
            catch (SafeException safeException) {
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify(1, (Throwable)iOException);
            }
        }

        private void setDominance(InstanceCookie[] instanceCookieArray) throws IOException {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = null;
            int n = 0;
            while (n < instanceCookieArray.length) {
                try {
                    TCRef tCRef = (TCRef)instanceCookieArray[n].instanceCreate();
                    Object object2 = ((TCRefImpl)tCRef).getConstraint();
                    if (object2 != null && !object2.equals(object)) {
                        object = object2;
                        arrayList.add(object2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    ((WindowManagerImpl)WindowManager.getDefault()).annotatePersistenceError(classNotFoundException, "");
                }
                ++n;
            }
            ModeImpl modeImpl = this.obtainModeImpl();
            TopComponentContainer topComponentContainer = modeImpl.getContainerInstance();
            if (topComponentContainer != null) {
                topComponentContainer.setConstraintsOrder(arrayList);
            }
        }

        private void removeComponents(Set set) throws IOException {
            ModeImpl modeImpl = this.obtainModeImpl();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    TCRef tCRef = (TCRef)((InstanceCookie)iterator.next()).instanceCreate();
                    if (EventQueue.isDispatchThread()) {
                        try {
                            TopComponent topComponent = tCRef.getTopComponent();
                            modeImpl.release(topComponent);
                        }
                        catch (SafeException safeException) {
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        continue;
                    }
                    EventQueue.invokeLater(new Runnable(this, tCRef, modeImpl){
                        private final /* synthetic */ TCRef val$curRef;
                        private final /* synthetic */ ModeImpl val$mi;
                        private final /* synthetic */ CookiesImpl this$0;
                        {
                            this.this$0 = cookiesImpl;
                            this.val$curRef = tCRef;
                            this.val$mi = modeImpl;
                        }

                        public void run() {
                            try {
                                TopComponent topComponent = this.val$curRef.getTopComponent();
                                this.val$mi.release(topComponent);
                            }
                            catch (SafeException safeException) {
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                            }
                        }
                    });
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    ((WindowManagerImpl)WindowManager.getDefault()).annotatePersistenceError(classNotFoundException, "");
                }
            }
        }

        private Map createTCRefs(InstanceCookie[] instanceCookieArray) {
            HashMap<InstanceCookie, TCRef> hashMap = new HashMap<InstanceCookie, TCRef>(instanceCookieArray.length * 2);
            int n = 0;
            while (n < instanceCookieArray.length) {
                try {
                    TCRef tCRef = (TCRef)instanceCookieArray[n].instanceCreate();
                    hashMap.put(instanceCookieArray[n], tCRef);
                }
                catch (IOException iOException) {
                    this.notifyTCCreationFailure(iOException, instanceCookieArray[n]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.notifyTCCreationFailure(classNotFoundException, instanceCookieArray[n]);
                }
                ++n;
            }
            return hashMap;
        }

        /*
         * Unable to fully structure code
         */
        private List addComponents(Set var1_1, InstanceCookie[] var2_2, Map var3_3) throws IOException {
            var5_4 = new ArrayList<TCRef>(var1_1.size());
            var6_5 = 0;
            while (var6_5 < var2_2.length) {
                block9: {
                    var4_6 = (TCRef)var3_3.get(var2_2[var6_5]);
                    if (var1_1.contains(var2_2[var6_5]) && var4_6 != null) {
                        block10: {
                            try {
                                var4_6.updateMode();
                                ((TCRefImpl)var4_6).setOrderWeight(10 * (var6_5 + 1));
                                var5_4.add(var4_6);
                                break block9;
                            }
                            catch (SafeException var7_7) {
                                var4_6.destroy();
                                break block9;
                            }
                            catch (IOException var8_8) {
                                var9_9 = ErrorManager.getDefault();
                                var10_10 = var9_9.findAnnotations((Throwable)var8_8);
                                var11_11 = true;
                                if (var10_10.length <= 0) break block10;
                                var12_13 = 0;
                                ** while (var12_13 < var10_10.length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                var13_14 = var10_10[var12_13].getStackTrace();
                                if (var13_14 != null && var13_14 instanceof DataObjectNotFoundException) {
                                    var11_11 = false;
                                    break;
                                }
                                ++var12_13;
                                continue;
                            }
                        }
                        var12_12 = NbBundle.getMessage((Class)(CookiesImpl.class$org$netbeans$core$windows$layers$ModeData$CookiesImpl == null ? CookiesImpl.class$("org.netbeans.core.windows.layers.ModeData$CookiesImpl") : CookiesImpl.class$org$netbeans$core$windows$layers$ModeData$CookiesImpl), (String)"EXC_LoadTCRef", (Object[])new Object[]{var4_6, var8_8.getMessage()});
                        var4_6.destroy();
                        var9_9.annotate((Throwable)var8_8, var12_12);
                        if (var11_11) {
                            var9_9.notify(4096, (Throwable)var8_8);
                        } else {
                            var9_9.notify(1, (Throwable)var8_8);
                        }
                    }
                }
                ++var6_5;
            }
            return var5_4;
        }

        private void reorderComps(List list) throws IOException {
            List list2 = this.updateCompOrder(list);
            ModeImpl modeImpl = this.obtainModeImpl();
            TopComponentContainer topComponentContainer = modeImpl.getContainerInstance();
            if (topComponentContainer != null) {
                WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
                WindowManagerImpl.deferredPerformer().putRequest(new DeferredPerformer.DeferredCommand(this, topComponentContainer, list2){
                    private final /* synthetic */ TopComponentContainer val$tcc;
                    private final /* synthetic */ List val$orderedTcs;
                    private final /* synthetic */ CookiesImpl this$0;
                    {
                        this.this$0 = cookiesImpl;
                        this.val$tcc = topComponentContainer;
                        this.val$orderedTcs = list;
                    }

                    public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
                        this.val$tcc.reorder(this.val$orderedTcs);
                    }
                }, new DeferredPerformer.DeferredContext(null, true));
            }
        }

        private final void notifyTCCreationFailure(Exception exception, InstanceCookie instanceCookie) {
            String string = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_CreateTCRef"), instanceCookie);
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)exception, string);
            errorManager.notify(16, (Throwable)exception);
        }

        private static Set[] computeSets(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) {
            Set[] setArray = new Set[]{new HashSet(), new HashSet()};
            CookiesImpl.fillSet(setArray[0], instanceCookieArray);
            CookiesImpl.fillSet(setArray[1], instanceCookieArray2);
            Set set = (Set)((HashSet)setArray[0]).clone();
            setArray[0].removeAll(setArray[1]);
            setArray[1].removeAll(set);
            return setArray;
        }

        private static void fillSet(Set set, Object[] objectArray) {
            if (objectArray == null) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                set.add(objectArray[n]);
                ++n;
            }
        }

        private void setAreaBounds(ModeConfig modeConfig) throws IOException {
            ModeImpl modeImpl = this.obtainModeImpl();
            TopComponentContainer topComponentContainer = modeImpl.getContainerInstance();
            HashMap<String, TopComponentContainer.Area> hashMap = new HashMap<String, TopComponentContainer.Area>(20);
            Iterator iterator = ((AbstractList)modeConfig.dominance).iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle;
                TopComponentContainer.Area area;
                DominanceEntry dominanceEntry = (DominanceEntry)iterator.next();
                if (topComponentContainer != null) {
                    area = topComponentContainer.getArea(dominanceEntry.constraint);
                    if (area == null) {
                        area = new TCCTabbedAreaImpl(dominanceEntry.constraint);
                        hashMap.put(dominanceEntry.constraint, area);
                    }
                } else {
                    area = new TCCTabbedAreaImpl(dominanceEntry.constraint);
                    hashMap.put(dominanceEntry.constraint, area);
                }
                if (dominanceEntry.relBounds != null) {
                    if (modeImpl.isBoundsSet()) {
                        Rectangle rectangle2 = modeImpl.getBounds();
                        rectangle = new Rectangle();
                        rectangle.x = dominanceEntry.relBounds.x * rectangle2.width / 100;
                        rectangle.y = dominanceEntry.relBounds.y * rectangle2.height / 100;
                        rectangle.width = dominanceEntry.relBounds.width * rectangle2.width / 100;
                        rectangle.height = dominanceEntry.relBounds.height * rectangle2.height / 100;
                        this.convert2Maximized(rectangle, modeConfig);
                        area.setBounds(rectangle);
                        continue;
                    }
                    area.setRelativeBounds(dominanceEntry.relBounds);
                    continue;
                }
                if (dominanceEntry.absBounds == null) continue;
                rectangle = new Rectangle(dominanceEntry.absBounds);
                this.convert2Maximized(rectangle, modeConfig);
                area.setBounds(rectangle);
            }
            modeImpl.setAreas(hashMap);
        }

        private void convert2Maximized(Rectangle rectangle, ModeConfig modeConfig) throws IOException {
            ModeImpl modeImpl = this.obtainModeImpl();
            WorkspaceImpl workspaceImpl = (WorkspaceImpl)modeImpl.getWorkspace();
            if (!workspaceImpl.getWasMaxMode() || !"org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(modeImpl.getFrameType())) {
                return;
            }
            if (modeConfig.maximizedBounds == null) {
                return;
            }
            float f = (float)modeConfig.maximizedBounds.width / (float)modeConfig.bounds.width;
            rectangle.x = (int)((float)rectangle.x * f);
            rectangle.width = (int)((float)rectangle.width * f);
            f = (float)modeConfig.maximizedBounds.height / (float)modeConfig.bounds.height;
            rectangle.y = (int)((float)rectangle.y * f);
            rectangle.height = (int)((float)rectangle.height * f);
        }

        private List updateCompOrder(List list) throws IOException {
            TCRef tCRef = null;
            ArrayList<TCRef> arrayList = new ArrayList<TCRef>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                tCRef = (TCRef)iterator.next();
                if (!tCRef.isOpened()) continue;
                arrayList.add(tCRef);
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        ModeImpl obtainModeImpl() throws IOException {
            if (this.modeImpl == null) {
                FileObject fileObject = this.folder.getPrimaryFile();
                ProducerCookie producerCookie = (ProducerCookie)DataObject.find((FileObject)fileObject.getParent()).getCookie(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = CookiesImpl.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie);
                Workspace workspace = (Workspace)producerCookie.getProduct();
                if (workspace == null) {
                    String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = CookiesImpl.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_NoWorkspace"), fileObject.getName());
                    throw new IOException(string);
                }
                this.modeImpl = (ModeImpl)workspace.createMode(WindowUtils.unescape(fileObject.getName()), null, null);
            }
            return this.modeImpl;
        }

        public void save() throws IOException {
            if (this.mc != null && this.mc.invalid) {
                return;
            }
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((ModeData)this.folder);
            }
            this.propertyHandler.writeData();
            this.saveComponents();
            this.removeUnusedComponents();
            DataObject[] dataObjectArray = this.folder.getChildren();
            CookiesImpl.validate(dataObjectArray);
            DataObject[] dataObjectArray2 = this.sortTCRefData(this.obtainModeImpl().getLoadedTopComponents(), dataObjectArray);
            CookiesImpl.validate(dataObjectArray2);
            this.folder.setOrder(dataObjectArray2);
            try {
                try {
                    this.setVisualUpdate(false);
                    InstanceCookie[] instanceCookieArray = this.childrenCookies;
                    this.childrenCookies = this.createCookies();
                    this.updateComponents(this.mc, instanceCookieArray, this.childrenCookies, 2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.childrenCookies = null;
                    FoldingIOException foldingIOException = new FoldingIOException((Throwable)classNotFoundException);
                    ErrorManager.getDefault().annotate((Throwable)classNotFoundException, (Throwable)foldingIOException);
                    throw foldingIOException;
                }
                Object var6_5 = null;
                this.setVisualUpdate(true);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setVisualUpdate(true);
                throw throwable;
            }
        }

        private void setVisualUpdate(boolean bl) {
            this.visualUpdate = bl;
        }

        private boolean isVisualUpdate() {
            return this.visualUpdate;
        }

        private void saveComponents() throws IOException {
            ModeImpl modeImpl = this.obtainModeImpl();
            TopComponent[] topComponentArray = modeImpl.getLoadedTopComponents();
            FileObject fileObject = this.folder.getPrimaryFile();
            String string = null;
            FileObject fileObject2 = null;
            SaveCookie saveCookie = null;
            PersistenceManager persistenceManager = ((WindowManagerImpl)WindowManager.getDefault()).persistenceManager();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < topComponentArray.length) {
                block11: {
                    string = persistenceManager.lookupIdWithoutCreation(topComponentArray[n]);
                    if (!persistenceManager.isPersistent(topComponentArray[n], string, modeImpl.getWorkspace())) {
                        if (string != null) {
                            this.deleteTcRef(string);
                        }
                    } else {
                        try {
                            string = persistenceManager.lookupTCStringId(topComponentArray[n]);
                        }
                        catch (NotSerializableException notSerializableException) {
                            if (string != null) {
                                this.deleteTcRef(string);
                            }
                            break block11;
                        }
                        stringBuffer.replace(0, stringBuffer.length(), string);
                        stringBuffer.append('.');
                        stringBuffer.append("wstcref");
                        fileObject2 = FileUtil.createData((FileObject)fileObject, (String)stringBuffer.toString());
                        saveCookie = (SaveCookie)DataObject.find((FileObject)fileObject2).getCookie(class$org$openide$cookies$SaveCookie == null ? CookiesImpl.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                        if (saveCookie != null) {
                            try {
                                saveCookie.save();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().log(4096, "WinSys - ModeData.saveComponents: Saving of " + fileObject2 + " failed.");
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        } else {
                            ErrorManager.getDefault().log(4096, "WinSys - ModeData.saveComponents: No save cookie for file obj " + fileObject2);
                            Thread.dumpStack();
                            this.deleteTcRef(string);
                        }
                    }
                }
                ++n;
            }
        }

        private void removeUnusedComponents() throws IOException {
            ModeImpl modeImpl = this.obtainModeImpl();
            Set set = modeImpl.getRemovedComps();
            if (set != null) {
                String string = null;
                PersistenceManager persistenceManager = ((WindowManagerImpl)WindowManager.getDefault()).persistenceManager();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = persistenceManager.lookupIdWithoutCreation((TopComponent)iterator.next());
                    if (string == null) continue;
                    this.deleteTcRef(string);
                }
                modeImpl.clearRemovedComps();
            }
        }

        private void deleteTcRef(String string) throws IOException {
            FileObject fileObject = this.folder.getPrimaryFile().getFileObject(string, "wstcref");
            if (fileObject != null) {
                FileLock fileLock = fileObject.lock();
                fileObject.delete(fileLock);
                fileLock.releaseLock();
            }
        }

        private static void validate(DataObject[] dataObjectArray) {
            if (dataObjectArray == null) {
                throw new IllegalArgumentException();
            }
            int n = 0;
            while (n < dataObjectArray.length) {
                if (dataObjectArray[n] == null) {
                    throw new IllegalArgumentException();
                }
                ++n;
            }
        }

        public int getLoadedSections() {
            return this.currLoadedSections;
        }

        public int disposeDataSection(int n) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                this.loadedSections &= ~n;
            }
            throw new UnsupportedOperationException();
        }

        public int loadDataSection(int n) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (n == (this.loadedSections & n)) {
                    int n2 = this.loadedSections;
                    return n2;
                }
                if ((n & 2) != 0) {
                    n |= 1;
                }
                this.loadedSections |= n;
                if ((n & 4) != 0) {
                    this.updateComponentIds();
                }
                try {
                    try {
                        InstanceCookie[] instanceCookieArray = this.childrenCookies;
                        this.childrenCookies = this.createCookies();
                        this.updateAll(instanceCookieArray, this.childrenCookies, n);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        IOException iOException = new IOException();
                        throw (IOException)ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)classNotFoundException);
                    }
                    Object var6_7 = null;
                    this.currLoadedSections = this.loadedSections;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.currLoadedSections = this.loadedSections;
                    throw throwable;
                }
                int n3 = this.loadedSections;
                return n3;
            }
        }

        private int loadDataSection(int n, ModeConfig modeConfig, InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (n == (this.loadedSections & n)) {
                    int n2 = this.loadedSections;
                    return n2;
                }
                this.loadedSections |= n;
                try {
                    this.updateComponents(modeConfig, instanceCookieArray, instanceCookieArray2, n);
                    Object var8_7 = null;
                    this.currLoadedSections = this.loadedSections;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.currLoadedSections = this.loadedSections;
                    throw throwable;
                }
                int n3 = this.loadedSections;
                return n3;
            }
        }

        private DataObject[] sortTCRefData(TopComponent[] topComponentArray, DataObject[] dataObjectArray) throws IOException {
            if (topComponentArray.length != dataObjectArray.length) {
                return dataObjectArray;
            }
            if (dataObjectArray.length <= 1) {
                return dataObjectArray;
            }
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
            WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
            int n = 0;
            while (n < topComponentArray.length) {
                block7: {
                    String string;
                    try {
                        string = windowManagerImpl.lookupTCStringId(topComponentArray[n]);
                    }
                    catch (NotSerializableException notSerializableException) {
                        break block7;
                    }
                    int n2 = 0;
                    while (n2 < dataObjectArray.length) {
                        if (dataObjectArray[n2].getName().equals(string)) {
                            arrayList.add(dataObjectArray[n2]);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return arrayList.toArray(new DataObject[0]);
        }

        public void destroy() throws IOException {
            this.deleteFiles(true);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ void access$000(ModeConfig modeConfig, ModeImpl modeImpl) {
            CookiesImpl.doSetBounds(modeConfig, modeImpl);
        }
    }

    private static final class DominanceEntry {
        public String constraint;
        public int percSize;
        public Rectangle absBounds;
        public Rectangle relBounds;

        private DominanceEntry() {
        }
    }

    private static final class ModeConfig {
        public String name;
        public String displayName;
        public String frameType;
        public String containerType;
        public String constraints;
        public String activeTc;
        public String nameBundle;
        public String moduleCodeNameBase;
        public String moduleCodeNameRelease;
        public String moduleSpecificationVersion;
        public String description;
        public String descriptionBundle;
        public int userDefined;
        public int fromBundle;
        public int modeState;
        public int frameState;
        public int restoredFrameState;
        public Rectangle bounds;
        public Rectangle maximizedBounds;
        public Rectangle relativeBounds;
        public ArrayList dominance;
        public URL iconURL;
        public boolean invalid;

        private ModeConfig() {
        }

        public void clear() {
            this.bounds = null;
            this.maximizedBounds = null;
            this.relativeBounds = null;
            this.dominance = null;
        }
    }
}

