/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.WindowManagerData;
import org.netbeans.core.windows.layers.WorkspaceData;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WindowManagerData
extends DataFolder
implements CookieSet.Factory {
    private static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Window Manager Properties 1.0//EN";
    private static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Window Manager Properties 1.1//EN";
    private FileObject windowmanagerConfigFO;
    private InstanceCookieImpl instCookieImpl;
    private static Object SAVING = new Object();
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$WindowManagerData;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;

    public WindowManagerData(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.initCookies();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$layers$WindowManagerData == null ? (class$org$netbeans$core$windows$layers$WindowManagerData = WindowManagerData.class$("org.netbeans.core.windows.layers.WindowManagerData")) : class$org$netbeans$core$windows$layers$WindowManagerData);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    private void initCookies() {
        this.getCookieSet().add(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WindowManagerData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WindowManagerData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WindowManagerData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie, (CookieSet.Factory)this);
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        return cookie;
    }

    WindowManagerImpl getWindowManagerImpl() throws IOException {
        return this.instanceCookieImpl().obtainWindowManagerImpl();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz == (class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WindowManagerData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) || clazz == (class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WindowManagerData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) || clazz == (class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WindowManagerData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie)) {
            return this.instanceCookieImpl();
        }
        return null;
    }

    private synchronized InstanceCookieImpl instanceCookieImpl() {
        if (this.instCookieImpl != null) {
            return this.instCookieImpl;
        }
        this.instCookieImpl = new InstanceCookieImpl(this);
        return this.instCookieImpl;
    }

    FileObject getWindowManagerConfigFO() {
        if (this.windowmanagerConfigFO == null) {
            FileObject fileObject = null;
            Iterator iterator = this.files().iterator();
            while (iterator.hasNext()) {
                fileObject = (FileObject)iterator.next();
                if (!fileObject.hasExt("wswmgr")) continue;
                this.windowmanagerConfigFO = fileObject;
                break;
            }
        }
        return this.windowmanagerConfigFO;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class PropertyHandler
    extends DefaultHandler
    implements FileSystem.AtomicAction {
        private WindowManagerData folder;
        private FileObject fo;
        private WindowManagerConfig winMgrConfig;
        private XMLReader parser;
        private StringBuffer buffer;
        private final Object RW_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WindowManagerData;

        public PropertyHandler(WindowManagerData windowManagerData) {
            this.folder = windowManagerData;
            this.fo = windowManagerData.getWindowManagerConfigFO();
        }

        public WindowManagerConfig readData() throws SAXException, IOException {
            this.winMgrConfig = new WindowManagerConfig();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.getXMLParser().parse(new InputSource(this.fo.getInputStream()));
            }
            return this.winMgrConfig;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("main-window".equals(string3)) {
                this.handleMainWindow(attributes);
            } else if ("screen".equals(string3)) {
                this.handleScreen(attributes);
            } else if ("ui-mode".equals(string3)) {
                this.handleUIMode(attributes);
            } else if ("active".equals(string3)) {
                this.handleActive(attributes);
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        private void handleMainWindow(Attributes attributes) {
            if (this.winMgrConfig.mainWindowBounds == null) {
                this.winMgrConfig.mainWindowBounds = Utilities.getUsableScreenBounds();
            }
            try {
                String string = attributes.getValue("x");
                if ("center".equals(string)) {
                    this.winMgrConfig.centerMainWindowX = true;
                } else {
                    this.winMgrConfig.mainWindowBounds.x = Integer.parseInt(string);
                }
                string = attributes.getValue("y");
                if ("center".equals(string)) {
                    this.winMgrConfig.centerMainWindowY = true;
                } else {
                    this.winMgrConfig.mainWindowBounds.y = Integer.parseInt(string);
                }
                string = attributes.getValue("maximized");
                this.winMgrConfig.maximizedMainWindow = "true".equals(string);
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                Dimension dimension = Utilities.getUsableScreenBounds().getSize();
                string = attributes.getValue("relative-width");
                if (string != null) {
                    n = !WindowUtils.isMdi() ? 100 : Integer.parseInt(string);
                    n3 = (int)((double)(n * dimension.width) / 100.0);
                } else {
                    string = attributes.getValue("width");
                    n3 = Integer.parseInt(string);
                }
                string = attributes.getValue("relative-height");
                if (string != null) {
                    n2 = Integer.parseInt(string);
                    n4 = (int)((double)(n2 * dimension.height) / 100.0);
                } else {
                    string = attributes.getValue("height");
                    n4 = Integer.parseInt(string);
                }
                this.winMgrConfig.mainWindowBounds.width = n3;
                this.winMgrConfig.mainWindowBounds.height = n4;
                string = attributes.getValue("maximize-if-height-bellow");
                this.winMgrConfig.minHeight = string != null ? Integer.parseInt(string) : 0;
                string = attributes.getValue("maximize-if-width-bellow");
                this.winMgrConfig.minWidth = string != null ? Integer.parseInt(string) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                this.winMgrConfig.mainWindowBounds = null;
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WindowManagerData == null ? (class$org$netbeans$core$windows$layers$WindowManagerData = PropertyHandler.class$("org.netbeans.core.windows.layers.WindowManagerData")) : class$org$netbeans$core$windows$layers$WindowManagerData)).getString("EXC_WindowManagerBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
        }

        private void handleScreen(Attributes attributes) {
            if (this.winMgrConfig.screenSize == null) {
                this.winMgrConfig.screenSize = new Dimension();
            }
            try {
                this.winMgrConfig.screenSize.width = Integer.parseInt(attributes.getValue("width"));
                this.winMgrConfig.screenSize.height = Integer.parseInt(attributes.getValue("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.winMgrConfig.screenSize = null;
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WindowManagerData == null ? (class$org$netbeans$core$windows$layers$WindowManagerData = PropertyHandler.class$("org.netbeans.core.windows.layers.WindowManagerData")) : class$org$netbeans$core$windows$layers$WindowManagerData)).getString("EXC_WindowManagerScreenSize"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)numberFormatException, string);
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
        }

        private void handleUIMode(Attributes attributes) {
            String string = attributes.getValue("ui");
            this.winMgrConfig.uiMode = "mdi".equals(string) ? 2 : 1;
        }

        private void handleActive(Attributes attributes) {
            this.winMgrConfig.activeWorkspace = attributes.getValue("workspace");
        }

        public void endDocument() throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void writeData() throws IOException {
            this.fillBuffer();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.fo.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            }
        }

        private void fillBuffer() throws IOException {
            WindowManagerImpl windowManagerImpl = this.folder.getWindowManagerImpl();
            this.buffer = new StringBuffer(800);
            Object var2_2 = null;
            this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            this.buffer.append("<windowmanager version=\"1.0\">\n");
            this.appendMainWindow(windowManagerImpl);
            this.appendScreen(windowManagerImpl);
            this.appendUIMode(windowManagerImpl);
            this.appendActiveWorkspace(windowManagerImpl);
            this.buffer.append("</windowmanager>\n");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            FileLock fileLock;
            block3: {
                fileLock = this.fo.lock();
                OutputStreamWriter outputStreamWriter = null;
                try {
                    OutputStream outputStream = this.fo.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(this.buffer.toString());
                    Object var5_4 = null;
                    this.buffer = null;
                    if (outputStreamWriter == null) break block3;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.buffer = null;
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    fileLock.releaseLock();
                    throw throwable;
                }
                outputStreamWriter.close();
            }
            fileLock.releaseLock();
        }

        private void appendMainWindow(WindowManagerImpl windowManagerImpl) {
            MainWindow mainWindow = WindowManagerImpl.mainWindow();
            Rectangle rectangle = mainWindow.getBounds();
            boolean bl = false;
            if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
                try {
                    Method method = mainWindow.getClass().getMethod("getExtendedState", new Class[0]);
                    Integer n = (Integer)method.invoke((Object)mainWindow, new Object[0]);
                    bl = (n & 6) == 6;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
            this.buffer.append("    <main-window");
            this.buffer.append(" x=\"");
            this.buffer.append(rectangle.x);
            this.buffer.append("\" y=\"");
            this.buffer.append(rectangle.y);
            this.buffer.append("\" width=\"");
            this.buffer.append(rectangle.width);
            this.buffer.append("\" height=\"");
            this.buffer.append(rectangle.height);
            this.buffer.append("\" maximized=\"");
            this.buffer.append(bl ? "true" : "false");
            this.buffer.append("\" />\n");
        }

        private void appendScreen(WindowManagerImpl windowManagerImpl) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.buffer.append("    <screen");
            this.buffer.append(" width=\"");
            this.buffer.append(dimension.width);
            this.buffer.append("\" height=\"");
            this.buffer.append(dimension.height);
            this.buffer.append("\" />\n");
        }

        private void appendUIMode(WindowManagerImpl windowManagerImpl) {
            int n = windowManagerImpl.uiModeManager().getUIMode();
            this.buffer.append("    <ui-mode");
            this.buffer.append(" ui=\"");
            if (n == 2) {
                this.buffer.append("mdi");
            } else {
                this.buffer.append("sdi");
            }
            this.buffer.append("\" />\n");
        }

        private void appendActiveWorkspace(WindowManagerImpl windowManagerImpl) {
            Workspace workspace = windowManagerImpl.getCurrentWorkspace();
            this.buffer.append("    <active");
            this.buffer.append(" workspace=\"");
            if (workspace != null) {
                this.buffer.append(workspace.getName());
            }
            this.buffer.append("\" />\n");
        }

        private XMLReader getXMLParser() throws SAXException {
            if (this.parser == null) {
                this.parser = XMLUtil.createXMLReader();
                this.parser.setContentHandler(this);
                this.parser.setErrorHandler(this);
                this.parser.setEntityResolver(this);
            }
            return this.parser;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (WindowManagerData.INSTANCE_DTD_ID_1_0.equals(string) || WindowManagerData.INSTANCE_DTD_ID_1_1.equals(string)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                return new InputSource(byteArrayInputStream);
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static final class InstanceCookieImpl
    extends ICFolderImpl
    implements SaveCookie,
    LazyUpdater,
    FileSystem.AtomicAction {
        InstanceCookie[] childrenCookies;
        WindowManagerImpl windowManagerImpl;
        PropertyHandler propertyHandler;
        WindowManagerConfig wmc;
        int loadedSections = 0;
        boolean spacesUpdated = false;
        private boolean setMainWindowBounds = true;
        private final Object DATA_ID_LOCK = new Object();
        static /* synthetic */ Class class$org$openide$windows$Workspace;
        static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        public InstanceCookieImpl(DataFolder dataFolder) {
            super(dataFolder, FileUtil.findBrother((FileObject)dataFolder.getPrimaryFile(), (String)"wswmgr"), class$org$openide$windows$Workspace == null ? (class$org$openide$windows$Workspace = InstanceCookieImpl.class$("org.openide.windows.Workspace")) : class$org$openide$windows$Workspace);
        }

        public String instanceName() {
            return (class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl).getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl;
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            WindowManagerImpl windowManagerImpl;
            Object object = SAVING;
            synchronized (object) {
                windowManagerImpl = this.obtainWindowManagerImpl();
                if (this.childrenCookies == null) {
                    windowManagerImpl.attachUpdater(this);
                }
                InstanceCookie[] instanceCookieArray2 = this.childrenCookies;
                this.childrenCookies = instanceCookieArray;
                this.updateAll(instanceCookieArray2, instanceCookieArray);
            }
            return windowManagerImpl;
        }

        private void updateAll(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) throws IOException {
            if ((this.loadedSections & 1) != 0) {
                this.readProperties();
                this.setProperties();
            }
            if ((this.loadedSections & 2) != 0) {
                this.updateWorkspaces(instanceCookieArray, instanceCookieArray2);
            }
        }

        protected void updateProperties() throws IOException {
            if ((this.loadedSections & 1) != 0) {
                this.readProperties();
                this.setProperties();
            }
        }

        protected Object getDataLock() {
            return this.DATA_ID_LOCK;
        }

        private boolean readProperties() throws IOException {
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((WindowManagerData)this.folder);
            }
            this.wmc = null;
            try {
                this.wmc = this.propertyHandler.readData();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = InstanceCookieImpl.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData)).getString("EXC_WindowManagerParse"), this.folder.getName());
                IOException iOException = new IOException(string);
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)sAXException);
                throw iOException;
            }
            return true;
        }

        private void setProperties() throws IOException {
            WindowManagerImpl windowManagerImpl = this.obtainWindowManagerImpl();
            WindowManagerConfig windowManagerConfig = this.wmc;
            Mutex.EVENT.readAccess(new Runnable(this, windowManagerConfig, windowManagerImpl){
                private final /* synthetic */ WindowManagerConfig val$wmcLocal;
                private final /* synthetic */ WindowManagerImpl val$wmi;
                private final /* synthetic */ InstanceCookieImpl this$0;
                {
                    this.this$0 = instanceCookieImpl;
                    this.val$wmcLocal = windowManagerConfig;
                    this.val$wmi = windowManagerImpl;
                }

                public void run() {
                    if (InstanceCookieImpl.access$200(this.this$0)) {
                        if (this.val$wmcLocal.mainWindowBounds != null) {
                            boolean bl = true;
                            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                            if (this.val$wmcLocal.screenSize != null) {
                                WindowUtils.convertRectangle(this.val$wmcLocal.mainWindowBounds, this.val$wmcLocal.screenSize, dimension);
                            }
                            if (this.val$wmcLocal.minWidth > 0 && this.val$wmcLocal.minHeight > 0) {
                                if (this.val$wmcLocal.minWidth < dimension.width && this.val$wmcLocal.minHeight < dimension.height) {
                                    if (this.val$wmcLocal.mainWindowBounds.width < this.val$wmcLocal.minWidth || this.val$wmcLocal.mainWindowBounds.height < this.val$wmcLocal.minHeight) {
                                        this.val$wmcLocal.mainWindowBounds.width = this.val$wmcLocal.minWidth;
                                        this.val$wmcLocal.mainWindowBounds.height = this.val$wmcLocal.minHeight;
                                    }
                                    if (this.val$wmcLocal.mainWindowBounds.width > dimension.width || this.val$wmcLocal.mainWindowBounds.height > dimension.height) {
                                        bl = false;
                                    }
                                } else {
                                    bl = false;
                                }
                            } else {
                                this.val$wmcLocal.mainWindowBounds.width = Math.min(this.val$wmcLocal.mainWindowBounds.width, dimension.width);
                                this.val$wmcLocal.mainWindowBounds.height = Math.min(this.val$wmcLocal.mainWindowBounds.height, dimension.height);
                            }
                            if (!this.this$0.windowManagerImpl.isMainPositioned() && bl) {
                                if (WindowUtils.isMdi() && this.val$wmcLocal.maximizedMainWindow) {
                                    ((Component)WindowManagerImpl.mainWindow()).setBounds(this.val$wmcLocal.mainWindowBounds);
                                    if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
                                        MainWindow mainWindow = WindowManagerImpl.mainWindow();
                                        mainWindow.addComponentListener(new ComponentAdapter(this, mainWindow){
                                            private final /* synthetic */ Frame val$mainWindow;
                                            private final /* synthetic */ 1 this$1;
                                            {
                                                this.this$1 = var1_1;
                                                this.val$mainWindow = frame;
                                            }

                                            public void componentShown(ComponentEvent componentEvent) {
                                                this.val$mainWindow.removeComponentListener(this);
                                                try {
                                                    Method method = this.val$mainWindow.getClass().getMethod("setExtendedState", Integer.TYPE);
                                                    method.invoke((Object)this.val$mainWindow, new Integer(6));
                                                }
                                                catch (Exception exception) {
                                                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    if (WindowUtils.isMdi()) {
                                        Rectangle rectangle = Utilities.findCenterBounds((Dimension)this.val$wmcLocal.mainWindowBounds.getSize());
                                        if (this.val$wmcLocal.centerMainWindowX) {
                                            this.val$wmcLocal.mainWindowBounds.x = rectangle.x;
                                        }
                                        if (this.val$wmcLocal.centerMainWindowY) {
                                            this.val$wmcLocal.mainWindowBounds.y = rectangle.y;
                                        }
                                    }
                                    ((Component)WindowManagerImpl.mainWindow()).setBounds(this.val$wmcLocal.mainWindowBounds);
                                }
                                this.this$0.windowManagerImpl.setMainPositioned(true);
                            }
                        }
                        InstanceCookieImpl.access$202(this.this$0, false);
                    }
                    if (this.val$wmcLocal.uiMode != 0) {
                        this.val$wmi.setSavedUIMode(this.val$wmcLocal.uiMode);
                    }
                    if (this.val$wmcLocal.uiMode != 0 && this.val$wmi.uiModeManager().getUIMode() != this.val$wmcLocal.uiMode) {
                        this.val$wmi.uiModeManager().updateAll();
                    }
                }
            });
        }

        private void updateWorkspaces(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) throws IOException {
            Workspace workspace;
            String string;
            ArrayList<WorkspaceImpl> arrayList = new ArrayList<WorkspaceImpl>();
            int n = 0;
            while (n < instanceCookieArray2.length) {
                try {
                    WorkspaceImpl workspaceImpl = (WorkspaceImpl)instanceCookieArray2[n].instanceCreate();
                    arrayList.add(workspaceImpl);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)classNotFoundException);
                }
                ++n;
            }
            this.windowManagerImpl.setWorkspaces(arrayList.toArray(new WorkspaceImpl[arrayList.size()]));
            WindowManagerConfig windowManagerConfig = this.wmc;
            if (windowManagerConfig != null && (string = windowManagerConfig.activeWorkspace) != null && (workspace = this.windowManagerImpl.findLoadedWorkspace(string)) != null) {
                workspace.activate();
            }
        }

        private static Set createDiffSet(InstanceCookie[] instanceCookieArray, InstanceCookie[] instanceCookieArray2) {
            HashSet hashSet = new HashSet();
            InstanceCookieImpl.fillSet(hashSet, instanceCookieArray2, true);
            InstanceCookieImpl.fillSet(hashSet, instanceCookieArray, false);
            return hashSet;
        }

        private static void fillSet(Set set, Object[] objectArray, boolean bl) {
            if (objectArray == null) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                if (bl) {
                    set.add(objectArray[n]);
                } else {
                    set.remove(objectArray[n]);
                }
                ++n;
            }
        }

        private void checkWorkspaces() throws IOException {
            InstanceCookie instanceCookie;
            DataObject[] dataObjectArray = this.folder.getChildren();
            ArrayList<WorkspaceImpl> arrayList = new ArrayList<WorkspaceImpl>(dataObjectArray.length);
            int n = 0;
            while (n < dataObjectArray.length) {
                instanceCookie = (InstanceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? InstanceCookieImpl.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie != null) {
                    try {
                        WorkspaceImpl workspaceImpl = (WorkspaceImpl)instanceCookie.instanceCreate();
                        arrayList.add(workspaceImpl);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                }
                ++n;
            }
            instanceCookie = arrayList.toArray(new WorkspaceImpl[arrayList.size()]);
            this.windowManagerImpl.setWorkspaces((Workspace[])instanceCookie);
        }

        private Map createCurrentWorkspacesMap() {
            HashMap<String, Workspace> hashMap = new HashMap<String, Workspace>();
            Workspace[] workspaceArray = this.windowManagerImpl.getWorkspacesNoLoad();
            if (workspaceArray != null) {
                int n = 0;
                while (n < workspaceArray.length) {
                    hashMap.put(workspaceArray[n].getName(), workspaceArray[n]);
                    ++n;
                }
            }
            return hashMap;
        }

        private WindowManagerImpl obtainWindowManagerImpl() {
            if (this.windowManagerImpl == null) {
                this.windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
            }
            return this.windowManagerImpl;
        }

        public void save() throws IOException {
            Object object = SAVING;
            synchronized (object) {
                SaveCookie saveCookie;
                if (this.propertyHandler == null) {
                    this.propertyHandler = new PropertyHandler((WindowManagerData)this.folder);
                }
                this.propertyHandler.writeData();
                this.folder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
                FileObject[] fileObjectArray = this.folder.getPrimaryFile().getChildren();
                Workspace[] workspaceArray = this.obtainWindowManagerImpl().getWorkspaces();
                int n = 0;
                while (n < fileObjectArray.length) {
                    DataObject dataObject;
                    if (!fileObjectArray[n].isFolder() && (dataObject = DataObject.find((FileObject)fileObjectArray[n])) != null && dataObject instanceof WorkspaceData) {
                        saveCookie = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? InstanceCookieImpl.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                        if (saveCookie != null) {
                            saveCookie.save();
                        } else {
                            System.out.println("No save cookie for data obj " + dataObject);
                            Thread.dumpStack();
                        }
                    }
                    ++n;
                }
                saveCookie = this.folder.getChildren();
                DataObject[] dataObjectArray = this.sortWorkspaceData(workspaceArray, (DataObject[])saveCookie);
                this.folder.setOrder(dataObjectArray);
                try {
                    this.childrenCookies = this.createCookies();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.childrenCookies = null;
                    FoldingIOException foldingIOException = new FoldingIOException((Throwable)classNotFoundException);
                    ErrorManager.getDefault().annotate((Throwable)classNotFoundException, (Throwable)foldingIOException);
                    throw foldingIOException;
                }
            }
        }

        public void run() throws IOException {
            FileObject fileObject;
            Workspace[] workspaceArray = this.obtainWindowManagerImpl().getWorkspaces();
            FileObject fileObject2 = this.folder.getPrimaryFile();
            FileObject[] fileObjectArray = fileObject2.getChildren();
            HashSet<FileObject> hashSet = new HashSet<FileObject>(2 * fileObjectArray.length);
            int n = 0;
            while (n < fileObjectArray.length) {
                hashSet.add(fileObjectArray[n]);
                ++n;
            }
            String string = null;
            int n2 = 0;
            while (n2 < workspaceArray.length) {
                string = WindowUtils.escape(workspaceArray[n2].getName());
                fileObject = fileObject2.getFileObject(string, "wswksp");
                if (fileObject == null) {
                    fileObject2.createData(string, "wswksp");
                } else {
                    hashSet.remove(fileObject);
                }
                fileObject = fileObject2.getFileObject(string);
                if (fileObject == null) {
                    fileObject2.createFolder(string);
                } else {
                    hashSet.remove(fileObject);
                }
                ++n2;
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                fileObject = (FileObject)iterator.next();
                if (fileObject.isFolder()) continue;
                FileLock fileLock = fileObject.lock();
                fileObject.delete(fileLock);
                fileLock.releaseLock();
            }
        }

        private DataObject[] sortWorkspaceData(Workspace[] workspaceArray, DataObject[] dataObjectArray) {
            if (dataObjectArray.length == 0) {
                return dataObjectArray;
            }
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
            int n = 0;
            while (n < workspaceArray.length) {
                int n2 = 0;
                while (n2 < dataObjectArray.length) {
                    if (workspaceArray[n].getName().equals(dataObjectArray[n2].getName())) {
                        arrayList.add(dataObjectArray[n2]);
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            return arrayList.toArray(new DataObject[0]);
        }

        public int getLoadedSections() {
            return this.loadedSections;
        }

        public int disposeDataSection(int n) throws IOException {
            this.loadedSections &= ~n;
            throw new UnsupportedOperationException();
        }

        public int loadDataSection(int n) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (n == (this.loadedSections & n)) {
                    int n2 = this.loadedSections;
                    return n2;
                }
                this.loadedSections |= n;
                this.updateAll(null, this.childrenCookies);
                int n3 = this.loadedSections;
                return n3;
            }
        }

        public void resetComponents() {
        }

        public void destroy() throws IOException {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ boolean access$200(InstanceCookieImpl instanceCookieImpl) {
            return instanceCookieImpl.setMainWindowBounds;
        }

        static /* synthetic */ boolean access$202(InstanceCookieImpl instanceCookieImpl, boolean bl) {
            instanceCookieImpl.setMainWindowBounds = bl;
            return instanceCookieImpl.setMainWindowBounds;
        }
    }

    private static final class WindowManagerConfig {
        public Rectangle mainWindowBounds;
        public boolean centerMainWindowX;
        public boolean centerMainWindowY;
        public boolean maximizedMainWindow;
        public Dimension screenSize;
        public String activeWorkspace;
        public int uiMode;
        public int minWidth;
        public int minHeight;

        private WindowManagerConfig() {
        }

        public void clear() {
            this.mainWindowBounds = null;
            this.screenSize = null;
            this.centerMainWindowX = false;
            this.centerMainWindowY = false;
            this.maximizedMainWindow = false;
            this.minWidth = 0;
            this.minHeight = 0;
        }
    }
}

