/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class ModuleInfoManager {
    private static final ModuleInfoManager mim = new ModuleInfoManager();
    private HashMap modules = null;
    private Lookup.Result modulesResult = null;
    private HashMap mapOfListeners;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    private ModuleInfoManager() {
    }

    public static final ModuleInfoManager getDefault() {
        return mim;
    }

    public ModuleInfo getModule(String string) {
        Collection collection = null;
        if (this.modules == null) {
            collection = this.getModulesResult().allInstances();
        }
        ModuleInfoManager moduleInfoManager = this;
        synchronized (moduleInfoManager) {
            if (this.modules == null) {
                this.fillModules(collection);
            }
            ModuleInfo moduleInfo = (ModuleInfo)this.modules.get(string);
            return moduleInfo;
        }
    }

    private Lookup.Result getModulesResult() {
        ModuleInfoManager moduleInfoManager = this;
        synchronized (moduleInfoManager) {
            if (this.modulesResult == null) {
                this.modulesResult = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = ModuleInfoManager.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
                this.modulesResult.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        Collection collection = ModuleInfoManager.this.getModulesResult().allInstances();
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            ModuleInfoManager.this.fillModules(collection);
                        }
                    }
                });
            }
            Lookup.Result result = this.modulesResult;
            return result;
        }
    }

    private void fillModules(Collection collection) {
        HashMap<String, ModuleInfo> hashMap = new HashMap<String, ModuleInfo>((collection.size() << 2) / 3 + 1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
            hashMap.put(moduleInfo.getCodeNameBase(), moduleInfo);
        }
        this.modules = hashMap;
    }

    public ModuleInfo getModuleInfo(Class clazz) {
        Iterator iterator = this.getModulesResult().allInstances().iterator();
        while (iterator.hasNext()) {
            ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
            if (!moduleInfo.owns(clazz)) continue;
            return moduleInfo;
        }
        return null;
    }

    public synchronized void registerPropertyChangeListener(PropertyChangeListener propertyChangeListener, ModuleInfo moduleInfo) {
        PCL pCL;
        if (this.mapOfListeners == null) {
            this.mapOfListeners = new HashMap(this.modules.size());
        }
        if ((pCL = (PCL)this.mapOfListeners.get(moduleInfo)) == null) {
            pCL = new PCL(moduleInfo);
            this.mapOfListeners.put(moduleInfo, pCL);
        }
        pCL.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void unregisterPropertyChangeListener(PropertyChangeListener propertyChangeListener, ModuleInfo moduleInfo) {
        if (this.mapOfListeners == null) {
            return;
        }
        PCL pCL = (PCL)this.mapOfListeners.get(moduleInfo);
        if (pCL != null) {
            pCL.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized boolean isReloaded(ModuleInfo moduleInfo) {
        if (this.mapOfListeners == null) {
            return false;
        }
        PCL pCL = (PCL)this.mapOfListeners.get(moduleInfo);
        return pCL != null && pCL.isReloaded();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PCL
    implements PropertyChangeListener {
        private boolean aModuleHasBeenChanged = false;
        private boolean wasModuleEnabled;
        private ModuleInfo mi;
        private ArrayList propertyChangeListenerList;

        public PCL(ModuleInfo moduleInfo) {
            this.mi = moduleInfo;
            this.wasModuleEnabled = moduleInfo.isEnabled();
            moduleInfo.addPropertyChangeListener((PropertyChangeListener)this);
        }

        boolean isReloaded() {
            return this.aModuleHasBeenChanged;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                boolean bl;
                if (!Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    this.aModuleHasBeenChanged = true;
                    bl = this.wasModuleEnabled;
                } else {
                    bl = !this.wasModuleEnabled;
                }
                this.wasModuleEnabled = this.mi.isEnabled();
                if (bl) {
                    this.firePropertyChange();
                }
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerList == null) {
                this.propertyChangeListenerList = new ArrayList();
            }
            this.propertyChangeListenerList.add(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerList != null) {
                ((AbstractCollection)this.propertyChangeListenerList).remove(propertyChangeListener);
            }
        }

        private void firePropertyChange() {
            ArrayList arrayList;
            PCL pCL = this;
            synchronized (pCL) {
                if (this.propertyChangeListenerList == null) {
                    return;
                }
                arrayList = (ArrayList)this.propertyChangeListenerList.clone();
            }
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "enabled", null, null);
            int n = 0;
            while (n < arrayList.size()) {
                ((PropertyChangeListener)arrayList.get(n)).propertyChange(propertyChangeEvent);
                ++n;
            }
        }
    }
}

