/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import org.netbeans.modules.xml.tax.beans.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeNode;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class Lib {
    private static String CREATE_ATTRIBUTE_NAME = Util.THIS.getString("TEXT_new_attribute_name");
    private static String CREATE_ATTRIBUTE_VALUE = Util.THIS.getString("TEXT_new_attribute_value");

    public static Component getCustomizer(Object object) {
        Object o;
        BeanInfo beanInfo;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Lib::getCustomizer: object = " + object);
        }
        if (object == null) {
            return null;
        }
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: exception = " + e);
            }
            return null;
        }
        Class<?> clazz = beanInfo.getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            o = clazz.newInstance();
        }
        catch (InstantiationException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: exception = " + e);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: exception = " + e);
            }
            return null;
        }
        if (!(o instanceof Customizer)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: is NOT instanceof Customizer: " + o);
            }
            return null;
        }
        Customizer cust = (Customizer)o;
        Component comp = null;
        if (!(o instanceof Component)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: is NOT instanceof Component: " + o);
            }
            return null;
        }
        comp = (Component)o;
        cust.setObject(object);
        return comp;
    }

    public static Component getCustomizer(Class classClass, Object property, String propertyName) {
        Object peo;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(classClass);
        }
        catch (IntrospectionException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: exception = " + e);
            }
            return null;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Lib::getCustomizer: beaninfo = " + beanInfo);
        }
        PropertyDescriptor[] propDescrs = beanInfo.getPropertyDescriptors();
        PropertyDescriptor propertyDescriptor = null;
        int i = 0;
        while (i < propDescrs.length) {
            if (propertyName.equals(propDescrs[i].getName())) {
                propertyDescriptor = propDescrs[i];
                break;
            }
            ++i;
        }
        if (propertyDescriptor == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: have NOT property: " + propertyName);
            }
            return null;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Lib::getCustomizer: propertyDescriptor: " + propertyDescriptor);
        }
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Lib::getCustomizer: propertyEditorClass: " + clazz);
        }
        if (clazz == null) {
            return null;
        }
        try {
            peo = clazz.newInstance();
        }
        catch (InstantiationException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: exception = " + e);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: exception = " + e);
            }
            return null;
        }
        if (!(peo instanceof PropertyEditor)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: is NOT instanceof PropertyEditor: " + peo);
            }
            return null;
        }
        PropertyEditor editor = (PropertyEditor)peo;
        editor.setValue(property);
        Component comp = editor.getCustomEditor();
        if (comp == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: have NOT customizer: " + editor);
            }
            return null;
        }
        if (!(comp instanceof Customizer)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Lib::getCustomizer: is NOT instanceof Customizer: " + comp);
            }
            return null;
        }
        Customizer cust = (Customizer)((Object)comp);
        return comp;
    }

    public static boolean confirmAction(String message) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, 0);
        Object option = TopManager.getDefault().notify((NotifyDescriptor)nd);
        return option == NotifyDescriptor.YES_OPTION;
    }

    public static TreeAttribute createAttributeDialog() {
        return Lib.createAttributeDialog(false);
    }

    public static TreeAttribute createAttributeDialog(boolean mode) {
        try {
            TreeAttribute attr = new TreeAttribute(CREATE_ATTRIBUTE_NAME, CREATE_ATTRIBUTE_VALUE);
            Component customizer = Lib.getCustomizer(attr);
            if (customizer == null) {
                return null;
            }
            return (TreeAttribute)Lib.customNode(attr, customizer, Util.THIS.getString("TITLE_new_attribute"), mode);
        }
        catch (TreeException exc) {
            TAXUtil.notifyTreeException(exc);
            return null;
        }
    }

    private static TreeNode customNode(TreeNode treeNode, Component panel, String title, boolean mode) {
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, 2, NotifyDescriptor.OK_OPTION, 0, null, null);
        if (panel instanceof JComponent) {
            if (mode) {
                ((JComponent)panel).putClientProperty("xml-edit-mode", "new");
            } else {
                ((JComponent)panel).putClientProperty("xml-edit-mode", "edit");
            }
        }
        TopManager.getDefault().createDialog(dd).show();
        if (dd.getValue() != NotifyDescriptor.OK_OPTION) {
            return null;
        }
        return treeNode;
    }
}

