/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeException;

public class TreeDocumentTypeCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = -6111125131099262050L;
    private JLabel nameLabel;
    private JLabel publicLabel;
    private JTextField nameField;
    private JTextField publicField;
    private JLabel systemLabel;
    private JTextField systemField;
    private JPanel fillPanel;

    public TreeDocumentTypeCustomizer() {
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlName"));
        this.systemLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlSystemID"));
        this.publicLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlPublicID"));
        this.initAccessibility();
    }

    protected final TreeDocumentType getDocumentType() {
        return (TreeDocumentType)this.getTreeObject();
    }

    protected final void safePropertyChange(PropertyChangeEvent pche) {
        if (this.initializing) {
            return;
        }
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("elementName")) {
            this.updateNameComponent();
        } else if (pche.getPropertyName().equals("publicId")) {
            this.updatePublicIdComponent();
        } else if (pche.getPropertyName().equals("systemId")) {
            this.updateSystemIdComponent();
        }
    }

    protected final void updateDocumentTypeName() {
        try {
            this.getDocumentType().setElementName(this.nameField.getText());
        }
        catch (TreeException exc) {
            this.updateNameComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateNameComponent() {
        this.nameField.setText(this.getDocumentType().getElementName());
    }

    protected final void updateDocumentTypePublicId() {
        try {
            this.getDocumentType().setPublicId(AbstractTreeCustomizer.text2null(this.publicField.getText()));
        }
        catch (TreeException exc) {
            this.updatePublicIdComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updatePublicIdComponent() {
        this.publicField.setText(AbstractTreeCustomizer.null2text(this.getDocumentType().getPublicId()));
    }

    protected final void updateDocumentTypeSystemId() {
        try {
            String systemId = this.systemField.getText();
            if (this.getDocumentType().getPublicId() == null && !"".equals(systemId)) {
                systemId = AbstractTreeCustomizer.text2null(systemId);
            }
            this.getDocumentType().setSystemId(systemId);
        }
        catch (TreeException exc) {
            this.updateSystemIdComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateSystemIdComponent() {
        this.systemField.setText(AbstractTreeCustomizer.null2text(this.getDocumentType().getSystemId()));
    }

    protected final void initComponentValues() {
        this.updateNameComponent();
        this.updatePublicIdComponent();
        this.updateSystemIdComponent();
    }

    protected void updateReadOnlyStatus(boolean editable) {
        this.nameField.setEditable(editable);
        this.publicField.setEditable(editable);
        this.systemField.setEditable(editable);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.publicLabel = new JLabel();
        this.publicField = new JTextField();
        this.systemLabel = new JLabel();
        this.systemField = new JTextField();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(Util.THIS.getString("PROP_xmlName"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(20);
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeDocumentTypeCustomizer.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeDocumentTypeCustomizer.this.nameFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeDocumentTypeCustomizer.this.nameFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.nameField, gridBagConstraints);
        this.publicLabel.setText(Util.THIS.getString("PROP_xmlPublicID"));
        this.publicLabel.setLabelFor(this.publicField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.publicLabel, gridBagConstraints);
        this.publicField.setColumns(20);
        this.publicField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeDocumentTypeCustomizer.this.publicFieldActionPerformed(evt);
            }
        });
        this.publicField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeDocumentTypeCustomizer.this.publicFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeDocumentTypeCustomizer.this.publicFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.publicField, gridBagConstraints);
        this.systemLabel.setText(Util.THIS.getString("PROP_xmlSystemID"));
        this.systemLabel.setLabelFor(this.systemField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.systemLabel, gridBagConstraints);
        this.systemField.setColumns(20);
        this.systemField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeDocumentTypeCustomizer.this.systemFieldActionPerformed(evt);
            }
        });
        this.systemField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeDocumentTypeCustomizer.this.systemFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeDocumentTypeCustomizer.this.systemFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.systemField, gridBagConstraints);
        this.fillPanel.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void systemFieldFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.systemField.selectAll();
        }
    }

    private void publicFieldFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.publicField.selectAll();
        }
    }

    private void nameFieldFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.nameField.selectAll();
        }
    }

    private void publicFieldFocusLost(FocusEvent evt) {
        this.updateDocumentTypePublicId();
    }

    private void systemFieldFocusLost(FocusEvent evt) {
        this.updateDocumentTypeSystemId();
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        this.updateDocumentTypeName();
    }

    private void publicFieldActionPerformed(ActionEvent evt) {
        this.updateDocumentTypePublicId();
    }

    private void systemFieldActionPerformed(ActionEvent evt) {
        this.updateDocumentTypeSystemId();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.updateDocumentTypeName();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeDocumentTypeCustomizer"));
        this.nameField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_nameField4"));
        this.systemField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_systemField2"));
        this.publicField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_publicField3"));
    }
}

