/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.util;

import java.io.CharConversionException;
import javax.swing.SwingUtilities;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeText;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.xml.XMLUtil;

public final class TAXUtil {
    public static void setAttributeValue(TreeAttribute attribute, String value) throws TreeException {
        try {
            attribute.setValue(XMLUtil.toAttributeValue((String)value));
        }
        catch (CharConversionException exc) {
            throw new TreeException(exc);
        }
    }

    public static void setTextData(TreeText text, String value) throws TreeException {
        try {
            text.setData(XMLUtil.toElementContent((String)value));
        }
        catch (CharConversionException exc) {
            throw new TreeException(exc);
        }
    }

    public static void notifyWarning(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
                TopManager.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }

    public static String printableValue(String value) {
        if (value == null) {
            return new String("<null>");
        }
        int MAX_LENGTH = 33;
        int len = Math.min(value.length(), MAX_LENGTH);
        StringBuffer sb = new StringBuffer(2 * len);
        int i = 0;
        while (i < len) {
            char ch = value.charAt(i);
            if ('\r' == ch) {
                sb.append("\\r");
            } else if ('\n' == ch) {
                sb.append("\\n");
            } else if ('\t' == ch) {
                sb.append("\\t");
            } else if ('\b' == ch) {
                sb.append("\\b");
            } else if ('\f' == ch) {
                sb.append("\\f");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        if (value.length() > len) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static void notifyTreeException(TreeException exc) {
        TAXUtil.notifyWarning(exc.getMessage());
    }
}

