/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.BinaryFileWriter;
import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.PCDEntry;
import com.sun.tools.javamake.Utils;
import java.util.Enumeration;
import java.util.Hashtable;

public class ProjectDatabaseWriter
extends BinaryFileWriter {
    private Hashtable pcd;
    private int nOfEntries;
    private byte[] stringBuf;
    private int curStringBufPos;
    private int stringBufInc;
    private int curStringBufWatermark;
    private int stringCount;
    private StringHashTable stringHashTable;

    public byte[] writeProjectDatabase(Hashtable hashtable) {
        Object object;
        this.pcd = hashtable;
        this.nOfEntries = hashtable.size();
        this.initBuf(this.nOfEntries * 1000);
        this.stringBuf = new byte[this.nOfEntries * 300];
        this.stringBufInc = this.stringBuf.length / 5;
        this.curStringBufWatermark = this.stringBuf.length - 20;
        this.stringHashTable = new StringHashTable(this.stringBuf.length / 8);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object = (PCDEntry)enumeration.nextElement();
            this.writePCDEntry((PCDEntry)object);
        }
        object = this.buf;
        int n = this.curBufPos;
        int n2 = Utils.MAGIC.length + 8;
        int n3 = this.curStringBufPos;
        int n4 = n3 + n + 8;
        this.initBuf(n2 + n4);
        this.setBufferIncreaseMode(false);
        this.writePreamble(n4);
        this.writeStringTable(n3);
        System.arraycopy(object, 0, this.buf, this.curBufPos, n);
        return this.buf;
    }

    private void writePreamble(int n) {
        System.arraycopy(Utils.MAGIC, 0, this.buf, 0, Utils.MAGIC.length);
        this.curBufPos += Utils.MAGIC.length;
        this.writeInt(1);
        this.writeInt(n);
        this.writeInt(this.pcd.size());
    }

    private void writeStringTable(int n) {
        this.writeInt(this.stringCount);
        System.arraycopy(this.stringBuf, 0, this.buf, this.curBufPos, n);
        this.curBufPos += n;
    }

    private void writePCDEntry(PCDEntry pCDEntry) {
        this.writeStringRef(pCDEntry.className);
        this.writeStringRef(pCDEntry.javaFileFullPath);
        this.writeLong(pCDEntry.oldClassFileLastModified);
        this.writeLong(pCDEntry.oldClassFileFingerprint);
        this.writeClassInfo(pCDEntry.oldClassInfo);
    }

    private void writeClassInfo(ClassInfo classInfo) {
        Object[] objectArray;
        Object object;
        int n;
        Object[] objectArray2;
        this.writeStringRef(classInfo.name);
        int n2 = classInfo.cpoolRefsToClasses != null ? classInfo.cpoolRefsToClasses.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.cpoolRefsToClasses;
            n = 0;
            while (n < n2) {
                this.writeStringRef(objectArray2[n]);
                ++n;
            }
            object = classInfo.isRefClassArray;
            n = 0;
            while (n < n2) {
                this.buf[this.curBufPos++] = object[n] ? (byte)1 : 0;
                ++n;
            }
        }
        n2 = classInfo.cpoolRefsToFieldClasses != null ? classInfo.cpoolRefsToFieldClasses.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.cpoolRefsToFieldClasses;
            n = 0;
            while (n < n2) {
                this.writeStringRef(objectArray2[n]);
                ++n;
            }
            object = classInfo.cpoolRefsToFieldNames;
            n = 0;
            while (n < n2) {
                this.writeStringRef((String)object[n]);
                ++n;
            }
            objectArray = classInfo.cpoolRefsToFieldSignatures;
            n = 0;
            while (n < n2) {
                this.writeStringRef(objectArray[n]);
                ++n;
            }
        }
        n2 = classInfo.cpoolRefsToMethodClasses != null ? classInfo.cpoolRefsToMethodClasses.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.cpoolRefsToMethodClasses;
            n = 0;
            while (n < n2) {
                this.writeStringRef(objectArray2[n]);
                ++n;
            }
            object = classInfo.cpoolRefsToMethodNames;
            n = 0;
            while (n < n2) {
                this.writeStringRef((String)object[n]);
                ++n;
            }
            objectArray = classInfo.cpoolRefsToMethodSignatures;
            n = 0;
            while (n < n2) {
                this.writeStringRef(objectArray[n]);
                ++n;
            }
        }
        this.writeChar(classInfo.accessFlags);
        this.buf[this.curBufPos++] = classInfo.isNonMemberNestedClass ? (byte)1 : 0;
        this.writeStringRef(classInfo.superName);
        n2 = classInfo.interfaces != null ? classInfo.interfaces.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.interfaces;
            n = 0;
            while (n < n2) {
                this.writeStringRef(objectArray2[n]);
                ++n;
            }
        }
        n2 = classInfo.fieldNames != null ? classInfo.fieldNames.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.fieldNames;
            n = 0;
            while (n < n2) {
                this.writeStringRef(objectArray2[n]);
                ++n;
            }
            object = classInfo.fieldSignatures;
            n = 0;
            while (n < n2) {
                this.writeStringRef((String)object[n]);
                ++n;
            }
            objectArray = classInfo.fieldAccessFlags;
            n = 0;
            while (n < n2) {
                this.writeChar((int)objectArray[n]);
                ++n;
            }
        }
        n2 = classInfo.primitiveConstantInitValues != null ? classInfo.primitiveConstantInitValues.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.primitiveConstantInitValues;
            n = 0;
            while (n < n2) {
                object = objectArray2[n];
                if (object != null) {
                    if (object instanceof String) {
                        this.buf[this.curBufPos++] = 1;
                        this.writeStringRef((String)object);
                    } else if (object instanceof Integer) {
                        this.buf[this.curBufPos++] = 2;
                        this.writeInt((Integer)object);
                    } else if (object instanceof Long) {
                        this.buf[this.curBufPos++] = 3;
                        this.writeLong((Long)object);
                    } else if (object instanceof Float) {
                        this.buf[this.curBufPos++] = 4;
                        this.writeFloat(((Float)object).floatValue());
                    } else if (object instanceof Double) {
                        this.buf[this.curBufPos++] = 5;
                        this.writeDouble((Double)object);
                    }
                } else {
                    this.buf[this.curBufPos++] = 0;
                }
                ++n;
            }
        }
        n2 = classInfo.methodNames != null ? classInfo.methodNames.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.methodNames;
            n = 0;
            while (n < n2) {
                this.writeStringRef((String)objectArray2[n]);
                ++n;
            }
            object = classInfo.methodSignatures;
            n = 0;
            while (n < n2) {
                this.writeStringRef((String)object[n]);
                ++n;
            }
            objectArray = classInfo.methodAccessFlags;
            n = 0;
            while (n < n2) {
                this.writeChar((int)objectArray[n]);
                ++n;
            }
        }
        n2 = classInfo.checkedExceptions != null ? classInfo.checkedExceptions.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.checkedExceptions;
            n = 0;
            while (n < n2) {
                int n3 = objectArray2[n] != null ? ((Object)objectArray2[n]).length : 0;
                this.writeChar(n3);
                if (n3 > 0) {
                    int n4 = 0;
                    while (n4 < n3) {
                        this.writeStringRef((String)objectArray2[n][n4]);
                        ++n4;
                    }
                }
                ++n;
            }
        }
        n2 = classInfo.nestedClasses != null ? classInfo.nestedClasses.length : 0;
        this.writeChar(n2);
        if (n2 > 0) {
            objectArray2 = classInfo.nestedClasses;
            n = 0;
            while (n < n2) {
                this.writeStringRef((String)objectArray2[n]);
                ++n;
            }
        }
    }

    private void writeString(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        if (this.curStringBufPos + n > this.curStringBufWatermark) {
            this.stringBufInc = n >= this.stringBufInc ? (this.stringBufInc + n) * 2 : this.stringBufInc * 5 / 4;
            byte[] byArray2 = new byte[this.stringBuf.length + this.stringBufInc];
            System.arraycopy(this.stringBuf, 0, byArray2, 0, this.curStringBufPos);
            this.stringBuf = byArray2;
            this.curStringBufWatermark = this.stringBuf.length - 20;
        }
        this.stringBuf[this.curStringBufPos++] = (byte)(n >> 8 & 0xFF);
        this.stringBuf[this.curStringBufPos++] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.stringBuf, this.curStringBufPos, n);
        this.curStringBufPos += n;
    }

    private void writeStringRef(String string) {
        int n = this.stringHashTable.get(string);
        if (n == -1) {
            this.stringHashTable.add(string, this.stringCount);
            n = this.stringCount++;
            this.writeString(string);
        }
        this.writeInt(n);
    }

    static class StringHashTable {
        String[] keys;
        int[] values;
        int size;
        int nOfElements;
        int watermark;

        StringHashTable(int n) {
            this.size = n = this.makeLikePrimeNumber(n);
            this.keys = new String[n];
            this.values = new int[n];
            this.nOfElements = 0;
            this.watermark = n * 3 / 4;
        }

        final int get(String string) {
            int n = (string.hashCode() & Integer.MAX_VALUE) % this.size;
            while (this.keys[n] != string && this.keys[n] != null) {
                n = (n + 3) % this.size;
            }
            if (string == this.keys[n]) {
                return this.values[n];
            }
            return -1;
        }

        final void add(String string, int n) {
            if (this.nOfElements > this.watermark) {
                this.rehash();
            }
            int n2 = (string.hashCode() & Integer.MAX_VALUE) % this.size;
            while (this.keys[n2] != null) {
                n2 = (n2 + 3) % this.size;
            }
            this.keys[n2] = string;
            this.values[n2] = n;
            ++this.nOfElements;
        }

        private final void rehash() {
            String[] stringArray = this.keys;
            int[] nArray = this.values;
            int n = this.size;
            this.size = this.makeLikePrimeNumber(this.size * 3 / 2);
            this.keys = new String[this.size];
            this.values = new int[this.size];
            this.nOfElements = 0;
            this.watermark = this.size * 3 / 4;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2] != null) {
                    this.add(stringArray[n2], nArray[n2]);
                }
                ++n2;
            }
        }

        private final int makeLikePrimeNumber(int n) {
            n = n / 2 * 2 + 1;
            boolean bl = false;
            while (!(bl = (n += 2) % 3 != 0 && n % 5 != 0 && n % 7 != 0 && n % 11 != 0 && n % 13 != 0 && n % 17 != 0 && n % 19 != 0 && n % 23 != 0 && n % 29 != 0 && n % 31 != 0 && n % 37 != 0 && n % 41 != 0)) {
            }
            return n;
        }
    }
}

