/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.actions;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cvsclient.FsCommandFactory;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.actions.CallBackCommandAction;
import org.netbeans.modules.cvsclient.actions.JavaCvsActionSupporter;
import org.netbeans.modules.cvsclient.commands.CommandLineParamInput;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.openide.filesystems.FileObject;

public abstract class DefaultCallBackCommandAction
extends CallBackCommandAction {
    protected int usedUiMode;
    private LinkedList commandList;
    private LinkedList displList;

    public void initCallBack(JavaCvsActionSupporter javaCvsActionSupporter) {
        super.initCallBack(javaCvsActionSupporter);
        this.usedUiMode = 0;
        this.commandList = new LinkedList();
        this.displList = new LinkedList();
    }

    public void performCallBack(NbJavaCvsFileSystem nbJavaCvsFileSystem, FileObject[] fileObjectArray) {
        if (nbJavaCvsFileSystem.checkOffLine()) {
            return;
        }
        if (nbJavaCvsFileSystem.getUiMode() == 1) {
            this.usedUiMode = nbJavaCvsFileSystem.getUiMode();
        } else if (nbJavaCvsFileSystem.getUiMode() == 2 && this.usedUiMode == 0) {
            this.usedUiMode = nbJavaCvsFileSystem.getUiMode();
        }
        if (this.usedUiMode == 0 && this.isSwitched()) {
            this.usedUiMode = 1;
        }
        boolean bl = !FsCommandFactory.getFsInstance().showDisplayerWhenLimited(this.getCommandClass()) && nbJavaCvsFileSystem.getDisplayType() == 2;
        FileSystemCommand fileSystemCommand = FsCommandFactory.getFsInstance().createCommand(this.getCommandClass(), true, fileObjectArray, nbJavaCvsFileSystem.createClientProvider());
        nbJavaCvsFileSystem.prepareCommand(fileSystemCommand);
        this.commandList.add(fileSystemCommand);
        this.displList.add(new Boolean(bl));
    }

    protected FileSystemCommand getLastCommandInstance() {
        if (this.commandList != null && this.commandList.size() > 0) {
            return (FileSystemCommand)this.commandList.getLast();
        }
        return null;
    }

    protected List getCommandList() {
        return this.commandList;
    }

    protected List getDisplList() {
        return this.displList;
    }

    public void finishCallBack() {
        if (this.commandList.size() != 0) {
            if (this.usedUiMode == 2) {
                FsCommandFactory.getFsInstance().doShowCustomizerAndRun(this.commandList, new CommandLineParamInput(), this.displList);
                return;
            }
            boolean bl = false;
            if (this.usedUiMode == 0) {
                bl = true;
            }
            FsCommandFactory.getFsInstance().showCustomizerAndRun(this.commandList, this.displList, bl);
        }
        this.clearReferences();
    }

    protected void clearReferences() {
        this.commandList = null;
        this.displList = null;
    }

    protected abstract Class getCommandClass();

    public boolean isSwitchable() {
        return true;
    }
}

