/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.util.DefaultIgnoreFileFilter;
import org.netbeans.modules.javacvs.CvsCommand;
import org.netbeans.modules.javacvs.FsAdd;
import org.netbeans.modules.javacvs.FsAnnotate;
import org.netbeans.modules.javacvs.FsCheckout;
import org.netbeans.modules.javacvs.FsCommit;
import org.netbeans.modules.javacvs.FsDiff;
import org.netbeans.modules.javacvs.FsExport;
import org.netbeans.modules.javacvs.FsGlobalOptions;
import org.netbeans.modules.javacvs.FsHistory;
import org.netbeans.modules.javacvs.FsImport;
import org.netbeans.modules.javacvs.FsLog;
import org.netbeans.modules.javacvs.FsRemove;
import org.netbeans.modules.javacvs.FsStatus;
import org.netbeans.modules.javacvs.FsTag;
import org.netbeans.modules.javacvs.FsUpdate;
import org.netbeans.modules.javacvs.FsWatchers;
import org.netbeans.modules.javacvs.JavaCvsFileSystem;
import org.netbeans.modules.javacvs.JavaCvsFileSystemException;
import org.netbeans.modules.javacvs.caching.CvsFsCache;
import org.netbeans.modules.javacvs.caching.JavaCvsCache;
import org.netbeans.modules.javacvs.caching.RefreshCommand;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.CvsAdd;
import org.netbeans.modules.javacvs.commands.CvsAnnotate;
import org.netbeans.modules.javacvs.commands.CvsCheckout;
import org.netbeans.modules.javacvs.commands.CvsCommit;
import org.netbeans.modules.javacvs.commands.CvsDiff;
import org.netbeans.modules.javacvs.commands.CvsExport;
import org.netbeans.modules.javacvs.commands.CvsHistory;
import org.netbeans.modules.javacvs.commands.CvsImport;
import org.netbeans.modules.javacvs.commands.CvsLog;
import org.netbeans.modules.javacvs.commands.CvsRemove;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.javacvs.commands.CvsTag;
import org.netbeans.modules.javacvs.commands.CvsUpdate;
import org.netbeans.modules.javacvs.commands.CvsWatchers;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.FileSystemCommandImpl;
import org.netbeans.modules.javacvs.commands.FsGlobalOptionsImpl;
import org.netbeans.modules.javacvs.commands.JavaCvsCommandFactory;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.javacvs.commands.StandardClientProvider;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class JavaCvsFileSystem
extends AbstractFileSystem {
    static final long serialVersionUID = -5990750897426301780L;
    public static final String PROP_REL_MOUNT = "relMount";
    public static final String PROP_WORKING_DIR = "workingDir";
    public static final String PROP_OFF_LINE = "offLine";
    public static final String PROP_AUTO_REFRESH = "autoRefresh";
    public static final String PROP_ZIPPED_TRANSFER = "ZippedTransfer";
    public static final String PROP_HIDE_SHADOW_FILES = "hideShadowFiles";
    public static final String PROP_CVS_IGNORE_LIST = "cvsIgnoreList";
    public static final String PROP_FS_INGORED_FILES = "fsIgnoredFiles";
    public static final String PROP_CREATE_BACKUPS = "createBackups";
    public static final String PROP_CVS_SERVER_TYPE = "cvsServerType";
    public static final String PROP_CVS_SERVER_NAME = "cvsServerName";
    public static final String PROP_CVS_USER_NAME = "cvsUserName";
    public static final String PROP_CVS_REPOSITORY = "cvsRepository";
    public static final String PROP_CVS_PORT = "cvsPort";
    public static final int STANDARD_PORT = 2401;
    public static final int AUTO_NONE = 0;
    public static final int AUTO_SIMPLE = 1;
    public static final int AUTO_RECURS_ONCE = 2;
    public static final int AUTO_RECURS_EVERYTIME = 3;
    public static final int AUTO_MOUNT_AND_RESTART = 4;
    public static final int TYPE_SERVER = 0;
    public static final int TYPE_PSERVER = 1;
    private static final String[] TYPE_NAMES = new String[]{"server", "pserver"};
    protected static final int REFRESH_TIME = 150000;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 8;
    protected int refreshTimeToSet = 150000;
    private File rootFile = null;
    private boolean readOnly;
    protected transient CvsFsCache cache = null;
    private boolean isRootSet;
    private long cacheId = 0L;
    private File workingDir = null;
    private String relMount = "";
    private boolean offLine = false;
    private int autoRefresh = 0;
    private boolean zippedTransfer = true;
    private boolean hideShadowFiles = false;
    protected String fsIgnoredFiles = "~$|^\\.#";
    protected transient RE ignoredRE = null;
    private String repository = "";
    private String serverName = "";
    private int serverType = 1;
    private String userName = "";
    protected FileSystem.Status status;
    private File homeDirectory = new File(System.getProperty("user.home"));
    private ErrorManager errorManager;
    private int cvsPort = 2401;
    private boolean createBackups = true;
    private transient CacheHandlerListener cacheListener;
    private transient boolean freshlyMounted = false;
    protected transient WeakReference ignoreListReference;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cache$CacheHandlerListener;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsStatus;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsLog;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsUpdate;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsTag;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsRemove;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsDiff;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsCommit;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsCheckout;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsAdd;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsAnnotate;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsImport;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsExport;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsHistory;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsWatchers;

    public JavaCvsFileSystem() {
        this.initImpls();
        DefaultAttributes defaultAttributes = new DefaultAttributes(this.info, this.change, (AbstractFileSystem.List)new ListImpl());
        this.attr = defaultAttributes;
        this.list = defaultAttributes;
        this.isRootSet = false;
        this.setRefreshTime(0);
        this.setWorkingDir(new File(System.getProperty("user.home")));
        this.setOffLine(false);
        this.setAutoRefresh(0);
        this.setHideShadowFiles(false);
        try {
            this.ignoredRE = new RE(this.fsIgnoredFiles);
        }
        catch (RESyntaxException rESyntaxException) {
            this.ignoredRE = null;
        }
        this.freshlyMounted = true;
        this.initCache();
        this.independantInit();
    }

    protected void initImpls() {
        this.info = new InfoImpl();
        this.change = new ChangeImpl();
        this.status = new MyStatus();
    }

    public JavaCvsFileSystem(FileSystemCapability fileSystemCapability) {
        this();
        this.setCapability(fileSystemCapability);
    }

    protected void initCache() {
        CacheHandler cacheHandler = CacheHandler.getInstance();
        JavaCvsCache javaCvsCache = (JavaCvsCache)cacheHandler.getCache("javacvs");
        if (javaCvsCache == null) {
            javaCvsCache = new JavaCvsCache();
            cacheHandler.registerCacheType("javacvs", (FileSystemCache)javaCvsCache);
        }
        javaCvsCache.registerFileSystem((FileSystem)this);
        this.cacheListener = new CacheHandlerListenerImpl();
        javaCvsCache.addCacheHandlerListener((CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = JavaCvsFileSystem.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)this.cacheListener, (Object)((Object)javaCvsCache)));
    }

    protected void independantInit() {
        if (((Object)((Object)this)).getClass().equals(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)) {
            Lookup lookup = Lookup.getDefault();
            this.errorManager = (ErrorManager)lookup.lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = JavaCvsFileSystem.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            this.cache = new CvsFsCache(this, this.getHomeDirectory());
            this.cache.setAutoRefresh(this.getAutoRefresh());
            this.cache.setOffLine(this.isOffLine());
            this.cache.setHideShadowFiles(this.isHideShadowFiles());
            this.cache.setFsRootFile(new File(this.constructRootDirectory()));
        }
    }

    protected String computeSystemName(File file, int n) {
        if (n == 0) {
            return "org.netbeans.modules.javacvs.JavaCvsFileSystem " + file.toString();
        }
        return "org.netbeans.modules.javacvs.JavaCvsFileSystem " + file.toString() + n;
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"JavaCvsFileSystem.validFilesystemLabel", (Object)this.rootFile.toString());
    }

    public void setHomeDirectory(File file) {
        this.homeDirectory = file;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getRootDirectory() {
        return this.rootFile;
    }

    public JavaCvsCommandFactory getCommandFactory() {
        return JavaCvsCommandFactory.getInstance();
    }

    private synchronized void setRootDirectory(File file) throws PropertyVetoException, IOException {
        if (!file.exists() || file.isFile()) {
            throw new JavaCvsFileSystemException(file.toString() + " does not exist", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"JavaCvsFileSystem.EXC_root_dir_does_not_exist", (Object)file.toString()));
        }
        boolean bl = false;
        int n = 0;
        while (!bl) {
            try {
                this.setSystemName(this.computeSystemName(file, n));
                bl = true;
            }
            catch (PropertyVetoException propertyVetoException) {
                bl = false;
                ++n;
            }
        }
        this.rootFile = file;
        FileObject fileObject = this.refreshRoot();
        this.firePropertyChange("root", null, fileObject);
        this.firePropertyChange("name", null, this.getDisplayName());
        fileObject = this.findResource("");
        this.isRootSet = true;
    }

    public String constructRootDirectory() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.workingDir != null) {
            stringBuffer.append(this.workingDir.getAbsolutePath());
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != File.separatorChar) {
            stringBuffer.append(File.separatorChar);
        }
        if (this.relMount.startsWith(File.separator)) {
            stringBuffer.append(this.relMount.substring(1));
        } else {
            stringBuffer.append(this.relMount);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == File.separatorChar) {
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        String string = stringBuffer.toString().replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        return string;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        if (bl != this.readOnly) {
            this.readOnly = bl;
            this.firePropertyChange("readOnly", new Boolean(!bl), new Boolean(bl));
        }
    }

    public void setWorkingDir(File file) {
        if (!file.equals(this.workingDir)) {
            File file2 = this.workingDir;
            this.workingDir = file;
            String string = this.relMount;
            this.firePropertyChange(PROP_WORKING_DIR, file2, file);
            this.setRelMount("");
            try {
                this.setRootDirectory(new File(this.constructRootDirectory()));
            }
            catch (PropertyVetoException propertyVetoException) {
                this.workingDir = file2;
                this.firePropertyChange(PROP_WORKING_DIR, file, file2);
                this.firePropertyChange(PROP_REL_MOUNT, "", string);
                return;
            }
            catch (IOException iOException) {
                this.workingDir = file2;
                this.firePropertyChange(PROP_WORKING_DIR, file, file2);
                this.firePropertyChange(PROP_REL_MOUNT, "", string);
                return;
            }
        }
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setRelMount(String string) {
        if (!string.equals(this.relMount)) {
            String string2 = this.relMount;
            this.relMount = string;
            try {
                this.setRootDirectory(new File(this.constructRootDirectory()));
            }
            catch (PropertyVetoException propertyVetoException) {
                this.relMount = string2;
                return;
            }
            catch (IOException iOException) {
                this.relMount = string2;
                return;
            }
            this.firePropertyChange(PROP_REL_MOUNT, string2, string);
        }
    }

    public String getRelMount() {
        if (this.relMount == null) {
            return "";
        }
        return this.relMount;
    }

    public boolean isOffLine() {
        return this.offLine;
    }

    public void setOffLine(boolean bl) {
        if (bl != this.offLine) {
            this.offLine = bl;
            this.firePropertyChange(PROP_OFF_LINE, new Boolean(!this.offLine), new Boolean(bl));
        }
    }

    public boolean checkOffLine() {
        return this.isOffLine();
    }

    public int getAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(int n) {
        if (n != this.autoRefresh) {
            int n2 = this.autoRefresh;
            this.autoRefresh = n;
            this.firePropertyChange(PROP_AUTO_REFRESH, new Integer(n2), new Integer(this.autoRefresh));
        }
    }

    public boolean isZippedTransfer() {
        return this.zippedTransfer;
    }

    public void setZippedTransfer(boolean bl) {
        if (this.zippedTransfer != bl) {
            this.firePropertyChange(PROP_ZIPPED_TRANSFER, new Boolean(!bl), new Boolean(bl));
            this.zippedTransfer = bl;
        }
    }

    public String getFsIgnoredFiles() {
        return this.fsIgnoredFiles;
    }

    public synchronized void setFsIgnoredFiles(String string) throws IllegalArgumentException {
        if (!string.equals(this.fsIgnoredFiles)) {
            if (string.length() > 0) {
                try {
                    this.ignoredRE = new RE(string);
                }
                catch (RESyntaxException rESyntaxException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    throw illegalArgumentException;
                }
            } else {
                this.ignoredRE = null;
            }
            this.fsIgnoredFiles = string;
            this.firePropertyChange(PROP_FS_INGORED_FILES, null, null);
            Enumeration enumeration = this.existingFileObjects(this.findResource(""));
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (fileObject == null || !fileObject.isFolder()) continue;
                fileObject.refresh(true);
            }
        }
    }

    public void setHideShadowFiles(boolean bl) {
    }

    public boolean isHideShadowFiles() {
        return false;
    }

    public void setCvsRepository(String string) {
        if (!string.equals(this.repository)) {
            String string2 = this.repository;
            this.repository = string;
            this.firePropertyChange(PROP_CVS_REPOSITORY, string2, string);
        }
    }

    public String getCvsRepository() {
        return this.repository;
    }

    public void setCvsServerType(int n) {
        if (this.serverType != n) {
            int n2 = this.serverType;
            this.serverType = n;
            this.firePropertyChange(PROP_CVS_SERVER_TYPE, new Integer(n2), new Integer(n));
        }
    }

    public int getCvsServerType() {
        return this.serverType;
    }

    public int getCvsServerType(String string) {
        int n = 0;
        while (n < TYPE_NAMES.length) {
            if (TYPE_NAMES[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String[] getCvsServerTypes() {
        return TYPE_NAMES;
    }

    public String getCvsServerTypeName() {
        if (this.serverType >= 0 && this.serverType < TYPE_NAMES.length) {
            return TYPE_NAMES[this.serverType];
        }
        return "";
    }

    public String getCvsServerTypeName(int n) {
        if (n >= 0 && n < TYPE_NAMES.length) {
            return TYPE_NAMES[n];
        }
        return "";
    }

    public void setCvsServerName(String string) {
        if (!string.equals(this.serverName)) {
            String string2 = this.serverName;
            this.serverName = string;
            this.firePropertyChange(PROP_CVS_SERVER_NAME, string2, string);
        }
    }

    public String getCvsServerName() {
        return this.serverName;
    }

    public void setCvsUserName(String string) {
        if (!string.equals(this.userName)) {
            String string2 = this.userName;
            this.userName = string;
            this.firePropertyChange(PROP_CVS_USER_NAME, string2, string);
        }
    }

    public String getCvsUserName() {
        return this.userName;
    }

    public int getCvsPort() {
        return this.cvsPort;
    }

    public void setCvsPort(int n) {
        if (n != this.cvsPort) {
            int n2 = this.cvsPort;
            this.cvsPort = n;
            this.firePropertyChange(PROP_CVS_PORT, new Integer(n2), new Integer(n));
        }
    }

    public String getCvsRootString() {
        StringBuffer stringBuffer = new StringBuffer(":");
        stringBuffer.append(this.getCvsServerTypeName());
        stringBuffer.append(':');
        stringBuffer.append(this.getCvsUserName());
        stringBuffer.append('@');
        stringBuffer.append(this.getCvsServerName());
        stringBuffer.append(':');
        if (this.getCvsPort() != 2401) {
            stringBuffer.append("" + this.getCvsPort());
        }
        stringBuffer.append(this.getCvsRepository());
        return stringBuffer.toString();
    }

    protected JavaCvsStatusManager getStatusManager() {
        return JavaCvsStatusManager.getInstance();
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.rootFile.toString());
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    public SystemAction[] getActions() {
        return null;
    }

    public SystemAction[] getActions(Set set) {
        return null;
    }

    protected void handleDelete(String string) {
    }

    protected void handleRename(String string, String string2) {
    }

    protected CacheReference getCacheReference(String string) {
        Reference reference = this.findReference(string);
        if (reference != null && reference instanceof CacheReference) {
            CacheReference cacheReference = (CacheReference)reference;
            return cacheReference;
        }
        return null;
    }

    protected File getFile(String string) {
        if (string.length() > 0) {
            return new File(this.rootFile, string);
        }
        return new File(this.rootFile.getAbsolutePath());
    }

    protected File[] getFiles(FileObject[] fileObjectArray) {
        File[] fileArray = new File[fileObjectArray.length];
        int n = 0;
        while (n < fileObjectArray.length) {
            if (fileObjectArray[n] != null) {
                String string = fileObjectArray[n].getPackageNameExt('/', '.');
                fileArray[n] = this.getFile(string);
            }
            ++n;
        }
        return fileArray;
    }

    public FileObject getFileObjectForFile(File file) {
        String string = this.constructRootDirectory();
        String string2 = file.getAbsolutePath();
        if (string2.startsWith(string)) {
            String string3;
            if (string2.equals(string)) {
                string3 = "";
            } else {
                string3 = string2.substring(string.length() + 1, string2.length());
                if (string3.length() > 0 && string3.charAt(0) == File.separatorChar) {
                    string3 = string3.substring(1);
                }
            }
            string3 = string3.replace('\\', '/');
            FileObject fileObject = this.findResource(string3);
            return fileObject;
        }
        return null;
    }

    private Set getRecursFileObjectSet(File file) {
        FileObject fileObject = this.getFileObjectForFile(file);
        if (fileObject != null) {
            HashSet hashSet = new HashSet();
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
            return hashSet;
        }
        return null;
    }

    public void setRefreshTimeToSet() {
        this.setRefreshTime(this.refreshTimeToSet);
    }

    public boolean isImportant(String string) {
        CacheReference cacheReference = this.getCacheReference(string);
        if (cacheReference != null) {
            return cacheReference.isImportant();
        }
        return true;
    }

    protected Vector getImportantFiles(Object[] objectArray) {
        Vector<String> vector = new Vector<String>(3);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileObject fileObject = (FileObject)objectArray[n2];
            if (fileObject != null) {
                String string;
                boolean bl = true;
                try {
                    bl = fileObject.getFileSystem().equals((Object)this);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    bl = true;
                }
                if (bl && this.isImportant(string = fileObject.getPackageNameExt('/', '.'))) {
                    vector.addElement(string);
                }
            }
            ++n2;
        }
        return vector;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, NotActiveException {
        objectInputStream.defaultReadObject();
        this.initCache();
        this.independantInit();
        if (this.cvsPort == 0) {
            this.setCvsPort(2401);
        }
        if (this.fsIgnoredFiles == null) {
            this.fsIgnoredFiles = "";
        } else if (this.fsIgnoredFiles.length() > 0) {
            try {
                this.ignoredRE = new RE(this.fsIgnoredFiles);
            }
            catch (RESyntaxException rESyntaxException) {
                // empty catch block
            }
        }
        this.freshlyMounted = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    protected ClientProvider createClientProvider() {
        StandardClientProvider standardClientProvider = new StandardClientProvider(this.getHomeDirectory());
        standardClientProvider.setCvsRootString(this.getCvsRootString());
        standardClientProvider.setCvsPort(this.getCvsPort());
        standardClientProvider.setLocalPath(this.getRootDirectory().getAbsolutePath());
        List list = JavaCvsFileSystem.constructIgnoreList(this.getHomeDirectory(), new File(this.getWorkingDir(), "CVSROOT"));
        DefaultIgnoreFileFilter defaultIgnoreFileFilter = new DefaultIgnoreFileFilter(list);
        standardClientProvider.setIgnoreFilter(defaultIgnoreFileFilter);
        FsGlobalOptionsImpl fsGlobalOptionsImpl = (FsGlobalOptionsImpl)this.getCommandFactory().getGlobalOptions();
        standardClientProvider.setGlobalOptions(fsGlobalOptionsImpl.getLibraryGlobalOptions());
        return standardClientProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getCvsIgnoreList() {
        Object var2_1 = null;
        if (this.ignoreListReference != null) {
            Object t = this.ignoreListReference.get();
            var2_1 = t;
            if (t != null) return var2_1;
        }
        List list = JavaCvsFileSystem.constructIgnoreList(this.getHomeDirectory(), new File(this.getWorkingDir(), "CVSROOT"));
        String[] stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        this.ignoreListReference = new WeakReference<String[]>(stringArray);
        return stringArray;
    }

    public static List constructIgnoreList(File file, File file2) {
        List<String> list = null;
        File file3 = new File(file2, "cvsignore");
        try {
            list = DefaultIgnoreFileFilter.parseCvsIgnoreFile(file3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (list == null) {
            list = new LinkedList();
        }
        file3 = new File(file, ".cvsignore");
        try {
            list = DefaultIgnoreFileFilter.parseCvsIgnoreFile(file3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = System.getProperty("env-cvsignore");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                list.add(string2);
            }
        }
        return list;
    }

    public void doRefresh(FileObject[] fileObjectArray, boolean bl) {
        File[] fileArray;
        if (this.isOffLine()) {
            return;
        }
        File[] fileArray2 = this.getFiles(fileObjectArray);
        LinkedList<File> linkedList = new LinkedList<File>();
        LinkedList<File> linkedList2 = new LinkedList<File>();
        int n = 0;
        while (n < fileArray2.length) {
            if (fileArray2[n].isDirectory()) {
                linkedList.add(fileArray2[n]);
            } else {
                linkedList2.add(fileArray2[n]);
            }
            ++n;
        }
        if (linkedList.size() > 0) {
            fileArray = new File[linkedList.size()];
            fileArray = linkedList.toArray(fileArray);
            this.cache.doRefresh(fileArray, bl);
        }
        if (linkedList2.size() > 0) {
            fileArray = new File[linkedList2.size()];
            fileArray = linkedList2.toArray(fileArray);
            this.cache.doRefresh(fileArray, bl);
        }
    }

    public void removeNotify() {
        if (this.cacheListener != null) {
            // empty if block
        }
        if (this.cache != null) {
            this.cache.removeNotify();
        }
    }

    public void addNotify() {
        FileObject[] fileObjectArray = new FileObject[]{this.findResource("")};
        if (this.getAutoRefresh() == 2 && this.freshlyMounted || this.getAutoRefresh() == 3 && !this.freshlyMounted || this.getAutoRefresh() == 4) {
            this.doRefresh(fileObjectArray, true);
        }
    }

    protected void fireRecursiveFileStatus(FileObject fileObject) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            hashSet.add(fileObject2);
            fileObject2.refresh(true);
        }
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, hashSet, true, true));
    }

    protected void fireFileStatusForExisting(FileObject fileObject) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Enumeration enumeration = this.existingFileObjects(fileObject);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            boolean bl = this.setVirtualDataLoader(fileObject2);
            hashSet.add(fileObject2);
        }
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, hashSet, true, true));
    }

    protected void reloadChangedDataObjects(Set set) {
    }

    protected void refreshExisting(FileObject fileObject) {
        Enumeration enumeration = this.existingFileObjects(fileObject);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (fileObject2.isFolder()) {
                fileObject2.refresh();
                continue;
            }
            fileObject2.refresh(true);
        }
    }

    protected boolean setVirtualDataLoader(FileObject fileObject) {
        return false;
    }

    protected Reference createReference(FileObject fileObject) {
        return this.cache.createReference(fileObject);
    }

    public FsStatus createStatus() {
        CvsStatus cvsStatus = (CvsStatus)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsStatus == null ? (class$org$netbeans$modules$javacvs$commands$CvsStatus = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsStatus")) : class$org$netbeans$modules$javacvs$commands$CvsStatus, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsStatus.setClientProvider(clientProvider);
        return cvsStatus.getStatusImpl();
    }

    public FsStatus createRefresh() {
        RefreshCommand refreshCommand = new RefreshCommand();
        ClientProvider clientProvider = this.createClientProvider();
        refreshCommand.setClientProvider(clientProvider);
        return refreshCommand.getStatusImpl();
    }

    public FsLog createLog() {
        CvsLog cvsLog = (CvsLog)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsLog == null ? (class$org$netbeans$modules$javacvs$commands$CvsLog = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsLog")) : class$org$netbeans$modules$javacvs$commands$CvsLog, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsLog.setClientProvider(clientProvider);
        return cvsLog.getLogImpl();
    }

    public FsUpdate createUpdate() {
        CvsUpdate cvsUpdate = (CvsUpdate)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsUpdate == null ? (class$org$netbeans$modules$javacvs$commands$CvsUpdate = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsUpdate")) : class$org$netbeans$modules$javacvs$commands$CvsUpdate, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsUpdate.setClientProvider(clientProvider);
        return cvsUpdate.getUpdateImpl();
    }

    public FsTag createTag() {
        CvsTag cvsTag = (CvsTag)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsTag == null ? (class$org$netbeans$modules$javacvs$commands$CvsTag = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsTag")) : class$org$netbeans$modules$javacvs$commands$CvsTag, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsTag.setClientProvider(clientProvider);
        return cvsTag.getTagImpl();
    }

    public FsRemove createRemove() {
        CvsRemove cvsRemove = (CvsRemove)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsRemove == null ? (class$org$netbeans$modules$javacvs$commands$CvsRemove = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsRemove")) : class$org$netbeans$modules$javacvs$commands$CvsRemove, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsRemove.setClientProvider(clientProvider);
        return cvsRemove.getRemoveImpl();
    }

    public FsDiff createDiff() {
        CvsDiff cvsDiff = (CvsDiff)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsDiff == null ? (class$org$netbeans$modules$javacvs$commands$CvsDiff = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsDiff")) : class$org$netbeans$modules$javacvs$commands$CvsDiff, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsDiff.setClientProvider(clientProvider);
        return cvsDiff.getDiffImpl();
    }

    public FsCommit createCommit() {
        CvsCommit cvsCommit = (CvsCommit)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsCommit == null ? (class$org$netbeans$modules$javacvs$commands$CvsCommit = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsCommit")) : class$org$netbeans$modules$javacvs$commands$CvsCommit, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsCommit.setClientProvider(clientProvider);
        return cvsCommit.getCommitImpl();
    }

    public FsCheckout createCheckout() {
        CvsCheckout cvsCheckout = (CvsCheckout)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsCheckout == null ? (class$org$netbeans$modules$javacvs$commands$CvsCheckout = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsCheckout")) : class$org$netbeans$modules$javacvs$commands$CvsCheckout, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsCheckout.setLocalPath(this.getWorkingDir().getAbsolutePath());
        cvsCheckout.setClientProvider(clientProvider);
        return cvsCheckout.getCheckoutImpl();
    }

    public FsAdd createAdd() {
        CvsAdd cvsAdd = (CvsAdd)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsAdd == null ? (class$org$netbeans$modules$javacvs$commands$CvsAdd = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsAdd")) : class$org$netbeans$modules$javacvs$commands$CvsAdd, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsAdd.setClientProvider(clientProvider);
        return cvsAdd.getAddImpl();
    }

    public FsAnnotate createAnnotate() {
        CvsAnnotate cvsAnnotate = (CvsAnnotate)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsAnnotate == null ? (class$org$netbeans$modules$javacvs$commands$CvsAnnotate = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsAnnotate")) : class$org$netbeans$modules$javacvs$commands$CvsAnnotate, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsAnnotate.setClientProvider(clientProvider);
        return cvsAnnotate.getAnnotateImpl();
    }

    public FsImport createImport() {
        CvsImport cvsImport = (CvsImport)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsImport == null ? (class$org$netbeans$modules$javacvs$commands$CvsImport = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsImport")) : class$org$netbeans$modules$javacvs$commands$CvsImport, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsImport.setClientProvider(clientProvider);
        return cvsImport.getImportImpl();
    }

    public FsExport createExport() {
        CvsExport cvsExport = (CvsExport)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsExport == null ? (class$org$netbeans$modules$javacvs$commands$CvsExport = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsExport")) : class$org$netbeans$modules$javacvs$commands$CvsExport, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsExport.setClientProvider(clientProvider);
        return cvsExport.getExportImpl();
    }

    public FsHistory createHistory() {
        CvsHistory cvsHistory = (CvsHistory)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsHistory == null ? (class$org$netbeans$modules$javacvs$commands$CvsHistory = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsHistory")) : class$org$netbeans$modules$javacvs$commands$CvsHistory, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsHistory.setClientProvider(clientProvider);
        return cvsHistory.getHistoryImpl();
    }

    public FsWatchers createWatchers() {
        CvsWatchers cvsWatchers = (CvsWatchers)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsWatchers == null ? (class$org$netbeans$modules$javacvs$commands$CvsWatchers = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsWatchers")) : class$org$netbeans$modules$javacvs$commands$CvsWatchers, false);
        ClientProvider clientProvider = this.createClientProvider();
        cvsWatchers.setClientProvider(clientProvider);
        return cvsWatchers.getWatchersImpl();
    }

    public FsGlobalOptions getGlobalOptionsFor(CvsCommand cvsCommand) {
        FileSystemCommandImpl fileSystemCommandImpl = (FileSystemCommandImpl)((Object)cvsCommand);
        FileSystemCommand fileSystemCommand = fileSystemCommandImpl.getOuterClassInstance();
        return new FsGlobalOptionsImpl(fileSystemCommand.getGlobalOptions());
    }

    protected boolean checkVirtual(String string) {
        boolean bl;
        File file = this.getFile(string);
        boolean bl2 = bl = !file.exists();
        if (bl) {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            String string2 = this.cache.getFileStatusOnly(vector);
            bl = !string2.equals("Local") && !string2.equals("Unknown") && string2.length() > 1;
        }
        return bl;
    }

    public boolean isCreateBackups() {
        return this.createBackups;
    }

    public void setCreateBackups(boolean bl) {
        if (this.createBackups != bl) {
            this.createBackups = bl;
            this.firePropertyChange(PROP_CREATE_BACKUPS, new Boolean(!bl), new Boolean(bl));
        }
    }

    protected void markImportant(String string, boolean bl) {
        CacheReference cacheReference;
        super.markImportant(string, bl);
        if (bl && (cacheReference = this.getCacheReference(string)) != null) {
            cacheReference.markImportant();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CacheHandlerListenerImpl
    implements CacheHandlerListener {
        private CacheHandlerListenerImpl() {
        }

        public void cacheRemoved(CacheHandlerEvent cacheHandlerEvent) {
            this.cacheAdded(cacheHandlerEvent);
        }

        public void statusChanged(CacheHandlerEvent cacheHandlerEvent) {
            FileObject fileObject = JavaCvsFileSystem.this.getFileObjectForFile(new File(cacheHandlerEvent.getCacheFile().getAbsolutePath()));
            if (fileObject == null) {
                return;
            }
            if (!cacheHandlerEvent.isRecursive()) {
                if (fileObject.isFolder()) {
                    HashSet hashSet = new HashSet();
                    Enumeration enumeration = fileObject.getChildren(false);
                    while (enumeration.hasMoreElements()) {
                        hashSet.add(enumeration.nextElement());
                    }
                    JavaCvsFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)JavaCvsFileSystem.this, hashSet, true, true));
                } else {
                    JavaCvsFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)JavaCvsFileSystem.this, fileObject, true, true));
                }
            } else {
                this.cacheAdded(cacheHandlerEvent);
            }
        }

        public void cacheAdded(CacheHandlerEvent cacheHandlerEvent) {
            String string;
            CacheFile cacheFile = cacheHandlerEvent.getCacheFile();
            String string2 = cacheFile.getAbsolutePath();
            if (string2.startsWith(string = JavaCvsFileSystem.this.constructRootDirectory())) {
                FileObject fileObject;
                if (string2.length() > string.length()) {
                    string2 = string2.substring(string.length() + 1, string2.length());
                }
                if ((fileObject = JavaCvsFileSystem.this.findResource(string2 = string2.replace('\\', '/'))) == null) {
                    fileObject = JavaCvsFileSystem.this.findResource("");
                }
                JavaCvsFileSystem.this.refreshExisting(fileObject);
                JavaCvsFileSystem.this.fireFileStatusForExisting(fileObject);
            } else if (string.startsWith(string2)) {
                FileObject fileObject = JavaCvsFileSystem.this.findResource("");
                JavaCvsFileSystem.this.refreshExisting(fileObject);
                JavaCvsFileSystem.this.fireFileStatusForExisting(fileObject);
            }
        }
    }

    private class JavaCvsFOStream
    extends FileOutputStream {
        private File changingFile;
        private boolean closed = false;

        public JavaCvsFOStream(File file) throws IOException {
            super(file);
            this.changingFile = file;
        }

        public void close() throws IOException {
            super.close();
            if (!this.closed) {
                JavaCvsFileSystem.this.cache.fileModified(this.changingFile, true);
                this.closed = true;
            }
        }
    }

    public class ListImpl
    implements AbstractFileSystem.List {
        static final long serialVersionUID = -102893327017356802L;

        public String[] children(String string) {
            if (!JavaCvsFileSystem.this.isRootSet) {
                return null;
            }
            File file = JavaCvsFileSystem.this.getFile(string);
            String[] stringArray = null;
            if (file != null && file.isDirectory() && JavaCvsFileSystem.this.cache != null) {
                stringArray = JavaCvsFileSystem.this.cache.getDirContent(file);
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            int n = 0;
            while (n < stringArray.length) {
                if (JavaCvsFileSystem.this.ignoredRE != null && JavaCvsFileSystem.this.ignoredRE.match(stringArray[n])) {
                    stringArray[n] = null;
                }
                ++n;
            }
            return stringArray;
        }
    }

    public class ChangeImpl
    implements AbstractFileSystem.Change {
        static final long serialVersionUID = 1647280700071658302L;
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;

        public void createFolder(String string) throws IOException {
            File file = JavaCvsFileSystem.this.getFile(string);
            Object[] objectArray = new Object[]{file.getName(), JavaCvsFileSystem.this.getDisplayName(), file.getPath()};
            if (string.equals("")) {
                throw new JavaCvsFileSystemException("cannot create empty name", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_create_empty_name", (Object[])objectArray));
            }
            if (file.exists()) {
                throw new JavaCvsFileSystemException("folder " + file + " already exists", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_folder_already_exists", (Object[])objectArray));
            }
            boolean bl = this.createRecursiveFolder(file);
            if (!bl) {
                throw new JavaCvsFileSystemException("folder " + file + " could not be created", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_folder_could_not_be_created", (Object[])objectArray));
            }
            string = string.replace('\\', '/');
        }

        private boolean createRecursiveFolder(File file) {
            String string;
            if (file.exists()) {
                return true;
            }
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if ((string = file.getParent()) == null) {
                return false;
            }
            if (!this.createRecursiveFolder(new File(string))) {
                return false;
            }
            file.mkdir();
            if (file.exists()) {
                JavaCvsFileSystem.this.cache.addToCache(file);
                return true;
            }
            return false;
        }

        public void createData(String string) throws IOException {
            File file = JavaCvsFileSystem.this.getFile(string);
            if (!file.createNewFile()) {
                throw new JavaCvsFileSystemException("file " + file + " could not be created", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_created", (Object)file.getName(), (Object)JavaCvsFileSystem.this.getDisplayName(), (Object)file.getPath()));
            }
            if (file.exists()) {
                string = string.replace('\\', '/');
            }
        }

        public void rename(String string, String string2) throws IOException {
            File file = JavaCvsFileSystem.this.getFile(string);
            File file2 = JavaCvsFileSystem.this.getFile(string2);
            String string3 = string.replace('\\', '/');
            boolean bl = file2.exists() && !file2.equals(file);
            boolean bl2 = false;
            if (!bl) {
                bl2 = file.renameTo(file2);
                JavaCvsFileSystem.this.handleRename(string, string2);
            }
            if (!bl2 || bl) {
                throw new JavaCvsFileSystemException("file " + file + " could not be renamed to " + file2, NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_renamed", (Object[])new Object[]{file.getName(), file2.getName(), JavaCvsFileSystem.this.getDisplayName(), file.getPath(), file2.getPath()}));
            }
        }

        public void delete(String string) throws IOException {
            File file = JavaCvsFileSystem.this.getFile(string);
            string = string.replace('\\', '/');
            boolean bl = this.deleteFile(file);
            if (bl) {
                StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
                try {
                    Entry entry = standardAdminHandler.getEntry(file);
                    if (entry != null && entry.getRevision() != null && entry.getRevision().equals("0")) {
                        standardAdminHandler.removeEntry(file);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                JavaCvsFileSystem.this.handleDelete(string);
            }
            if (file.exists() && !bl) {
                throw new JavaCvsFileSystemException("file " + file + " could not be deleted", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_deleted", (Object)file.getName(), (Object)JavaCvsFileSystem.this.getDisplayName(), (Object)file.getPath()));
            }
        }

        private boolean deleteFile(File file) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    if (!this.deleteFile(fileArray[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            boolean bl = file.delete();
            return bl;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    protected class InfoImpl
    implements AbstractFileSystem.Info {
        static final long serialVersionUID = -627867218820299311L;
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;

        public boolean folder(String string) {
            return JavaCvsFileSystem.this.getFile(string).isDirectory();
        }

        public Date lastModified(String string) {
            File file = JavaCvsFileSystem.this.getFile(string);
            if (!file.exists()) {
                return new Date(System.currentTimeMillis());
            }
            return new Date(file.lastModified());
        }

        public boolean readOnly(String string) {
            File file = JavaCvsFileSystem.this.getFile(string);
            return file.exists() && !file.canWrite();
        }

        public String mimeType(String string) {
            FileObject fileObject = JavaCvsFileSystem.this.findResource(string);
            String string2 = fileObject != null ? FileUtil.getMIMEType((FileObject)fileObject) : "content/unknown";
            return string2;
        }

        public long size(String string) {
            return JavaCvsFileSystem.this.getFile(string).length();
        }

        public InputStream inputStream(String string) throws FileNotFoundException {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(JavaCvsFileSystem.this.getFile(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                final String string2 = string;
                if (JavaCvsFileSystem.this.errorManager != null) {
                    throw (FileNotFoundException)JavaCvsFileSystem.this.errorManager.annotate((Throwable)new FileNotFoundException(){
                        static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;

                        public String getLocalizedMessage() {
                            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = 1.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)).getString("MSG_FileNotExist"), string2);
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    }, MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = InfoImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)).getString("MSG_FileNotExist"), string2));
                }
                throw new FileNotFoundException(this, string2){
                    static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;
                    private final /* synthetic */ String val$fname;
                    private final /* synthetic */ InfoImpl this$1;
                    {
                        this.this$1 = infoImpl;
                        this.val$fname = string;
                    }

                    public String getLocalizedMessage() {
                        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = 2.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)).getString("MSG_FileNotExist"), this.val$fname);
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                };
            }
            return fileInputStream;
        }

        public OutputStream outputStream(String string) throws IOException {
            File file;
            if (JavaCvsFileSystem.this.isCreateBackups() && JavaCvsFileSystem.this.isImportant(string) && (file = JavaCvsFileSystem.this.getFile(string)) != null && !JavaCvsFileSystem.this.checkVirtual(string) && !string.endsWith("~") && file.length() > 0L) {
                File file2 = JavaCvsFileSystem.this.getFile(string + "~");
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
                ((OutputStream)bufferedOutputStream).flush();
                ((OutputStream)bufferedOutputStream).close();
                ((InputStream)bufferedInputStream).close();
            }
            return new JavaCvsFOStream(JavaCvsFileSystem.this.getFile(string));
        }

        public void lock(String string) throws IOException {
            File file = JavaCvsFileSystem.this.getFile(string);
            if (file.exists() && !file.canWrite()) {
                throw new JavaCvsFileSystemException("file " + file + " could not be locked", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = InfoImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_locked", (Object)file.getName()));
            }
        }

        public void unlock(String string) {
        }

        public void markUnimportant(String string) {
            CacheReference cacheReference = JavaCvsFileSystem.this.getCacheReference(string);
            if (cacheReference != null) {
                cacheReference.markUnimportant();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public class MyStatus
    implements FileSystem.Status,
    Serializable {
        static final long serialVersionUID = 7525827069203814770L;

        public Image annotateIcon(Image image, int n, Set set) {
            Image image2;
            Object[] objectArray = set.toArray();
            int n2 = objectArray.length;
            if (n2 == 0) {
                return image;
            }
            String string = null;
            Vector<String> vector = n2 == 1 ? JavaCvsFileSystem.this.getImportantFiles(objectArray) : JavaCvsFileSystem.this.getImportantFiles(objectArray);
            if (vector.size() == 0) {
                vector = new Vector<String>();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    FileObject fileObject = (FileObject)objectArray[n3];
                    vector.add(fileObject.getPackageNameExt('/', '.'));
                    ++n3;
                }
            }
            if ((string = JavaCvsFileSystem.this.cache.getFileStatusOnly(vector)) != null && (image2 = JavaCvsFileSystem.this.getStatusManager().getIcon(string)) != null) {
                image = Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)8);
            }
            return image;
        }

        public String annotateName(String string, Set set) {
            String string2;
            String string3 = string;
            String string4 = "";
            Object[] objectArray = set.toArray();
            int n = objectArray.length;
            if (n == 0 || string.indexOf(JavaCvsFileSystem.this.getRootDirectory().toString()) >= 0) {
                return string3;
            }
            Vector<String> vector = n == 1 ? JavaCvsFileSystem.this.getImportantFiles(objectArray) : JavaCvsFileSystem.this.getImportantFiles(objectArray);
            if (vector.size() == 0) {
                vector = new Vector<String>();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    FileObject fileObject = (FileObject)objectArray[n2];
                    vector.add(fileObject.getPackageNameExt('/', '.'));
                    ++n2;
                }
            }
            string3 = string2 = JavaCvsFileSystem.this.cache.getStatus(string, vector).trim();
            return string3;
        }
    }
}

