/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.commands;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.add.AddInformation;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.lib.cvsclient.command.remove.RemoveInformation;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.file.FileStatus;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.caching.CvsCacheFile;
import org.netbeans.modules.javacvs.caching.JavaCvsCache;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.util.NbBundle;

public abstract class CacheUpdatingFsCommand
extends FileSystemCommand {
    public static final String UPD_CONFLICT = "C";
    public static final String UPD_MODIFIED = "M";
    public static final String UPD_ADDED = "A";
    public static final String UPD_REMOVE = "R";
    public static final String UPD_UPDATE = "U";
    public static final String UPD_PATCH = "P";
    public static final String UPD_UNKNOWN = "?";
    public static final String UPD_TAG = "T";
    public static final String UPD_DEL_TAG = "D";
    public static final String UPD_MERGED = "G";
    private static final String STATUS_NO_REVISION_CONTROL_FILE = "No revision control file";
    private HashMap dirs = new HashMap();
    private boolean refreshing = false;
    private boolean fullEntriesUpdate;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand;

    public CacheUpdatingFsCommand() {
    }

    public CacheUpdatingFsCommand(ClientProvider clientProvider) {
        this();
        this.setClientProvider(clientProvider);
    }

    public void setRefreshing(boolean bl) {
        this.refreshing = bl;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    protected void updateCache(DefaultFileInfoContainer defaultFileInfoContainer) {
        if (defaultFileInfoContainer == null || defaultFileInfoContainer.getFile() == null) {
            return;
        }
        HashMap hashMap = this.getDirMap(defaultFileInfoContainer.getFile().getParentFile());
        String string = defaultFileInfoContainer.getType();
        String string2 = "";
        if (string.equals(UPD_TAG) || string.equals(UPD_DEL_TAG)) {
            return;
        }
        if (string.equals(UPD_UPDATE) || string.equals(UPD_PATCH)) {
            string2 = "Upd";
        } else if (string.equals(UPD_ADDED)) {
            string2 = "LAdded";
        } else if (string.equals(UPD_REMOVE)) {
            string2 = "LRemoved";
        } else if (string.equals(UPD_MODIFIED)) {
            string2 = "LMod";
        } else if (string.equals(UPD_CONFLICT)) {
            string2 = "Conflict";
        } else if (string.equals(UPD_UNKNOWN)) {
            string2 = "Unknown";
        } else if (string.equals(UPD_MERGED)) {
            string2 = "LMod";
        } else if (string.equals("Y")) {
            string2 = null;
        }
        hashMap.put(defaultFileInfoContainer, string2);
    }

    private HashMap getDirMap(File file) {
        HashMap hashMap = (HashMap)this.dirs.get(file);
        if (hashMap == null) {
            hashMap = new HashMap(20);
            this.dirs.put(file, hashMap);
        }
        return hashMap;
    }

    protected void prepareCache(File[] fileArray, boolean bl) {
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                File file = null;
                file = fileArray[n].isDirectory() ? fileArray[n] : fileArray[n].getParentFile();
                this.createDirMap(file, bl);
                ++n;
            }
        }
    }

    private void createDirMap(File file, boolean bl) {
        File[] fileArray;
        this.getDirMap(file);
        if (bl && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.createDirMap(fileArray[n], bl);
                }
                ++n;
            }
        }
    }

    protected void updateCache(AddInformation addInformation) {
        HashMap hashMap = this.getDirMap(addInformation.getFile().getParentFile());
        if (addInformation.isDirectory()) {
            String string = addInformation.getFile() + File.separator + "CVS" + File.separator + "netbeans.cache";
            File file = new File(string);
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string2 = " ";
            return;
        }
        String string = addInformation.getType();
        String string3 = string.equals(UPD_UPDATE) ? "Upd" : "LAdded";
        hashMap.put(addInformation, string3);
    }

    protected void updateCache(RemoveInformation removeInformation) {
        HashMap hashMap = this.getDirMap(removeInformation.getFile().getParentFile());
        if (removeInformation.isRemoved()) {
            String string = "LRemoved";
            hashMap.put(removeInformation, string);
        }
    }

    protected void updateCache(CommitInformation commitInformation) {
        HashMap hashMap = this.getDirMap(commitInformation.getFile().getParentFile());
        if (commitInformation.getType().equals("Removed")) {
            hashMap.put(commitInformation, null);
        } else {
            String string = "Upd";
            hashMap.put(commitInformation, string);
        }
    }

    protected void updateCache(StatusInformation statusInformation) {
        HashMap hashMap = this.getDirMap(statusInformation.getFile().getParentFile());
        if (STATUS_NO_REVISION_CONTROL_FILE.equals(statusInformation.getRepositoryRevision()) && !FileStatus.ADDED.equals(statusInformation.getStatus())) {
            hashMap.put(statusInformation, JavaCvsStatusManager.convertStatus(FileStatus.UNKNOWN));
            return;
        }
        hashMap.put(statusInformation, JavaCvsStatusManager.convertStatus(statusInformation.getStatus()));
    }

    protected void fireCacheEvents() {
        Object object;
        CacheHandler cacheHandler = CacheHandler.getInstance();
        JavaCvsCache javaCvsCache = (JavaCvsCache)cacheHandler.getCache("javacvs");
        HashSet<Object> hashSet = new HashSet<Object>();
        File[] fileArray = this.getFiles();
        int n = 0;
        while (n < fileArray.length) {
            object = fileArray[n];
            if (object != null) {
                if (((File)object).isDirectory()) {
                    hashSet.add(object);
                } else {
                    hashSet.add(((File)object).getParentFile());
                }
            }
            ++n;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            CacheFile cacheFile = cacheHandler.getCacheFile(file, -1, "javacvs");
            if (cacheFile == null) continue;
            javaCvsCache.fireCacheHandlerEvent(0, cacheFile);
        }
    }

    protected void fireUpdateCache() {
        CacheHandler cacheHandler = CacheHandler.getInstance();
        JavaCvsCache javaCvsCache = (JavaCvsCache)cacheHandler.getCache("javacvs");
        CacheHandler.getInstance().registerCacheType("JavaCvs_Refreshing", (FileSystemCache)new JavaCvsCache());
        TreeSet treeSet = new TreeSet(this.dirs.keySet());
        Iterator iterator = treeSet.iterator();
        StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
        while (iterator.hasNext()) {
            Object object;
            FileInfoContainer fileInfoContainer;
            File file = (File)iterator.next();
            if (file == null) continue;
            CvsCacheDir cvsCacheDir = new CvsCacheDir("JavaCvs_Refreshing", file);
            if (!this.isRefreshing()) {
                boolean bl = cvsCacheDir.readFromDisk();
            }
            Entry[] entryArray = null;
            try {
                entryArray = standardAdminHandler.getEntriesAsArray(file);
                if (this.isFullEntriesUpdate()) {
                    this.updateFromEntries(file, entryArray, cvsCacheDir);
                }
            }
            catch (IOException iOException) {
                entryArray = new Entry[]{};
            }
            HashMap hashMap = (HashMap)this.dirs.get(file);
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string;
                fileInfoContainer = (FileInfoContainer)iterator2.next();
                object = (CvsCacheFile)cvsCacheDir.getFile(fileInfoContainer.getFile().getName());
                if (object != null) {
                    string = (String)hashMap.get(fileInfoContainer);
                    object.setStatusNonModifying(string);
                    this.applyInfo((CacheFile)object, fileInfoContainer, entryArray);
                    if (string != null) continue;
                    cvsCacheDir.removeFile(fileInfoContainer.getFile().getName(), false);
                    CacheFile cacheFile = CacheHandler.getInstance().getCacheFile(file, -1, "javacvs");
                    if (cacheFile == null || !(cacheFile instanceof CvsCacheDir)) continue;
                    CvsCacheDir cvsCacheDir2 = (CvsCacheDir)cacheFile;
                    cvsCacheDir2.removeFile(fileInfoContainer.getFile().getName(), false);
                    continue;
                }
                object = new CvsCacheFile("JavaCvs_Refreshing", fileInfoContainer.getFile().getName());
                string = (String)hashMap.get(fileInfoContainer);
                if (object == null || string == null) continue;
                cvsCacheDir.addFile((CacheFile)object, false);
                object.setStatusNonModifying(string);
                this.applyInfo((CacheFile)object, fileInfoContainer, entryArray);
            }
            cvsCacheDir.setAppliedLevel(3);
            cvsCacheDir.simpleWriteToDisk();
            fileInfoContainer = cacheHandler.getCacheFile(file, -1, "javacvs");
            if (fileInfoContainer == null || !(fileInfoContainer instanceof CvsCacheDir) || (object = (CvsCacheDir)((Object)fileInfoContainer)).getAppliedLevel() < 0) continue;
            object.setAppliedLevel(0);
        }
        this.dirs = new HashMap();
        this.fireCacheEvents();
    }

    protected void updateFromEntries(File file, Entry[] entryArray, CvsCacheDir cvsCacheDir) {
        if (entryArray != null) {
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                if (!entry.isDirectory()) {
                    CvsCacheFile cvsCacheFile = (CvsCacheFile)cvsCacheDir.getFile(entry.getName());
                    if (cvsCacheFile == null) {
                        cvsCacheFile = new CvsCacheFile("JavaCvs_Refreshing", entry.getName());
                        cvsCacheDir.addFile(cvsCacheFile, false);
                    }
                    cvsCacheFile.setRevision(entry.getRevision());
                    cvsCacheFile.setSticky(entry.getStickyInformation());
                    if (!this.isRefreshing() && cvsCacheFile.getStatus() == null || cvsCacheFile.getStatus().equals("Local")) {
                        if (cvsCacheFile.getRevision().startsWith("-")) {
                            cvsCacheFile.setStatusNonModifying("LRemoved");
                        } else if (cvsCacheFile.getRevision().equals("0")) {
                            cvsCacheFile.setStatusNonModifying("LAdded");
                        } else if (entry.getLastModified() != null) {
                            long l = entry.getLastModified().getTime() / 1000L;
                            File file2 = new File(cvsCacheFile.getAbsolutePath());
                            if (!file2.exists()) {
                                cvsCacheFile.setStatusNonModifying("NCheckout");
                            } else {
                                long l2 = file2.lastModified() / 1000L;
                                if (l == l2) {
                                    cvsCacheFile.setStatusNonModifying("Upd");
                                } else {
                                    cvsCacheFile.setStatusNonModifying("LMod");
                                }
                            }
                        }
                    }
                }
                ++n;
            }
        }
    }

    private void applyInfo(CacheFile cacheFile, FileInfoContainer fileInfoContainer, Entry[] entryArray) {
        if (fileInfoContainer instanceof StatusInformation) {
            this.applyInfo(cacheFile, (StatusInformation)fileInfoContainer, entryArray);
            return;
        }
        if (fileInfoContainer.getClass().equals(class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer == null ? (class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer = CacheUpdatingFsCommand.class$("org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer")) : class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer)) {
            this.applyInfo(cacheFile, (DefaultFileInfoContainer)fileInfoContainer, entryArray);
            return;
        }
        if (fileInfoContainer instanceof CommitInformation) {
            this.applyInfo(cacheFile, (CommitInformation)fileInfoContainer, entryArray);
            return;
        }
        if (fileInfoContainer instanceof AddInformation) {
            this.applyInfo(cacheFile, (AddInformation)fileInfoContainer, entryArray);
            return;
        }
        if (fileInfoContainer instanceof RemoveInformation) {
            this.applyInfo(cacheFile, (RemoveInformation)fileInfoContainer, entryArray);
            return;
        }
    }

    private void applyInfo(CacheFile cacheFile, DefaultFileInfoContainer defaultFileInfoContainer, Entry[] entryArray) {
        Entry entry = null;
        int n = 0;
        while (n < entryArray.length) {
            if (cacheFile.getName().equals(entryArray[n].getName())) {
                entry = entryArray[n];
                break;
            }
            ++n;
        }
        if (entry != null) {
            cacheFile.setRevision(entry.getRevision());
            cacheFile.setSticky(entry.getStickyInformation());
        }
    }

    private void applyInfo(CacheFile cacheFile, AddInformation addInformation, Entry[] entryArray) {
        if (addInformation.isDirectory()) {
            return;
        }
        if (addInformation.getType().equals(UPD_ADDED)) {
            cacheFile.setRevision(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand == null ? (class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand = CacheUpdatingFsCommand.class$("org.netbeans.modules.javacvs.commands.CacheUpdatingFsCommand")) : class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand)).getString("CacheUpdatingFsCommand.newRevision"));
            return;
        }
        if (addInformation.getType().equals(UPD_MODIFIED)) {
            ((CvsCacheFile)cacheFile).setStatusNonModifying("LMod");
        }
        Entry entry = null;
        int n = 0;
        while (n < entryArray.length) {
            if (cacheFile.getName().equals(entryArray[n].getName())) {
                entry = entryArray[n];
                break;
            }
            ++n;
        }
        if (entry != null) {
            cacheFile.setRevision(entry.getRevision());
            cacheFile.setSticky(entry.getStickyInformation());
        }
    }

    private void applyInfo(CacheFile cacheFile, RemoveInformation removeInformation, Entry[] entryArray) {
        if (!(cacheFile instanceof CacheDir)) {
            Entry entry = null;
            int n = 0;
            while (n < entryArray.length) {
                if (cacheFile.getName().equals(entryArray[n].getName())) {
                    entry = entryArray[n];
                    break;
                }
                ++n;
            }
            if (entry != null) {
                cacheFile.setRevision(entry.getRevision());
            } else {
                cacheFile.setRevision("-");
            }
        }
    }

    private void applyInfo(CacheFile cacheFile, CommitInformation commitInformation, Entry[] entryArray) {
        cacheFile.setRevision(commitInformation.getRevision());
        Entry entry = null;
        if (commitInformation.getRevision().lastIndexOf(46) > 1) {
            int n = 0;
            while (n < entryArray.length) {
                if (cacheFile.getName().equals(entryArray[n].getName())) {
                    entry = entryArray[n];
                    if (entry.getStickyInformation() == null) break;
                    cacheFile.setSticky(entry.getStickyInformation());
                    break;
                }
                ++n;
            }
        }
    }

    private void applyInfo(CacheFile cacheFile, StatusInformation statusInformation, Entry[] entryArray) {
        String string;
        String string2 = statusInformation.getWorkingRevision();
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        cacheFile.setRevision(string2);
        if (string2 != null) {
            if ("New file!".equals(string2)) {
                cacheFile.setRevision(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand == null ? (class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand = CacheUpdatingFsCommand.class$("org.netbeans.modules.javacvs.commands.CacheUpdatingFsCommand")) : class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand)).getString("CacheUpdatingFsCommand.newRevision"));
            }
            if (string2.startsWith("No entry")) {
                cacheFile.setRevision(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand == null ? (class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand = CacheUpdatingFsCommand.class$("org.netbeans.modules.javacvs.commands.CacheUpdatingFsCommand")) : class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand)).getString("CacheUpdatingFsCommand.noWorkingEntry"));
            }
        }
        if ((string = statusInformation.getStickyTag()) != null && !string.equals("(none)")) {
            int n;
            if (string.charAt(0) == '(' && string.charAt(string.length()) == ')') {
                string = string.substring(1, string.length() - 1);
            }
            if ((n = string.indexOf(40)) > 0) {
                string = string.substring(0, n - 1);
            }
            cacheFile.setSticky(string);
        }
        if ((string = statusInformation.getStickyDate()) != null && !string.equals("(none)")) {
            if (string.charAt(0) == '(' && string.charAt(string.length()) == ')') {
                string = string.substring(1, string.length() - 1);
            }
            cacheFile.setSticky(string);
        }
    }

    public boolean isFullEntriesUpdate() {
        return this.fullEntriesUpdate;
    }

    public void setFullEntriesUpdate(boolean bl) {
        this.fullEntriesUpdate = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

