/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.commands;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.javacvs.CvsCommand;
import org.netbeans.modules.javacvs.commands.ClientCreationException;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.events.AfterEachCommandDisplayerEvent;
import org.netbeans.modules.javacvs.events.BeforeEachCommandDisplayerEvent;
import org.netbeans.modules.javacvs.events.CommandDisplayerEvent;
import org.netbeans.modules.javacvs.events.CommandDisplayerListener;
import org.netbeans.modules.javacvs.events.CommandErrorEvent;
import org.netbeans.modules.javacvs.events.CommandErrorListener;
import org.netbeans.modules.javacvs.events.FailedDisplayerEvent;
import org.netbeans.modules.javacvs.events.FinishDisplayerEvent;
import org.netbeans.modules.javacvs.events.InfoGeneratedDisplayerEvent;
import org.netbeans.modules.javacvs.events.MessageGeneratedDisplayerEvent;
import org.netbeans.modules.javacvs.events.ServerErrorException;
import org.netbeans.modules.javacvs.events.StartDisplayerEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public abstract class FileSystemCommand
extends CVSAdapter
implements Runnable,
Cloneable {
    private LinkedList stdErrList;
    private LinkedList stdOutList;
    private Thread thread;
    protected Client libClient;
    protected GlobalOptions globalOptions;
    private EventManager eventManager;
    private boolean dispWasSet;
    private String root;
    private Command currCommand;
    private ArrayList errListeners;
    private boolean stopCommand;
    private File[] files;
    private Object[] paramOptions;
    private Object[] paramClosingOptions;
    private boolean defaultSettings;
    private boolean serverError = false;
    protected Vector toDoCommands;
    private boolean running;
    private ClientProvider provider;
    private CommandDisplayerListener[] displayListeners;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$FileSystemCommand;

    public FileSystemCommand() {
        this.initInternals();
        this.initializeCommandList();
    }

    public FileSystemCommand(ClientProvider clientProvider) {
        this();
        this.setClientProvider(clientProvider);
    }

    private void initInternals() {
        this.setRunning(false);
        this.stopCommand = false;
        this.thread = null;
        this.serverError = false;
        this.setFiles(null);
    }

    public Object clone() throws CloneNotSupportedException {
        FileSystemCommand fileSystemCommand = (FileSystemCommand)super.clone();
        fileSystemCommand.initInternals();
        return fileSystemCommand;
    }

    public CvsCommand getImpl() {
        return new CvsCommand();
    }

    public void setClientProvider(ClientProvider clientProvider) {
        this.provider = clientProvider;
        this.setGlobalOptions(this.provider.getGlobalOptions());
    }

    public void setFiles(File[] fileArray) {
        this.files = fileArray;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFileObjects(FileObject[] fileObjectArray) {
        this.setFiles(this.convertFileObjects(fileObjectArray));
    }

    public synchronized void stopCommand() {
        this.stopCommand = true;
    }

    public synchronized void hardCommandStop() {
        this.libClient.abort();
        this.stopCommand = true;
    }

    public synchronized boolean isStopped() {
        return this.stopCommand;
    }

    public ClientProvider getClientProvider() {
        return this.provider;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        this.globalOptions = globalOptions;
    }

    public GlobalOptions getGlobalOptions() {
        return this.globalOptions;
    }

    private EventManager getEventManager() throws ClientCreationException {
        if (this.libClient == null) {
            this.libClient = this.createClient();
        }
        return this.libClient.getEventManager();
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setRunning(boolean bl) {
        if (!bl) {
            if (this.errListeners != null) {
                this.errListeners.clear();
            }
            if (this.displayListeners != null) {
                this.displayListeners = null;
            }
            if (this.libClient != null) {
                try {
                    Connection connection = this.libClient.getConnection();
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.libClient = null;
            }
            if (this.eventManager != null) {
                this.eventManager.removeCVSListener(this);
                this.eventManager = null;
            }
            if (this.toDoCommands != null) {
                this.toDoCommands.clear();
                this.toDoCommands = null;
            }
        }
        this.running = bl;
    }

    protected Command getCurrentCommand() {
        return this.currCommand;
    }

    private void setCurrentCommand(Command command) {
        this.currCommand = command;
    }

    protected Command loadCommand(Class clazz) {
        Command command = null;
        try {
            command = (Command)clazz.newInstance();
            return command;
        }
        catch (Exception exception) {
            return command;
        }
    }

    public void startCommand() {
        this.setRunning(true);
        this.thread = new Thread((Runnable)this, "JavaCvsFileSystem.CVSCommand");
        this.thread.start();
    }

    public abstract String getName();

    protected void initializeCommandList() {
        this.toDoCommands = new Vector(2);
    }

    protected void clearCommandList() {
        this.toDoCommands.clear();
    }

    protected void initCommand(boolean bl) {
        this.fireDisplayerEvent(new StartDisplayerEvent(this));
    }

    protected void finishedCommand() {
        this.fireDisplayerEvent(new FinishDisplayerEvent(this));
    }

    protected void beforeEachExecute() {
        this.fireDisplayerEvent(new BeforeEachCommandDisplayerEvent(this, this.getCurrentCommand()));
    }

    protected void afterEachExecute() {
        this.fireDisplayerEvent(new AfterEachCommandDisplayerEvent(this));
    }

    protected void executeFailed(Exception exception) {
        this.fireDisplayerEvent(new FailedDisplayerEvent(this, exception));
    }

    public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
        FileInfoContainer fileInfoContainer = fileInfoEvent.getInfoContainer();
        this.fireDisplayerEvent(new InfoGeneratedDisplayerEvent(this, fileInfoContainer));
    }

    private Client createClient() throws ClientCreationException {
        ClientProvider clientProvider = this.getClientProvider();
        if (clientProvider == null) {
            throw new ClientCreationException("", NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$FileSystemCommand == null ? (class$org$netbeans$modules$javacvs$commands$FileSystemCommand = FileSystemCommand.class$("org.netbeans.modules.javacvs.commands.FileSystemCommand")) : class$org$netbeans$modules$javacvs$commands$FileSystemCommand)).getString("FileSystemCommand.noClientAvailable"));
        }
        return clientProvider.createClient(clientProvider.getCvsRootString());
    }

    public void run() {
        try {
            if (this.libClient == null) {
                this.libClient = this.createClient();
            }
            this.eventManager = this.libClient.getEventManager();
        }
        catch (ClientCreationException clientCreationException) {
            this.executeFailed(clientCreationException);
            this.fireCommandErrorListener(true);
            this.setRunning(false);
            return;
        }
        this.eventManager.addCVSListener(this);
        this.initCommand(true);
        if (this.isStopped()) {
            this.executeFailed(null);
            this.fireCommandErrorListener(true);
            this.setRunning(false);
            return;
        }
        Iterator iterator = ((AbstractList)this.toDoCommands).iterator();
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            this.setCurrentCommand(command);
            this.beforeEachExecute();
            if (this.isStopped()) {
                this.executeFailed(null);
                this.fireCommandErrorListener(true);
                this.setRunning(false);
                return;
            }
            try {
                this.provider.openConnection(this.libClient, this.provider.getCvsRootString());
                this.libClient.executeCommand(command, this.globalOptions);
                this.libClient.getConnection().close();
                if (this.serverError) {
                    throw new ServerErrorException();
                }
            }
            catch (Exception exception) {
                this.executeFailed(exception);
                this.fireCommandErrorListener(true);
                this.stopCommand();
                this.setRunning(false);
                return;
            }
            this.afterEachExecute();
            if (!this.isStopped()) continue;
            this.executeFailed(null);
            this.fireCommandErrorListener(true);
            this.setRunning(false);
            return;
        }
        this.finishedCommand();
        this.setRunning(false);
    }

    public void addCommandErrorListener(CommandErrorListener commandErrorListener) {
        if (this.errListeners == null) {
            this.errListeners = new ArrayList();
        }
        this.errListeners.add(commandErrorListener);
    }

    public void removeCommandErrorListener(CommandErrorListener commandErrorListener) {
        if (this.errListeners != null) {
            ((AbstractCollection)this.errListeners).remove(commandErrorListener);
        }
    }

    private void fireCommandErrorListener(boolean bl) {
        ArrayList arrayList;
        FileSystemCommand fileSystemCommand = this;
        synchronized (fileSystemCommand) {
            if (this.errListeners == null) {
                return;
            }
            arrayList = (ArrayList)this.errListeners.clone();
        }
        CommandErrorEvent commandErrorEvent = new CommandErrorEvent(this, bl);
        int n = 0;
        while (n < arrayList.size()) {
            ((CommandErrorListener)arrayList.get(n)).errorGenerated(commandErrorEvent);
            ++n;
        }
    }

    public void messageSent(MessageEvent messageEvent) {
        this.fireDisplayerEvent(new MessageGeneratedDisplayerEvent(this, messageEvent));
    }

    public synchronized void addDisplayerListener(CommandDisplayerListener commandDisplayerListener) {
        if (this.displayListeners == null || this.displayListeners.length == 0) {
            this.displayListeners = new CommandDisplayerListener[1];
        } else {
            CommandDisplayerListener[] commandDisplayerListenerArray = new CommandDisplayerListener[this.displayListeners.length + 1];
            int n = 0;
            while (n < this.displayListeners.length) {
                commandDisplayerListenerArray[n] = this.displayListeners[n];
                ++n;
            }
            this.displayListeners = commandDisplayerListenerArray;
        }
        this.displayListeners[this.displayListeners.length - 1] = commandDisplayerListener;
    }

    public synchronized void removeDisplayerListener(CommandDisplayerListener commandDisplayerListener) {
        if (this.displayListeners.length == 1) {
            this.displayListeners = null;
        } else {
            CommandDisplayerListener[] commandDisplayerListenerArray = new CommandDisplayerListener[this.displayListeners.length - 1];
            int n = 0;
            while (n < commandDisplayerListenerArray.length) {
                if (this.displayListeners[n] == commandDisplayerListener) {
                    int n2 = n + 1;
                    while (n2 < this.displayListeners.length) {
                        commandDisplayerListenerArray[n2 - 1] = this.displayListeners[n2];
                        ++n2;
                    }
                    break;
                }
                commandDisplayerListenerArray[n] = this.displayListeners[n];
                ++n;
            }
            this.displayListeners = commandDisplayerListenerArray;
        }
    }

    private void fireDisplayerEvent(CommandDisplayerEvent commandDisplayerEvent) {
        if (this.displayListeners == null || this.displayListeners.length == 0) {
            return;
        }
        CommandDisplayerListener[] commandDisplayerListenerArray = null;
        CommandDisplayerListener[] commandDisplayerListenerArray2 = this.displayListeners;
        synchronized (commandDisplayerListenerArray2) {
            commandDisplayerListenerArray = new CommandDisplayerListener[this.displayListeners.length];
            System.arraycopy(this.displayListeners, 0, commandDisplayerListenerArray, 0, commandDisplayerListenerArray.length);
        }
        int n = 0;
        while (n < commandDisplayerListenerArray.length) {
            commandDisplayerEvent.fireEvent(commandDisplayerListenerArray[n]);
            ++n;
        }
    }

    public boolean setCommandArguments(Command command) {
        boolean bl = true;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getImpl().getClass());
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                Method method3 = null;
                Object object = null;
                try {
                    method3 = command.getClass().getMethod(method2.getName(), method2.getParameterTypes());
                    object = method.invoke((Object)this.getImpl(), null);
                    if (method3 != null) {
                        method3.invoke((Object)command, object);
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean getCommandArguments(Command command) {
        boolean bl = true;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getImpl().getClass());
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                Method method3 = null;
                try {
                    method3 = command.getClass().getMethod(method.getName(), method.getParameterTypes());
                    Object object = method3.invoke((Object)command, null);
                    method2.invoke((Object)this.getImpl(), object);
                }
                catch (Exception exception) {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    protected abstract Class getMainCvsCommand();

    public String getCVSArguments() {
        Command command = this.loadCommand(this.getMainCvsCommand());
        boolean bl = this.setCommandArguments(command);
        return command.getCVSArguments();
    }

    public String getCVSCommand() {
        Command command = this.loadCommand(this.getMainCvsCommand());
        boolean bl = this.setCommandArguments(command);
        return command.getCVSCommand();
    }

    public void clearAllSwitches() {
        Command command = this.loadCommand(this.getMainCvsCommand());
        command.resetCVSCommand();
        this.getCommandArguments(command);
    }

    public boolean copySwitchesFrom(FileSystemCommand fileSystemCommand) {
        boolean bl = false;
        if (!fileSystemCommand.getClass().equals(this.getClass())) {
            return bl;
        }
        Command command = this.loadCommand(this.getMainCvsCommand());
        bl = fileSystemCommand.setCommandArguments(command);
        if (!bl) {
            return bl;
        }
        bl = this.getCommandArguments(command);
        return bl;
    }

    public String getCVSEquivalent() {
        if (this.isRunning()) {
            return "";
        }
        this.initCommand(false);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.toDoCommands).iterator();
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            stringBuffer.append("cvs " + this.getGlobalOptions().getCVSCommand() + " ");
            String string = command.getCVSCommand();
            string = string.replace('\n', ' ');
            stringBuffer.append(string + "\n");
        }
        this.clearCommandList();
        return stringBuffer.toString();
    }

    public String getCvsrcEntry() {
        Command command = this.loadCommand(this.getMainCvsCommand());
        boolean bl = this.setCommandArguments(command);
        if (bl) {
            return command.getCVSCommand();
        }
        return "";
    }

    public void parseCvsArguments(String string) {
        Object object;
        String string2;
        String[] stringArray;
        Command command = this.loadCommand(this.getMainCvsCommand());
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        boolean bl = false;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.equals("\"")) {
                string2 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).equals("\"")) break;
                    string2 = string2 + (String)object;
                }
                linkedList.add(string2);
                continue;
            }
            if (stringArray.equals(" ")) continue;
            linkedList.add(stringArray);
        }
        stringArray = new String[linkedList.size()];
        stringArray = linkedList.toArray(stringArray);
        command.resetCVSCommand();
        string2 = command.getOptString();
        object = new GetOpt(stringArray, string2);
        int n = -1;
        ((GetOpt)object).optIndexSet(0);
        boolean bl2 = false;
        while ((n = ((GetOpt)object).getopt()) != -1) {
            boolean bl3 = command.setCVSCommand((char)n, ((GetOpt)object).optArgGet());
        }
        this.getCommandArguments(command);
    }

    protected File[] convertFileObjects(FileObject[] fileObjectArray) {
        if (fileObjectArray == null) {
            return null;
        }
        File[] fileArray = new File[fileObjectArray.length];
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject = fileObjectArray[n];
            File file = FileSystemCommand.toFile(fileObject);
            if (file != null) {
                fileArray[n] = file;
            }
            ++n;
        }
        return fileArray;
    }

    public static File toFile(FileObject fileObject) {
        String string = fileObject.getPackageNameExt(File.separatorChar, '.');
        final class Env
        extends FileSystem.Environment {
            public File found;
            private final /* synthetic */ String val$pne;

            Env(String string) {
                this.val$pne = string;
            }

            public void addClassPath(String string) {
                File file;
                if (this.found != null) {
                    return;
                }
                File file2 = new File(string);
                if (!file2.isDirectory()) {
                    return;
                }
                this.found = file = new File(file2, this.val$pne);
            }
        }
        Env env = new Env(string);
        try {
            fileObject.getFileSystem().prepareEnvironment((FileSystem.Environment)env);
            return env.found;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        super.commandTerminated(terminationEvent);
        this.serverError = terminationEvent.isError();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

