/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.util.MultilinePanel;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;

final class FixActionImpl {
    private final JPDADebugger session;
    private final Method redefineClassesMethod;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$com$sun$jdi$VirtualMachine;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

    FixActionImpl(JPDADebugger jPDADebugger) throws NoSuchMethodException {
        this.session = jPDADebugger;
        this.redefineClassesMethod = (class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = FixActionImpl.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine).getMethod("redefineClasses", class$java$util$Map == null ? (class$java$util$Map = FixActionImpl.class$("java.util.Map")) : class$java$util$Map);
    }

    private boolean compile(DataObject dataObject) {
        CompilerCookie compilerCookie = (CompilerCookie)dataObject.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = FixActionImpl.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (compilerCookie != null) {
            return AbstractCompileAction.compile(Collections.enumeration(Collections.singleton(compilerCookie)), (String)JPDADebugger.getLocString("MSG_Compile_before_fix"));
        }
        return true;
    }

    private List getClassFiles(DataObject dataObject) {
        Set set = dataObject.files();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (!fileObject.getExt().equals("class")) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    private Map loadBytecodes(List list) {
        String string = null;
        try {
            HashMap<ReferenceType, byte[]> hashMap = new HashMap<ReferenceType, byte[]>((int)((double)list.size() * 1.5), 0.75f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                string = fileObject.getPackageName('/');
                byte[] byArray = null;
                List<ReferenceType> list2 = this.session.virtualMachine.classesByName(string);
                int n = list2.size();
                if (n == 0) continue;
                InputStream inputStream = fileObject.getInputStream();
                long l = fileObject.getSize();
                if (l > Integer.MAX_VALUE) {
                    throw new RuntimeException("File too large: " + fileObject);
                }
                byArray = new byte[(int)l];
                inputStream.read(byArray);
                if (n == 1) {
                    hashMap.put(list2.get(0), byArray);
                    continue;
                }
                Iterator<ReferenceType> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    hashMap.put(iterator2.next(), byArray);
                }
            }
            return hashMap;
        }
        catch (IOException iOException) {
            String string2 = JPDADebugger.getLocString("EXC_Could_not_read_class_file");
            String string3 = MessageFormat.format(string2, string);
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 0));
            return null;
        }
    }

    private boolean redefineClasses(Map map) {
        try {
            this.redefineClassesMethod.invoke((Object)this.session.virtualMachine, map);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof UnsupportedOperationException) {
                String string = JPDADebugger.getLocString("MSG_Unsupported_class_definition_changes");
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)new MultilinePanel(string), 0));
            } else {
                String string = JPDADebugger.getLocString("EXC_Cannot_redefine_class");
                ErrorManager.getDefault().annotate(throwable, string);
                ErrorManager.getDefault().notify(256, throwable);
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(4096, (Throwable)illegalAccessException);
            return false;
        }
    }

    private ReferenceType getTopmostFrameRefType() {
        if (!this.session.currentThread.isSuspended()) {
            return null;
        }
        try {
            StackFrame stackFrame = this.session.currentThread.getThreadReference().frame(0);
            return stackFrame.location().declaringType();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return null;
        }
    }

    private void warnTopmostFrameRedefined() {
        String string = JPDADebugger.getLocString("MSG_Old_frame_on_stack_title");
        String string2 = JPDADebugger.getLocString("MSG_Old_frame_on_stack");
        String string3 = JPDADebugger.getLocString("MSG_Old_frame_on_stack_pop_frame");
        String string4 = JPDADebugger.getLocString("MSG_Old_frame_on_stack_leave_frame");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new MultilinePanel(string, string2), string, true, new Object[]{string3, string4}, (Object)string3, 0, new HelpCtx("NetbeansDebuggerJPDAPopOldFrame"), null);
        dialogDescriptor.setClosingOptions(null);
        dialogDescriptor.setMessageType(2);
        Object object = TopManager.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == string3) {
            this.session.popTopmostFrame();
        }
    }

    void fix() {
        ReferenceType referenceType;
        boolean bl;
        DataObject dataObject = this.session.dataObjectToFix;
        if (dataObject == null) {
            throw new IllegalStateException();
        }
        if (!this.compile(dataObject)) {
            return;
        }
        List list = this.getClassFiles(dataObject);
        if (list.isEmpty()) {
            String string = JPDADebugger.getLocString("MSG_no_class_files_found");
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            return;
        }
        Map map = this.loadBytecodes(list);
        if (map == null) {
            return;
        }
        if (map.isEmpty()) {
            this.session.getIOManager().println(JPDADebugger.getLocString("MSG_No_class_redefined"));
            return;
        }
        boolean bl2 = bl = this.session.getState() == 3;
        if (bl) {
            this.session.setSuspended(true);
        }
        boolean bl3 = this.session.canPopFrames() && this.session.currentThread.isSuspended() && this.session.currentThread.getStackDepth() > 1;
        ReferenceType referenceType2 = referenceType = bl3 ? this.getTopmostFrameRefType() : null;
        if (!this.redefineClasses(map)) {
            return;
        }
        Set set = map.keySet();
        Breakpoint[] breakpointArray = set.iterator();
        String string = ((ReferenceType)breakpointArray.next()).name();
        int n = string.indexOf(46);
        String string2 = n == -1 ? null : string.substring(0, n + 1);
        IOManager iOManager = this.session.getIOManager();
        iOManager.println(JPDADebugger.getLocString("MSG_Redefined_classes"));
        iOManager.print("   ", 1);
        iOManager.println(string);
        while (breakpointArray.hasNext()) {
            iOManager.print("   ", 1);
            iOManager.println(((ReferenceType)breakpointArray.next()).name());
        }
        if (bl3 && set.contains(referenceType)) {
            this.warnTopmostFrameRedefined();
        }
        try {
            breakpointArray = this.session.getBreakpoints();
            int n2 = 0;
            while (n2 < breakpointArray.length) {
                Breakpoint breakpoint = breakpointArray[n2];
                iOManager = ((CoreBreakpoint)breakpointArray[n2]).getEvent((Debugger)this.session);
                if (iOManager instanceof LineBreakpoint) {
                    ((LineBreakpoint)iOManager).refreshAfterFix(set, string2);
                } else if (iOManager instanceof MethodBreakpoint) {
                    ((MethodBreakpoint)iOManager).refreshAfterFix(set, string2);
                }
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            ErrorManager.getDefault().notify(4096, (Throwable)classCastException);
        }
        if (bl) {
            this.session.resume();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

