/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.lang.reflect.Modifier;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class InstanceField
extends JPDAVariable {
    private ObjectReference instance;
    private Field field;

    InstanceField(JPDADebugger jPDADebugger, ObjectReference objectReference, Field field) {
        super(jPDADebugger, true);
        this.name = field.name();
        this.instance = objectReference;
        this.field = field;
        try {
            this.setRemoteValue(objectReference.getValue(field));
            this.modifiers = Modifier.toString(field.modifiers());
            this.type = field.typeName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    public void validate() {
        if (this.isCloned) {
            if (this.isObject) {
                this.value = this.value.toString();
            }
        } else {
            try {
                this.setRemoteValue(this.instance.getValue(this.field));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
        }
        this.firePropertyChange();
    }

    protected boolean setValue(final Value value) {
        try {
            new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    InstanceField.this.instance.setValue(InstanceField.this.field, value);
                    return null;
                }
            }.throwAndWait(null);
        }
        catch (InvalidTypeException invalidTypeException) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception exception) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

