/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class LocalVariable
extends JPDAVariable {
    private ThreadReference thread = null;
    private int callStackIndex;
    private com.sun.jdi.LocalVariable lv;

    LocalVariable(JPDADebugger jPDADebugger, ThreadReference threadReference, int n, com.sun.jdi.LocalVariable localVariable) {
        super(jPDADebugger, true);
        this.thread = threadReference;
        this.callStackIndex = n;
        this.lv = localVariable;
        this.name = localVariable.name();
        this.type = localVariable.typeName();
        try {
            this.setRemoteValue(threadReference.frame(n).getValue(localVariable));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            // empty catch block
        }
        this.modifiers = "";
        this.update();
    }

    public void validate() {
        if (this.isCloned) {
            if (this.isObject) {
                this.value = this.remoteValue.toString();
            }
        } else {
            try {
                this.setRemoteValue(this.thread.frame(this.callStackIndex).getValue(this.lv));
                this.type = this.lv.typeName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
        }
        this.firePropertyChange();
    }

    protected boolean setValue(final Value value) {
        try {
            new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    StackFrame stackFrame = LocalVariable.this.thread.frame(LocalVariable.this.callStackIndex);
                    stackFrame.setValue(LocalVariable.this.lv, value);
                    return null;
                }
            }.throwAndWait(null);
        }
        catch (InvalidTypeException invalidTypeException) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception exception) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

