/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.lang.reflect.Modifier;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class StaticField
extends JPDAVariable {
    private ReferenceType parentClass;
    private Field field;

    StaticField(JPDADebugger jPDADebugger, ReferenceType referenceType, Field field) {
        super(jPDADebugger, true);
        this.name = field.name();
        this.field = field;
        this.parentClass = referenceType;
        try {
            this.setRemoteValue(referenceType.getValue(field));
            this.modifiers = Modifier.toString(field.modifiers());
            this.type = field.typeName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    public void validate() {
        if (this.isCloned) {
            if (this.isObject) {
                this.value = this.remoteValue.toString();
            }
        } else {
            try {
                this.setRemoteValue(this.parentClass.getValue(this.field));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
        }
        this.firePropertyChange();
    }

    protected boolean setValue(final Value value) {
        if (!(this.parentClass instanceof ClassType)) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        try {
            new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    ((ClassType)StaticField.this.parentClass).setValue(StaticField.this.field, value);
                    return null;
                }
            }.throwAndWait(null);
        }
        catch (InvalidTypeException invalidTypeException) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception exception) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

