/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.ThreadBreakpointPanel;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.debugger.Debugger;
import org.openide.explorer.propertysheet.editors.ChoicePropertyEditor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;

public class ThreadBreakpoint
extends CoreBreakpoint.Event
implements Executor,
StopEvent,
InfoProducer,
CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = -5603544771083816554L;
    public static final String PROP_TYPE = "type";
    public static final int TYPE_START = 1;
    public static final int TYPE_DEATH = 2;
    public static final String TYPE_NAME = "java-thread";
    private transient ThreadReference thread;
    private StepManager.Requestor requestor;
    private int type = 1;
    private transient String action;
    private transient CoreBreakpoint.Action[] actions;

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debugger;
        if (jPDADebugger.virtualMachine == null || jPDADebugger.isDisconnected()) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = jPDADebugger.getStepManager().new StepManager.Requestor(this);
        }
        try {
            EventRequest eventRequest;
            this.requestor.removeRequests();
            if ((this.type & 1) != 0) {
                eventRequest = jPDADebugger.getRequestManager().createThreadStartRequest();
                eventRequest.setSuspendPolicy(2);
                this.requestor.add(eventRequest);
                eventRequest.enable();
            }
            if ((this.type & 2) != 0) {
                eventRequest = jPDADebugger.getRequestManager().createThreadDeathRequest();
                eventRequest.setSuspendPolicy(2);
                this.requestor.add(eventRequest);
                eventRequest.enable();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return true;
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{new PropertySupport.ReadWrite(PROP_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_breakpoint_type"), JPDADebugger.getLocString("HINT_breakpoint_type")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(ThreadBreakpoint.this.getType());
            }

            public void setValue(Object object) throws IllegalArgumentException {
                if (!(object instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                ThreadBreakpoint.this.setType((Integer)object);
            }

            public PropertyEditor getPropertyEditor() {
                return new ChoicePropertyEditor(new int[]{1, 2, 3}, new String[]{JPDADebugger.getLocString("CTL_Property_type_start_name"), JPDADebugger.getLocString("CTL_Property_type_death_name"), JPDADebugger.getLocString("CTL_Property_type_both_name")});
            }
        }};
    }

    protected void perform() {
        super.perform();
        CoreBreakpoint.Action[] actionArray = this.getBreakpoint().getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n] instanceof JavaStopAction) {
                ((JavaStopAction)actionArray[n]).performStopAction((CoreBreakpoint.Event)this);
            }
            ++n;
        }
    }

    public Line[] getLines() {
        return null;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Thread_event_type_name");
    }

    public String getCategoryDisplayName() {
        return JPDADebugger.getLocString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return JPDADebugger.getLocString("CTL_Thread_start_event_name");
        }
        if (this.type == 2) {
            return JPDADebugger.getLocString("CTL_Thread_death_event_name");
        }
        return JPDADebugger.getLocString("CTL_Thread_event_name");
    }

    public String getIconBase() {
        return "/org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    }

    public JComponent getCustomizer() {
        return new ThreadBreakpointPanel(this);
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] actionArray = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new ThreadPrintAction()};
            if (actionArray.length != 0) {
                CoreBreakpoint.Action[] actionArray2 = this.actions;
                this.actions = new CoreBreakpoint.Action[actionArray.length + actionArray2.length];
                System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                System.arraycopy(actionArray2, 0, this.actions, actionArray.length, actionArray2.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        return jPDADebugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public void synchronizeWith(CoreBreakpoint.Event event) {
    }

    public void exec(Event event) {
        if (event instanceof ThreadStartEvent) {
            this.thread = ((ThreadStartEvent)event).thread();
            this.action = JPDADebugger.getLocString("CTL_Started");
        } else {
            this.thread = ((ThreadDeathEvent)event).thread();
            this.action = JPDADebugger.getLocString("CTL_Death");
        }
        this.perform();
    }

    public void stop(boolean bl) {
        ((JPDADebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n == this.type) {
            return;
        }
        if ((n & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.type;
        this.type = n;
        this.firePropertyChange(PROP_TYPE, new Integer(n2), new Integer(n));
    }

    public String toString() {
        return "JPDAThreadBreakpoint " + this.getType();
    }

    class ThreadPrintAction
    extends PrintAction {
        static final long serialVersionUID = -5539254080847611623L;

        ThreadPrintAction() {
            super(JPDADebugger.getLocString("CTL_Thread_print_name"));
        }

        protected void resolveTag(String string, CoreBreakpoint.Event event, StringBuffer stringBuffer) {
            if (string.equals("action")) {
                stringBuffer.append(((ThreadBreakpoint)event).action);
            } else {
                super.resolveTag(string, event, stringBuffer);
            }
        }
    }
}

