/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.ValueVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class WatchVariable
extends ValueVariable {
    WatchVariable(JPDADebugger jPDADebugger, boolean bl) {
        super(jPDADebugger, bl);
    }

    void update(String string, Value value, String string2) {
        this.name = string;
        this.setRemoteValue(value);
        this.type = string2;
        this.modifiers = "";
        this.update();
    }

    protected boolean setValue(final Value value) {
        StackFrame stackFrame;
        JPDAThread jPDAThread = (JPDAThread)this.debugger.getCurrentThread();
        if (jPDAThread == null) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        ThreadReference threadReference = jPDAThread.getThreadReference();
        try {
            stackFrame = threadReference.frame(0);
        }
        catch (Exception exception) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        try {
            Object object = new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    LocalVariable localVariable = stackFrame.visibleVariableByName(WatchVariable.this.getVariableName());
                    if (localVariable != null) {
                        stackFrame.setValue(localVariable, value);
                    } else {
                        ObjectReference objectReference = stackFrame.thisObject();
                        ReferenceType referenceType = objectReference != null ? objectReference.referenceType() : stackFrame.location().declaringType();
                        Field field = referenceType.fieldByName(WatchVariable.this.getVariableName());
                        if (field != null) {
                            if (objectReference != null) {
                                objectReference.setValue(field, value);
                            } else {
                                ((ClassType)referenceType).setValue(field, value);
                            }
                        } else {
                            return referenceType;
                        }
                    }
                    return null;
                }
            }.throwAndWait(null);
            if (object != null) {
                JPDAVariable.notify(JPDAVariable.getString("EXC_Cannot_assign_to_expression"));
                return false;
            }
        }
        catch (InvalidTypeException invalidTypeException) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception exception) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

