/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.debugger.jpda.evaluator.BodyParser;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.ParseException;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;
import org.netbeans.modules.debugger.jpda.evaluator.TimeoutException;
import org.netbeans.modules.debugger.jpda.evaluator.TokenMgrError;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;

public class Evaluator {
    private static final int DEFAULT_TIME_OUT = 4000;
    private static int timeout = 4000;
    private static RemoteValue result;
    private static Value toStringResult;
    private static Exception exception;
    private static boolean finished;

    public static synchronized Value evaluate(String string, VirtualMachine virtualMachine, ThreadReference threadReference, int n, List list) throws EvaluateException {
        VMEngine vMEngine = new VMEngine(virtualMachine, threadReference, n, list);
        if (string == null) {
            string = "";
        }
        StringReader stringReader = new StringReader(string);
        BodyParser.Init(stringReader);
        PValue pValue = null;
        try {
            pValue = BodyParser.parseExpression();
        }
        catch (ParseException parseException) {
            throw new EvaluateException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new EvaluateException(tokenMgrError.getMessage());
        }
        EvaluatingThread evaluatingThread = new EvaluatingThread(Thread.currentThread(), vMEngine, pValue);
        result = null;
        exception = null;
        finished = false;
        evaluatingThread.start();
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!finished) {
            evaluatingThread.stop();
            throw new TimeoutException(PValue.getLocString("CTL_Time_out"));
        }
        if (exception != null) {
            if (exception instanceof EvaluateException) {
                throw (EvaluateException)exception;
            }
            PValue.error("CTL_Unexpected_exception", exception.toString());
        }
        return vMEngine.mirrorOf(result);
    }

    public static synchronized Value toString(ObjectReference objectReference, Method method, ThreadReference threadReference) throws EvaluateException {
        ToStringThread toStringThread = new ToStringThread(Thread.currentThread(), objectReference, method, threadReference);
        toStringResult = null;
        exception = null;
        finished = false;
        toStringThread.start();
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!finished) {
            toStringThread.stop();
            throw new TimeoutException(PValue.getLocString("CTL_Time_out"));
        }
        if (exception != null) {
            if (exception instanceof EvaluateException) {
                throw (EvaluateException)exception;
            }
            PValue.error("CTL_Unexpected_exception", exception.toString());
        }
        return toStringResult;
    }

    private static class ToStringThread
    extends Thread {
        private Thread thread;
        private Method method;
        private ObjectReference obj;
        private ThreadReference remoteThread;

        ToStringThread(Thread thread, ObjectReference objectReference, Method method, ThreadReference threadReference) {
            this.thread = thread;
            this.method = method;
            this.obj = objectReference;
            this.remoteThread = threadReference;
        }

        public void run() {
            try {
                toStringResult = this.obj.invokeMethod(this.remoteThread, this.method, new LinkedList(), 1);
            }
            catch (Exception exception) {
                Evaluator.exception = exception;
            }
            finished = true;
            this.thread.interrupt();
        }
    }

    private static class EvaluatingThread
    extends Thread {
        private Thread thread;
        private VMEngine engine;
        private PValue tree;

        EvaluatingThread(Thread thread, VMEngine vMEngine, PValue pValue) {
            this.thread = thread;
            this.engine = vMEngine;
            this.tree = pValue;
        }

        public void run() {
            try {
                result = this.tree.value(this.engine);
            }
            catch (Exception exception) {
                Evaluator.exception = exception;
            }
            finished = true;
            this.thread.interrupt();
        }
    }
}

