/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;

public abstract class LReference {
    public void setValue(RemoteValue remoteValue) throws EvaluateException {
    }

    static class ArrayItem
    extends LReference {
        private VMEngine engine;
        private ArrayReference array;
        private int index;

        public ArrayItem(VMEngine vMEngine, ArrayReference arrayReference, int n) {
            this.engine = vMEngine;
            this.array = arrayReference;
            this.index = n;
        }

        public void setValue(RemoteValue remoteValue) throws EvaluateException {
            Value value = this.engine.mirrorOf(remoteValue);
            try {
                this.array.setValue(this.index, value);
            }
            catch (Exception exception) {
                PValue.error("CTL_Value_cannot_be_set");
            }
        }
    }

    static class StaticVariable
    extends LReference {
        private VMEngine engine;
        private Field field;
        private ReferenceType reference;

        public StaticVariable(VMEngine vMEngine, ReferenceType referenceType, Field field) {
            this.engine = vMEngine;
            this.reference = referenceType;
            this.field = field;
        }

        public void setValue(RemoteValue remoteValue) throws EvaluateException {
            Value value = this.engine.mirrorOf(remoteValue);
            try {
                if (!(this.reference instanceof ClassType)) {
                    PValue.error("CTL_Value_cannot_be_set");
                }
                ((ClassType)this.reference).setValue(this.field, value);
            }
            catch (Exception exception) {
                PValue.error("CTL_Value_cannot_be_set");
            }
        }
    }

    static class InstanceVariable
    extends LReference {
        private VMEngine engine;
        private Field field;
        private ObjectReference object;

        public InstanceVariable(VMEngine vMEngine, ObjectReference objectReference, Field field) {
            this.engine = vMEngine;
            this.object = objectReference;
            this.field = field;
        }

        public void setValue(RemoteValue remoteValue) throws EvaluateException {
            Value value = this.engine.mirrorOf(remoteValue);
            try {
                this.object.setValue(this.field, value);
            }
            catch (Exception exception) {
                PValue.error("CTL_Value_cannot_be_set");
            }
        }
    }

    static class LocalVariable
    extends LReference {
        private VMEngine engine;
        private com.sun.jdi.LocalVariable localVariable;
        private StackFrame stackFrame;

        public LocalVariable(VMEngine vMEngine, StackFrame stackFrame, com.sun.jdi.LocalVariable localVariable) {
            this.engine = vMEngine;
            this.localVariable = localVariable;
            this.stackFrame = stackFrame;
        }

        public void setValue(RemoteValue remoteValue) throws EvaluateException {
            Value value = this.engine.mirrorOf(remoteValue);
            try {
                this.stackFrame.setValue(this.localVariable, value);
            }
            catch (Exception exception) {
                PValue.error("CTL_Value_cannot_be_set");
            }
        }
    }
}

