/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;
import org.netbeans.modules.debugger.jpda.evaluator.Token;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;

public class Node {

    static class BinaryConditionalOperator
    extends PValue {
        private PValue lVar;
        private PValue rVar;

        BinaryConditionalOperator(PValue pValue, Token token, PValue pValue2) {
            super(token);
            this.lVar = pValue;
            this.rVar = pValue2;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.lVar.value(vMEngine);
            if (remoteValue instanceof RemoteValue.Boolean) {
                boolean bl = ((RemoteValue.Boolean)remoteValue).booleanValue();
                if (this.token.kind == 91 && !bl) {
                    return new RemoteValue.Boolean(false);
                }
                if (this.token.kind == 90 && bl) {
                    return new RemoteValue.Boolean(true);
                }
                RemoteValue remoteValue2 = this.rVar.value(vMEngine);
                if (remoteValue2 instanceof RemoteValue.Boolean) {
                    bl = ((RemoteValue.Boolean)remoteValue2).booleanValue();
                    return new RemoteValue.Boolean(bl);
                }
                PValue.error("CTL_Bin_cond_operator_cannot_be_performed", PValue.operatorName(this.token.kind), remoteValue2.typeName());
            } else {
                PValue.error("CTL_Bin_cond_operator_cannot_be_performed", PValue.operatorName(this.token.kind), remoteValue.typeName());
            }
            return null;
        }
    }

    static class UnaryOperator
    extends PValue {
        private PValue operand;

        UnaryOperator(PValue pValue, Token token) {
            super(token);
            this.operand = pValue;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.operand.value(vMEngine);
            switch (this.token.kind) {
                case 82: {
                    if (!(remoteValue instanceof RemoteValue.Boolean)) break;
                    return new RemoteValue.Boolean(!((RemoteValue.Boolean)remoteValue).booleanValue());
                }
                case 83: {
                    if (!(remoteValue instanceof RemoteValue.Numeric) || remoteValue instanceof RemoteValue.Double || remoteValue instanceof RemoteValue.Float) break;
                    if (remoteValue instanceof RemoteValue.Long) {
                        return new RemoteValue.Long(((RemoteValue.Numeric)remoteValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    return new RemoteValue.Integer(~((RemoteValue.Numeric)remoteValue).intValue());
                }
                case 94: {
                    if (remoteValue instanceof RemoteValue.Numeric) {
                        if (remoteValue instanceof RemoteValue.Double || remoteValue instanceof RemoteValue.Float || remoteValue instanceof RemoteValue.Long || remoteValue instanceof RemoteValue.Integer) {
                            return remoteValue;
                        }
                        return new RemoteValue.Integer(((RemoteValue.Numeric)remoteValue).intValue());
                    }
                }
                case 95: {
                    if (!(remoteValue instanceof RemoteValue.Numeric)) break;
                    RemoteValue.Numeric numeric = (RemoteValue.Numeric)remoteValue;
                    if (remoteValue instanceof RemoteValue.Double) {
                        return new RemoteValue.Double(-numeric.doubleValue());
                    }
                    if (remoteValue instanceof RemoteValue.Float) {
                        return new RemoteValue.Float(-numeric.floatValue());
                    }
                    if (remoteValue instanceof RemoteValue.Long) {
                        return new RemoteValue.Long(-numeric.longValue());
                    }
                    return new RemoteValue.Integer(-numeric.intValue());
                }
            }
            PValue.error("CTL_Unary_operator_cannot_be_used", PValue.operatorName(this.token.kind), remoteValue.typeName());
            return null;
        }
    }

    static class BinaryOperator
    extends PValue {
        private PValue lVar;
        private PValue rVar;

        BinaryOperator(PValue pValue, Token token, PValue pValue2) {
            super(token);
            this.lVar = pValue;
            this.rVar = pValue2;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.lVar.value(vMEngine);
            RemoteValue remoteValue2 = this.rVar.value(vMEngine);
            return BinaryOperator.value(vMEngine, remoteValue, this.token.kind, remoteValue2);
        }

        static RemoteValue value(VMEngine vMEngine, RemoteValue remoteValue, int n, RemoteValue remoteValue2) throws EvaluateException {
            if (remoteValue instanceof RemoteValue.Boolean && remoteValue2 instanceof RemoteValue.Boolean) {
                boolean bl = ((RemoteValue.Boolean)remoteValue).booleanValue();
                boolean bl2 = ((RemoteValue.Boolean)remoteValue2).booleanValue();
                boolean bl3 = false;
                switch (n) {
                    case 86: {
                        bl3 = bl == bl2;
                        break;
                    }
                    case 89: {
                        bl3 = bl != bl2;
                        break;
                    }
                    case 99: {
                        bl3 = bl | bl2;
                        break;
                    }
                    case 98: {
                        bl3 = bl & bl2;
                        break;
                    }
                    case 100: {
                        bl3 = bl ^ bl2;
                        break;
                    }
                    default: {
                        PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(n), remoteValue.typeName(), remoteValue2.typeName());
                    }
                }
                return new RemoteValue.Boolean(bl3);
            }
            if (remoteValue instanceof RemoteValue.Numeric && remoteValue2 instanceof RemoteValue.Numeric) {
                switch (n) {
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 101: {
                        return BinaryOperator.evaluateAddOperator((RemoteValue.Numeric)remoteValue, (RemoteValue.Numeric)remoteValue2, n);
                    }
                    case 102: 
                    case 103: 
                    case 104: {
                        return BinaryOperator.evaluateShiftOperator((RemoteValue.Numeric)remoteValue, (RemoteValue.Numeric)remoteValue2, n);
                    }
                    case 98: 
                    case 99: 
                    case 100: {
                        return BinaryOperator.evaluateBitOperator((RemoteValue.Numeric)remoteValue, (RemoteValue.Numeric)remoteValue2, n);
                    }
                    case 80: 
                    case 81: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: {
                        return BinaryOperator.evaluateComparisonOperator((RemoteValue.Numeric)remoteValue, (RemoteValue.Numeric)remoteValue2, n);
                    }
                }
            }
            if (n == 86 || n == 89) {
                if (remoteValue instanceof RemoteValue.Null) {
                    if (remoteValue2 instanceof RemoteValue.Null) {
                        return new RemoteValue.Boolean(n == 86);
                    }
                    if (remoteValue2 instanceof RemoteValue.Object) {
                        return new RemoteValue.Boolean(n == 89);
                    }
                }
                if (remoteValue instanceof RemoteValue.Object) {
                    if (remoteValue2 instanceof RemoteValue.Null) {
                        return new RemoteValue.Boolean(n == 89);
                    }
                    if (remoteValue2 instanceof RemoteValue.Object) {
                        return new RemoteValue.Boolean(vMEngine.instancesEquals((RemoteValue.Object)remoteValue, (RemoteValue.Object)remoteValue2));
                    }
                }
            }
            if ((remoteValue instanceof RemoteValue.String || remoteValue2 instanceof RemoteValue.String) && n == 94) {
                String string;
                String string2 = remoteValue.toString(vMEngine);
                if (string2 == null) {
                    string2 = "null";
                }
                if ((string = remoteValue2.toString(vMEngine)) == null) {
                    string = "null";
                }
                return vMEngine.stringToObject(string2 + string);
            }
            PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(n), remoteValue.typeName(), remoteValue2.typeName());
            return null;
        }

        private static RemoteValue.Numeric evaluateAddOperator(RemoteValue.Numeric numeric, RemoteValue.Numeric numeric2, int n) throws EvaluateException {
            if (numeric instanceof RemoteValue.Double || numeric2 instanceof RemoteValue.Double) {
                double d = numeric.doubleValue();
                double d2 = numeric2.doubleValue();
                double d3 = 0.0;
                switch (n) {
                    case 94: {
                        d3 = d + d2;
                        break;
                    }
                    case 95: {
                        d3 = d - d2;
                        break;
                    }
                    case 101: {
                        d3 = d % d2;
                        break;
                    }
                    case 96: {
                        d3 = d * d2;
                        break;
                    }
                    case 97: {
                        d3 = d / d2;
                    }
                }
                return new RemoteValue.Double(d3);
            }
            if (numeric instanceof RemoteValue.Float || numeric2 instanceof RemoteValue.Float) {
                float f = numeric.floatValue();
                float f2 = numeric2.floatValue();
                float f3 = 0.0f;
                switch (n) {
                    case 94: {
                        f3 = f + f2;
                        break;
                    }
                    case 95: {
                        f3 = f - f2;
                        break;
                    }
                    case 101: {
                        f3 = f % f2;
                        break;
                    }
                    case 96: {
                        f3 = f * f2;
                        break;
                    }
                    case 97: {
                        f3 = f / f2;
                    }
                }
                return new RemoteValue.Float(f3);
            }
            if (numeric instanceof RemoteValue.Long || numeric2 instanceof RemoteValue.Long) {
                long l = numeric.longValue();
                long l2 = numeric2.longValue();
                long l3 = 0L;
                switch (n) {
                    case 94: {
                        l3 = l + l2;
                        break;
                    }
                    case 95: {
                        l3 = l - l2;
                        break;
                    }
                    case 101: {
                        l3 = l % l2;
                        break;
                    }
                    case 96: {
                        l3 = l * l2;
                        break;
                    }
                    case 97: {
                        l3 = l / l2;
                    }
                }
                return new RemoteValue.Long(l3);
            }
            int n2 = numeric.intValue();
            int n3 = numeric2.intValue();
            int n4 = 0;
            switch (n) {
                case 94: {
                    n4 = n2 + n3;
                    break;
                }
                case 95: {
                    n4 = n2 - n3;
                    break;
                }
                case 101: {
                    n4 = n2 % n3;
                    break;
                }
                case 96: {
                    n4 = n2 * n3;
                    break;
                }
                case 97: {
                    n4 = n2 / n3;
                }
            }
            return new RemoteValue.Integer(n4);
        }

        private static RemoteValue.Numeric evaluateShiftOperator(RemoteValue.Numeric numeric, RemoteValue.Numeric numeric2, int n) throws EvaluateException {
            if (numeric instanceof RemoteValue.Float || numeric instanceof RemoteValue.Double || numeric2 instanceof RemoteValue.Float || numeric2 instanceof RemoteValue.Double) {
                PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(n), numeric.typeName(), numeric.typeName());
                return null;
            }
            if (numeric instanceof RemoteValue.Long) {
                long l = numeric.longValue();
                long l2 = numeric2.longValue();
                long l3 = 0L;
                switch (n) {
                    case 102: {
                        l3 = l << (int)l2;
                        break;
                    }
                    case 103: {
                        l3 = l >> (int)l2;
                        break;
                    }
                    case 104: {
                        l3 = l >>> (int)l2;
                    }
                }
                return new RemoteValue.Long(l3);
            }
            int n2 = numeric.intValue();
            long l = numeric2.longValue();
            int n3 = 0;
            switch (n) {
                case 102: {
                    n3 = n2 << (int)l;
                    break;
                }
                case 103: {
                    n3 = n2 >> (int)l;
                    break;
                }
                case 104: {
                    n3 = n2 >>> (int)l;
                }
            }
            return new RemoteValue.Integer(n3);
        }

        private static RemoteValue.Numeric evaluateBitOperator(RemoteValue.Numeric numeric, RemoteValue.Numeric numeric2, int n) throws EvaluateException {
            if (numeric instanceof RemoteValue.Float || numeric instanceof RemoteValue.Double || numeric2 instanceof RemoteValue.Float || numeric2 instanceof RemoteValue.Double) {
                PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(n), numeric.typeName(), numeric.typeName());
                return null;
            }
            if (numeric instanceof RemoteValue.Long || numeric2 instanceof RemoteValue.Long) {
                long l = numeric.longValue();
                long l2 = numeric2.longValue();
                long l3 = 0L;
                switch (n) {
                    case 98: {
                        l3 = l & l2;
                        break;
                    }
                    case 99: {
                        l3 = l | l2;
                        break;
                    }
                    case 100: {
                        l3 = l ^ l2;
                    }
                }
                return new RemoteValue.Long(l3);
            }
            int n2 = numeric.intValue();
            int n3 = numeric2.intValue();
            int n4 = 0;
            switch (n) {
                case 98: {
                    n4 = n2 & n3;
                    break;
                }
                case 99: {
                    n4 = n2 | n3;
                    break;
                }
                case 100: {
                    n4 = n2 ^ n3;
                }
            }
            return new RemoteValue.Integer(n4);
        }

        private static RemoteValue.Boolean evaluateComparisonOperator(RemoteValue.Numeric numeric, RemoteValue.Numeric numeric2, int n) {
            float f;
            boolean bl = false;
            if (numeric instanceof RemoteValue.Double || numeric2 instanceof RemoteValue.Double) {
                double d = numeric.doubleValue();
                double d2 = numeric2.doubleValue();
                switch (n) {
                    case 81: {
                        bl = d < d2;
                        break;
                    }
                    case 80: {
                        bl = d > d2;
                        break;
                    }
                    case 87: {
                        bl = d <= d2;
                        break;
                    }
                    case 88: {
                        bl = d >= d2;
                        break;
                    }
                    case 86: {
                        bl = d == d2;
                        break;
                    }
                    case 89: {
                        boolean bl2 = bl = d != d2;
                    }
                }
            }
            if (numeric instanceof RemoteValue.Float || numeric2 instanceof RemoteValue.Float) {
                float f2 = numeric.floatValue();
                f = numeric2.floatValue();
                switch (n) {
                    case 81: {
                        bl = f2 < f;
                        break;
                    }
                    case 80: {
                        bl = f2 > f;
                        break;
                    }
                    case 87: {
                        bl = f2 <= f;
                        break;
                    }
                    case 88: {
                        bl = f2 >= f;
                        break;
                    }
                    case 86: {
                        bl = f2 == f;
                        break;
                    }
                    case 89: {
                        boolean bl3 = bl = f2 != f;
                    }
                }
            }
            if (numeric instanceof RemoteValue.Long || numeric instanceof RemoteValue.Long) {
                long l = numeric.longValue();
                long l2 = numeric2.longValue();
                switch (n) {
                    case 81: {
                        bl = l < l2;
                        break;
                    }
                    case 80: {
                        bl = l > l2;
                        break;
                    }
                    case 87: {
                        bl = l <= l2;
                        break;
                    }
                    case 88: {
                        bl = l >= l2;
                        break;
                    }
                    case 86: {
                        bl = l == l2;
                        break;
                    }
                    case 89: {
                        bl = l != l2;
                    }
                }
            }
            float f3 = numeric.intValue();
            f = numeric2.intValue();
            switch (n) {
                case 81: {
                    bl = f3 < f;
                    break;
                }
                case 80: {
                    bl = f3 > f;
                    break;
                }
                case 87: {
                    bl = f3 <= f;
                    break;
                }
                case 88: {
                    bl = f3 >= f;
                    break;
                }
                case 86: {
                    bl = f3 == f;
                    break;
                }
                case 89: {
                    bl = f3 != f;
                }
            }
            return new RemoteValue.Boolean(bl);
        }
    }

    static class ConditionalExpression
    extends PValue {
        private PValue condition;
        private PValue leftOperand;
        private PValue rightOperand;

        ConditionalExpression(PValue pValue, PValue pValue2, PValue pValue3) {
            super(null);
            this.condition = pValue;
            this.leftOperand = pValue2;
            this.rightOperand = pValue3;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.condition.value(vMEngine);
            if (!(remoteValue instanceof RemoteValue.Boolean)) {
                PValue.error("CTL_Condition_of_conditional_operator_not_boolean", remoteValue.typeName());
                return null;
            }
            if (((RemoteValue.Boolean)remoteValue).booleanValue()) {
                return this.leftOperand.value(vMEngine);
            }
            return this.rightOperand.value(vMEngine);
        }
    }

    static class AssignmentOperator
    extends PValue {
        private PValue lOperand;
        private PValue rOperand;

        AssignmentOperator(PValue pValue, Token token, PValue pValue2) {
            super(token);
            this.lOperand = pValue;
            this.rOperand = pValue2;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.lOperand.value(vMEngine);
            if (!(remoteValue instanceof RemoteValue.Primitive) && !(remoteValue instanceof RemoteValue.String) && this.token.kind != 79) {
                PValue.error("CTL_Cannot_perform_compound_assignment", PValue.operatorName(this.token.kind), remoteValue.typeName());
                return null;
            }
            RemoteValue remoteValue2 = this.rOperand.value(vMEngine);
            int n = this.token.kind;
            int n2 = -1;
            switch (n) {
                case 105: {
                    n2 = 94;
                    break;
                }
                case 106: {
                    n2 = 95;
                    break;
                }
                case 107: {
                    n2 = 96;
                    break;
                }
                case 108: {
                    n2 = 97;
                    break;
                }
                case 109: {
                    n2 = 98;
                    break;
                }
                case 110: {
                    n2 = 99;
                    break;
                }
                case 111: {
                    n2 = 100;
                    break;
                }
                case 112: {
                    n2 = 101;
                    break;
                }
                case 113: {
                    n2 = 102;
                    break;
                }
                case 114: {
                    n2 = 103;
                    break;
                }
                case 115: {
                    n2 = 104;
                }
            }
            if (n2 != -1) {
                remoteValue2 = BinaryOperator.value(vMEngine, remoteValue, n2, remoteValue2);
            }
            if (remoteValue instanceof RemoteValue.String && !(remoteValue2 instanceof RemoteValue.String) && !(remoteValue2 instanceof RemoteValue.Null)) {
                PValue.error("CTL_Cannot_perform_assignment", remoteValue2.typeName(), remoteValue.typeName());
                return null;
            }
            if (remoteValue instanceof RemoteValue.Boolean && !(remoteValue2 instanceof RemoteValue.Boolean)) {
                PValue.error("CTL_Cannot_perform_assignment", remoteValue2.typeName(), remoteValue.typeName());
                return null;
            }
            if (remoteValue instanceof RemoteValue.Numeric) {
                if (!(remoteValue2 instanceof RemoteValue.Numeric)) {
                    PValue.error("CTL_Cannot_perform_assignment", remoteValue2.typeName(), remoteValue.typeName());
                    return null;
                }
                RemoteValue.Numeric numeric = null;
                RemoteValue.Numeric numeric2 = (RemoteValue.Numeric)remoteValue2;
                if (remoteValue instanceof RemoteValue.Short) {
                    numeric = new RemoteValue.Short(numeric2.shortValue());
                } else if (remoteValue instanceof RemoteValue.Byte) {
                    numeric = new RemoteValue.Byte(numeric2.byteValue());
                } else if (remoteValue instanceof RemoteValue.Character) {
                    numeric = new RemoteValue.Character(numeric2.charValue());
                } else if (remoteValue instanceof RemoteValue.Integer) {
                    numeric = new RemoteValue.Integer(numeric2.intValue());
                } else if (remoteValue instanceof RemoteValue.Long) {
                    numeric = new RemoteValue.Long(numeric2.longValue());
                } else if (remoteValue instanceof RemoteValue.Float) {
                    numeric = new RemoteValue.Float(numeric2.floatValue());
                } else if (remoteValue instanceof RemoteValue.Double) {
                    numeric = new RemoteValue.Double(numeric2.doubleValue());
                }
                numeric.setReference(numeric2.getReference());
                remoteValue2 = numeric;
            }
            if (!remoteValue.isLValue()) {
                PValue.error("CTL_Cannot_assign_to_non_lvalue", PValue.operatorName(n));
                return null;
            }
            remoteValue.setValue(remoteValue2);
            return remoteValue2;
        }
    }

    static class MMOperator
    extends PValue {
        private PValue operand;
        private boolean isPrefix;

        MMOperator(PValue pValue, boolean bl) {
            super(null);
            this.operand = pValue;
            this.isPrefix = bl;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.operand.value(vMEngine);
            if (!(remoteValue instanceof RemoteValue.Numeric)) {
                PValue.error("CTL_Cannot_decrement_non_numeric_value", remoteValue.typeName());
                return null;
            }
            if (!remoteValue.isLValue()) {
                PValue.error("CTL_Cannot_decrement_non_lvalue");
                return null;
            }
            RemoteValue.Byte byteVal = new RemoteValue.Byte(1);
            RemoteValue remoteValue2 = BinaryOperator.value(vMEngine, remoteValue, 95, byteVal);
            remoteValue.setValue(remoteValue2);
            if (this.isPrefix) {
                return remoteValue2;
            }
            remoteValue.setReference(null);
            return remoteValue;
        }
    }

    static class PPOperator
    extends PValue {
        private PValue operand;
        private boolean isPrefix;

        PPOperator(PValue pValue, boolean bl) {
            super(null);
            this.operand = pValue;
            this.isPrefix = bl;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.operand.value(vMEngine);
            if (!(remoteValue instanceof RemoteValue.Numeric)) {
                PValue.error("CTL_Cannot_increment_non_numeric_value", remoteValue.typeName());
                return null;
            }
            if (!remoteValue.isLValue()) {
                PValue.error("CTL_Cannot_increment_non_lvalue");
                return null;
            }
            RemoteValue.Byte byteVal = new RemoteValue.Byte(1);
            RemoteValue remoteValue2 = BinaryOperator.value(vMEngine, remoteValue, 94, byteVal);
            remoteValue.setValue(remoteValue2);
            if (this.isPrefix) {
                return remoteValue2;
            }
            remoteValue.setReference(null);
            return remoteValue;
        }
    }

    static class CastOperator
    extends PValue {
        private PValue operand;
        private String typeName;

        CastOperator(PValue pValue, String string) {
            super(null);
            this.operand = pValue;
            this.typeName = string;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.operand.value(vMEngine);
            if (remoteValue instanceof RemoteValue.Object || remoteValue instanceof RemoteValue.Null) {
                if (vMEngine.isInstanceOf(remoteValue, this.typeName)) {
                    return remoteValue;
                }
                PValue.error("CTL_Cast_operator_throws_exception", remoteValue.typeName(), this.typeName);
                return null;
            }
            if (remoteValue instanceof RemoteValue.Boolean) {
                if (this.typeName.equals("boolean")) {
                    return remoteValue;
                }
                PValue.error("CTL_Cast_operator_throws_exception", remoteValue.typeName(), this.typeName);
                return null;
            }
            if (remoteValue instanceof RemoteValue.Numeric) {
                RemoteValue.Numeric numeric = null;
                if (this.typeName.equals("short")) {
                    numeric = new RemoteValue.Short(((RemoteValue.Numeric)remoteValue).shortValue());
                } else if (this.typeName.equals("byte")) {
                    numeric = new RemoteValue.Byte(((RemoteValue.Numeric)remoteValue).byteValue());
                } else if (this.typeName.equals("char")) {
                    numeric = new RemoteValue.Character(((RemoteValue.Numeric)remoteValue).charValue());
                } else if (this.typeName.equals("int")) {
                    numeric = new RemoteValue.Integer(((RemoteValue.Numeric)remoteValue).intValue());
                } else if (this.typeName.equals("long")) {
                    numeric = new RemoteValue.Long(((RemoteValue.Numeric)remoteValue).longValue());
                } else if (this.typeName.equals("float")) {
                    numeric = new RemoteValue.Float(((RemoteValue.Numeric)remoteValue).floatValue());
                } else if (this.typeName.equals("double")) {
                    numeric = new RemoteValue.Double(((RemoteValue.Numeric)remoteValue).doubleValue());
                }
                if (numeric != null) {
                    numeric.setReference(remoteValue.getReference());
                    return numeric;
                }
            }
            PValue.error("CTL_Cast_operator_throws_exception", remoteValue.typeName(), this.typeName);
            return null;
        }
    }

    static class InstanceofOperator
    extends PValue {
        private PValue variable;
        private String type;

        InstanceofOperator(PValue pValue, String string) {
            super(null);
            this.variable = pValue;
            this.type = string;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.variable.value(vMEngine);
            if (remoteValue instanceof RemoteValue.Object || remoteValue instanceof RemoteValue.Null) {
                return new RemoteValue.Boolean(vMEngine.isInstanceOf(remoteValue, this.type));
            }
            PValue.error("CTL_Instanceof_on_primitive_type", remoteValue.typeName());
            return null;
        }
    }

    static class NewObjectOperator
    extends PValue {
        private String typeName;
        private List args;

        public NewObjectOperator(String string, List list) {
            super(null);
            this.typeName = string;
            this.args = list;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            ArrayList<RemoteValue> arrayList = new ArrayList<RemoteValue>();
            int n = 0;
            while (n < this.args.size()) {
                arrayList.add(((PValue)this.args.get(n)).value(vMEngine));
                ++n;
            }
            return vMEngine.createNewObject(this.typeName, arrayList);
        }
    }

    static class MethodInvocation
    extends PValue {
        private PValue variable;
        private String methodName;
        private List args;

        public MethodInvocation(PValue pValue, String string, List list) {
            super(null);
            this.variable = pValue;
            this.methodName = string;
            this.args = list;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = null;
            boolean bl = false;
            if (this.variable != null) {
                try {
                    remoteValue = this.variable.value(vMEngine);
                }
                catch (EvaluateException evaluateException) {
                    remoteValue = null;
                    if (this.variable instanceof Variable) {
                        bl = true;
                    }
                    throw evaluateException;
                }
                if (remoteValue != null) {
                    if (!(remoteValue instanceof RemoteValue.Object)) {
                        PValue.error("CTL_Method_invocation_on_non_object", this.methodName, remoteValue.typeName());
                        return null;
                    }
                    if (remoteValue instanceof RemoteValue.Array) {
                        PValue.error("CTL_Method_invocation_on_array", this.methodName);
                        return null;
                    }
                }
            }
            ArrayList<RemoteValue> arrayList = new ArrayList<RemoteValue>();
            int n = 0;
            while (n < this.args.size()) {
                arrayList.add(((PValue)this.args.get(n)).value(vMEngine));
                ++n;
            }
            String string = null;
            if (bl) {
                string = ((Variable)this.variable).name;
            }
            return vMEngine.invokeMethod((RemoteValue.Object)remoteValue, string, this.methodName, arrayList);
        }
    }

    static class FieldOfVariable
    extends PValue {
        PValue variable;
        Token fieldName;

        FieldOfVariable(PValue pValue, Token token) {
            super(null);
            this.variable = pValue;
            this.fieldName = token;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.variable.value(vMEngine);
            if (!(remoteValue instanceof RemoteValue.Object)) {
                PValue.error("CTL_Field_operator_on_primitive_type", remoteValue.typeName());
                return null;
            }
            return vMEngine.field((RemoteValue.Object)remoteValue, this.fieldName.image);
        }
    }

    static class IndexedVariable
    extends PValue {
        private PValue variable;
        private PValue index;

        IndexedVariable(PValue pValue, PValue pValue2) {
            super(null);
            this.variable = pValue;
            this.index = pValue2;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            RemoteValue remoteValue = this.variable.value(vMEngine);
            if (!(remoteValue instanceof RemoteValue.Array)) {
                PValue.error("CTL_Not_array", remoteValue.typeName());
                return null;
            }
            RemoteValue remoteValue2 = this.index.value(vMEngine);
            if (!(remoteValue2 instanceof RemoteValue.Numeric) || remoteValue2 instanceof RemoteValue.Long || remoteValue2 instanceof RemoteValue.Float || remoteValue2 instanceof RemoteValue.Double) {
                PValue.error("CTL_Index_of_array", remoteValue2.typeName());
                return null;
            }
            return vMEngine.itemOfArray((RemoteValue.Array)remoteValue, ((RemoteValue.Numeric)remoteValue2).intValue());
        }
    }

    static class Variable
    extends PValue {
        String name;

        Variable(String string) {
            super(null);
            this.name = string;
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            return vMEngine.resolveVariableName(this.name);
        }
    }

    static class StringLiteral
    extends PValue {
        StringLiteral(Token token) {
            super(token);
        }

        static String resolveString(String string) {
            String string2 = "";
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '\\') {
                    string2 = string2 + string.charAt(n);
                } else {
                    char c;
                    switch (string.charAt(++n)) {
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case '\"': {
                            c = '\"';
                            break;
                        }
                        case '\'': {
                            c = '\'';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                        default: {
                            c = '\u0000';
                            while (n < string.length() && string.charAt(n) >= '0' && string.charAt(n) <= '7' && c * 8 + string.charAt(n) - 48 < 256) {
                                c = (char)(c * 8 + (string.charAt(n) - 48));
                                ++n;
                            }
                            --n;
                        }
                    }
                    string2 = string2 + c;
                }
                ++n;
            }
            return string2;
        }

        public RemoteValue value(VMEngine vMEngine) {
            String string = StringLiteral.resolveString(this.token.image.substring(1, this.token.image.length() - 1));
            return vMEngine.stringToObject(string);
        }
    }

    static class CharacterLiteral
    extends PValue {
        CharacterLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine vMEngine) {
            char c = StringLiteral.resolveString(this.token.image.substring(1, this.token.image.length() - 1)).charAt(0);
            return new RemoteValue.Character(c);
        }
    }

    static class NullLiteral
    extends PValue {
        NullLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine vMEngine) {
            return new RemoteValue.Null();
        }
    }

    static class BooleanLiteral
    extends PValue {
        BooleanLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine vMEngine) {
            return new RemoteValue.Boolean(this.token.image.equals("true"));
        }
    }

    static class FloatLiteral
    extends PValue {
        FloatLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            String string = this.token.image;
            char c = string.charAt(string.length() - 1);
            try {
                if (c == 'f' || c == 'F') {
                    return new RemoteValue.Float(Float.parseFloat(string));
                }
                return new RemoteValue.Double(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                PValue.error("CTL_Bad_number_format", this.token.image);
                return null;
            }
        }
    }

    static class IntegerLiteral
    extends PValue {
        IntegerLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
            String string = this.token.image;
            char c = string.charAt(string.length() - 1);
            boolean bl = c == 'L' || c == 'l';
            try {
                if (bl) {
                    return new RemoteValue.Long(Long.decode(string.substring(0, string.length() - 1)));
                }
                return new RemoteValue.Integer(Integer.decode(string));
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    if (string.equals("0x8000000000000000L")) {
                        return new RemoteValue.Long(Long.MIN_VALUE);
                    }
                    if (string.equals("0xffffffffffffffffL")) {
                        return new RemoteValue.Long(-1L);
                    }
                    if (string.equals("01777777777777777777777L")) {
                        return new RemoteValue.Long(-1L);
                    }
                    if (string.equals("01000000000000000000000L")) {
                        return new RemoteValue.Long(Long.MIN_VALUE);
                    }
                } else {
                    if (string.equals("0x80000000")) {
                        return new RemoteValue.Integer(Integer.MIN_VALUE);
                    }
                    if (string.equals("0xffffffff")) {
                        return new RemoteValue.Integer(-1);
                    }
                    if (string.equals("020000000000")) {
                        return new RemoteValue.Integer(Integer.MIN_VALUE);
                    }
                    if (string.equals("037777777777")) {
                        return new RemoteValue.Integer(-1);
                    }
                }
                PValue.error("CTL_Bad_number_format", this.token.image);
                return null;
            }
        }
    }
}

