/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.LReference;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;

public class VMEngine {
    private VirtualMachine vm;
    private ThreadReference threadReference;
    private int frame;
    private List imports;
    private StackFrame stackFrame;

    public VMEngine(VirtualMachine virtualMachine, ThreadReference threadReference, int n, List list) throws EvaluateException {
        this.vm = virtualMachine;
        this.threadReference = threadReference;
        this.frame = n;
        this.imports = list != null ? list : new LinkedList();
        this.stackFrame = null;
        try {
            this.stackFrame = threadReference.frame(n);
        }
        catch (Exception exception) {
            PValue.error("CTL_Cannot_obtain_stack_frame");
        }
    }

    /*
     * Unable to fully structure code
     */
    public RemoteValue resolveVariableName(String var1_1) throws EvaluateException {
        var2_2 = new StringTokenizer(var1_1, ".");
        var3_3 = var2_2.nextToken();
        var5_4 = this.localValue(var3_3);
        if (var5_4 == null) {
            var5_4 = this.instanceValue(var3_3);
        }
        if (var5_4 == null) {
            var5_4 = this.staticValue(var3_3);
        }
        if (var5_4 == null) {
            var6_5 = true;
            while (var2_2.hasMoreTokens()) {
                var7_6 = this.resolveTypeName(var3_3, var6_5);
                if (var7_6 != null) {
                    var8_7 = var2_2.nextToken();
                    var5_4 = this.staticValue(var7_6, var8_7);
                    break;
                }
                var3_3 = var3_3 + "." + var2_2.nextToken();
                var6_5 = false;
            }
        }
        if (var5_4 != null) ** GOTO lbl29
        PValue.error("CTL_Unknown_identifier", var1_1);
        return null;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.nextToken();
            if (!(var5_4 instanceof RemoteValue.Object)) {
                PValue.error("CTL_Unknown_field_name", var3_3);
                return null;
            }
            if ((var5_4 = this.field((RemoteValue.Object)var5_4, var3_3)) != null) continue;
            PValue.error("CTL_Unknown_field_name", var3_3);
            return null;
lbl29:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl30:
        // 1 sources

        return var5_4;
    }

    public RemoteValue localValue(String string) throws EvaluateException {
        if (string.equals("this")) {
            ObjectReference objectReference = this.stackFrame.thisObject();
            if (objectReference == null) {
                PValue.error("CTL_No_this_object");
                return null;
            }
            return this.resolveValue(objectReference);
        }
        try {
            LocalVariable localVariable = this.stackFrame.visibleVariableByName(string);
            if (localVariable == null) {
                return null;
            }
            RemoteValue remoteValue = this.resolveValue(this.stackFrame.getValue(localVariable));
            remoteValue.setReference(new LReference.LocalVariable(this, this.stackFrame, localVariable));
            return remoteValue;
        }
        catch (AbsentInformationException absentInformationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public RemoteValue instanceValue(String string) {
        try {
            ObjectReference objectReference = this.stackFrame.thisObject();
            if (objectReference == null) {
                return null;
            }
            Field field = objectReference.referenceType().fieldByName(string);
            if (field == null) {
                return null;
            }
            RemoteValue remoteValue = this.resolveValue(objectReference.getValue(field));
            remoteValue.setReference(new LReference.InstanceVariable(this, objectReference, field));
            return remoteValue;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RemoteValue staticValue(String string) {
        try {
            ReferenceType referenceType = this.stackFrame.location().declaringType();
            return this.staticValue(referenceType, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private RemoteValue staticValue(ReferenceType referenceType, String string) {
        try {
            Field field = referenceType.fieldByName(string);
            if (field == null || !field.isStatic()) {
                if (string.equals("class")) {
                    return this.resolveValue(referenceType.classObject());
                }
                return null;
            }
            RemoteValue remoteValue = this.resolveValue(referenceType.getValue(field));
            remoteValue.setReference(new LReference.StaticVariable(this, referenceType, field));
            return remoteValue;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RemoteValue field(RemoteValue.Object object, String string) throws EvaluateException {
        try {
            ObjectReference objectReference = object.reference();
            if (objectReference instanceof ArrayReference) {
                if (string.equals("length")) {
                    return new RemoteValue.Integer(((ArrayReference)objectReference).length());
                }
                PValue.error("CTL_Unknown_field_name", string);
                return null;
            }
            ReferenceType referenceType = objectReference.referenceType();
            Field field = referenceType.fieldByName(string);
            if (field == null) {
                PValue.error("CTL_Unknown_field_name", string);
                return null;
            }
            RemoteValue remoteValue = this.resolveValue(objectReference.getValue(field));
            remoteValue.setReference(new LReference.InstanceVariable(this, objectReference, field));
            return remoteValue;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RemoteValue itemOfArray(RemoteValue.Array array, int n) throws EvaluateException {
        ArrayReference arrayReference = (ArrayReference)array.reference();
        if (n < 0 || n >= arrayReference.length()) {
            PValue.error("CTL_Array_index_out_of_bounds", new Integer(n));
            return null;
        }
        RemoteValue remoteValue = this.resolveValue(arrayReference.getValue(n));
        remoteValue.setReference(new LReference.ArrayItem(this, arrayReference, n));
        return remoteValue;
    }

    public RemoteValue invokeMethod(RemoteValue.Object object, String string, String string2, List list) throws EvaluateException {
        Object object2;
        ObjectReference objectReference = null;
        ReferenceType referenceType = null;
        if (object == null) {
            if (string != null) {
                referenceType = this.resolveTypeName(string, true);
                if (referenceType == null) {
                    PValue.error("CTL_Unknown_identifier", string);
                    return null;
                }
            } else {
                objectReference = this.stackFrame.thisObject();
                if (objectReference == null) {
                    referenceType = this.stackFrame.location().declaringType();
                }
            }
        } else {
            objectReference = object.reference();
        }
        if (objectReference != null) {
            referenceType = objectReference.referenceType();
        }
        if (!(referenceType instanceof ClassType)) {
            PValue.error("CTL_Cannot_invoke_method_on_array", string2);
            return null;
        }
        ClassType classType = (ClassType)referenceType;
        List<Method> list2 = classType.methodsByName(string2);
        if (list2.size() == 0) {
            PValue.error("CTL_No_method_found", string2);
            return null;
        }
        ArrayList<Value> arrayList = new ArrayList<Value>();
        Value value = null;
        int n = 0;
        while (n < list.size()) {
            object2 = (RemoteValue)list.get(n);
            if (object2 instanceof RemoteValue.Void) {
                PValue.error("CTL_Void_value_cannot_be_passed", string2);
                return null;
            }
            if (object2 instanceof RemoteValue.Null) {
                arrayList.add(null);
            } else {
                arrayList.add(this.mirrorOf((RemoteValue)list.get(n)));
            }
            ++n;
        }
        object2 = this.mostSpecificMethod(list2, arrayList);
        if (object2 == null) {
            PValue.error("CTL_No_method_matches_parameters", string2);
            return null;
        }
        try {
            value = objectReference != null ? objectReference.invokeMethod(this.threadReference, (Method)object2, arrayList, 1) : classType.invokeMethod(this.threadReference, (Method)object2, arrayList, 1);
        }
        catch (InvocationException invocationException) {
            String string3 = invocationException.exception().referenceType().name();
            PValue.error("CTL_Method_has_thrown_exception", string2, string3);
            return null;
        }
        catch (Exception exception) {
            PValue.error("CTL_Exception_during_method_invocation", string2, exception.getClass().getName());
            return null;
        }
        try {
            this.stackFrame = this.threadReference.frame(this.frame);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.resolveValue(value);
    }

    public RemoteValue.Object createNewObject(String string, List list) throws EvaluateException {
        Object object;
        ReferenceType referenceType = this.resolveTypeName(string, true);
        if (referenceType == null) {
            PValue.error("CTL_Unknown_identifier", string);
            return null;
        }
        if (referenceType instanceof InterfaceType) {
            PValue.error("CTL_Cannot_create_instance_of_interface", string);
            return null;
        }
        if (referenceType instanceof ArrayType) {
            PValue.error("CTL_Array_creation_not_supported", string);
            return null;
        }
        List<Method> list2 = referenceType.methodsByName("<init>");
        ArrayList<Value> arrayList = new ArrayList<Value>();
        ObjectReference objectReference = null;
        int n = 0;
        while (n < list.size()) {
            object = (RemoteValue)list.get(n);
            if (object instanceof RemoteValue.Void) {
                PValue.error("CTL_Void_value_cannot_be_passed_to_constructor", string);
                return null;
            }
            if (object instanceof RemoteValue.Null) {
                arrayList.add(null);
            } else {
                arrayList.add(this.mirrorOf((RemoteValue)list.get(n)));
            }
            ++n;
        }
        object = this.mostSpecificMethod(list2, arrayList);
        if (object == null) {
            PValue.error("CTL_No_constructor_matches_parameters", string);
            return null;
        }
        try {
            objectReference = ((ClassType)referenceType).newInstance(this.threadReference, (Method)object, arrayList, 1);
        }
        catch (InvocationException invocationException) {
            String string2 = invocationException.exception().referenceType().name();
            PValue.error("CTL_Constructor_has_thrown_exception", string, string2);
            return null;
        }
        catch (Exception exception) {
            PValue.error("CTL_Exception_during_constructor_invocation", string, exception.getClass().getName());
            return null;
        }
        try {
            this.stackFrame = this.threadReference.frame(this.frame);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (RemoteValue.Object)this.resolveValue(objectReference);
    }

    public boolean isInstanceOf(RemoteValue remoteValue, String string) throws EvaluateException {
        ReferenceType referenceType = this.resolveTypeName(string, true);
        if (referenceType == null) {
            PValue.error("CTL_Unknown_identifier", string);
            return false;
        }
        if (remoteValue instanceof RemoteValue.Null) {
            return true;
        }
        if (!(remoteValue instanceof RemoteValue.Object)) {
            PValue.error("CTL_First_operand_not_instance", remoteValue.typeName());
            return false;
        }
        ReferenceType referenceType2 = ((RemoteValue.Object)remoteValue).reference().referenceType();
        if (!(referenceType2 instanceof ClassType)) {
            return referenceType2 instanceof ArrayType && referenceType.name().equals("java.lang.Object");
        }
        return this.resolveInstanceOf((ClassType)referenceType2, referenceType);
    }

    private boolean resolveInstanceOf(ClassType classType, ReferenceType referenceType) {
        ClassType classType2 = classType;
        boolean bl = false;
        while (classType2 != null) {
            if (referenceType.equals(classType2)) {
                return true;
            }
            classType2 = classType2.superclass();
        }
        List<InterfaceType> list = classType.allInterfaces();
        int n = 0;
        while (n < list.size()) {
            if (referenceType.equals(list.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private ReferenceType resolveTypeName(String string, boolean bl) {
        try {
            Object object;
            List<ReferenceType> list = this.vm.classesByName(string);
            if (list.size() == 0 && bl) {
                int n = 0;
                while (n < this.imports.size()) {
                    object = (String)this.imports.get(n);
                    list = this.vm.classesByName((String)object + "." + string);
                    if (list.size() != 0) break;
                    ++n;
                }
            }
            if (list.size() == 0) {
                return null;
            }
            object = list.get(0);
            if (list.size() > 1) {
                ClassLoaderReference classLoaderReference = this.stackFrame.location().declaringType().classLoader();
                int n = 0;
                while (n < list.size()) {
                    ReferenceType referenceType = list.get(n);
                    if (classLoaderReference == referenceType.classLoader()) {
                        object = referenceType;
                        break;
                    }
                    ++n;
                }
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method mostSpecificMethod(List list, List list2) {
        Object object = null;
        List<Type> list3 = null;
        try {
            int n;
            int n2;
            Object object2;
            ArrayList<Method> arrayList = new ArrayList<Method>();
            int n3 = 0;
            while (n3 < list.size()) {
                block14: {
                    Method method = (Method)list.get(n3);
                    try {
                        object2 = method.argumentTypes();
                    }
                    catch (Exception exception) {
                        break block14;
                    }
                    if (!method.isAbstract() && object2.size() == list2.size()) {
                        boolean bl = true;
                        n2 = object2.size();
                        n = 0;
                        while (n < n2) {
                            if (!this.isAssignable((Value)list2.get(n), (Type)object2.get(n))) {
                                bl = false;
                                break;
                            }
                            ++n;
                        }
                        if (bl) {
                            arrayList.add(method);
                        }
                    }
                }
                ++n3;
            }
            if (arrayList.size() == 0) {
                return null;
            }
            object = (Method)arrayList.get(0);
            list3 = object.argumentTypes();
            int n4 = 1;
            while (n4 < arrayList.size()) {
                object2 = (Method)arrayList.get(n4);
                List<Type> list4 = object2.argumentTypes();
                n2 = 1;
                n = 0;
                while (n < list4.size()) {
                    if (!this.isAssignable(list4.get(n), list3.get(n))) {
                        n2 = 0;
                        break;
                    }
                    ++n;
                }
                if (n2 != 0) {
                    object = object2;
                    list3 = list4;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private static int indexOfPrimitiveType(PrimitiveType primitiveType) {
        if (primitiveType instanceof IntegerType) {
            return 3;
        }
        if (primitiveType instanceof LongType) {
            return 4;
        }
        if (primitiveType instanceof FloatType) {
            return 5;
        }
        if (primitiveType instanceof DoubleType) {
            return 6;
        }
        if (primitiveType instanceof CharType) {
            return 2;
        }
        if (primitiveType instanceof ShortType) {
            return 2;
        }
        if (primitiveType instanceof ByteType) {
            return 1;
        }
        return 0;
    }

    private boolean isAssignable(Value value, Type type) {
        if (value == null) {
            return !(type instanceof PrimitiveType);
        }
        return this.isAssignable(value.type(), type);
    }

    private boolean isAssignable(Type type, Type type2) {
        if (type instanceof PrimitiveType) {
            int n;
            if (!(type2 instanceof PrimitiveType)) {
                return false;
            }
            if (type instanceof BooleanType || type2 instanceof BooleanType) {
                return type instanceof BooleanType && type2 instanceof BooleanType;
            }
            int n2 = VMEngine.indexOfPrimitiveType((PrimitiveType)type);
            return n2 < (n = VMEngine.indexOfPrimitiveType((PrimitiveType)type2)) || n2 == n && type.equals(type2);
        }
        if (!(type2 instanceof ReferenceType)) {
            return false;
        }
        if (type instanceof ArrayType) {
            return type.equals(type2) || type2.name().equals("java.lang.Object");
        }
        return this.resolveInstanceOf((ClassType)type, (ReferenceType)type2);
    }

    public RemoteValue.String stringToObject(String string) {
        return new RemoteValue.String(this.vm.mirrorOf(string));
    }

    public String toStringValue(RemoteValue.Object object) throws EvaluateException {
        RemoteValue remoteValue = this.invokeMethod(object, null, "toString", new ArrayList());
        if (remoteValue instanceof RemoteValue.Null) {
            return null;
        }
        StringReference stringReference = (StringReference)((RemoteValue.String)remoteValue).reference();
        return stringReference.value();
    }

    public boolean instancesEquals(RemoteValue.Object object, RemoteValue.Object object2) {
        return object.reference().equals(object2.reference());
    }

    public RemoteValue resolveValue(Value value) {
        if (value instanceof ObjectReference) {
            if (value instanceof ArrayReference) {
                return new RemoteValue.Array((ArrayReference)value);
            }
            if (value instanceof StringReference) {
                return new RemoteValue.String((StringReference)value);
            }
            return new RemoteValue.Object((ObjectReference)value);
        }
        if (value instanceof BooleanValue) {
            return new RemoteValue.Boolean(((BooleanValue)value).value());
        }
        if (value instanceof IntegerValue) {
            return new RemoteValue.Integer(((IntegerValue)value).value());
        }
        if (value instanceof LongValue) {
            return new RemoteValue.Long(((LongValue)value).value());
        }
        if (value instanceof FloatValue) {
            return new RemoteValue.Float(((FloatValue)value).value());
        }
        if (value instanceof DoubleValue) {
            return new RemoteValue.Double(((DoubleValue)value).value());
        }
        if (value instanceof ShortValue) {
            return new RemoteValue.Short(((ShortValue)value).value());
        }
        if (value instanceof ByteValue) {
            return new RemoteValue.Byte(((ByteValue)value).value());
        }
        if (value instanceof CharValue) {
            return new RemoteValue.Character(((CharValue)value).value());
        }
        if (value instanceof VoidValue) {
            return new RemoteValue.Void();
        }
        if (value == null) {
            return new RemoteValue.Null();
        }
        return null;
    }

    public Value mirrorOf(RemoteValue remoteValue) {
        if (remoteValue instanceof RemoteValue.Integer) {
            return this.vm.mirrorOf(((RemoteValue.Integer)remoteValue).intValue());
        }
        if (remoteValue instanceof RemoteValue.Long) {
            return this.vm.mirrorOf(((RemoteValue.Long)remoteValue).longValue());
        }
        if (remoteValue instanceof RemoteValue.Byte) {
            return this.vm.mirrorOf(((RemoteValue.Byte)remoteValue).byteValue());
        }
        if (remoteValue instanceof RemoteValue.Short) {
            return this.vm.mirrorOf(((RemoteValue.Short)remoteValue).shortValue());
        }
        if (remoteValue instanceof RemoteValue.Float) {
            return this.vm.mirrorOf(((RemoteValue.Float)remoteValue).floatValue());
        }
        if (remoteValue instanceof RemoteValue.Double) {
            return this.vm.mirrorOf(((RemoteValue.Double)remoteValue).doubleValue());
        }
        if (remoteValue instanceof RemoteValue.Character) {
            return this.vm.mirrorOf(((RemoteValue.Character)remoteValue).charValue());
        }
        if (remoteValue instanceof RemoteValue.Boolean) {
            return this.vm.mirrorOf(((RemoteValue.Boolean)remoteValue).booleanValue());
        }
        if (remoteValue instanceof RemoteValue.Object) {
            return ((RemoteValue.Object)remoteValue).reference();
        }
        return null;
    }
}

