/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.lite;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.modules.apisupport.lite.LiteInstaller;
import org.netbeans.modules.apisupport.lite.WizardData;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public class SharedData
extends WizardData {
    static final String CLASS_PREFIX = "My";
    private String moduleName;
    private String packageName;
    private FileSystem targetFS;
    private DataFolder mainFolder;
    private String dataLoaderClass;
    private static SharedData sharedData;
    private String layerClass;
    private Properties properties = new Properties();
    private String version;
    private String moduleDesc;
    private String category;
    private static final ResourceBundle bundle;
    private Document document = null;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$lite$SharedData;

    private SharedData() {
    }

    public static SharedData getShared() {
        if (sharedData == null) {
            sharedData = new SharedData();
        }
        return sharedData;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String string) {
        this.moduleName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public FileSystem getTargetFS() {
        return this.targetFS;
    }

    public void setTargetFS(FileSystem fileSystem) {
        this.targetFS = fileSystem;
    }

    public void run() {
        try {
            this.createPackage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createPackage() throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getPackageName(), ".");
        FileObject fileObject = this.getTargetFS().getRoot();
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            fileObject = fileObject.getFileObject(string) == null ? fileObject.createFolder(string) : fileObject.getFileObject(string);
        }
    }

    private DataFolder getTopFolder() {
        DataFolder dataFolder = this.mainFolder;
        while (dataFolder.getFolder() != null) {
            dataFolder = dataFolder.getFolder();
        }
        return dataFolder;
    }

    void manifest(DataObject dataObject) {
        if (dataObject instanceof JarDataObject) {
            JarDataObject jarDataObject = (JarDataObject)dataObject;
            JarContent jarContent = jarDataObject.getJarContent();
            Manifest manifest = jarContent.getManifest();
            manifest.getMainAttributes().putValue("OpenIDE-Module", this.packageName);
            manifest.getMainAttributes().putValue("OpenIDE-Module-Name", this.moduleName);
            if (this.version == null || this.version.length() == 0) {
                this.setVersion("0.1");
            }
            manifest.getMainAttributes().putValue("OpenIDE-Module-Specification-Version", this.version);
            if (this.moduleDesc != null && this.moduleDesc.length() > 0) {
                manifest.getMainAttributes().putValue("OpenIDE-Module-Long-Description", this.moduleDesc);
            }
            if (this.category != null && this.category.length() > 0) {
                manifest.getMainAttributes().putValue("OpenIDE-Module-Display-Category", this.category);
            }
            if (this.layerClass != null) {
                manifest.getMainAttributes().putValue("OpenIDE-Module-Layer", this.layerClass + ".xml");
            }
            if (this.dataLoaderClass != null) {
                Attributes attributes = new Attributes();
                attributes.putValue("OpenIDE-Module-Class", "Loader");
                manifest.getEntries().put(new String(this.dataLoaderClass + ".class"), attributes);
            }
            jarContent.setManifest(manifest);
            jarContent.addDataObject((DataObject)this.mainFolder);
            try {
                jarDataObject.writeJarContent(jarContent);
                jarDataObject.getPrimaryFile().setAttribute("NetBeansAttrExecutor", (Object)new ServiceType.Handle((ServiceType)new LiteInstaller()));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        } else {
            ErrorManager.getDefault().log(1, "JAR file was of the wrong class: " + dataObject);
        }
    }

    void addBundleEntry(String string, String string2) {
        ((Hashtable)this.properties).put(string, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void generateBundle() {
        FileLock fileLock = null;
        try {
            try {
                FileObject fileObject = this.mainFolder.getPrimaryFile().createData("Bundle", "properties");
                fileLock = fileObject.lock();
                this.properties.store(fileObject.getOutputStream(fileLock), "# Resource bundle for package " + this.packageName);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                Object var4_5 = null;
                fileLock.releaseLock();
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public DataFolder getMainFolder() {
        return this.mainFolder;
    }

    public void setMainFolder(DataFolder dataFolder) {
        this.mainFolder = dataFolder;
    }

    public String getDataLoaderClass() {
        return this.dataLoaderClass;
    }

    public void setDataLoaderClass(String string) {
        this.dataLoaderClass = string;
    }

    public String getLayerClass() {
        return this.layerClass;
    }

    public void setLayerClass(String string) {
        this.layerClass = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getModuleDesc() {
        return this.moduleDesc;
    }

    public void setModuleDesc(String string) {
        this.moduleDesc = string;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    void nullLayerDocument() {
        this.document = null;
    }

    Document getLayerDocument() {
        if (this.document == null) {
            this.document = XMLUtil.createDocument((String)"filesystem", null, (String)"-//NetBeans//DTD Filesystem 1.1//EN", (String)"http://www.netbeans.org/dtds/filesystem-1_1.dtd");
        }
        return this.document;
    }

    void xml() {
        if (this.document == null) {
            return;
        }
        try {
            this.getTargetFS().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    SharedData.this.xml_create();
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void xml_create() {
        FileLock fileLock = null;
        FileObject fileObject = null;
        try {
            fileObject = this.getMainFolder().getPrimaryFile().createData("mf-layer", "xml");
            this.setLayerClass(fileObject.getPackageName('/'));
            fileLock = fileObject.lock();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        this.document.getDocumentElement().normalize();
        try {
            try {
                XMLUtil.write((Document)this.document, (OutputStream)fileObject.getOutputStream(fileLock), null);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                Object var5_6 = null;
                fileLock.releaseLock();
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    static void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            int n;
            while ((n = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(n);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            bufferedInputStream.close();
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$apisupport$lite$SharedData == null ? (class$org$netbeans$modules$apisupport$lite$SharedData = SharedData.class$("org.netbeans.modules.apisupport.lite.SharedData")) : class$org$netbeans$modules$apisupport$lite$SharedData));
    }
}

