/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.text.Format;
import java.util.Map;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.rmi.RMIExecInfo;
import org.netbeans.modules.rmi.RMIExecutorSettings;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RMIExecutor
extends ProcessExecutor {
    static final long serialVersionUID = -1327375421897348602L;
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor("{java.home}{/}bin{/}java", "-cp {filesystems} -Djava.security.policy={filesystemsIPURL}RMI/rmi.policy -Djava.rmi.server.codebase={filesystemsIPURL} -Djava.rmi.server.hostname={hostip} {classname} {arguments}", NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIExecutor == null ? (class$org$netbeans$modules$rmi$RMIExecutor = RMIExecutor.class$("org.netbeans.modules.rmi.RMIExecutor")) : class$org$netbeans$modules$rmi$RMIExecutor)).getString("MSG_ExecutorHint"));
    private static boolean defaultClassic;
    private static boolean defaultClassicSet;
    private boolean classic;
    private boolean classicSet = false;
    private static final int CURRENT_VERSION = 1;
    private int serializedVersion = 1;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIExecutor;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIStubCompilerType;

    public RMIExecutor() {
        this.setExternalExecutor(DEFAULT);
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIExecutor == null ? (class$org$netbeans$modules$rmi$RMIExecutor = RMIExecutor.class$("org.netbeans.modules.rmi.RMIExecutor")) : class$org$netbeans$modules$rmi$RMIExecutor)).getString("PROP_RMIExecutorName"));
    }

    public RMIExecutor(String string, String string2, String string3) {
        this.setExternalExecutor(new NbProcessDescriptor(string2, string3, NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIExecutor == null ? (class$org$netbeans$modules$rmi$RMIExecutor = RMIExecutor.class$("org.netbeans.modules.rmi.RMIExecutor")) : class$org$netbeans$modules$rmi$RMIExecutor)).getString("MSG_ExecutorHint")));
        this.setName(string);
    }

    public boolean isClassic() {
        if (this.classicSet) {
            return this.classic;
        }
        if (!defaultClassicSet) {
            defaultClassic = Utils.classicPreferred((String)(System.getProperty("jdk.home") + File.separatorChar + "bin" + File.separatorChar + "java"));
            defaultClassicSet = true;
        }
        return defaultClassic;
    }

    public void setClassic(boolean bl) {
        boolean bl2 = this.classic;
        this.classic = bl;
        this.classicSet = true;
        this.firePropertyChange("classic", new Boolean(bl2), new Boolean(bl));
    }

    public String getHostname() {
        return RMIExecutorSettings.getDefault().getHostname();
    }

    public String getHostIP() {
        return RMIExecutorSettings.getDefault().getHostIP();
    }

    public int getInternalHttpPort() {
        return RMIExecutorSettings.getDefault().getInternalHttpPort();
    }

    public URL getRepositoryURL() {
        return RMIExecutorSettings.getDefault().getRepositoryURL();
    }

    public URL getRepositoryIPURL() {
        return RMIExecutorSettings.getDefault().getRepositoryIPURL();
    }

    protected Process createProcess(ExecInfo execInfo) throws IOException {
        return this.getExternalExecutor().exec((Format)((Object)new RMIFormat(execInfo)));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$rmi$RMIExecutor == null ? (class$org$netbeans$modules$rmi$RMIExecutor = RMIExecutor.class$("org.netbeans.modules.rmi.RMIExecutor")) : class$org$netbeans$modules$rmi$RMIExecutor);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serializedVersion < 1) {
            this.serializedVersion = 1;
            String string = this.getExternalExecutor().getArguments();
            string = RMIExecutor.replace(string, "-classic", "{classic}");
            string = RMIExecutor.replace(string, "-Xdebug -Djava.compiler=NONE", "-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n -Djava.compiler=NONE");
            this.setExternalExecutor(new NbProcessDescriptor(this.getExternalExecutor().getProcessName(), string, NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$RMIStubCompilerType == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerType = RMIExecutor.class$("org.netbeans.modules.rmi.RMIStubCompilerType")) : class$org$netbeans$modules$rmi$RMIStubCompilerType)).getString("MSG_ExecutorHint")));
        }
    }

    private static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n > -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            return string;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultClassicSet = false;
    }

    public class RMIFormat
    extends ProcessExecutor.Format {
        static final long serialVersionUID = 745095811977999930L;
        static final String TAG_CLASSIC = "classic";

        public RMIFormat(ExecInfo execInfo) {
            super(execInfo);
            Map map = this.getMap();
            RMIExecutorSettings.getDefault().addSettings(map);
            if (execInfo instanceof RMIExecInfo) {
                ((RMIExecInfo)execInfo).addSettings(map);
            }
            map.put(TAG_CLASSIC, RMIExecutor.this.isClassic() ? "-classic" : "");
        }
    }
}

