/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.rmi.RMICompilerSupport;
import org.netbeans.modules.rmi.RMIDataLoader;
import org.netbeans.modules.rmi.RMIDataObject;
import org.netbeans.modules.rmi.RMIStubCompilerType;
import org.netbeans.modules.rmi.RMIStubSupport;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;

public class RMIStubCompiler
extends ExternalCompiler {
    private static final boolean DEBUG = false;
    private String fname;
    private RMIStubCompilerType myType;
    private JavaCompilerType javaType;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIStubCompilerGroup;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIDataLoader;

    public RMIStubCompiler(FileObject fileObject, String string, Object object, NbProcessDescriptor nbProcessDescriptor, ExternalCompiler.ErrorExpression errorExpression, RMIStubCompilerType rMIStubCompilerType) {
        this(fileObject, string, object, nbProcessDescriptor, errorExpression, rMIStubCompilerType, null);
    }

    public RMIStubCompiler(FileObject fileObject, String string, Object object, NbProcessDescriptor nbProcessDescriptor, ExternalCompiler.ErrorExpression errorExpression, RMIStubCompilerType rMIStubCompilerType, JavaCompilerType javaCompilerType) {
        super(fileObject, object, nbProcessDescriptor, errorExpression);
        this.fname = string;
        this.myType = rMIStubCompilerType;
        this.javaType = javaCompilerType;
    }

    public Class compilerGroupClass() {
        return class$org$netbeans$modules$rmi$RMIStubCompilerGroup == null ? (class$org$netbeans$modules$rmi$RMIStubCompilerGroup = RMIStubCompiler.class$("org.netbeans.modules.rmi.RMIStubCompilerGroup")) : class$org$netbeans$modules$rmi$RMIStubCompilerGroup;
    }

    public String getFileName() {
        if (this.fname != null) {
            FileObject fileObject = this.getFileObject().getParent();
            if (fileObject.isRoot()) {
                return this.fname;
            }
            return fileObject.getPackageName('.') + '.' + this.fname;
        }
        return this.getFileObject().getPackageName('.');
    }

    public boolean isUpToDate() {
        RMIDataLoader rMIDataLoader = (RMIDataLoader)DataLoader.getLoader((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = RMIStubCompiler.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader));
        FileObject fileObject = this.getFileObject();
        FileSystem fileSystem = RMICompilerSupport.getTargetFileSystem(this.myType, this.javaType);
        Object var4_4 = null;
        boolean bl = false;
        if (fileSystem == JavaCompilerType.TARGET_INVALID) {
            return false;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (fileSystem != null) {
            fileObject2 = fileSystem.findResource(fileObject2.getPackageNameExt('/', '.'));
        }
        if (fileObject2 == null) {
            return false;
        }
        if (rMIDataLoader != null) {
            String[] stringArray = rMIDataLoader.getStubFormats();
            Object[] objectArray = new Object[]{this.fname};
            int n = 0;
            while (n < stringArray.length) {
                String string = MessageFormat.format(stringArray[n], objectArray);
                FileObject fileObject3 = fileObject2.getFileObject(string, "class");
                if (fileObject3 != null) {
                    fileObject3.refresh();
                    bl = true;
                    if (fileObject3.getSize() <= 0L || fileObject.lastModified().after(fileObject3.lastModified())) {
                        bl = false;
                        break;
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    protected void registerStubs(FileSystem fileSystem) throws IOException {
        RMIDataLoader rMIDataLoader = (RMIDataLoader)DataLoader.getLoader((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = RMIStubCompiler.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader));
        RMIDataObject rMIDataObject = (RMIDataObject)DataObject.find((FileObject)this.getFileObject());
        FileObject[] fileObjectArray = fileSystem != null ? RMIStubSupport.getStubs((DataObject)rMIDataObject, fileSystem, rMIDataLoader.getStubFormats()) : RMIStubSupport.getStubs((DataObject)rMIDataObject, rMIDataLoader.getStubFormats());
        int n = 0;
        while (n < fileObjectArray.length) {
            rMIDataObject.registerStubFile(fileObjectArray[n]);
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void deleteFileObject(FileObject fileObject) throws IOException {
        FileLock fileLock = null;
        if (fileObject == null) {
            return;
        }
        try {
            fileLock = fileObject.lock();
            fileObject.delete(fileLock);
            Object var3_2 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public Object compilerGroupKey() {
        try {
            return new Key(this.getFileObject().getFileSystem().getRoot(), this.myType, this.javaType);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return new Key(this.myType, this.javaType);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof RMIStubCompiler) {
            RMIStubCompiler rMIStubCompiler = (RMIStubCompiler)((Object)object);
            if (rMIStubCompiler.getFileName().equals(this.getFileName())) {
                return true;
            }
            if (rMIStubCompiler.getCompilerDescriptor().equals((Object)this.getCompilerDescriptor())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        String string = this.getFileName();
        return string.hashCode() ^ (this.getCompilerDescriptor() == null ? 0 : this.getCompilerDescriptor().hashCode());
    }

    public String toString() {
        return "org.netbeans.modules.rmi.RMIStubCompiler[file=" + this.getFileName() + ", upToDate=" + this.isUpToDate() + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Key {
        private FileObject root;
        private RMIStubCompilerType myType;
        private JavaCompilerType javaType;

        private Key(FileObject fileObject, RMIStubCompilerType rMIStubCompilerType, JavaCompilerType javaCompilerType) {
            this.root = fileObject;
            this.myType = rMIStubCompilerType;
            this.javaType = javaCompilerType;
        }

        private Key(RMIStubCompilerType rMIStubCompilerType, JavaCompilerType javaCompilerType) {
            this(null, rMIStubCompilerType, javaCompilerType);
        }

        public FileObject getRoot() {
            return this.root;
        }

        public RMIStubCompilerType getType() {
            return this.myType;
        }

        public JavaCompilerType getJavaType() {
            return this.javaType;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.root == key.root && this.myType == key.myType && this.javaType == key.javaType;
            }
            return false;
        }

        public int hashCode() {
            if (this.root != null) {
                return this.root.hashCode() ^ ((Object)((Object)this.myType)).hashCode() ^ (this.javaType != null ? this.javaType.hashCode() : 0);
            }
            return ((Object)((Object)this.myType)).hashCode() ^ (this.javaType != null ? this.javaType.hashCode() : 0);
        }
    }
}

