/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.activation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.rmi.RMIModule;
import org.netbeans.modules.rmi.activation.ActivationSystemChildren;
import org.netbeans.modules.rmi.activation.ActivationSystemItem;
import org.netbeans.modules.rmi.activation.ActivationSystemNode;
import org.netbeans.modules.rmi.settings.RMIActivationSettings;
import org.netbeans.modules.rmi.settings.RMIRegistryItems;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class ActivationBrowserChildren
extends Children.Keys
implements PropertyChangeListener {
    private RequestProcessor.Task task = null;
    private int timeout;
    private static boolean debug = Boolean.getBoolean("org.netbeans.modules.rmi.test");

    protected void scheduleRefreshTask(int n) {
        if (this.task == null) {
            this.updateTimeout();
            this.task = RMIModule.getRP().create((Runnable)new RefreshTask());
            this.task.setPriority(1);
        }
        this.task.schedule(n);
        if (debug) {
            System.err.println("ABChildren: Task resheduled: " + n + " ms.");
        }
    }

    protected void addNotify() {
        this.scheduleRefreshTask(0);
        RMIRegistryItems.getInstance().addPropertyChangeListener(this);
        RMIActivationSettings.getDefault().addPropertyChangeListener(this);
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        RMIRegistryItems.getInstance().removePropertyChangeListener(this);
        RMIActivationSettings.getDefault().removePropertyChangeListener(this);
    }

    protected Node[] createNodes(Object object) {
        ActivationSystemItem activationSystemItem = (ActivationSystemItem)object;
        return new Node[]{new ActivationSystemNode(activationSystemItem, (Children)new ActivationSystemChildren(activationSystemItem))};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("as".equals(propertyChangeEvent.getPropertyName())) {
            this.setKeys(RMIRegistryItems.getInstance().getASSet());
        } else if ("refreshTime".equals(propertyChangeEvent.getPropertyName())) {
            this.updateTimeout();
            if (this.timeout > 0) {
                this.scheduleRefreshTask(this.timeout);
            } else if (this.task != null && this.task.isFinished()) {
                boolean bl = this.task.cancel();
                if (debug) {
                    System.err.println("ABChildren: task canceled: " + bl);
                }
            }
        }
    }

    private void updateTimeout() {
        this.timeout = RMIActivationSettings.getDefault().getRefreshTime();
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        public void run() {
            if (debug) {
                System.err.println("ABChildren: start refresh");
            }
            Set set = RMIRegistryItems.getInstance().getASSet();
            ActivationBrowserChildren.super.setKeys(set);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ActivationSystemItem activationSystemItem = (ActivationSystemItem)iterator.next();
                if (debug) {
                    System.err.println("ABChildren: item = " + activationSystemItem);
                }
                activationSystemItem.updateActivationItems();
            }
            if (debug) {
                System.err.println("ABChildren: end refresh");
            }
            if (ActivationBrowserChildren.this.timeout > 0) {
                ActivationBrowserChildren.this.scheduleRefreshTask(ActivationBrowserChildren.this.timeout);
            }
        }
    }
}

