/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.activation;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import org.netbeans.modules.rmi.RMIModule;
import org.netbeans.modules.rmi.activation.ActivationItem;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ActivationNode
extends AbstractNode
implements Node.Cookie {
    private ActivationItem item;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationNode;

    public ActivationNode(Children children, ActivationItem activationItem) {
        super(children);
        this.item = activationItem;
        this.setName(ActivationNode.getString("LBL_InvalidActivationItem"));
        this.setIconBase("org/netbeans/modules/rmi/resources/activationItemOff");
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)this);
    }

    public ActivationItem getItem() {
        return this.item;
    }

    public void destroy() throws IOException {
        RMIModule.getRP();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                try {
                    TopManager.getDefault().setStatusText(ActivationNode.getString("MSG_UnregisterStart"));
                    ActivationNode.this.item.unregister();
                    TopManager.getDefault().setStatusText(ActivationNode.getString("MSG_UnregisterSuccessful"));
                }
                catch (UnknownGroupException unknownGroupException) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ActivationNode.getString("ERR_UnregisteredGroup"), 0));
                }
                catch (UnknownObjectException unknownObjectException) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ActivationNode.getString("ERR_UnregisteredObj"), 0));
                }
                catch (ActivationException activationException) {
                    ErrorManager errorManager = RMIModule.getErrorManager(this.getClass());
                    errorManager.annotate((Throwable)activationException, ActivationNode.getString("ERR_Unregistration"));
                    errorManager.notify((Throwable)activationException);
                    TopManager.getDefault().setStatusText(ActivationNode.getString("MSG_UnregisterFailed"));
                }
                catch (RemoteException remoteException) {
                    ErrorManager errorManager = RMIModule.getErrorManager(this.getClass());
                    errorManager.annotate((Throwable)remoteException, ActivationNode.getString("ERR_Unregistration"));
                    errorManager.notify((Throwable)remoteException);
                    TopManager.getDefault().setStatusText(ActivationNode.getString("MSG_UnregisterFailed"));
                }
            }
        });
    }

    public boolean canDestroy() {
        return true;
    }

    protected static String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$activation$ActivationNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationNode = ActivationNode.class$("org.netbeans.modules.rmi.activation.ActivationNode")) : class$org$netbeans$modules$rmi$activation$ActivationNode), (String)string);
    }

    protected static String getString(String string, String string2) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$activation$ActivationNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationNode = ActivationNode.class$("org.netbeans.modules.rmi.activation.ActivationNode")) : class$org$netbeans$modules$rmi$activation$ActivationNode), (String)string, (Object)ActivationNode.getString(string2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

