/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.activation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import org.netbeans.modules.rmi.activation.ActivationItem;
import org.netbeans.modules.rmi.activation.ActivationSystemItem;

public final class ActivationObjectItem
extends ActivationItem {
    public static final String PROP_DESCRIPTOR = "aoiDesc";
    protected ActivationID id;
    private ActivationDesc desc;
    private PropertyChangeSupport support;
    private boolean deleted = false;

    public ActivationObjectItem(ActivationID activationID, ActivationDesc activationDesc, ActivationSystemItem activationSystemItem) {
        super(activationSystemItem);
        this.id = activationID;
        this.desc = activationDesc;
    }

    public void setDesc(ActivationDesc activationDesc) {
        boolean bl = !this.desc.equals((Object)activationDesc);
        this.desc = activationDesc;
        if (bl) {
            this.firePropertyChange(PROP_DESCRIPTOR, null, null);
        }
    }

    public ActivationDesc getDesc() {
        return this.desc;
    }

    public void modifyDesc(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, UnknownObjectException, RemoteException {
        this.asItem.getActivationSystem().setActivationDesc(this.id, activationDesc);
        this.setDesc(activationDesc);
    }

    public ActivationID getActivationID() {
        return this.id;
    }

    public void unregister() throws ActivationException, UnknownObjectException, RemoteException {
        if (this.isDeleted()) {
            return;
        }
        this.asItem.getActivationSystem().unregisterObject(this.id);
        this.setDeleted(true);
        this.asItem.removeActivationObjectItem(this);
    }

    public void inactivate() throws RemoteException, UnknownGroupException, UnknownObjectException {
        this.asItem.inactivateObject(this.id);
    }

    public boolean equals(Object object) {
        if (object instanceof ActivationObjectItem) {
            ActivationObjectItem activationObjectItem = (ActivationObjectItem)object;
            return this.getActivationID().equals((Object)activationObjectItem.getActivationID());
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof ActivationObjectItem) {
            int n;
            ActivationObjectItem activationObjectItem = (ActivationObjectItem)object;
            String string = this.desc.getClassName();
            String string2 = activationObjectItem.getDesc().getClassName();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if ((n = string.compareTo(string2)) == 0) {
                n = this.id.hashCode() - activationObjectItem.getActivationID().hashCode();
            }
            return n;
        }
        return super.compareTo(object);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (this.support != null) {
            this.support.firePropertyChange(string, null, null);
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }
}

