/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.activation;

import java.awt.datatransfer.StringSelection;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationGroupDesc;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.rmi.activation.ActivationGroupItem;
import org.netbeans.modules.rmi.activation.ActivationGroupNode;
import org.netbeans.modules.rmi.activation.ActivationItem;
import org.netbeans.modules.rmi.activation.ActivationNode;
import org.netbeans.modules.rmi.activation.ActivationObjectItem;
import org.netbeans.modules.rmi.activation.ActivationObjectNode;
import org.netbeans.modules.rmi.activation.ActivationSystemItem;
import org.netbeans.modules.rmi.activation.ActivationSystemNode;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class GenerateSetupAction
extends CookieAction {
    private static final char NL = '\n';
    private static final char QUOTATION = '\"';
    private static final String INDENT = "    ";
    private static final String NULL = "null";
    private static MessageFormat msgCmd = new MessageFormat("java.rmi.activation.ActivationGroupDesc.CommandEnvironment cmd{0} =\n{1}new java.rmi.activation.ActivationGroupDesc.CommandEnvironment({2}, {3});");
    private static MessageFormat msgGroupDesc = new MessageFormat("java.rmi.activation.ActivationGroupDesc groupDesc{0} =\n{1}new java.rmi.activation.ActivationGroupDesc({2}, {3}, groupData{0}, {4}, {5});");
    private static MessageFormat msgMarshalled = new MessageFormat("java.rmi.MarshalledObject {0}Data{1} = null;");
    private static MessageFormat msgGroupRegistration = new MessageFormat("java.rmi.activation.ActivationGroupID groupID{0} =\n{1}system.registerGroup(groupDesc{0});");
    private static MessageFormat msgObjDesc = new MessageFormat("java.rmi.activation.ActivationDesc desc{0} =\n{1}new java.rmi.activation.ActivationDesc(groupID{2}, {3}, {4}, objData{0}, {5});");
    private static MessageFormat msgObjRegistration = new MessageFormat("system.registerObject(desc{0});");
    private static MessageFormat msgPutProperty = new MessageFormat("overrides{0}.put(\"{1}\", \"{2}\");");
    private static MessageFormat msgProperties = new MessageFormat("java.util.Properties overrides{0} = new java.util.Properties();");
    private int groupCounter;
    private int objCounter;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationSystemNode;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationNode;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$GenerateSetupAction;

    protected Class[] cookieClasses() {
        return new Class[]{class$org$netbeans$modules$rmi$activation$ActivationSystemNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationSystemNode = GenerateSetupAction.class$("org.netbeans.modules.rmi.activation.ActivationSystemNode")) : class$org$netbeans$modules$rmi$activation$ActivationSystemNode, class$org$netbeans$modules$rmi$activation$ActivationNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationNode = GenerateSetupAction.class$("org.netbeans.modules.rmi.activation.ActivationNode")) : class$org$netbeans$modules$rmi$activation$ActivationNode};
    }

    protected int mode() {
        return 4;
    }

    protected void performAction(Node[] nodeArray) {
        TopManager.getDefault().getClipboard().setContents(new StringSelection(this.generate(this.shakeNodes(nodeArray))), null);
    }

    private Map shakeNodes(Node[] nodeArray) {
        HashSet<Object> hashSet;
        Object object;
        Object object2;
        HashSet<ActivationSystemItem> hashSet2 = new HashSet<ActivationSystemItem>();
        HashSet<ActivationItem> hashSet3 = new HashSet<ActivationItem>();
        HashSet<ActivationItem> hashSet4 = new HashSet<ActivationItem>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = 0;
        while (n < nodeArray.length) {
            if (nodeArray[n] instanceof ActivationSystemNode) {
                hashSet2.add(((ActivationSystemNode)nodeArray[n]).getActivationSystem());
            } else if (nodeArray[n] instanceof ActivationGroupNode) {
                hashSet3.add(((ActivationNode)nodeArray[n]).getItem());
            } else if (nodeArray[n] instanceof ActivationObjectNode) {
                hashSet4.add(((ActivationNode)nodeArray[n]).getItem());
            }
            ++n;
        }
        Iterator iterator = hashSet4.iterator();
        while (iterator.hasNext()) {
            object2 = (ActivationObjectItem)iterator.next();
            object = ((ActivationItem)object2).getActivationSystemItem().getActivationGroupItem((ActivationObjectItem)object2);
            if (hashSet2.contains(((ActivationItem)object2).getActivationSystemItem()) || hashSet3.contains(object)) continue;
            hashSet = (HashSet<Object>)hashMap.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                hashMap.put(object, hashSet);
            }
            hashSet.add(object2);
        }
        iterator = hashSet3.iterator();
        while (iterator.hasNext()) {
            object2 = (ActivationGroupItem)iterator.next();
            if (hashSet2.contains(((ActivationItem)object2).getActivationSystemItem())) continue;
            hashMap.put(object2, ((ActivationGroupItem)object2).getActivatables());
        }
        object2 = hashSet2.iterator();
        while (object2.hasNext()) {
            object = (ActivationSystemItem)object2.next();
            iterator = ((ActivationSystemItem)object).getActivationGroupItems().iterator();
            while (iterator.hasNext()) {
                hashSet = (ActivationGroupItem)iterator.next();
                hashMap.put(hashSet, ((ActivationGroupItem)((Object)hashSet)).getActivatables());
            }
        }
        return hashMap;
    }

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$activation$GenerateSetupAction == null ? (class$org$netbeans$modules$rmi$activation$GenerateSetupAction = GenerateSetupAction.class$("org.netbeans.modules.rmi.activation.GenerateSetupAction")) : class$org$netbeans$modules$rmi$activation$GenerateSetupAction), (String)"LBL_GenerateSetupAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String generate(Map map) {
        if (map.isEmpty()) {
            return "";
        }
        this.groupCounter = 0;
        this.objCounter = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.generateSystem()).append('\n');
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            ActivationGroupItem activationGroupItem = (ActivationGroupItem)iterator.next();
            stringBuffer.append(this.generateGroup(activationGroupItem, (Set)map.get(activationGroupItem))).append('\n');
        }
        return stringBuffer.toString();
    }

    private String generateSystem() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// activation system lookup").append('\n').append("java.rmi.registry.Registry registry = ").append('\n').append(INDENT).append("java.rmi.registry.LocateRegistry.getRegistry(java.rmi.activation.ActivationSystem.SYSTEM_PORT);").append('\n');
        stringBuffer.append("java.rmi.activation.ActivationSystem system =").append('\n').append(INDENT).append("(java.rmi.activation.ActivationSystem) registry.lookup(\"java.rmi.activation.ActivationSystem\");").append('\n');
        return stringBuffer.toString();
    }

    private String generateGroup(ActivationGroupItem activationGroupItem, Set set) {
        String string;
        String string2;
        Object object;
        Object object2;
        String string3 = String.valueOf(++this.groupCounter);
        ActivationGroupDesc activationGroupDesc = activationGroupItem.getDesc();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// new activation group").append('\n');
        ActivationGroupDesc.CommandEnvironment commandEnvironment = activationGroupDesc.getCommandEnvironment();
        if (commandEnvironment != null) {
            object2 = commandEnvironment.getCommandPath();
            if (object2 != null) {
                object2 = this.quotation(this.escape((String)object2));
            }
            object = this.generateStringArray(commandEnvironment.getCommandOptions());
            stringBuffer.append(msgCmd.format(new String[]{string3, INDENT, object2, object})).append('\n');
            string2 = "cmd" + string3;
        } else {
            string2 = NULL;
        }
        object2 = activationGroupDesc.getPropertyOverrides();
        if (object2 != null) {
            stringBuffer.append(this.generateProperties((Properties)object2, string3));
            string = "overrides" + string3;
        } else {
            string = NULL;
        }
        stringBuffer.append(msgMarshalled.format(new String[]{"group", string3})).append('\n');
        stringBuffer.append(msgGroupDesc.format(new String[]{string3, INDENT, this.quotation(activationGroupDesc.getClassName()), this.quotation(this.escape(activationGroupDesc.getLocation())), string, string2})).append('\n');
        stringBuffer.append(msgGroupRegistration.format(new String[]{string3, INDENT})).append('\n');
        object = new ArrayList(set);
        if (!((ArrayList)object).isEmpty()) {
            Collections.sort(object);
            stringBuffer.append('\n').append("// register objects").append('\n');
            Iterator iterator = ((AbstractList)object).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.generateObject((ActivationObjectItem)iterator.next())).append('\n');
            }
        }
        return stringBuffer.toString();
    }

    private String generateObject(ActivationObjectItem activationObjectItem) {
        String string = String.valueOf(this.groupCounter);
        String string2 = String.valueOf(++this.objCounter);
        StringBuffer stringBuffer = new StringBuffer();
        ActivationDesc activationDesc = activationObjectItem.getDesc();
        stringBuffer.append(msgMarshalled.format(new String[]{"obj", string2})).append('\n');
        stringBuffer.append(msgObjDesc.format(new String[]{string2, INDENT, string, this.quotation(activationDesc.getClassName()), this.quotation(this.escape(activationDesc.getLocation())), String.valueOf(activationDesc.getRestartMode())})).append('\n');
        stringBuffer.append(msgObjRegistration.format(new String[]{string2})).append('\n');
        return stringBuffer.toString();
    }

    private String generateStringArray(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return NULL;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new String[] {");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(this.quotation(this.escape(stringArray[n]))).append(", ");
            ++n;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    private String generateProperties(Properties properties, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(msgProperties.format(new String[]{string, INDENT})).append('\n');
        Enumeration enumeration = ((Hashtable)properties).keys();
        String[] stringArray = new String[3];
        stringArray[0] = string;
        while (enumeration.hasMoreElements()) {
            stringArray[1] = (String)enumeration.nextElement();
            stringArray[2] = this.escape(properties.getProperty(stringArray[1]));
            stringBuffer.append(msgPutProperty.format(stringArray)).append('\n');
        }
        return stringBuffer.toString();
    }

    private String quotation(String string) {
        if (string == null) {
            return NULL;
        }
        return '\"' + string + '\"';
    }

    private String escape(String string) {
        if (string == null) {
            return NULL;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

