/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.registry;

import java.rmi.server.RMIClassLoader;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import org.openide.nodes.Node;

public class ServiceItem
implements Comparable,
Node.Cookie {
    public static final String FMT_NAME = "{0}[class={1}]";
    private String name;
    private Class clazz;

    public ServiceItem(String string, Class clazz) {
        this.name = string;
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public Class getServiceClass() {
        return this.clazz;
    }

    public String getClassAnnotation() {
        Class clazz = this.getServiceClass();
        if (clazz != null) {
            String string = RMIClassLoader.getClassAnnotation(clazz);
            if (string == null) {
                try {
                    ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                    string = protectionDomain.getCodeSource().getLocation().toString();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return string;
        }
        return null;
    }

    public boolean equals(Object object) {
        ServiceItem serviceItem;
        if (object != null && object instanceof ServiceItem && (serviceItem = (ServiceItem)object).getName().equals(this.name)) {
            return this.clazz == null ? serviceItem.getServiceClass() == null : this.clazz.equals(serviceItem.getServiceClass());
        }
        return false;
    }

    public String toString() {
        return MessageFormat.format(FMT_NAME, this.getName(), this.getServiceClass());
    }

    public int compareTo(Object object) {
        return ((ServiceItem)object).getName().compareTo(this.getName());
    }
}

