/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.scripting;

import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.scripting.AbstractScriptType;
import org.openide.execution.ScriptType;
import org.python.core.PyException;
import org.python.util.PythonInterpreter;

public class JPythonScriptType
extends AbstractScriptType {
    static final long serialVersionUID = 5438294236761951778L;
    private static final String JYTHON_EXTENSION = "py";
    private static final String JYTHON_DISPLAY_NAME = "Jython";
    private transient PythonInterpreter pythonInterpreter;

    public JPythonScriptType() {
        this.getExtensions().addExtension(JYTHON_EXTENSION);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new JPythonScriptType();
    }

    protected String displayName() {
        return JYTHON_DISPLAY_NAME;
    }

    public void addVariable(String string, Object object) {
        this.getInterpreter().set(string, object);
    }

    private PythonInterpreter getInterpreter() {
        if (this.pythonInterpreter == null) {
            System.setProperty("python.cachedir", System.getProperty("netbeans.user") + "/system/jpythoncachedir");
            this.pythonInterpreter = new PythonInterpreter();
        }
        return this.pythonInterpreter;
    }

    public Object eval(String string, ScriptType.Context context) throws InvocationTargetException {
        try {
            return this.getInterpreter().eval(string);
        }
        catch (PyException pyException) {
            throw new InvocationTargetException(pyException, pyException.getMessage());
        }
    }

    public void exec(String string, ScriptType.Context context) throws InvocationTargetException {
        try {
            this.getInterpreter().exec(string);
        }
        catch (PyException pyException) {
            throw new InvocationTargetException(pyException, pyException.getMessage());
        }
    }
}

