/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.scripting.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.text.MessageFormat;
import org.netbeans.modules.scripting.remote.TelnetServer;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServerSettings
extends SystemOption {
    public static final int DEFAULT_PORT = 2345;
    public static final String PROP_RUNNING = "running";
    public static final String PROP_PORT = "port";
    private static boolean running;
    private static int port;
    private static boolean inited;
    private static boolean pendingRunning;
    private static final long serialVersionUID = -8091449028693180861L;
    static /* synthetic */ Class class$org$netbeans$modules$scripting$ScriptModule;
    static /* synthetic */ Class class$org$netbeans$modules$scripting$remote$ServerSettings;

    private boolean isGlobal() {
        return true;
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$scripting$ScriptModule == null ? (class$org$netbeans$modules$scripting$ScriptModule = ServerSettings.class$("org.netbeans.modules.scripting.ScriptModule")) : class$org$netbeans$modules$scripting$ScriptModule)).getString("LBL_TelnetServer");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$scripting$remote$ServerSettings == null ? (class$org$netbeans$modules$scripting$remote$ServerSettings = ServerSettings.class$("org.netbeans.modules.scripting.remote.ServerSettings")) : class$org$netbeans$modules$scripting$remote$ServerSettings);
    }

    protected void initialize() {
        super.initialize();
        inited = false;
        running = false;
        port = 2345;
    }

    public boolean isRunning() {
        ServerSettings serverSettings = this;
        synchronized (serverSettings) {
            if (!inited) {
                inited = true;
                this.setRunning(false);
            }
            boolean bl = running;
            return bl;
        }
    }

    public void setRunning(boolean bl) {
        ServerSettings serverSettings = this;
        synchronized (serverSettings) {
            if (this.isReadExternal()) {
                pendingRunning = bl;
            } else {
                boolean bl2 = running;
                running = bl;
                this.firePropertyChange(PROP_RUNNING, new Boolean(bl2), new Boolean(bl));
                if (bl2 && !bl) {
                    TelnetServer.shutdown();
                } else if (!bl2 && bl) {
                    TelnetServer.startup();
                }
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        inited = true;
        this.setRunning(pendingRunning);
    }

    public int getPort() {
        return port;
    }

    public void setPort(int n) {
        if (n < 0 || n > 65535) {
            String string = MessageFormat.format("Port out of range: {0}", new Integer(n));
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            return;
        }
        ServerSettings serverSettings = this;
        synchronized (serverSettings) {
            if (n == port) {
                return;
            }
            boolean bl = running;
            if (this.isReadExternal()) {
                running = false;
            } else {
                this.setRunning(false);
            }
            int n2 = port;
            port = n;
            this.firePropertyChange(PROP_PORT, new Integer(n2), new Integer(n));
            if (bl) {
                if (this.isReadExternal()) {
                    running = true;
                } else {
                    this.setRunning(true);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        port = 2345;
    }
}

