/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jdepend;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import jdepend.textui.JDepend;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class JDependTask
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private Path _sourcesPath;
    private File _outputFile;
    private File _dir;
    private Path _compileClasspath;
    private boolean _haltonerror = false;
    private boolean _fork = false;
    private static final int SUCCESS = 0;
    private static final int ERRORS = 1;

    public JDependTask() {
        this.commandline.setClassname("jdepend.textui.JDepend");
    }

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public File getOutputFile() {
        return this._outputFile;
    }

    public void setHaltonerror(boolean value) {
        this._haltonerror = value;
    }

    public boolean getHaltonerror() {
        return this._haltonerror;
    }

    public void setFork(boolean value) {
        this._fork = value;
    }

    public boolean getFork() {
        return this._fork;
    }

    public void setJvm(String value) {
        this.commandline.setVm(value);
    }

    public Path createSourcespath() {
        if (this._sourcesPath == null) {
            this._sourcesPath = new Path(((ProjectComponent)this).project);
        }
        return this._sourcesPath.createPath();
    }

    public Path getSourcespath() {
        return this._sourcesPath;
    }

    public void setDir(File dir) {
        this._dir = dir;
    }

    public File getDir() {
        return this._dir;
    }

    public void setClasspath(Path classpath) {
        if (this._compileClasspath == null) {
            this._compileClasspath = classpath;
        } else {
            this._compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this._compileClasspath;
    }

    public Path createClasspath() {
        if (this._compileClasspath == null) {
            this._compileClasspath = new Path(((ProjectComponent)this).project);
        }
        return this._compileClasspath.createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void execute() throws BuildException {
        boolean errorOccurred;
        if (this.getSourcespath() == null) {
            throw new BuildException("Missing Sourcepath required argument");
        }
        int exitValue = 1;
        boolean wasKilled = false;
        if (!this.getFork()) {
            exitValue = this.executeInVM();
        } else {
            ExecuteWatchdog watchdog = this.createWatchdog();
            exitValue = this.executeAsForked(watchdog);
            if (watchdog != null) {
                // empty if block
            }
        }
        boolean bl = errorOccurred = exitValue == 1;
        if (errorOccurred) {
            if (this.getHaltonerror()) {
                throw new BuildException("JDepend failed", this.location);
            }
            this.log("JDepend FAILED", 0);
        }
    }

    public int executeInVM() throws BuildException {
        JDepend jdepend = new JDepend();
        if (this.getOutputFile() != null) {
            FileWriter fw;
            try {
                fw = new FileWriter(this.getOutputFile().getPath());
            }
            catch (IOException e) {
                String msg = "JDepend Failed when creating the output file: " + e.getMessage();
                this.log(msg);
                throw new BuildException(msg);
            }
            jdepend.setWriter(new PrintWriter(fw));
            this.log("Ouptut to be stored in " + this.getOutputFile().getPath());
        }
        PathTokenizer sourcesPath = new PathTokenizer(this.getSourcespath().toString());
        while (sourcesPath.hasMoreTokens()) {
            File f = new File(sourcesPath.nextToken());
            if (!f.exists() || !f.isDirectory()) {
                String msg = "\"" + f.getPath() + "\" does not represent a valid directory. JDepend would fail.";
                this.log(msg);
                throw new BuildException(msg);
            }
            try {
                jdepend.addDirectory(f.getPath());
            }
            catch (IOException e) {
                String msg = "JDepend Failed when adding a source directory: " + e.getMessage();
                this.log(msg);
                throw new BuildException(msg);
            }
        }
        jdepend.analyze();
        return 0;
    }

    public int executeAsForked(ExecuteWatchdog watchdog) throws BuildException {
        this.createClasspath();
        if (this.getClasspath().toString().length() > 0) {
            this.createJvmarg().setValue("-classpath");
            this.createJvmarg().setValue(this.getClasspath().toString());
        }
        if (this.getOutputFile() != null) {
            this.commandline.createArgument().setValue("-file");
            this.commandline.createArgument().setValue(this._outputFile.getPath());
        }
        PathTokenizer sourcesPath = new PathTokenizer(this.getSourcespath().toString());
        while (sourcesPath.hasMoreTokens()) {
            File f = new File(sourcesPath.nextToken());
            if (!f.exists() || !f.isDirectory()) {
                throw new BuildException("\"" + f.getPath() + "\" does not represent a valid directory. JDepend would fail.");
            }
            this.commandline.createArgument().setValue(f.getPath());
        }
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), watchdog);
        execute.setCommandline(this.commandline.getCommandline());
        if (this.getDir() != null) {
            execute.setWorkingDirectory(this.getDir());
            execute.setAntRun(((ProjectComponent)this).project);
        }
        if (this.getOutputFile() != null) {
            this.log("Ouptut to be stored in " + this.getOutputFile().getPath());
        }
        this.log("Executing: " + this.commandline.toString(), 3);
        try {
            return execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed.", (Throwable)e, this.location);
        }
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        return null;
    }
}

