/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.optional.metamata.MAudit;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class MAuditStreamHandler
implements ExecuteStreamHandler {
    protected MAudit task;
    protected BufferedReader br;
    protected RegexpMatcher matcher;
    protected OutputStream xmlOut = null;
    protected Hashtable auditedFiles = new Hashtable();

    MAuditStreamHandler(MAudit task, OutputStream xmlOut) {
        this.task = task;
        this.xmlOut = xmlOut;
        this.matcher = new RegexpMatcherFactory().newRegexpMatcher();
        this.matcher.setPattern("(?:file:)?(.+):(\\d+)\\s*:\\s+(.*)");
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public void setProcessErrorStream(InputStream is) {
    }

    public void setProcessOutputStream(InputStream is) throws IOException {
        this.br = new BufferedReader(new InputStreamReader(is));
    }

    public void start() throws IOException {
        this.parseOutput(this.br);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        Document doc = MAuditStreamHandler.getDocumentBuilder().newDocument();
        Element rootElement = doc.createElement("classes");
        Enumeration keys = this.auditedFiles.keys();
        Hashtable filemapping = this.task.getFileMapping();
        rootElement.setAttribute("audited", String.valueOf(filemapping.size()));
        rootElement.setAttribute("reported", String.valueOf(this.auditedFiles.size()));
        int errors = 0;
        while (keys.hasMoreElements()) {
            String filepath = (String)keys.nextElement();
            Vector v = (Vector)this.auditedFiles.get(filepath);
            String fullclassname = (String)filemapping.get(filepath);
            if (fullclassname == null) {
                this.task.getProject().log("Could not find class mapping for " + filepath, 1);
                continue;
            }
            int pos = fullclassname.lastIndexOf(46);
            String pkg = pos == -1 ? "" : fullclassname.substring(0, pos);
            String clazzname = pos == -1 ? fullclassname : fullclassname.substring(pos + 1);
            Element clazz = doc.createElement("class");
            clazz.setAttribute("package", pkg);
            clazz.setAttribute("name", clazzname);
            clazz.setAttribute("violations", String.valueOf(v.size()));
            errors += v.size();
            int i = 0;
            while (i < v.size()) {
                MAudit.Violation violation = (MAudit.Violation)v.elementAt(i);
                Element error = doc.createElement("violation");
                error.setAttribute("line", String.valueOf(violation.line));
                error.setAttribute("message", violation.error);
                clazz.appendChild(error);
                ++i;
            }
            rootElement.appendChild(clazz);
        }
        rootElement.setAttribute("violations", String.valueOf(errors));
        if (this.xmlOut == null) return;
        OutputStreamWriter wri = null;
        wri = new OutputStreamWriter(this.xmlOut, "UTF-8");
        wri.write("<?xml version=\"1.0\"?>\n");
        new DOMElementWriter().write(rootElement, (Writer)wri, 0, "  ");
        ((Writer)wri).flush();
        Object var17_17 = null;
        if (this.xmlOut == System.out) return;
        if (this.xmlOut == System.err || wri == null) return;
        try {
            ((Writer)wri).close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (IOException exc) {
                this.task.log("Unable to write log file", 0);
                Object var17_18 = null;
                if (this.xmlOut == System.out) return;
                if (this.xmlOut == System.err || wri == null) return;
                try {
                    ((Writer)wri).close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (this.xmlOut == System.out || this.xmlOut == System.err || wri == null) throw throwable;
            try {
                ((Writer)wri).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    protected void parseOutput(BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null) {
            this.processLine(line);
        }
    }

    protected void processLine(String line) {
        Vector matches = this.matcher.getGroups(line);
        if (matches != null) {
            String file = (String)matches.elementAt(1);
            int lineNum = Integer.parseInt((String)matches.elementAt(2));
            String msg = (String)matches.elementAt(3);
            this.addViolationEntry(file, MAudit.createViolation(lineNum, msg));
        } else {
            this.task.log(line, 2);
        }
    }

    protected void addViolationEntry(String file, MAudit.Violation entry) {
        Vector<MAudit.Violation> violations = (Vector<MAudit.Violation>)this.auditedFiles.get(file);
        if (violations == null) {
            violations = new Vector<MAudit.Violation>();
            this.auditedFiles.put(file, violations);
        }
        violations.add(entry);
    }
}

