/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.optional.metamata.MetricsElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MMetricsStreamHandler
implements ExecuteStreamHandler {
    protected static final String CLASS = "class";
    protected static final String PACKAGE = "package";
    protected static final String FILE = "file";
    protected static final String METHOD = "method";
    protected static final String[] ATTRIBUTES = new String[]{"name", "vg", "loc", "dit", "noa", "nrm", "nlm", "wmc", "rfc", "dac", "fanout", "cbo", "lcom", "nocl"};
    protected InputStream metricsOutput;
    protected OutputStream xmlOutputStream;
    protected TransformerHandler metricsHandler;
    protected Task task;
    protected Stack stack = new Stack();

    MMetricsStreamHandler(Task task, OutputStream xmlOut) {
        this.task = task;
        this.xmlOutputStream = xmlOut;
    }

    public void setProcessInputStream(OutputStream p1) throws IOException {
    }

    public void setProcessErrorStream(InputStream p1) throws IOException {
    }

    public void setProcessOutputStream(InputStream is) throws IOException {
        this.metricsOutput = is;
    }

    public void start() throws IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (!factory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            throw new IllegalStateException("Invalid Transformer factory feature");
        }
        try {
            this.metricsHandler = ((SAXTransformerFactory)factory).newTransformerHandler();
            this.metricsHandler.setResult(new StreamResult(new OutputStreamWriter(this.xmlOutputStream, "UTF-8")));
            Transformer transformer = this.metricsHandler.getTransformer();
            transformer.setOutputProperty("indent", "yes");
            this.metricsHandler.startDocument();
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "company", "company", "CDATA", "metamata");
            this.metricsHandler.startElement("", "metrics", "metrics", attr);
            this.parseOutput();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public void stop() {
        try {
            while (this.stack.size() > 0) {
                ElementEntry elem = (ElementEntry)this.stack.pop();
                this.metricsHandler.endElement("", elem.getType(), elem.getType());
            }
            this.metricsHandler.endElement("", "metrics", "metrics");
            this.metricsHandler.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    protected void parseOutput() throws IOException, SAXException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.metricsOutput));
        String line = null;
        while ((line = br.readLine()) != null) {
            this.processLine(line);
        }
    }

    protected void processLine(String line) throws SAXException {
        if (line.startsWith("Construct\tV(G)\tLOC\tDIT\tNOA\tNRM\tNLM\tWMC\tRFC\tDAC\tFANOUT\tCBO\tLCOM\tNOCL")) {
            return;
        }
        try {
            MetricsElement elem = MetricsElement.parse(line);
            this.startElement(elem);
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.task.log(line, 2);
        }
    }

    protected void startElement(MetricsElement elem) throws SAXException {
        int indent = elem.getIndent();
        if (this.stack.size() > 0) {
            ElementEntry previous = (ElementEntry)this.stack.peek();
            try {
                while (indent <= previous.getIndent() && this.stack.size() > 0) {
                    this.stack.pop();
                    this.metricsHandler.endElement("", previous.getType(), previous.getType());
                    previous = (ElementEntry)this.stack.peek();
                }
            }
            catch (EmptyStackException ignored) {
                // empty catch block
            }
        }
        String type = this.getConstructType(elem);
        Attributes attrs = this.createAttributes(elem);
        this.metricsHandler.startElement("", type, type, attrs);
        this.stack.push(new ElementEntry(type, indent));
    }

    protected String getConstructType(MetricsElement elem) {
        if (elem.isCompilationUnit()) {
            return FILE;
        }
        if (elem.isMethod()) {
            return METHOD;
        }
        if (this.stack.size() == 0) {
            return PACKAGE;
        }
        ElementEntry previous = (ElementEntry)this.stack.peek();
        String prevType = previous.getType();
        int prevIndent = previous.getIndent();
        int indent = elem.getIndent();
        if (prevType.equals(FILE) && indent > prevIndent) {
            return CLASS;
        }
        if (prevType.equals(CLASS) && indent >= prevIndent) {
            return CLASS;
        }
        return PACKAGE;
    }

    protected Attributes createAttributes(MetricsElement elem) {
        AttributesImpl impl = new AttributesImpl();
        int i = 0;
        String name = ATTRIBUTES[i++];
        impl.addAttribute("", name, name, "CDATA", elem.getName());
        Enumeration metrics = elem.getMetrics();
        while (metrics.hasMoreElements()) {
            String value = (String)metrics.nextElement();
            if (value.length() > 0) {
                name = ATTRIBUTES[i];
                impl.addAttribute("", name, name, "CDATA", value);
            }
            ++i;
        }
        return impl;
    }

    private static final class ElementEntry {
        private String type;
        private int indent;

        ElementEntry(String type, int indent) {
            this.type = type;
            this.indent = indent;
        }

        public String getType() {
            return this.type;
        }

        public int getIndent() {
            return this.indent;
        }
    }
}

