/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.vss.MSVSS;
import org.apache.tools.ant.types.Commandline;

public class MSVSSLABEL
extends MSVSS {
    private String m_AutoResponse = null;
    private String m_Label = null;
    private String m_Version = null;
    private String m_Comment = "-";
    public static final String FLAG_LABEL = "-L";

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        int result = 0;
        if (this.getVsspath() == null) {
            String msg = "vsspath attribute must be set!";
            throw new BuildException(msg, this.location);
        }
        if (this.getLabel() == null) {
            String msg = "label attribute must be set!";
            throw new BuildException(msg, this.location);
        }
        commandLine.setExecutable(this.getSSCommand());
        commandLine.createArgument().setValue("Label");
        commandLine.createArgument().setValue(this.getVsspath());
        commandLine.createArgument().setValue("-C" + this.getComment());
        this.getAutoresponse(commandLine);
        this.getLabelCommand(commandLine);
        this.getVersionCommand(commandLine);
        this.getLoginCommand(commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    public void setLabel(String label) {
        this.m_Label = label.equals("") || label.equals("null") ? null : label;
    }

    public void getVersionCommand(Commandline cmd) {
        if (this.m_Version != null) {
            cmd.createArgument().setValue("-V" + this.m_Version);
        }
    }

    public void getLabelCommand(Commandline cmd) {
        if (this.m_Label != null) {
            cmd.createArgument().setValue(FLAG_LABEL + this.m_Label);
        }
    }

    public void setVersion(String version) {
        this.m_Version = version.equals("") || version.equals("null") ? null : version;
    }

    public String getLabel() {
        return this.m_Label;
    }

    public void setComment(String comment) {
        this.m_Comment = comment.equals("") || comment.equals("null") ? "-" : comment;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setAutoresponse(String response) {
        this.m_AutoResponse = response.equals("") || response.equals("null") ? null : response;
    }

    public void getAutoresponse(Commandline cmd) {
        if (this.m_AutoResponse == null) {
            cmd.createArgument().setValue("-I-");
        } else if (this.m_AutoResponse.equalsIgnoreCase("Y")) {
            cmd.createArgument().setValue("-I-Y");
        } else if (this.m_AutoResponse.equalsIgnoreCase("N")) {
            cmd.createArgument().setValue("-I-N");
        } else {
            cmd.createArgument().setValue("-I-");
        }
    }
}

