/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class SimpleContentModel
implements ContentModelValidator {
    public static final short CHOICE = -1;
    public static final short SEQUENCE = -1;
    private QName fFirstChild = new QName();
    private QName fSecondChild = new QName();
    private int fOperator;
    private boolean fDTD;

    public SimpleContentModel(short operator, QName firstChild, QName secondChild, boolean dtd) {
        this.fFirstChild.setValues(firstChild);
        if (secondChild != null) {
            this.fSecondChild.setValues(secondChild);
        } else {
            this.fSecondChild.clear();
        }
        this.fOperator = operator;
        this.fDTD = dtd;
    }

    public int validate(QName[] children, int offset, int length) {
        switch (this.fOperator) {
            case 0: {
                if (length == 0) {
                    return 0;
                }
                if (this.fDTD ? children[offset].rawname != this.fFirstChild.rawname : children[offset].uri != this.fFirstChild.uri || children[offset].localpart != this.fFirstChild.localpart) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 1: {
                if (length == 1 && (this.fDTD ? children[offset].rawname != this.fFirstChild.rawname : children[offset].uri != this.fFirstChild.uri || children[offset].localpart != this.fFirstChild.localpart)) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 2: {
                if (length <= 0) break;
                if (this.fDTD) {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].rawname != this.fFirstChild.rawname) {
                            return index;
                        }
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].uri != this.fFirstChild.uri || children[offset + index].localpart != this.fFirstChild.localpart) {
                            return index;
                        }
                        ++index;
                    }
                }
                break;
            }
            case 3: {
                if (length == 0) {
                    return 0;
                }
                if (this.fDTD) {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].rawname != this.fFirstChild.rawname) {
                            return index;
                        }
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].uri != this.fFirstChild.uri || children[offset + index].localpart != this.fFirstChild.localpart) {
                            return index;
                        }
                        ++index;
                    }
                }
                break;
            }
            case 4: {
                if (length == 0) {
                    return 0;
                }
                if (this.fDTD ? children[offset].rawname != this.fFirstChild.rawname && children[offset].rawname != this.fSecondChild.rawname : !(children[offset].uri == this.fFirstChild.uri && children[offset].localpart == this.fFirstChild.localpart || children[offset].uri == this.fSecondChild.uri && children[offset].localpart == this.fSecondChild.localpart)) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 5: {
                if (length == 2) {
                    if (this.fDTD) {
                        if (children[offset].rawname != this.fFirstChild.rawname) {
                            return 0;
                        }
                        if (children[offset + 1].rawname == this.fSecondChild.rawname) break;
                        return 1;
                    }
                    if (children[offset].uri != this.fFirstChild.uri || children[offset].localpart != this.fFirstChild.localpart) {
                        return 0;
                    }
                    if (children[offset + 1].uri == this.fSecondChild.uri && children[offset + 1].localpart == this.fSecondChild.localpart) break;
                    return 1;
                }
                if (length > 2) {
                    return 2;
                }
                return length;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return -1;
    }
}

