/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;

public class QNameDV
extends TypeValidator {
    private static final String EMPTY_STRING = "";

    public short getAllowedFacets() {
        return 63;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        String localpart;
        String prefix;
        int colonptr = content.indexOf(":");
        if (colonptr > 0) {
            prefix = context.getSymbol(content.substring(0, colonptr));
            localpart = content.substring(colonptr + 1);
        } else {
            prefix = context.getSymbol(EMPTY_STRING);
            localpart = content;
        }
        if (prefix.length() > 0 && !XMLChar.isValidNCName(prefix)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        if (!XMLChar.isValidNCName(localpart)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        String uri = context.getURI(prefix);
        if (prefix.length() > 0 && uri == null) {
            throw new InvalidDatatypeValueException("UndeclaredPrefix", new Object[]{content, prefix});
        }
        return new QName(prefix, context.getSymbol(localpart), context.getSymbol(content), uri);
    }

    public int getDataLength(Object value) {
        return ((QName)value).rawname.length();
    }
}

