/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Vector;
import org.apache.xerces.dom.ASModelImpl;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.dom3.as.DOMASBuilder;
import org.apache.xerces.dom3.as.DOMASException;
import org.apache.xerces.dom3.ls.DOMInputSource;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.parsers.DTDXSParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public class DOMASBuilderImpl
extends DOMBuilderImpl
implements DOMASBuilder {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected XSGrammarBucket fGrammarBucket;
    protected SubstitutionGroupHandler fSubGroupHandler;
    protected CMBuilder fCMBuilder;
    protected XSDHandler fSchemaHandler;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected SymbolTable fSymbolTable;
    protected XMLGrammarPool fGrammarPool = null;
    protected ASModelImpl fAbstractSchema;
    String XMLNS;
    String URI_XSI;
    String XSI_SCHEMALOCATION;
    String XSI_NONAMESPACESCHEMALOCATION;
    String XSI_TYPE;
    String XSI_NIL;
    String URI_SCHEMAFORSCHEMA;

    public DOMASBuilderImpl() {
        super(new DTDXSParserConfiguration());
    }

    public DOMASBuilderImpl(XMLParserConfiguration config) {
        super(config);
    }

    public DOMASBuilderImpl(SymbolTable symbolTable) {
        super(new DTDXSParserConfiguration(symbolTable));
    }

    public DOMASBuilderImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        super(new DTDXSParserConfiguration(symbolTable, grammarPool));
        this.fGrammarPool = grammarPool;
    }

    public ASModel getAbstractSchema() {
        return this.fAbstractSchema;
    }

    public void setAbstractSchema(ASModel abstractSchema) {
        this.fAbstractSchema = (ASModelImpl)abstractSchema;
        if (this.fGrammarPool == null) {
            this.fGrammarPool = (XMLGrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        }
        if (this.fAbstractSchema != null) {
            this.initGrammarPool(this.fAbstractSchema);
        }
    }

    public ASModel parseASURI(String uri) throws DOMASException, Exception {
        XMLInputSource source = new XMLInputSource(null, uri, null);
        try {
            return this.parseASInputSource(source);
        }
        catch (XNIException e) {
            Exception ex = e.getException();
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASModel parseASInputSource(DOMInputSource is) throws DOMASException, Exception {
        XMLInputSource xis = this.dom2xmlInputSource(is);
        try {
            try {
                void e;
                ASModel aSModel = this.parseASInputSource(xis);
                Object var6_5 = null;
                if (is.getStringData() == null) return e;
                try {
                    xis.getCharacterStream().close();
                    return e;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return e;
            }
            catch (XNIException e) {
                Exception ex = e.getException();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is.getStringData() == null) throw throwable;
            try {}
            catch (IOException e2) {
                throw throwable;
            }
            xis.getCharacterStream().close();
            throw throwable;
        }
    }

    ASModel parseASInputSource(XMLInputSource is) throws Exception {
        if (this.fSchemaHandler == null) {
            this.fGrammarBucket = new XSGrammarBucket();
            this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
            this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
            this.fCMBuilder = new CMBuilder(new XSDeclarationPool());
        }
        this.fErrorReporter = (XMLErrorReporter)this.fConfiguration.getProperty(ERROR_REPORTER);
        this.fEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty(ENTITY_MANAGER);
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty(SYMBOL_TABLE);
        String externalSchemas = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-schemaLocation");
        String noNamespaceExternalSchemas = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
        this.XMLNS = this.fSymbolTable.addSymbol("xmlns");
        this.URI_XSI = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.XSI_SCHEMALOCATION = this.fSymbolTable.addSymbol("schemaLocation");
        this.XSI_NONAMESPACESCHEMALOCATION = this.fSymbolTable.addSymbol("noNamespaceSchemaLocation");
        this.XSI_TYPE = this.fSymbolTable.addSymbol("type");
        this.XSI_NIL = this.fSymbolTable.addSymbol("nil");
        this.URI_SCHEMAFORSCHEMA = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
        this.initGrammarBucket();
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, externalSchemas, noNamespaceExternalSchemas, this.fGrammarPool);
        SchemaGrammar grammar = this.fSchemaHandler.parseSchema(null, is, (short)3);
        if (this.getFeature(SCHEMA_FULL_CHECKING)) {
            XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        ASModelImpl newAsModel = new ASModelImpl();
        this.addGrammars(newAsModel, this.fGrammarBucket);
        return newAsModel;
    }

    private void initGrammarBucket() {
        this.fGrammarBucket.reset();
        if (this.fAbstractSchema != null) {
            this.initGrammarBucketRecurse(this.fAbstractSchema);
        }
    }

    private void initGrammarBucketRecurse(ASModelImpl currModel) {
        if (currModel.getGrammar() != null) {
            this.fGrammarBucket.putGrammar(currModel.getGrammar());
        }
        int i = 0;
        while (i < currModel.getInternalASModels().size()) {
            ASModelImpl nextModel = (ASModelImpl)currModel.getInternalASModels().elementAt(i);
            this.initGrammarBucketRecurse(nextModel);
            ++i;
        }
    }

    private void addGrammars(ASModelImpl model, XSGrammarBucket grammarBucket) {
        SchemaGrammar[] grammarList = grammarBucket.getGrammars();
        int i = 0;
        while (i < grammarList.length) {
            ASModelImpl newModel = new ASModelImpl();
            newModel.setGrammar(grammarList[i]);
            model.addASModel(newModel);
            ++i;
        }
    }

    private void initGrammarPool(ASModelImpl currModel) {
        if (this.fGrammarPool != null) {
            Grammar[] grammars = new Grammar[1];
            grammars[0] = currModel.getGrammar();
            if (grammars[0] != null) {
                this.fGrammarPool.cacheGrammars(grammars[0].getGrammarDescription().getGrammarType(), grammars);
            }
            Vector modelStore = currModel.getInternalASModels();
            int i = 0;
            while (i < modelStore.size()) {
                this.initGrammarPool((ASModelImpl)modelStore.elementAt(i));
                ++i;
            }
        }
    }
}

